/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import org.alfresco.repo.action.executer.DummyMimetypeService;
import org.alfresco.repo.action.executer.TransformActionExecuter;
import org.junit.Assert;
import org.junit.Test;

public class TransformActionExecuterTest {
    @Test
    public void transformName() throws Exception {
        DummyMimetypeService dummyMimetypeService = new DummyMimetypeService("txt");
        String original = "Letter to Bank Manager.doc";
        String newMimetype = "text/plain";
        String newName = TransformActionExecuter.transformName(dummyMimetypeService, original, "text/plain", true);
        Assert.assertEquals((Object)"Letter to Bank Manager.txt", (Object)newName);
        original = "No.1 - First Document Title";
        newName = TransformActionExecuter.transformName(dummyMimetypeService, original, "text/plain", true);
        Assert.assertEquals((Object)(original + ".txt"), (Object)newName);
        original = "No.1 - First Document Title";
        newName = TransformActionExecuter.transformName(dummyMimetypeService, original, "text/plain", false);
        Assert.assertEquals((Object)original, (Object)newName);
        original = "Letter to Bank Manager";
        newName = TransformActionExecuter.transformName(dummyMimetypeService, original, "text/plain", true);
        Assert.assertEquals((Object)(original + ".txt"), (Object)newName);
        original = "Letter to Bank Manager";
        newName = TransformActionExecuter.transformName(dummyMimetypeService, original, "text/plain", false);
        Assert.assertEquals((Object)original, (Object)newName);
        original = "Letter to Bank Manager.";
        newName = TransformActionExecuter.transformName(dummyMimetypeService, original, "text/plain", true);
        Assert.assertEquals((Object)(original + "txt"), (Object)newName);
        original = "Letter to Bank Manager.";
        newName = TransformActionExecuter.transformName(dummyMimetypeService, original, "text/plain", false);
        Assert.assertEquals((Object)original, (Object)newName);
        original = "Letter to Bank Manager.txt";
        String unknownMimetype = "Marcel/Marceau";
        dummyMimetypeService = new DummyMimetypeService("bin");
        newName = TransformActionExecuter.transformName(dummyMimetypeService, original, "Marcel/Marceau", true);
        Assert.assertEquals((Object)"Letter to Bank Manager.bin", (Object)newName);
    }
}

