/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.registry;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.registry.RegistryKey;
import org.alfresco.repo.admin.registry.RegistryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryServiceImpl
implements RegistryService {
    private static Log logger = LogFactory.getLog(RegistryServiceImpl.class);
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private SearchService searchService;
    private StoreRef registryStoreRef;
    private String registryRootPath;

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setRegistryStoreRef(StoreRef registryStoreRef) {
        this.registryStoreRef = registryStoreRef;
    }

    public void setRegistryStore(String registryStore) {
        this.setRegistryStoreRef(new StoreRef(registryStore));
    }

    public void setRegistryRootPath(String registryRootPath) {
        this.registryRootPath = registryRootPath;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"registryRootPath", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"registryStore", (Object)this.registryStoreRef);
        PropertyCheck.mandatory((Object)this, (String)"registryRootPath", (Object)this.registryRootPath);
    }

    private NodeRef getRegistryRootNodeRef() {
        NodeRef registryRootNodeRef = null;
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(this.registryStoreRef);
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, this.registryRootPath, new QueryParameterDefinition[0], (NamespacePrefixResolver)this.namespaceService, false, "xpath");
        if (nodeRefs.size() == 0) {
            throw new AlfrescoRuntimeException("Registry root not present: \n   Store: " + this.registryStoreRef + "\n" + "   Path:  " + this.registryRootPath);
        }
        if (nodeRefs.size() > 1) {
            throw new AlfrescoRuntimeException("Registry root path has multiple targets: \n   Store: " + this.registryStoreRef + "\n" + "   Path:  " + this.registryRootPath);
        }
        registryRootNodeRef = (NodeRef)nodeRefs.get(0);
        QName typeQName = this.nodeService.getType(registryRootNodeRef);
        if (!typeQName.equals((Object)ContentModel.TYPE_CONTAINER)) {
            throw new AlfrescoRuntimeException("Registry root is not of type " + ContentModel.TYPE_CONTAINER + ": \n" + "   Node: " + registryRootNodeRef + "\n" + "   Type: " + typeQName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found root for registry: \n   Store: " + this.registryStoreRef + "\n" + "   Path : " + this.registryRootPath + "\n" + "   Root:  " + registryRootNodeRef));
        }
        return registryRootNodeRef;
    }

    private Pair<NodeRef, QName> getPath(RegistryKey key, boolean create) {
        NodeRef currentNodeRef = this.getRegistryRootNodeRef();
        String namespaceUri = key.getNamespaceUri();
        String[] pathElements = key.getPath();
        String property = key.getProperty();
        for (String pathElement : pathElements) {
            QName assocQName = QName.createQName((String)namespaceUri, (String)QName.createValidLocalName((String)pathElement));
            List childAssocRefs = this.nodeService.getChildAssocs(currentNodeRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)assocQName);
            int size = childAssocRefs.size();
            if (size == 0) {
                if (create) {
                    PropertyMap properties = new PropertyMap();
                    properties.put(ContentModel.PROP_NAME, pathElement);
                    currentNodeRef = this.nodeService.createNode(currentNodeRef, ContentModel.ASSOC_CHILDREN, assocQName, ContentModel.TYPE_CONTAINER, (Map)properties).getChildRef();
                    continue;
                }
                currentNodeRef = null;
                break;
            }
            if (size > 1 && create) {
                boolean first = true;
                for (ChildAssociationRef assocRef : childAssocRefs) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    this.nodeService.removeChildAssociation(assocRef);
                }
            }
            currentNodeRef = ((ChildAssociationRef)childAssocRefs.get(0)).getChildRef();
        }
        QName propertyQName = null;
        if (property != null) {
            propertyQName = QName.createQName((String)namespaceUri, (String)QName.createValidLocalName((String)property));
        }
        Pair resultPair = new Pair((Object)currentNodeRef, (Object)propertyQName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Converted registry key: \n   Key:      " + key + "\n" + "   Result:   " + resultPair));
        }
        if (resultPair.getFirst() == null) {
            return null;
        }
        return resultPair;
    }

    @Override
    public void addProperty(RegistryKey key, Serializable value) {
        if (key.getProperty() == null) {
            throw new IllegalArgumentException("Registry values must be added using paths that contain property names: " + key);
        }
        String namespaceUri = key.getNamespaceUri();
        if (!this.namespaceService.getURIs().contains(namespaceUri)) {
            throw new NamespaceException("Unable to add a registry value with an unregistered namespace: " + namespaceUri);
        }
        Pair<NodeRef, QName> keyPair = this.getPath(key, true);
        this.nodeService.setProperty((NodeRef)keyPair.getFirst(), (QName)keyPair.getSecond(), value);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added value to registry: \n   Key:   " + key + "\n" + "   Value: " + value));
        }
    }

    @Override
    public Serializable getProperty(RegistryKey key) {
        if (key.getProperty() == null) {
            throw new IllegalArgumentException("Registry values must be fetched using paths that contain property names: " + key);
        }
        Pair<NodeRef, QName> keyPair = this.getPath(key, false);
        Serializable property = null;
        if (keyPair != null) {
            property = this.nodeService.getProperty((NodeRef)keyPair.getFirst(), (QName)keyPair.getSecond());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved property from registry: \n   Key:   " + key + "\n" + "   Value: " + property));
        }
        return property;
    }

    @Override
    public Collection<String> getChildElements(RegistryKey key) {
        Pair<NodeRef, QName> keyPair = this.getPath(key, false);
        if (keyPair == null) {
            return Collections.emptyList();
        }
        RegexQNamePattern qnamePattern = new RegexQNamePattern(key.getNamespaceUri(), ".*");
        List childAssocRefs = this.nodeService.getChildAssocs((NodeRef)keyPair.getFirst(), (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)qnamePattern);
        ArrayList<String> results = new ArrayList<String>(childAssocRefs.size());
        for (ChildAssociationRef assocRef : childAssocRefs) {
            results.add(assocRef.getQName().getLocalName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved child elements from registry: \n   Key:      " + key + "\n" + "   Elements: " + results));
        }
        return results;
    }

    @Override
    public void copy(RegistryKey sourceKey, RegistryKey targetKey) {
        if (sourceKey.getProperty() == null && targetKey.getProperty() != null) {
            throw new AlfrescoRuntimeException("Registry keys must both be path specific for a copy: \n   Source: " + sourceKey + "\n" + "   Target: " + targetKey);
        }
        if (sourceKey.getProperty() != null && targetKey.getProperty() == null) {
            throw new AlfrescoRuntimeException("Registry keys must both be value specific for a copy: \n   Source: " + sourceKey + "\n" + "   Target: " + targetKey);
        }
        Pair<NodeRef, QName> sourceKeyPair = this.getPath(sourceKey, false);
        if (sourceKeyPair == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Nothing copied from non-existent registry source key: \n   Source: " + sourceKey + "\n" + "   Target: " + targetKey));
            }
            return;
        }
        Pair<NodeRef, QName> targetKeyPair = this.getPath(targetKey, true);
        if (sourceKeyPair.getSecond() != null) {
            Serializable value = this.nodeService.getProperty((NodeRef)sourceKeyPair.getFirst(), (QName)sourceKeyPair.getSecond());
            this.nodeService.setProperty((NodeRef)targetKeyPair.getFirst(), (QName)targetKeyPair.getSecond(), value);
        } else {
            HashSet<NodeRef> processedNodeRefs = new HashSet<NodeRef>(20);
            this.copyRecursive(sourceKey, targetKey, processedNodeRefs);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Copied registry keys: \n   Source: " + sourceKey + "\n" + "   Target: " + targetKey));
        }
    }

    private void copyRecursive(RegistryKey sourceKey, RegistryKey targetKey, Set<NodeRef> processedNodeRefs) {
        String sourceNamespaceUri = sourceKey.getNamespaceUri();
        String targetNamespaceUri = targetKey.getNamespaceUri();
        Pair<NodeRef, QName> sourceKeyPair = this.getPath(sourceKey, false);
        if (sourceKeyPair == null) {
            return;
        }
        NodeRef sourceNodeRef = (NodeRef)sourceKeyPair.getFirst();
        if (processedNodeRefs.contains(sourceNodeRef)) {
            logger.error((Object)("Circular paths detected in registry entries: \n   Current Source Key: " + sourceKey + "\n" + "   Current Target Key: " + targetKey + "\n" + "   Source Node:        " + sourceNodeRef));
            logger.error((Object)"Bypassing circular registry entry");
            return;
        }
        Pair<NodeRef, QName> targetKeyPair = this.getPath(targetKey, true);
        NodeRef targetNodeRef = (NodeRef)targetKeyPair.getFirst();
        Map sourceProperties = this.nodeService.getProperties(sourceNodeRef);
        Map targetProperties = this.nodeService.getProperties(targetNodeRef);
        boolean changed = false;
        for (Map.Entry entry : sourceProperties.entrySet()) {
            QName sourcePropertyQName = (QName)entry.getKey();
            if (!EqualsHelper.nullSafeEquals((Object)sourcePropertyQName.getNamespaceURI(), (Object)sourceNamespaceUri)) continue;
            Serializable value = (Serializable)entry.getValue();
            QName targetPropertyQName = QName.createQName((String)targetNamespaceUri, (String)sourcePropertyQName.getLocalName());
            targetProperties.put(targetPropertyQName, value);
            changed = true;
        }
        if (changed) {
            this.nodeService.setProperties(targetNodeRef, targetProperties);
        }
        processedNodeRefs.add(sourceNodeRef);
        Collection<String> sourceChildElements = this.getChildElements(sourceKey);
        String[] sourcePath = sourceKey.getPath();
        String[] childSourcePath = new String[sourcePath.length + 1];
        System.arraycopy(sourcePath, 0, childSourcePath, 0, sourcePath.length);
        String[] targetPath = targetKey.getPath();
        String[] childTargetPath = new String[targetPath.length + 1];
        System.arraycopy(targetPath, 0, childTargetPath, 0, targetPath.length);
        Iterator<String> i$ = sourceChildElements.iterator();
        while (i$.hasNext()) {
            String sourceChildElement;
            childSourcePath[sourcePath.length] = sourceChildElement = i$.next();
            RegistryKey sourceChildKey = new RegistryKey(sourceNamespaceUri, childSourcePath, null);
            childTargetPath[targetPath.length] = sourceChildElement;
            RegistryKey targetChildKey = new RegistryKey(targetNamespaceUri, childTargetPath, null);
            this.copyRecursive(sourceChildKey, targetChildKey, processedNodeRefs);
        }
    }

    @Override
    public void delete(RegistryKey key) {
        Pair<NodeRef, QName> keyPair = this.getPath(key, false);
        if (keyPair == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Nothing to delete for registry key: \n   Key: " + key));
            }
            return;
        }
        NodeRef pathNodeRef = (NodeRef)keyPair.getFirst();
        QName propertyQName = (QName)keyPair.getSecond();
        if (propertyQName == null) {
            this.nodeService.deleteNode(pathNodeRef);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Performed path-based delete: \n   Key:  " + key + "\n" + "   Node: " + pathNodeRef));
            }
        } else {
            this.nodeService.removeProperty(pathNodeRef, propertyQName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Performed value-based delete: \n   Key:      " + key + "\n" + "   Node:     " + pathNodeRef + "\n" + "   Property: " + propertyQName));
            }
        }
    }
}

