/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.SortedMap;
import junit.framework.Assert;
import org.alfresco.repo.avm.AVMServiceTestBase;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.util.GUID;

public class AVMChildNamePatternMatchPerformanceTest
extends AVMServiceTestBase {
    public void test_1000() throws Exception {
        fTransactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute() throws Throwable {
                try {
                    String name;
                    int i;
                    AVMServiceTestBase.fService.createStore("StagingArea");
                    AVMServiceTestBase.fService.createStore("SandBox");
                    AVMServiceTestBase.fService.createDirectory("StagingArea:/", "www");
                    AVMServiceTestBase.fService.createLayeredDirectory("StagingArea:/www", "SandBox:/", "www");
                    for (i = 0; i < 500; ++i) {
                        name = GUID.generate();
                        if (i % 100 == 0) {
                            name = "A" + name;
                        }
                        if (name.startsWith("a")) {
                            name = "G" + name;
                        }
                        AVMServiceTestBase.fService.createFile("SandBox:/www", name).close();
                    }
                    System.out.println("Create SandBox:/www");
                    for (i = 0; i < 500; ++i) {
                        name = GUID.generate();
                        if (i % 100 == 0) {
                            name = "A" + name;
                        }
                        if (name.startsWith("a")) {
                            name = "G" + name;
                        }
                        AVMServiceTestBase.fService.createFile("StagingArea:/www", name).close();
                    }
                    System.out.println("Create StagingArea:/www");
                    long start = System.nanoTime();
                    AVMNodeDescriptor dir = AVMServiceTestBase.fService.lookup(-1, "SandBox:/www");
                    SortedMap<String, AVMNodeDescriptor> result = AVMServiceTestBase.fService.getDirectoryListing(dir, "A*");
                    Assert.assertEquals((int)10, (int)result.size());
                    long end = System.nanoTime();
                    System.out.println("Pattern in " + (float)(end - start) / 1.0E9f);
                    Object var8_7 = null;
                    AVMServiceTestBase.fService.purgeStore("StagingArea");
                    AVMServiceTestBase.fService.purgeStore("SandBox");
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    AVMServiceTestBase.fService.purgeStore("StagingArea");
                    AVMServiceTestBase.fService.purgeStore("SandBox");
                    throw throwable;
                }
                return null;
            }
        });
    }
}

