/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Pattern;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.util.BulkLoader;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.VersionDescriptor;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.wcm.util.WCMUtil;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public class AVMInterpreter {
    private static final Pattern collectionPattern = Pattern.compile("^\\[(.*)\\]$");
    private static final Pattern nodeRefPattern = Pattern.compile("^\\w+://\\w+\\w+$");
    private static final Pattern integerPattern = Pattern.compile("^\\d+$");
    private static final Pattern dateTimePattern = Pattern.compile("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}$");
    private AVMService fService;
    private AVMSyncService fSyncService;
    private AVMLockingService fLockingService;
    private PermissionService fPermissionService;
    private BufferedReader fIn = new BufferedReader(new InputStreamReader(System.in));
    private BulkLoader fLoader;

    public static void main(String[] args) {
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext("config/alfresco/application-context.xml");
        AVMInterpreter console = new AVMInterpreter();
        console.setAvmService((AVMService)context.getBean("AVMService"));
        console.setAvmSyncService((AVMSyncService)context.getBean("AVMSyncService"));
        console.setAvmLockingService((AVMLockingService)context.getBean("AVMLockingService"));
        console.setPermissionService((PermissionService)context.getBean("PermissionService"));
        BulkLoader loader = new BulkLoader();
        loader.setAvmService((AVMService)context.getBean("AVMService"));
        console.setBulkLoader(loader);
        console.rep();
        context.close();
    }

    public void setAvmService(AVMService service) {
        this.fService = service;
    }

    public void setAvmSyncService(AVMSyncService syncService) {
        this.fSyncService = syncService;
    }

    public void setAvmLockingService(AVMLockingService lockService) {
        this.fLockingService = lockService;
    }

    public void setPermissionService(PermissionService service) {
        this.fPermissionService = service;
    }

    public void setBulkLoader(BulkLoader loader) {
        this.fLoader = loader;
    }

    public void rep() {
        while (true) {
            System.out.print("> ");
            try {
                String line = this.fIn.readLine();
                if (line.equals("exit")) {
                    return;
                }
                System.out.println(this.interpretCommand(line, this.fIn));
                continue;
            }
            catch (IOException ie) {
                ie.printStackTrace(System.err);
                System.exit(2);
                continue;
            }
            break;
        }
    }

    public String interpretCommand(String line, BufferedReader in) {
        String[] command = line.split(",\\s+");
        if (command.length == 0) {
            command = new String[]{line};
        }
        try {
            PrintStream out;
            ByteArrayOutputStream bout;
            block162: {
                bout = new ByteArrayOutputStream();
                out = new PrintStream(bout);
                if (command[0].equals("ls")) {
                    if (command.length < 2) {
                        return "Syntax Error.";
                    }
                    int version = command.length == 2 ? -1 : Integer.parseInt(command[2]);
                    AVMNodeDescriptor desc = this.fService.lookup(version, command[1]);
                    if (desc == null) {
                        return "Not Found.";
                    }
                    SortedMap<String, AVMNodeDescriptor> listing = this.fService.getDirectoryListing(desc, true);
                    for (String name : listing.keySet()) {
                        out.println(name + " " + listing.get(name));
                    }
                } else if (command[0].equals("lsr")) {
                    if (command.length < 2) {
                        return "Syntax Error.";
                    }
                    int version = command.length == 2 ? -1 : Integer.parseInt(command[2]);
                    AVMNodeDescriptor desc = this.fService.lookup(version, command[1]);
                    this.recursiveList(out, desc, 0);
                } else if (command[0].equals("lsrep")) {
                    List<AVMStoreDescriptor> repos = this.fService.getStores();
                    for (AVMStoreDescriptor repo : repos) {
                        out.println(repo);
                    }
                } else if (command[0].equals("lsver")) {
                    if (command.length < 2 || command.length > 4) {
                        return "Syntax Error.";
                    }
                    List<VersionDescriptor> listing = null;
                    String storeName = command[1];
                    if (command.length == 2) {
                        listing = this.fService.getStoreVersions(storeName);
                    } else {
                        Date fromDate = ISO8601DateFormat.parse((String)command[2]);
                        Date toDate = new Date();
                        if (command.length == 4) {
                            toDate = ISO8601DateFormat.parse((String)command[3]);
                        }
                        listing = this.fService.getStoreVersions(storeName, fromDate, toDate);
                    }
                    for (VersionDescriptor desc : listing) {
                        out.println(desc);
                    }
                } else if (command[0].equals("mkrep")) {
                    if (command.length != 2) {
                        return "Syntax Error.";
                    }
                    this.fService.createStore(command[1]);
                } else if (command[0].equals("load")) {
                    if (command.length != 3) {
                        return "Syntax Error.";
                    }
                    this.fLoader.recursiveLoad(command[1], command[2]);
                } else if (command[0].equals("mkdir")) {
                    if (command.length != 3) {
                        return "Syntax Error.";
                    }
                    this.fService.createDirectory(command[1], command[2]);
                } else if (command[0].equals("mkbr")) {
                    if (command.length != 5) {
                        return "Syntax Error.";
                    }
                    this.fService.createBranch(Integer.parseInt(command[4]), command[1], command[2], command[3]);
                } else if (command[0].equals("mkldir")) {
                    if (command.length != 4) {
                        return "Syntax Error.";
                    }
                    this.fService.createLayeredDirectory(command[1], command[2], command[3]);
                } else if (command[0].equals("setopacity")) {
                    if (command.length != 3) {
                        return "Syntax Error.";
                    }
                    boolean isOpaque = new Boolean(command[2]);
                    this.fService.setOpacity(command[1], isOpaque);
                } else if (command[0].equals("rename")) {
                    if (command.length != 5) {
                        return "Syntax Error.";
                    }
                    this.fService.rename(command[1], command[2], command[3], command[4]);
                } else if (command[0].equals("cp")) {
                    int read;
                    if (command.length != 5) {
                        return "Syntax Error.";
                    }
                    InputStream fin = this.fService.getFileInputStream(Integer.parseInt(command[2]), command[1]);
                    OutputStream fout = this.fService.createFile(command[3], command[4]);
                    byte[] buff = new byte[8192];
                    while ((read = fin.read(buff)) != -1) {
                        fout.write(buff, 0, read);
                    }
                    fin.close();
                    fout.close();
                } else if (command[0].equals("retarget")) {
                    if (command.length != 3) {
                        return "Syntax Error.";
                    }
                    this.fService.retargetLayeredDirectory(command[1], command[2]);
                } else if (command[0].equals("mkprimary")) {
                    if (command.length != 2) {
                        return "Syntax Error.";
                    }
                    this.fService.makePrimary(command[1]);
                } else if (command[0].equals("mklfile")) {
                    if (command.length != 4) {
                        return "Syntax Error.";
                    }
                    this.fService.createLayeredFile(command[1], command[2], command[3]);
                } else if (command[0].equals("snap")) {
                    if (command.length < 2 || command.length > 4) {
                        return "Syntax Error.";
                    }
                    String tag = command.length > 2 ? command[2] : null;
                    String description = command.length > 3 ? command[3] : null;
                    this.fService.createSnapshot(command[1], tag, description);
                } else if (command[0].equals("cat")) {
                    String l;
                    if (command.length < 2) {
                        return "Syntax Error.";
                    }
                    int version = command.length == 2 ? -1 : Integer.parseInt(command[2]);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.fService.getFileInputStream(version, command[1])));
                    while ((l = reader.readLine()) != null) {
                        out.println(l);
                    }
                    reader.close();
                } else if (command[0].equals("rm")) {
                    if (command.length != 3) {
                        return "Syntax Error.";
                    }
                    this.fService.removeNode(command[1], command[2]);
                } else if (command[0].equals("rmrep")) {
                    if (command.length != 2) {
                        return "Syntax Error.";
                    }
                    this.fService.purgeStore(command[1]);
                } else if (command[0].equals("rmver")) {
                    if (command.length != 3) {
                        return "Syntax Error.";
                    }
                    String storeName = command[1];
                    int ver = Integer.parseInt(command[2]);
                    String wpStoreId = WCMUtil.getWebProject(this.fService, storeName);
                    if (wpStoreId != null && ver <= 2) {
                        return "WCM store - cannot delete versions 0-2";
                    }
                    this.fService.purgeVersion(ver, storeName);
                } else if (command[0].equals("rmvers")) {
                    if (command.length != 4) {
                        return "Syntax Error.";
                    }
                    String storeName = command[1];
                    String wpStoreId = WCMUtil.getWebProject(this.fService, storeName);
                    Date fromDate = ISO8601DateFormat.parse((String)command[2]);
                    Date toDate = ISO8601DateFormat.parse((String)command[3]);
                    List<VersionDescriptor> listing = this.fService.getStoreVersions(storeName, fromDate, toDate);
                    for (VersionDescriptor desc : listing) {
                        int ver = desc.getVersionID();
                        if (wpStoreId != null && ver <= 2) {
                            return "WCM store - cannot delete versions 0-2";
                        }
                        this.fService.purgeVersion(ver, storeName);
                    }
                } else if (command[0].equals("write")) {
                    String l;
                    if (command.length != 2) {
                        return "Syntax Error.";
                    }
                    PrintStream ps = new PrintStream(this.fService.getFileOutputStream(command[1]));
                    while (!(l = in.readLine()).equals("")) {
                        ps.println(l);
                    }
                    ps.close();
                } else if (command[0].equals("create")) {
                    String l;
                    if (command.length != 3) {
                        return "Syntax Error.";
                    }
                    PrintStream ps = new PrintStream(this.fService.createFile(command[1], command[2]));
                    while (!(l = in.readLine()).equals("")) {
                        ps.println(l);
                    }
                    ps.close();
                } else if (command[0].equals("stat")) {
                    if (command.length < 2) {
                        return "Syntax Error.";
                    }
                    int version = command.length == 2 ? -1 : Integer.parseInt(command[2]);
                    AVMNodeDescriptor desc = this.fService.lookup(version, command[1]);
                    out.println(desc);
                    out.println("Version: " + desc.getVersionID());
                    out.println("Owner: " + desc.getOwner());
                    out.println("Mod Time: " + new Date(desc.getModDate()));
                } else if (command[0].equals("getnodeproperties")) {
                    if (command.length < 2) {
                        return "Syntax Error.";
                    }
                    int version = command.length == 2 ? -1 : Integer.parseInt(command[2]);
                    Map<QName, PropertyValue> properties = this.fService.getNodeProperties(version, command[1]);
                    for (Map.Entry<QName, PropertyValue> p : properties.entrySet()) {
                        out.println(p.getKey() + ": " + p.getValue());
                    }
                } else if (command[0].equals("setnodepermission")) {
                    if (command.length != 4) {
                        return "Syntax Error.";
                    }
                    this.fPermissionService.setPermission(AVMNodeConverter.ToNodeRef(-1, command[1]), command[2], command[3], true);
                } else if (command[0].equals("clearnodepermission")) {
                    if (command.length != 3) {
                        return "Syntax Error.";
                    }
                    this.fPermissionService.clearPermission(AVMNodeConverter.ToNodeRef(-1, command[1]), command[2]);
                } else if (command[0].equals("descnode")) {
                    String store;
                    String path;
                    if (command.length < 2) {
                        return "Syntax Error.";
                    }
                    int version = command.length == 2 ? -1 : Integer.parseInt(command[2]);
                    AVMNodeDescriptor nodeDesc = this.fService.lookup(version, path = command[1]);
                    if (nodeDesc == null) {
                        return "Path Not Found.";
                    }
                    out.println(nodeDesc.toString());
                    out.println("isDirectory: " + nodeDesc.isDirectory());
                    out.println("isFile: " + nodeDesc.isFile());
                    out.println("isPrimary: " + nodeDesc.isPrimary());
                    out.println("isOpaque: " + nodeDesc.getOpacity());
                    out.println("creator: " + nodeDesc.getCreator());
                    out.println("owner: " + nodeDesc.getOwner());
                    out.println("lastModifier: " + nodeDesc.getLastModifier());
                    out.println("created: " + new Date(nodeDesc.getCreateDate()));
                    out.println("modified: " + new Date(nodeDesc.getModDate()));
                    out.println("lastAccess: " + new Date(nodeDesc.getAccessDate()));
                    String lockPath = path.substring(path.indexOf("/"));
                    String mainStore = store = path.substring(0, path.indexOf(":"));
                    if (store.indexOf("--") != -1) {
                        mainStore = store.substring(0, store.indexOf("--"));
                    }
                    try {
                        String lockOwner = this.fLockingService.getLockOwner(mainStore, lockPath);
                        if (lockOwner != null) {
                            out.println("lock: " + lockOwner);
                            break block162;
                        }
                        out.println("No locks found");
                    }
                    catch (AVMNotFoundException avmerr) {
                        out.println("No locks found");
                    }
                } else if (command[0].equals("deletenodeproperty")) {
                    if (command.length != 3) {
                        return "Syntax Error.";
                    }
                    this.fService.deleteNodeProperty(command[1], QName.createQName((String)command[2]));
                    out.println("deleted property " + command[2] + " of " + command[1]);
                } else if (command[0].equals("history")) {
                    if (command.length != 4) {
                        return "Syntax Error.";
                    }
                    AVMNodeDescriptor desc = this.fService.lookup(Integer.parseInt(command[2]), command[1]);
                    List<AVMNodeDescriptor> history = this.fService.getHistory(desc, Integer.parseInt(command[3]));
                    for (AVMNodeDescriptor node : history) {
                        out.println(node);
                        out.println("Version: " + node.getVersionID());
                        out.println("Owner: " + node.getOwner());
                        out.println("Mod Time: " + new Date(node.getModDate()));
                    }
                } else if (command[0].equals("ca")) {
                    if (command.length != 5) {
                        return "Syntax Error.";
                    }
                    AVMNodeDescriptor left = this.fService.lookup(Integer.parseInt(command[2]), command[1]);
                    AVMNodeDescriptor right = this.fService.lookup(Integer.parseInt(command[4]), command[3]);
                    AVMNodeDescriptor ca = this.fService.getCommonAncestor(left, right);
                    out.println(ca);
                } else if (command[0].equals("statstore")) {
                    if (command.length != 2) {
                        return "Syntax Error.";
                    }
                    AVMStoreDescriptor desc = this.fService.getStore(command[1]);
                    if (desc == null) {
                        return "Not Found.";
                    }
                    out.println(desc);
                    Map<QName, PropertyValue> props = this.fService.getStoreProperties(command[1]);
                    for (QName name : props.keySet()) {
                        out.println(name + ": " + props.get(name));
                    }
                } else if (command[0].equals("compare")) {
                    if (command.length != 5) {
                        return "Syntax Error.";
                    }
                    List<AVMDifference> diffs = this.fSyncService.compare(Integer.parseInt(command[2]), command[1], Integer.parseInt(command[4]), command[3], null);
                    for (AVMDifference diff : diffs) {
                        out.println(diff);
                    }
                } else if (command[0].equals("update")) {
                    if (command.length != 4) {
                        return "Syntax Error.";
                    }
                    AVMDifference diff = new AVMDifference(Integer.parseInt(command[2]), command[1], -1, command[3], 0);
                    ArrayList<AVMDifference> diffs = new ArrayList<AVMDifference>();
                    diffs.add(diff);
                    this.fSyncService.update(diffs, null, false, false, false, false, null, null);
                } else if (command[0].equals("resetLayer")) {
                    if (command.length != 2) {
                        return "Syntax Error.";
                    }
                    this.fSyncService.resetLayer(command[1]);
                } else if (command[0].equals("flatten")) {
                    if (command.length != 3) {
                        return "Syntax Error.";
                    }
                    this.fSyncService.flatten(command[1], command[2]);
                } else if (command[0].equals("getnodeaspects")) {
                    if (command.length != 3) {
                        return "Syntax Error.";
                    }
                    Set<QName> aspects = this.fService.getAspects(Integer.parseInt(command[2]), command[1]);
                    for (QName qn : aspects) {
                        out.println(qn.toString());
                    }
                } else if (command[0].equals("addnodeaspect")) {
                    if (command.length != 3) {
                        return "Syntax Error.";
                    }
                    this.fService.addAspect(command[1], QName.createQName((String)command[2]));
                } else if (command[0].equals("deletenodeaspect")) {
                    if (command.length != 3) {
                        return "Syntax Error.";
                    }
                    this.fService.removeAspect(command[1], QName.createQName((String)command[2]));
                } else if (command[0].equals("setnodeproperty")) {
                    if (command.length < 4) {
                        return "Syntax Error.";
                    }
                    QName valueQName = QName.createQName((String)command[2]);
                    String propertyValue = "";
                    if (command.length > 4) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 3; i < command.length; ++i) {
                            sb.append(command[i]);
                        }
                        propertyValue = sb.toString();
                    } else {
                        propertyValue = command[3];
                    }
                    Serializable serializableValue = AVMInterpreter.convertValueFromSring(propertyValue);
                    QName valueTypeQName = AVMInterpreter.getValueTypeQName(propertyValue);
                    this.fService.setNodeProperty(command[1], valueQName, new PropertyValue(valueTypeQName, serializableValue));
                    out.println("set property " + command[2] + " of " + command[1]);
                } else if (command[0].equals("setstoreproperty")) {
                    if (command.length < 4) {
                        return "Syntax Error.";
                    }
                    QName valueQName = QName.createQName((String)command[2]);
                    String propertyValue = "";
                    if (command.length > 4) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 3; i < command.length; ++i) {
                            sb.append(command[i]);
                        }
                        propertyValue = sb.toString();
                    } else {
                        propertyValue = command[3];
                    }
                    Serializable serializableValue = AVMInterpreter.convertValueFromSring(propertyValue);
                    QName valueTypeQName = AVMInterpreter.getValueTypeQName(propertyValue);
                    this.fService.setStoreProperty(command[1], valueQName, new PropertyValue(valueTypeQName, serializableValue));
                    out.println("set property " + command[2] + " of " + command[1]);
                } else if (command[0].equals("setstorepermission")) {
                    if (command.length != 4) {
                        return "Syntax Error.";
                    }
                    this.fPermissionService.setPermission(new StoreRef("avm", command[1]), command[2], command[3], true);
                } else if (command[0].equals("clearstorepermission")) {
                    if (command.length != 3) {
                        return "Syntax Error.";
                    }
                    this.fPermissionService.clearPermission(new StoreRef("avm", command[1]), command[2]);
                } else {
                    return "Syntax Error.";
                }
            }
            out.flush();
            String retVal = new String(bout.toByteArray());
            out.close();
            return retVal;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return e.toString();
        }
    }

    private void recursiveList(PrintStream out, AVMNodeDescriptor dir, int indent) {
        SortedMap<String, AVMNodeDescriptor> listing = this.fService.getDirectoryListing(dir, true);
        for (String name : listing.keySet()) {
            AVMNodeDescriptor child = (AVMNodeDescriptor)listing.get(name);
            for (int i = 0; i < indent; ++i) {
                out.print(' ');
            }
            out.println(name + " " + child);
            if (!child.isDirectory()) continue;
            this.recursiveList(out, child, indent + 2);
        }
    }

    private static Serializable convertValueFromSring(String sValue) {
        Object retValue = "";
        CharSequence seq = sValue.subSequence(0, sValue.length());
        if (collectionPattern.matcher(seq).matches()) {
            String[] elements = AVMInterpreter.getCSVArray(sValue.substring(1, sValue.length() - 1));
            HashSet<Serializable> propValues = new HashSet<Serializable>(elements.length);
            for (int i = 0; i < elements.length; ++i) {
                if ("".equals(elements[i])) continue;
                propValues.add(AVMInterpreter.convertValueFromSring(elements[i]));
            }
            retValue = propValues;
        } else if (nodeRefPattern.matcher(seq).matches()) {
            retValue = new NodeRef(sValue);
        } else if (integerPattern.matcher(seq).matches()) {
            retValue = new Integer(sValue);
        } else if (!dateTimePattern.matcher(seq).matches()) {
            retValue = sValue;
        }
        return retValue;
    }

    private static QName getValueTypeQName(String sValue) {
        QName typeQName = null;
        CharSequence seq = sValue.subSequence(0, sValue.length());
        if (collectionPattern.matcher(seq).matches()) {
            String[] elements = AVMInterpreter.getCSVArray(sValue.substring(1, sValue.length() - 1));
            if (elements[0] != "") {
                typeQName = AVMInterpreter.getValueTypeQName(elements[0]);
            }
        } else {
            typeQName = nodeRefPattern.matcher(seq).matches() ? DataTypeDefinition.NODE_REF : (integerPattern.matcher(seq).matches() ? DataTypeDefinition.INT : (dateTimePattern.matcher(seq).matches() ? DataTypeDefinition.DATETIME : DataTypeDefinition.TEXT));
        }
        return typeQName;
    }

    private static String[] getCSVArray(String valueString) {
        String[] elements = valueString.split(",\\s+");
        if (elements.length == 0) {
            elements = new String[]{valueString};
        }
        return elements;
    }
}

