/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMNodeConverter {
    private static Log fgLogger = LogFactory.getLog(AVMNodeConverter.class);

    public static NodeRef ToNodeRef(int version, String avmPath) {
        String[] pathParts = AVMUtil.splitPath(avmPath);
        while (pathParts[1].endsWith("/") && pathParts[1].length() > 1) {
            pathParts[1] = pathParts[1].substring(0, pathParts[1].length() - 1);
        }
        StoreRef storeRef = AVMNodeConverter.ToStoreRef(pathParts[0]);
        String translated = version + pathParts[1];
        translated = translated.replaceAll("/+", ";");
        return new NodeRef(storeRef, translated);
    }

    public static StoreRef ToStoreRef(String avmStore) {
        return new StoreRef("avm", avmStore);
    }

    public static Pair<Integer, String> ToAVMVersionPath(NodeRef nodeRef) {
        StoreRef store = nodeRef.getStoreRef();
        String translated = nodeRef.getId();
        int off = (translated = translated.replace(';', '/')).indexOf(47);
        if (off == -1) {
            fgLogger.error((Object)translated);
            throw new AVMException("Bad Node Reference: " + nodeRef.getId());
        }
        int version = Integer.parseInt(translated.substring(0, off));
        String path = translated.substring(off);
        return new Pair((Object)version, (Object)AVMUtil.buildAVMPath(store.getIdentifier(), path));
    }

    public static String ExtendAVMPath(String path, String name) {
        return AVMUtil.extendAVMPath(path, name);
    }

    public static String[] SplitBase(String path) {
        return AVMUtil.splitBase(path);
    }

    public static String NormalizePath(String path) {
        return AVMUtil.normalizePath(path);
    }
}

