/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.alfresco.model.WCMModel;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMNodeDAO;
import org.alfresco.repo.avm.AVMNodeImpl;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.AVMStoreDAO;
import org.alfresco.repo.avm.AVMStoreImpl;
import org.alfresco.repo.avm.AVMStorePropertyDAO;
import org.alfresco.repo.avm.ChildEntry;
import org.alfresco.repo.avm.ChildEntryDAO;
import org.alfresco.repo.avm.ChildKey;
import org.alfresco.repo.avm.CreateStoreTxnListener;
import org.alfresco.repo.avm.CreateVersionTxnListener;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.avm.DirectoryNodeImpl;
import org.alfresco.repo.avm.FileNode;
import org.alfresco.repo.avm.LayeredDirectoryNode;
import org.alfresco.repo.avm.LayeredDirectoryNodeImpl;
import org.alfresco.repo.avm.LayeredFileNode;
import org.alfresco.repo.avm.LayeredFileNodeImpl;
import org.alfresco.repo.avm.Lookup;
import org.alfresco.repo.avm.LookupCache;
import org.alfresco.repo.avm.PlainDirectoryNode;
import org.alfresco.repo.avm.PlainDirectoryNodeImpl;
import org.alfresco.repo.avm.PlainFileNode;
import org.alfresco.repo.avm.PlainFileNodeImpl;
import org.alfresco.repo.avm.PurgeStoreTxnListener;
import org.alfresco.repo.avm.PurgeVersionTxnListener;
import org.alfresco.repo.avm.VersionLayeredNodeEntry;
import org.alfresco.repo.avm.VersionLayeredNodeEntryDAO;
import org.alfresco.repo.avm.VersionLayeredNodeEntryImpl;
import org.alfresco.repo.avm.VersionRoot;
import org.alfresco.repo.avm.VersionRootDAO;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.domain.avm.AVMStoreEntity;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.security.permissions.ACLCopyMode;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.avm.AVMBadArgumentException;
import org.alfresco.service.cmr.avm.AVMCycleException;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMExistsException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.AVMWrongTypeException;
import org.alfresco.service.cmr.avm.LayeringDescriptor;
import org.alfresco.service.cmr.avm.VersionDescriptor;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionContext;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.FileNameValidator;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMRepository {
    private static final String MSG_CYCLE_ON_CREATE = "avm.cycle.create";
    private static final String MSG_CYCLE_ON_LOOKUP = "avm.cycle.lookup";
    private static Log fgLogger = LogFactory.getLog(AVMRepository.class);
    private static AVMRepository fgInstance;
    private ThreadLocal<Integer> fLookupCount = new ThreadLocal();
    private ContentStore fContentStore;
    private LookupCache fLookupCache;
    private AVMStoreDAO fAVMStoreDAO;
    private AVMNodeDAO fAVMNodeDAO;
    private VersionRootDAO fVersionRootDAO;
    private VersionLayeredNodeEntryDAO fVersionLayeredNodeEntryDAO;
    private AVMStorePropertyDAO fAVMStorePropertyDAO;
    private ChildEntryDAO fChildEntryDAO;
    private PermissionService fPermissionService;
    private CreateStoreTxnListener fCreateStoreTxnListener;
    private PurgeStoreTxnListener fPurgeStoreTxnListener;
    private CreateVersionTxnListener fCreateVersionTxnListener;
    private PurgeVersionTxnListener fPurgeVersionTxnListener;
    private static final String WCM_STORE_SEPARATOR = "--";
    private static final String WCM_STORE_PREVIEW = "--preview";
    private static final String WCM_STORE_WORKFLOW = "--workflow-";

    public AVMRepository() {
        fgInstance = this;
    }

    public void setContentStore(ContentStore store) {
        this.fContentStore = store;
    }

    public void setLookupCache(LookupCache cache) {
        this.fLookupCache = cache;
    }

    public void setCreateStoreTxnListener(CreateStoreTxnListener listener) {
        this.fCreateStoreTxnListener = listener;
    }

    public void setPurgeStoreTxnListener(PurgeStoreTxnListener listener) {
        this.fPurgeStoreTxnListener = listener;
    }

    public void setCreateVersionTxnListener(CreateVersionTxnListener listener) {
        this.fCreateVersionTxnListener = listener;
    }

    public void setPurgeVersionTxnListener(PurgeVersionTxnListener listener) {
        this.fPurgeVersionTxnListener = listener;
    }

    public void setAvmStoreDAO(AVMStoreDAO dao) {
        this.fAVMStoreDAO = dao;
    }

    public void setAvmNodeDAO(AVMNodeDAO dao) {
        this.fAVMNodeDAO = dao;
    }

    public void setVersionRootDAO(VersionRootDAO dao) {
        this.fVersionRootDAO = dao;
    }

    public void setVersionLayeredNodeEntryDAO(VersionLayeredNodeEntryDAO dao) {
        this.fVersionLayeredNodeEntryDAO = dao;
    }

    public void setAvmStorePropertyDAO(AVMStorePropertyDAO dao) {
        this.fAVMStorePropertyDAO = dao;
    }

    public void setChildEntryDAO(ChildEntryDAO dao) {
        this.fChildEntryDAO = dao;
    }

    public void setPermissionService(PermissionService service) {
        this.fPermissionService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream createFile(String path, String name) {
        this.fLookupCount.set(1);
        try {
            OutputStream out;
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            OutputStream outputStream = out = store.createFile(pathParts[1], name);
            Object var8_7 = null;
            this.fLookupCount.set(null);
            return outputStream;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFile(String path, String name, File data, List<QName> aspects, Map<QName, PropertyValue> properties) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.createFile(pathParts[1], name, data, aspects, properties);
            Object var9_8 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDirectory(String path, String name, List<QName> aspects, Map<QName, PropertyValue> properties) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.createDirectory(pathParts[1], name, aspects, properties);
            Object var8_7 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public AVMNodeDescriptor createDirectory(AVMNodeDescriptor parent, String name) {
        Long parentAcl;
        AVMNode node = this.fAVMNodeDAO.getByID(parent.getId());
        if (node == null) {
            throw new AVMNotFoundException(parent.getId() + " not found.");
        }
        if (!(node instanceof DirectoryNode)) {
            throw new AVMWrongTypeException("Not a directory.");
        }
        if (!this.can(null, node, "CreateChildren", true)) {
            throw new AccessDeniedException("Not allowed to write in: " + parent);
        }
        String[] pathParts = this.SplitPath(parent.getPath());
        AVMStore store = this.getAVMStoreByName(pathParts[0]);
        if (store == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        DirectoryNode dir = (DirectoryNode)node;
        DirectoryNodeImpl child = null;
        Long l = parentAcl = dir.getAcl() == null ? null : dir.getAcl().getId();
        if (dir instanceof LayeredDirectoryNode) {
            child = new LayeredDirectoryNodeImpl(null, store, null, parentAcl, ACLCopyMode.INHERIT);
            ((LayeredDirectoryNode)((Object)child)).setPrimaryIndirection(false);
            ((LayeredDirectoryNode)((Object)child)).setLayerID(parent.getLayerID());
            child.copyACLs(dir, ACLCopyMode.INHERIT);
            AVMDAOs.Instance().fAVMNodeDAO.update(child);
        } else {
            child = new PlainDirectoryNodeImpl(store);
            child.copyACLs(dir, ACLCopyMode.INHERIT);
            AVMDAOs.Instance().fAVMNodeDAO.save(child);
        }
        dir.putChild(name, child);
        this.fLookupCache.onWrite(pathParts[0]);
        AVMNodeDescriptor desc = child.getDescriptor(parent.getPath(), name, parent.getIndirection(), parent.getIndirectionVersion());
        return desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLayeredDirectory(String srcPath, String dstPath, String name) {
        if (dstPath.indexOf(srcPath) == 0) {
            throw new AVMCycleException(MSG_CYCLE_ON_CREATE);
        }
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(dstPath);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.createLayeredDirectory(srcPath, pathParts[1], name);
            Object var7_6 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLayeredFile(String srcPath, String dstPath, String name) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(dstPath);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.createLayeredFile(srcPath, pathParts[1], name);
            Object var7_6 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public void createAVMStore(String name) {
        this.createAVMStore(name, null);
    }

    public void createAVMStore(String name, Map<QName, PropertyValue> props) {
        AlfrescoTransactionSupport.bindListener(this.fCreateStoreTxnListener);
        if (this.getAVMStoreByName(name) != null) {
            throw new AVMExistsException("AVMStore exists: " + name);
        }
        AVMStoreImpl rep = new AVMStoreImpl(this, name);
        DirectoryNode rootNode = rep.getRoot();
        rootNode.setStoreNew(null);
        this.fAVMNodeDAO.update(rootNode);
        if (props != null) {
            this.setStoreProperties(name, props);
        }
        this.fCreateStoreTxnListener.storeCreated(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBranch(int version, String srcPath, String dstPath, String name) {
        Lookup sPath;
        String[] pathParts;
        if (dstPath.indexOf(srcPath) == 0) {
            throw new AVMCycleException(MSG_CYCLE_ON_CREATE);
        }
        this.fLookupCount.set(1);
        List<VersionLayeredNodeEntry> layeredEntries = null;
        try {
            pathParts = this.SplitPath(srcPath);
            AVMStore srcRepo = this.getAVMStoreByName(pathParts[0]);
            if (srcRepo == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            if (version < 0) {
                this.fLookupCache.onSnapshot(pathParts[0]);
                version = srcRepo.createSnapshot("Branch Snapshot", null, new HashMap<String, Integer>()).get(pathParts[0]);
            }
            if ((sPath = srcRepo.lookup(version, pathParts[1], false, false)) == null) {
                throw new AVMNotFoundException("Path not found.");
            }
            VersionRoot lastVersion = this.fVersionRootDAO.getByVersionID(srcRepo, version);
            layeredEntries = this.fVersionLayeredNodeEntryDAO.get(lastVersion);
            Object var11_10 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
        this.fLookupCount.set(1);
        try {
            Long inheritAcl;
            pathParts = this.SplitPath(dstPath);
            AVMStore dstRepo = this.getAVMStoreByName(pathParts[0]);
            if (dstRepo == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            Lookup dPath = dstRepo.lookupDirectory(-1, pathParts[1], true);
            if (dPath == null) {
                throw new AVMNotFoundException("Path not found.");
            }
            DirectoryNode dirNode = (DirectoryNode)dPath.getCurrentNode();
            if (!this.can(dstRepo, dirNode, "AddChildren", dPath.getDirectlyContained())) {
                throw new AccessDeniedException("Not permitted to add children: " + dstPath);
            }
            AVMNode srcNode = sPath.getCurrentNode();
            AVMNodeImpl dstNode = null;
            Long l = inheritAcl = srcNode.getAcl() == null ? null : srcNode.getAcl().getId();
            if (srcNode.getType() == 2) {
                dstNode = new PlainDirectoryNodeImpl((PlainDirectoryNode)srcNode, dstRepo, inheritAcl, ACLCopyMode.INHERIT);
            } else if (srcNode.getType() == 3) {
                dstNode = new LayeredDirectoryNodeImpl((LayeredDirectoryNode)srcNode, dstRepo, sPath, false, inheritAcl, ACLCopyMode.INHERIT);
                ((LayeredDirectoryNode)((Object)dstNode)).setLayerID(dstNode.getId());
                AVMDAOs.Instance().fAVMNodeDAO.update(dstNode);
            } else {
                dstNode = srcNode.getType() == 1 ? new LayeredFileNodeImpl((LayeredFileNode)srcNode, dstRepo, inheritAcl, ACLCopyMode.INHERIT) : new PlainFileNodeImpl((PlainFileNode)srcNode, dstRepo, inheritAcl, ACLCopyMode.INHERIT);
            }
            dstNode.setAncestor(srcNode);
            dirNode.putChild(name, dstNode);
            String beginingPath = AVMUtil.normalizePath(srcPath);
            String finalPath = AVMUtil.extendAVMPath(dstPath, name);
            finalPath = AVMUtil.normalizePath(finalPath);
            VersionRoot latestVersion = this.fVersionRootDAO.getMaxVersion(dstRepo);
            for (VersionLayeredNodeEntry entry : layeredEntries) {
                String path = entry.getPath();
                if (!path.startsWith(srcPath)) continue;
                String newPath = finalPath + path.substring(beginingPath.length());
                VersionLayeredNodeEntryImpl newEntry = new VersionLayeredNodeEntryImpl(latestVersion, newPath);
                this.fVersionLayeredNodeEntryDAO.save(newEntry);
            }
            Object var23_24 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var23_25 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream(String path) {
        this.fLookupCount.set(1);
        try {
            OutputStream out;
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            OutputStream outputStream = out = store.getOutputStream(pathParts[1]);
            Object var7_6 = null;
            this.fLookupCount.set(null);
            return outputStream;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentReader getContentReader(int version, String path) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found: " + pathParts[0]);
            }
            ContentReader contentReader = store.getContentReader(version, pathParts[1]);
            Object var7_6 = null;
            this.fLookupCount.set(null);
            return contentReader;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentWriter createContentWriter(String path, boolean update) {
        this.fLookupCount.set(1);
        try {
            ContentWriter writer;
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found: " + pathParts[0]);
            }
            this.fLookupCache.onWrite(pathParts[0]);
            ContentWriter contentWriter = writer = store.createContentWriter(pathParts[1], update);
            Object var8_7 = null;
            this.fLookupCount.set(null);
            return contentWriter;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String srcPath, String srcName, String dstPath, String dstName) {
        AVMNode srcNode;
        DirectoryNode srcDir;
        Lookup sPath;
        String[] pathParts;
        String extSrc;
        String extDst = AVMUtil.extendAVMPath(dstPath, "");
        if (extDst.indexOf(extSrc = AVMUtil.extendAVMPath(AVMUtil.extendAVMPath(srcPath, srcName), "")) == 0) {
            throw new AVMCycleException(MSG_CYCLE_ON_CREATE);
        }
        this.fLookupCount.set(1);
        try {
            pathParts = this.SplitPath(srcPath);
            AVMStore srcRepo = this.getAVMStoreByName(pathParts[0]);
            if (srcRepo == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            sPath = srcRepo.lookupDirectory(-1, pathParts[1], true);
            if (sPath == null) {
                throw new AVMNotFoundException("Path not found.");
            }
            srcDir = (DirectoryNode)sPath.getCurrentNode();
            Pair<AVMNode, Boolean> temp = srcDir.lookupChild(sPath, srcName, false);
            AVMNode aVMNode = srcNode = temp == null ? null : (AVMNode)temp.getFirst();
            if (srcNode == null) {
                throw new AVMNotFoundException("Not found: " + srcName);
            }
            if (!this.can(srcRepo, srcNode, "DeleteNode", false)) {
                throw new AccessDeniedException("Not allowed to delete target: " + srcPath);
            }
            this.fLookupCache.onDelete(pathParts[0]);
            Object var14_13 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
        this.fLookupCount.set(1);
        try {
            pathParts = this.SplitPath(dstPath);
            AVMStore dstRepo = this.getAVMStoreByName(pathParts[0]);
            if (dstRepo == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            Lookup dPath = dstRepo.lookupDirectory(-1, pathParts[1], true);
            if (dPath == null) {
                throw new AVMNotFoundException("Path not found.");
            }
            DirectoryNode dstDir = (DirectoryNode)dPath.getCurrentNode();
            if (!this.can(dstRepo, dstDir, "AddChildren", dPath.getDirectlyContained())) {
                throw new AccessDeniedException("Not allowed to write: " + dstPath);
            }
            Pair<AVMNode, Boolean> temp = dstDir.lookupChild(dPath, dstName, true);
            AVMNode child = temp == null ? null : (AVMNode)temp.getFirst();
            boolean renameCase = false;
            if (child != null && child.getType() != 4) {
                String avmDstPath;
                String avmSrcPath = AVMUtil.extendAVMPath(srcPath, srcName);
                if (avmSrcPath.equalsIgnoreCase(avmDstPath = AVMUtil.extendAVMPath(dstPath, dstName)) && !srcName.equals(dstName)) {
                    if (fgLogger.isDebugEnabled()) {
                        fgLogger.debug((Object)("rename: only change case: from " + avmSrcPath + " to " + avmDstPath));
                    }
                    renameCase = true;
                } else {
                    throw new AVMExistsException("Node exists: " + dstName);
                }
            }
            if (!renameCase) {
                Long parentAcl = dstDir.getAcl() == null ? null : dstDir.getAcl().getId();
                AVMNodeImpl dstNode = null;
                if (srcNode.getType() == 2) {
                    if (sPath.isLayered()) {
                        if (dPath.isLayered() && dPath.getTopLayer().equals(sPath.getTopLayer())) {
                            dstNode = new LayeredDirectoryNodeImpl((PlainDirectoryNode)srcNode, dstRepo, sPath, true, parentAcl, ACLCopyMode.COPY);
                            ((LayeredDirectoryNode)((Object)dstNode)).setLayerID(sPath.getTopLayer().getLayerID());
                        } else {
                            dstNode = new LayeredDirectoryNodeImpl((DirectoryNode)srcNode, dstRepo, sPath, srcName, parentAcl, ACLCopyMode.COPY);
                            ((LayeredDirectoryNode)((Object)dstNode)).setLayerID(dstNode.getId());
                        }
                        AVMDAOs.Instance().fAVMNodeDAO.update(dstNode);
                    } else {
                        dstNode = new PlainDirectoryNodeImpl((PlainDirectoryNode)srcNode, dstRepo, parentAcl, ACLCopyMode.COPY);
                    }
                } else if (srcNode.getType() == 3) {
                    if (!sPath.isLayered() || sPath.isInThisLayer() && srcDir.getType() == 3 && ((LayeredDirectoryNode)srcDir).directlyContains(srcNode)) {
                        Lookup srcLookup = this.lookup(-1, srcPath + "/" + srcName, true);
                        dstNode = new LayeredDirectoryNodeImpl((LayeredDirectoryNode)srcNode, dstRepo, srcLookup, true, parentAcl, ACLCopyMode.COPY);
                        ((LayeredDirectoryNode)((Object)dstNode)).setLayerID(((LayeredDirectoryNode)srcNode).getLayerID());
                    } else {
                        if (((LayeredDirectoryNode)srcNode).getPrimaryIndirection()) {
                            Lookup srcLookup = this.lookup(-1, srcPath + "/" + srcName, true);
                            dstNode = new LayeredDirectoryNodeImpl((LayeredDirectoryNode)srcNode, dstRepo, srcLookup, true, parentAcl, ACLCopyMode.COPY);
                        } else {
                            dstNode = new LayeredDirectoryNodeImpl((DirectoryNode)srcNode, dstRepo, sPath, srcName, parentAcl, ACLCopyMode.COPY);
                        }
                        if (dPath.isLayered()) {
                            ((LayeredDirectoryNode)((Object)dstNode)).setLayerID(dPath.getTopLayer().getLayerID());
                        } else {
                            ((LayeredDirectoryNode)((Object)dstNode)).setLayerID(dstNode.getId());
                        }
                    }
                    AVMDAOs.Instance().fAVMNodeDAO.update(dstNode);
                } else {
                    dstNode = srcNode.getType() == 1 ? new LayeredFileNodeImpl((LayeredFileNode)srcNode, dstRepo, parentAcl, ACLCopyMode.COPY) : new PlainFileNodeImpl((PlainFileNode)srcNode, dstRepo, parentAcl, ACLCopyMode.COPY);
                }
                srcDir.removeChild(sPath, srcName);
                if (child != null) {
                    dstNode.setAncestor(child);
                }
                dstDir.putChild(dstName, dstNode);
                if (child == null) {
                    dstNode.setAncestor(srcNode);
                }
            } else {
                this.forceCopy(AVMUtil.extendAVMPath(srcPath, srcName));
                Pair<ChildEntry, Boolean> result = srcDir.lookupChildEntry(sPath, srcName, false);
                if (result != null) {
                    ChildKey key = ((ChildEntry)result.getFirst()).getKey();
                    key.setName(srcName);
                    AVMDAOs.Instance().fChildEntryDAO.rename(key, dstName);
                }
            }
            this.fLookupCache.onWrite(pathParts[0]);
            Object var21_23 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var21_24 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncover(String dirPath, String name) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(dirPath);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.uncover(pathParts[1], name);
            Object var6_5 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public Map<String, Integer> createSnapshot(String storeName, String tag, String description) {
        AlfrescoTransactionSupport.bindListener(this.fCreateVersionTxnListener);
        AVMStore store = this.getAVMStoreByName(storeName);
        if (store == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        Map<String, Integer> result = store.createSnapshot(tag, description, new HashMap<String, Integer>());
        for (Map.Entry<String, Integer> entry : result.entrySet()) {
            this.fLookupCache.onSnapshot(entry.getKey());
            this.fCreateVersionTxnListener.versionCreated(entry.getKey(), entry.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String path, String name) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onDelete(pathParts[0]);
            store.removeNode(pathParts[1], name);
            Object var6_5 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public void purgeAVMStore(String name) {
        AlfrescoTransactionSupport.bindListener(this.fPurgeStoreTxnListener);
        AVMStore store = this.getAVMStoreByName(name);
        if (store == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        this.fLookupCache.onDelete(name);
        DirectoryNode root = store.getRoot();
        if (!this.can(store, root, "DeleteChildren", true)) {
            throw new AccessDeniedException("Not allowed to purge: " + name);
        }
        root.setIsRoot(false);
        this.fAVMNodeDAO.update(root);
        List<VersionRoot> vRoots = this.fVersionRootDAO.getAllInAVMStore(store);
        for (VersionRoot vr : vRoots) {
            AVMNode node = this.fAVMNodeDAO.getByID(vr.getRoot().getId());
            node.setIsRoot(false);
            this.fAVMNodeDAO.update(node);
            this.fVersionLayeredNodeEntryDAO.delete(vr);
            this.fVersionRootDAO.delete(vr);
        }
        List<AVMNode> newGuys = this.fAVMNodeDAO.getNewInStore(store);
        for (AVMNode newGuy : newGuys) {
            newGuy.setStoreNew(null);
            this.fAVMNodeDAO.update(newGuy);
        }
        this.fAVMStorePropertyDAO.delete(store);
        this.fAVMStoreDAO.delete(store);
        this.fAVMStoreDAO.invalidateCache();
        this.fPurgeStoreTxnListener.storePurged(name);
        if (fgLogger.isDebugEnabled()) {
            fgLogger.debug((Object)("Purged store: " + name));
        }
    }

    public void purgeVersion(String name, int version) {
        AlfrescoTransactionSupport.bindListener(this.fPurgeVersionTxnListener);
        AVMStore store = this.getAVMStoreByName(name);
        if (store == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        this.fLookupCache.onDelete(name);
        store.purgeVersion(version);
        this.fPurgeVersionTxnListener.versionPurged(name, version);
        if (fgLogger.isDebugEnabled()) {
            fgLogger.debug((Object)("Purged version: " + name + " " + version));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(int version, String path) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            InputStream inputStream = store.getInputStream(version, pathParts[1]);
            Object var7_6 = null;
            this.fLookupCount.set(null);
            return inputStream;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public InputStream getInputStream(AVMNodeDescriptor desc) {
        AVMNode node = this.fAVMNodeDAO.getByID(desc.getId());
        if (!(node instanceof FileNode)) {
            throw new AVMWrongTypeException(desc + " is not a File.");
        }
        if (!this.can(null, node, "ReadContent", false)) {
            throw new AccessDeniedException("Not allowed to read content: " + desc);
        }
        FileNode file = (FileNode)node;
        ContentData data = file.getContentData(null);
        if (data == null) {
            throw new AVMException(desc + " has no content.");
        }
        ContentReader reader = this.fContentStore.getReader(data.getContentUrl());
        return reader.getContentInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, AVMNodeDescriptor> getListing(int version, String path, boolean includeDeleted) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            SortedMap<String, AVMNodeDescriptor> sortedMap = store.getListing(version, pathParts[1], includeDeleted);
            Object var8_7 = null;
            this.fLookupCount.set(null);
            return sortedMap;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, AVMNodeDescriptor> getListingDirect(int version, String path, boolean includeDeleted) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            SortedMap<String, AVMNodeDescriptor> sortedMap = store.getListingDirect(version, pathParts[1], includeDeleted);
            Object var8_7 = null;
            this.fLookupCount.set(null);
            return sortedMap;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public SortedMap<String, AVMNodeDescriptor> getListingDirect(AVMNodeDescriptor dir, boolean includeDeleted) {
        AVMNode node = this.fAVMNodeDAO.getByID(dir.getId());
        if (node == null) {
            throw new AVMBadArgumentException("Invalid Node.");
        }
        if (!this.can(null, node, "ReadChildren", false)) {
            throw new AccessDeniedException("Not allowed to read children: " + dir);
        }
        if (node.getType() == 2) {
            return this.getListing(dir, includeDeleted);
        }
        if (node.getType() != 3) {
            throw new AVMWrongTypeException("Not a directory.");
        }
        LayeredDirectoryNode dirNode = (LayeredDirectoryNode)node;
        return dirNode.getListingDirect(dir, includeDeleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, AVMNodeDescriptor> getListing(AVMNodeDescriptor dir, boolean includeDeleted) {
        this.fLookupCount.set(1);
        try {
            SortedMap<String, AVMNodeDescriptor> listing;
            AVMNode node = this.fAVMNodeDAO.getByID(dir.getId());
            if (node == null) {
                throw new AVMBadArgumentException("Invalid Node.");
            }
            if (node.getType() != 3 && node.getType() != 2) {
                throw new AVMWrongTypeException("Not a directory.");
            }
            if (!this.can(null, node, "ReadChildren", false)) {
                throw new AccessDeniedException("Not allowed to read children: " + dir);
            }
            DirectoryNode dirNode = (DirectoryNode)node;
            SortedMap<String, AVMNodeDescriptor> sortedMap = listing = dirNode.getListing(dir, includeDeleted);
            Object var8_7 = null;
            this.fLookupCount.set(null);
            return sortedMap;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, AVMNodeDescriptor> getListing(AVMNodeDescriptor dir, String childNamePattern, boolean includeDeleted) {
        this.fLookupCount.set(1);
        try {
            SortedMap<String, AVMNodeDescriptor> listing;
            AVMNode node = this.fAVMNodeDAO.getByID(dir.getId());
            if (node == null) {
                throw new AVMBadArgumentException("Invalid Node.");
            }
            if (node.getType() != 3 && node.getType() != 2) {
                throw new AVMWrongTypeException("Not a directory.");
            }
            if (!this.can(null, node, "ReadChildren", false)) {
                throw new AccessDeniedException("Not allowed to read children: " + dir);
            }
            DirectoryNode dirNode = (DirectoryNode)node;
            SortedMap<String, AVMNodeDescriptor> sortedMap = listing = dirNode.getListing(dir, childNamePattern, includeDeleted);
            Object var9_8 = null;
            this.fLookupCount.set(null);
            return sortedMap;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDeleted(int version, String path) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            List<String> list = store.getDeleted(version, pathParts[1]);
            Object var7_6 = null;
            this.fLookupCount.set(null);
            return list;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public List<AVMStoreDescriptor> getAVMStores() {
        List<AVMStoreEntity> storeEntities = AVMDAOs.Instance().newAVMStoreDAO.getAllStores();
        ArrayList<AVMStoreDescriptor> result = new ArrayList<AVMStoreDescriptor>(storeEntities.size());
        for (AVMStoreEntity storeEntity : storeEntities) {
            AVMStoreImpl store = new AVMStoreImpl();
            store.setId(storeEntity.getId());
            store.setName(storeEntity.getName());
            result.add(store.getDescriptor());
        }
        return result;
    }

    public AVMStoreDescriptor getAVMStore(String name) {
        AVMStore store = this.getAVMStoreByName(name);
        if (store == null) {
            return null;
        }
        return store.getDescriptor();
    }

    public List<VersionDescriptor> getAVMStoreVersions(String name) {
        AVMStore store = this.getAVMStoreByName(name);
        if (store == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        return store.getVersions();
    }

    public List<VersionDescriptor> getAVMStoreVersions(String name, Date from, Date to) {
        AVMStore store = this.getAVMStoreByName(name);
        if (store == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        return store.getVersions(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIndirectionPath(int version, String path) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            String string = store.getIndirectionPath(version, pathParts[1]);
            Object var7_6 = null;
            this.fLookupCount.set(null);
            return string;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public int getLatestVersionID(String name) {
        AVMStore store = this.getAVMStoreByName(name);
        if (store == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        return store.getNextVersionID();
    }

    public int getLatestSnapshotID(String name) {
        AVMStore store = this.getAVMStoreByName(name);
        if (store == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        return store.getLastVersionID();
    }

    private AVMStore getAVMStoreByName(String name) {
        AVMStore store = this.fAVMStoreDAO.getByName(name);
        return store;
    }

    public AVMNodeDescriptor getAVMStoreRoot(int version, String name) {
        AVMStore store = this.getAVMStoreByName(name);
        if (store == null) {
            throw new AVMNotFoundException("Not found: " + name);
        }
        return store.getRoot(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup lookup(int version, String path, boolean includeDeleted) {
        AVMStore store;
        String[] pathParts;
        Integer count;
        block8: {
            count = this.fLookupCount.get();
            try {
                if (count == null) {
                    this.fLookupCount.set(1);
                } else {
                    this.fLookupCount.set(count + 1);
                }
                if (this.fLookupCount.get() > 50) {
                    throw new AVMCycleException(MSG_CYCLE_ON_LOOKUP);
                }
                pathParts = this.SplitPath(path);
                store = this.getAVMStoreByName(pathParts[0]);
                if (store != null) break block8;
                Lookup lookup = null;
                Object var9_9 = null;
                if (count == null) {
                    this.fLookupCount.set(null);
                }
                return lookup;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var9_11 = null;
                    if (count != null) break block9;
                    this.fLookupCount.set(null);
                }
                throw throwable;
            }
        }
        Lookup lookup = store.lookup(version, pathParts[1], false, includeDeleted);
        Object var9_10 = null;
        if (count == null) {
            this.fLookupCount.set(null);
        }
        return lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AVMNodeDescriptor lookup(AVMNodeDescriptor dir, String name, boolean includeDeleted) {
        this.fLookupCount.set(1);
        try {
            AVMNode node = this.fAVMNodeDAO.getByID(dir.getId());
            if (node == null) {
                throw new AVMNotFoundException("Not found: " + dir.getId());
            }
            if (node.getType() != 3 && node.getType() != 2) {
                throw new AVMWrongTypeException("Not a directory.");
            }
            DirectoryNode dirNode = (DirectoryNode)node;
            if (!this.can(null, dirNode, "ReadChildren", false)) {
                throw new AccessDeniedException("Not allowed to read children: " + dir);
            }
            AVMNodeDescriptor aVMNodeDescriptor = dirNode.lookupChild(dir, name, includeDeleted);
            Object var8_7 = null;
            this.fLookupCount.set(null);
            return aVMNodeDescriptor;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public List<Pair<Integer, String>> getPaths(AVMNodeDescriptor desc) {
        AVMNode node = this.fAVMNodeDAO.getByID(desc.getId());
        if (node == null) {
            throw new AVMNotFoundException("Not found: " + desc);
        }
        ArrayList<Pair<Integer, String>> paths = new ArrayList<Pair<Integer, String>>();
        ArrayList<String> components = new ArrayList<String>();
        this.recursiveGetPaths(node, components, paths);
        return paths;
    }

    public Pair<Integer, String> getAPath(AVMNodeDescriptor desc) {
        AVMNode node = this.fAVMNodeDAO.getByID(desc.getId());
        if (node == null) {
            throw new AVMNotFoundException("Could not find node: " + desc);
        }
        if (fgLogger.isDebugEnabled()) {
            fgLogger.debug((Object)("Getting A Path for: " + desc));
        }
        ArrayList<String> components = new ArrayList<String>();
        return this.recursiveGetAPath(node, components);
    }

    public List<Pair<Integer, String>> getHeadPaths(AVMNodeDescriptor desc) {
        AVMNode node = this.fAVMNodeDAO.getByID(desc.getId());
        if (node == null) {
            throw new AVMNotFoundException("Not found: " + desc.getPath());
        }
        ArrayList<Pair<Integer, String>> paths = new ArrayList<Pair<Integer, String>>();
        ArrayList<String> components = new ArrayList<String>();
        this.recursiveGetHeadPaths(node, components, paths);
        return paths;
    }

    public List<String> getVersionPaths(VersionRoot version, AVMNode node) {
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<String> components = new ArrayList<String>();
        this.recursiveGetVersionPaths(node, components, paths, version.getRoot(), version.getAvmStore().getName());
        return paths;
    }

    private void recursiveGetVersionPaths(AVMNode node, List<String> components, List<String> paths, DirectoryNode root, String storeName) {
        if (!this.can(null, node, "ReadChildren", false)) {
            return;
        }
        if (node.equals(root)) {
            paths.add(this.makePath(components, storeName));
            return;
        }
        List<ChildEntry> entries = this.fChildEntryDAO.getByChild(node);
        for (ChildEntry entry : entries) {
            String name = entry.getKey().getName();
            components.add(name);
            DirectoryNode parent = entry.getKey().getParent();
            this.recursiveGetVersionPaths(parent, components, paths, root, storeName);
            components.remove(components.size() - 1);
        }
    }

    public List<Pair<Integer, String>> getPathsInStoreHead(AVMNodeDescriptor desc, String store) {
        AVMStore st = this.getAVMStoreByName(store);
        if (st == null) {
            throw new AVMNotFoundException("Store not found: " + store);
        }
        AVMNode node = this.fAVMNodeDAO.getByID(desc.getId());
        if (node == null) {
            throw new AVMNotFoundException("Not found: " + desc);
        }
        ArrayList<Pair<Integer, String>> paths = new ArrayList<Pair<Integer, String>>();
        ArrayList<String> components = new ArrayList<String>();
        this.recursiveGetPathsInStoreHead(node, components, paths, st.getRoot(), store);
        return paths;
    }

    private void recursiveGetPaths(AVMNode node, List<String> components, List<Pair<Integer, String>> paths) {
        if (!this.can(null, node, "ReadChildren", false)) {
            return;
        }
        if (node.getIsRoot()) {
            VersionRoot vr;
            AVMStore store = this.fAVMStoreDAO.getByRoot(node);
            if (store != null) {
                this.addPath(components, -1, store.getName(), paths);
            }
            if ((vr = this.fVersionRootDAO.getByRoot(node)) != null) {
                this.addPath(components, vr.getVersionID(), vr.getAvmStore().getName(), paths);
            }
            return;
        }
        List<ChildEntry> entries = this.fChildEntryDAO.getByChild(node);
        for (ChildEntry entry : entries) {
            String name = entry.getKey().getName();
            components.add(name);
            DirectoryNode parent = entry.getKey().getParent();
            this.recursiveGetPaths(parent, components, paths);
            components.remove(components.size() - 1);
        }
    }

    private Pair<Integer, String> recursiveGetAPath(AVMNode node, List<String> components) {
        if (!this.can(null, node, "ReadChildren", false)) {
            return null;
        }
        if (node.getIsRoot()) {
            AVMStore store = this.fAVMStoreDAO.getByRoot(node);
            if (store != null) {
                if (fgLogger.isDebugEnabled()) {
                    fgLogger.debug((Object)("Found path in HEAD of: " + store.getName()));
                }
                return new Pair((Object)-1, (Object)this.makePath(components, store.getName()));
            }
            VersionRoot vr = this.fVersionRootDAO.getByRoot(node);
            if (vr != null) {
                if (fgLogger.isDebugEnabled()) {
                    fgLogger.debug((Object)("Found path in version " + vr.getVersionID() + " in: " + vr.getAvmStore().getName()));
                }
                return new Pair((Object)vr.getVersionID(), (Object)this.makePath(components, vr.getAvmStore().getName()));
            }
            return null;
        }
        List<ChildEntry> entries = this.fChildEntryDAO.getByChild(node);
        for (ChildEntry entry : entries) {
            String name = entry.getKey().getName();
            if (fgLogger.isDebugEnabled()) {
                fgLogger.debug((Object)("Found component: " + name));
            }
            components.add(name);
            Pair<Integer, String> path = this.recursiveGetAPath(entry.getKey().getParent(), components);
            if (path != null) {
                return path;
            }
            components.remove(components.size() - 1);
        }
        return null;
    }

    private void recursiveGetHeadPaths(AVMNode node, List<String> components, List<Pair<Integer, String>> paths) {
        if (!this.can(null, node, "ReadChildren", false)) {
            return;
        }
        if (node.getIsRoot()) {
            AVMStore store = this.fAVMStoreDAO.getByRoot(node);
            if (store != null) {
                this.addPath(components, -1, store.getName(), paths);
                return;
            }
            return;
        }
        List<ChildEntry> entries = this.fChildEntryDAO.getByChild(node);
        for (ChildEntry entry : entries) {
            String name = entry.getKey().getName();
            components.add(name);
            DirectoryNode parent = entry.getKey().getParent();
            this.recursiveGetHeadPaths(parent, components, paths);
            components.remove(components.size() - 1);
        }
    }

    private void recursiveGetPathsInStoreHead(AVMNode node, List<String> components, List<Pair<Integer, String>> paths, DirectoryNode root, String storeName) {
        if (!this.can(null, node, "ReadChildren", false)) {
            return;
        }
        if (node.equals(root)) {
            this.addPath(components, -1, storeName, paths);
            return;
        }
        List<ChildEntry> entries = this.fChildEntryDAO.getByChild(node);
        for (ChildEntry entry : entries) {
            String name = entry.getKey().getName();
            components.add(name);
            DirectoryNode parent = entry.getKey().getParent();
            this.recursiveGetHeadPaths(parent, components, paths);
            components.remove(components.size() - 1);
        }
    }

    private void addPath(List<String> components, int version, String storeName, List<Pair<Integer, String>> paths) {
        paths.add((Pair<Integer, String>)new Pair((Object)version, (Object)this.makePath(components, storeName)));
    }

    private void addPath(List<String> components, String storeName, List<String> paths) {
        paths.add(this.makePath(components, storeName));
    }

    private String makePath(List<String> components, String storeName) {
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(storeName);
        pathBuilder.append(":");
        if (components.size() == 0) {
            pathBuilder.append("/");
            return pathBuilder.toString();
        }
        for (int i = components.size() - 1; i >= 0; --i) {
            pathBuilder.append("/");
            pathBuilder.append(components.get(i));
        }
        return pathBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayeringDescriptor getLayeringInfo(int version, String path) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            Lookup lookup = store.lookup(version, pathParts[1], false, true);
            if (lookup == null) {
                throw new AVMNotFoundException("Path not found.");
            }
            if (!this.can(store, lookup.getCurrentNode(), "ReadProperties", false)) {
                throw new AccessDeniedException("Not allowed to read properties: " + path);
            }
            LayeringDescriptor layeringDescriptor = new LayeringDescriptor(!lookup.getDirectlyContained(), lookup.getAVMStore().getDescriptor(), lookup.getFinalStore().getDescriptor());
            Object var8_7 = null;
            this.fLookupCount.set(null);
            return layeringDescriptor;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup lookupDirectory(int version, String path) {
        AVMStore store;
        String[] pathParts;
        Integer count;
        block7: {
            count = this.fLookupCount.get();
            try {
                if (count == null) {
                    this.fLookupCount.set(1);
                }
                this.fLookupCount.set(this.fLookupCount.get() + 1);
                if (this.fLookupCount.get() > 50) {
                    throw new AVMCycleException(MSG_CYCLE_ON_LOOKUP);
                }
                pathParts = this.SplitPath(path);
                store = this.getAVMStoreByName(pathParts[0]);
                if (store != null) break block7;
                Lookup lookup = null;
                Object var8_8 = null;
                if (count == null) {
                    this.fLookupCount.set(null);
                }
                return lookup;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var8_10 = null;
                    if (count != null) break block8;
                    this.fLookupCount.set(null);
                }
                throw throwable;
            }
        }
        Lookup lookup = store.lookupDirectory(version, pathParts[1], false);
        Object var8_9 = null;
        if (count == null) {
            this.fLookupCount.set(null);
        }
        return lookup;
    }

    private String[] SplitPath(String path) {
        return AVMUtil.splitPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePrimary(String path) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.makePrimary(pathParts[1]);
            Object var5_4 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retargetLayeredDirectory(String path, String target) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.retargetLayeredDirectory(pathParts[1], target);
            Object var6_5 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public List<AVMNodeDescriptor> getHistory(AVMNodeDescriptor desc, int count) {
        AVMNode ancNode;
        AVMNode node = this.fAVMNodeDAO.getByID(desc.getId());
        if (node == null) {
            throw new AVMNotFoundException("Not found.");
        }
        if (!this.can(null, node, "ReadProperties", false)) {
            throw new AccessDeniedException("Not allowed to read properties: " + desc);
        }
        if (count < 0) {
            count = Integer.MAX_VALUE;
        }
        ArrayList<AVMNodeDescriptor> history = new ArrayList<AVMNodeDescriptor>();
        for (int i = 0; i < count && (ancNode = node.getAncestor()) != null && this.can(null, ancNode, "ReadProperties", false) && (node.getType() != 1 || ancNode.getType() != 0); ++i) {
            history.add(ancNode.getDescriptor("UNKNOWN", "UNKNOWN", "UNKNOWN", -1));
            node = ancNode;
        }
        return history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpacity(String path, boolean opacity) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.setOpacity(pathParts[1], opacity);
            Object var6_5 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeProperty(String path, QName name, PropertyValue value) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.setNodeProperty(pathParts[1], name, value);
            Object var7_6 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeProperties(String path, Map<QName, PropertyValue> properties) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.setNodeProperties(pathParts[1], properties);
            Object var6_5 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyValue getNodeProperty(int version, String path, QName name) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            PropertyValue propertyValue = store.getNodeProperty(version, pathParts[1], name);
            Object var8_7 = null;
            this.fLookupCount.set(null);
            return propertyValue;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<QName, PropertyValue> getNodeProperties(int version, String path) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            Map<QName, PropertyValue> map = store.getNodeProperties(version, pathParts[1]);
            Object var7_6 = null;
            this.fLookupCount.set(null);
            return map;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNodeProperty(String path, QName name) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.deleteNodeProperty(pathParts[1], name);
            Object var6_5 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNodeProperties(String path) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.deleteNodeProperties(pathParts[1]);
            Object var5_4 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public void setStoreProperty(String store, QName name, PropertyValue value) {
        AVMStore st = this.getAVMStoreByName(store);
        if (st == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        st.setProperty(name, value);
    }

    public void setStoreProperties(String store, Map<QName, PropertyValue> props) {
        AVMStore st = this.getAVMStoreByName(store);
        if (st == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        st.setProperties(props);
    }

    public PropertyValue getStoreProperty(String store, QName name) {
        if (store == null) {
            throw new AVMBadArgumentException("Null store name.");
        }
        AVMStore st = this.getAVMStoreByName(store);
        if (st == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        return st.getProperty(name);
    }

    public Map<QName, PropertyValue> queryStorePropertyKey(String store, QName keyPattern) {
        AVMStore st = this.getAVMStoreByName(store);
        if (st == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        return this.fAVMStorePropertyDAO.queryByKeyPattern(st, keyPattern);
    }

    public Map<String, Map<QName, PropertyValue>> queryStoresPropertyKeys(QName keyPattern) {
        return this.fAVMStorePropertyDAO.queryByKeyPattern(keyPattern);
    }

    public Map<QName, PropertyValue> getStoreProperties(String store) {
        if (store == null) {
            throw new AVMBadArgumentException("Null store name.");
        }
        AVMStore st = this.getAVMStoreByName(store);
        if (st == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        return st.getProperties();
    }

    public void deleteStoreProperty(String store, QName name) {
        AVMStore st = this.getAVMStoreByName(store);
        if (st == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        st.deleteProperty(name);
    }

    public AVMNodeDescriptor getCommonAncestor(AVMNodeDescriptor left, AVMNodeDescriptor right) {
        AVMNode lNode = this.fAVMNodeDAO.getByID(left.getId());
        AVMNode rNode = this.fAVMNodeDAO.getByID(right.getId());
        if (lNode == null || rNode == null) {
            throw new AVMNotFoundException("Node not found.");
        }
        if (!this.can(null, lNode, "ReadProperties", false)) {
            throw new AccessDeniedException("Not allowed to read properties: " + left);
        }
        if (!this.can(null, rNode, "ReadProperties", false)) {
            throw new AccessDeniedException("Not allowed to read properties: " + right);
        }
        ArrayList<AVMNode> leftHistory = new ArrayList<AVMNode>();
        ArrayList<AVMNode> rightHistory = new ArrayList<AVMNode>();
        while (lNode != null || rNode != null) {
            AVMNode check;
            boolean checkRight = false;
            if (lNode != null) {
                leftHistory.add(lNode);
                checkRight = true;
                lNode = lNode.getAncestor();
            }
            boolean checkLeft = false;
            if (rNode != null) {
                rightHistory.add(rNode);
                checkLeft = true;
                rNode = rNode.getAncestor();
            }
            if (checkRight) {
                check = (AVMNode)leftHistory.get(leftHistory.size() - 1);
                for (AVMNode node : rightHistory) {
                    if (!node.equals(check)) continue;
                    return node.getDescriptor("", "", "", -1);
                }
            }
            if (!checkLeft) continue;
            check = (AVMNode)rightHistory.get(rightHistory.size() - 1);
            for (AVMNode node : leftHistory) {
                if (!node.equals(check)) continue;
                return node.getDescriptor("", "", "", -1);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentData getContentDataForRead(int version, String path) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            ContentData contentData = store.getContentDataForRead(version, pathParts[1]);
            Object var7_6 = null;
            this.fLookupCount.set(null);
            return contentData;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentData getContentDataForWrite(String path) {
        this.fLookupCount.set(1);
        try {
            ContentData result;
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            ContentData contentData = result = store.getContentDataForWrite(pathParts[1]);
            Object var7_6 = null;
            this.fLookupCount.set(null);
            return contentData;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentData(String path, ContentData data) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.setContentData(pathParts[1], data);
            Object var6_5 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public static AVMRepository GetInstance() {
        return fgInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaDataFrom(String path, AVMNodeDescriptor from) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found: " + pathParts[0]);
            }
            AVMNode fromNode = this.fAVMNodeDAO.getByID(from.getId());
            if (fromNode == null) {
                throw new AVMNotFoundException("Node not found: " + from.getPath());
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.setMetaDataFrom(pathParts[1], fromNode);
            Object var7_6 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAspect(String path, QName aspectName) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.addAspect(pathParts[1], aspectName);
            Object var6_5 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<QName> getAspects(int version, String path) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            Set<QName> set = store.getAspects(version, pathParts[1]);
            Object var7_6 = null;
            this.fLookupCount.set(null);
            return set;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAspect(String path, QName aspectName) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.removeAspect(pathParts[1], aspectName);
            Object var6_5 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAspect(int version, String path, QName aspectName) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            boolean bl = store.hasAspect(version, pathParts[1], aspectName);
            Object var8_7 = null;
            this.fLookupCount.set(null);
            return bl;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setACL(String path, Acl acl) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.setACL(pathParts[1], acl);
            Object var6_5 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Acl getACL(int version, String path) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            Acl acl = store.getACL(version, pathParts[1]);
            Object var7_6 = null;
            this.fLookupCount.set(null);
            return acl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void link(String parentPath, String name, AVMNodeDescriptor toLink) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(parentPath);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            store.link(pathParts[1], name, toLink);
            this.fLookupCache.onWrite(pathParts[0]);
            Object var7_6 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLink(String parentPath, String name, AVMNodeDescriptor toLink) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(parentPath);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            store.updateLink(pathParts[1], name, toLink);
            this.fLookupCache.onWrite(pathParts[0]);
            Object var7_6 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public void link(AVMNodeDescriptor parent, String name, AVMNodeDescriptor child) {
        AVMNode node = this.fAVMNodeDAO.getByID(parent.getId());
        if (!(node instanceof DirectoryNode)) {
            throw new AVMWrongTypeException("Not a Directory.");
        }
        DirectoryNode dir = (DirectoryNode)node;
        if (!dir.getIsNew()) {
            throw new AVMException("Directory has not already been copied.");
        }
        if (!this.can(null, dir, "AddChildren", false)) {
            throw new AccessDeniedException("Not allowed to write: " + parent);
        }
        dir.link(name, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flatten(String path, String name) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onDelete(pathParts[0]);
            Lookup lPath = store.lookup(-1, pathParts[1], true, false);
            AVMNode node = lPath.getCurrentNode();
            if (node == null) {
                throw new AVMNotFoundException("Path not found.");
            }
            if (!(node instanceof LayeredDirectoryNode)) {
                throw new AVMWrongTypeException("Not a Layered Directory.");
            }
            if (!this.can(store, node, "Flatten", lPath.getDirectlyContained())) {
                throw new AccessDeniedException("Not allowed to write in: " + path);
            }
            LayeredDirectoryNode dir = (LayeredDirectoryNode)node;
            dir.flatten(name);
            Object var9_8 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AVMNodeDescriptor forceCopy(String path) {
        this.fLookupCount.set(1);
        try {
            AVMNodeDescriptor desc;
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found.");
            }
            this.fLookupCache.onWrite(pathParts[0]);
            Lookup lPath = store.lookup(-1, pathParts[1], true, true);
            if (lPath == null) {
                throw new AVMNotFoundException("Path not found.");
            }
            AVMNode node = lPath.getCurrentNode();
            AVMNodeDescriptor aVMNodeDescriptor = desc = node.getDescriptor(lPath);
            Object var9_8 = null;
            this.fLookupCount.set(null);
            return aVMNodeDescriptor;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public void renameStore(String sourceName, String destName) {
        AlfrescoTransactionSupport.bindListener(this.fPurgeStoreTxnListener);
        AlfrescoTransactionSupport.bindListener(this.fCreateStoreTxnListener);
        AVMStore store = this.getAVMStoreByName(sourceName);
        if (store == null) {
            throw new AVMNotFoundException("Store Not Found: " + sourceName);
        }
        if (this.getAVMStoreByName(destName) != null) {
            throw new AVMExistsException("Store Already Exists: " + destName);
        }
        if (!FileNameValidator.isValid(destName)) {
            throw new AVMBadArgumentException("Bad store name: " + destName);
        }
        store.setName(destName);
        AVMDAOs.Instance().fAVMStoreDAO.update(store);
        store.createSnapshot("Rename Store", "Rename Store from " + sourceName + " to " + destName, new HashMap<String, Integer>());
        this.fLookupCache.onDelete(sourceName);
        this.fAVMStoreDAO.invalidateCache();
        this.fPurgeStoreTxnListener.storePurged(sourceName);
        this.fCreateStoreTxnListener.storeCreated(destName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revert(String path, String name, AVMNodeDescriptor toRevertTo) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found: " + pathParts[0]);
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.revert(pathParts[1], name, toRevertTo);
            Object var7_6 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGuid(String path, String guid) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store not found:" + pathParts[0]);
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.setGuid(pathParts[1], guid);
            Object var6_5 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncoding(String path, String encoding) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store Not Found: " + pathParts[0]);
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.setEncoding(pathParts[1], encoding);
            Object var6_5 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMimeType(String path, String mimeType) {
        this.fLookupCount.set(1);
        try {
            String[] pathParts = this.SplitPath(path);
            AVMStore store = this.getAVMStoreByName(pathParts[0]);
            if (store == null) {
                throw new AVMNotFoundException("Store Not Found: " + pathParts[0]);
            }
            this.fLookupCache.onWrite(pathParts[0]);
            store.setMimeType(pathParts[1], mimeType);
            Object var6_5 = null;
            this.fLookupCount.set(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fLookupCount.set(null);
            throw throwable;
        }
    }

    public List<String> getPathsInStoreVersion(AVMNodeDescriptor desc, String store, int version) {
        AVMNode node = this.fAVMNodeDAO.getByID(desc.getId());
        if (node == null) {
            throw new AVMNotFoundException("Not found: " + desc);
        }
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<String> components = new ArrayList<String>();
        this.recursiveGetStoreVersionPaths(store, node, version, components, paths);
        return paths;
    }

    private void recursiveGetStoreVersionPaths(String storeName, AVMNode node, int version, List<String> components, List<String> paths) {
        if (!this.can(null, node, "Read", false)) {
            return;
        }
        if (node.getIsRoot()) {
            VersionRoot versionRoot = this.fVersionRootDAO.getByRoot(node);
            if (versionRoot.getAvmStore().getName().equals(storeName) && versionRoot.getVersionID() == version) {
                this.addPath(components, storeName, paths);
                return;
            }
            return;
        }
        List<ChildEntry> entries = this.fChildEntryDAO.getByChild(node);
        for (ChildEntry entry : entries) {
            String name = entry.getKey().getName();
            components.add(name);
            DirectoryNode parent = entry.getKey().getParent();
            this.recursiveGetStoreVersionPaths(storeName, parent, version, components, paths);
            components.remove(components.size() - 1);
        }
    }

    public Map<QName, PropertyValue> getNodeProperties(AVMNodeDescriptor desc) {
        AVMNode node = this.fAVMNodeDAO.getByID(desc.getId());
        if (node == null) {
            throw new AVMNotFoundException("Node not found: " + desc);
        }
        if (!this.can(null, node, "ReadProperties", false)) {
            throw new AccessDeniedException("Not allowed to read properties: " + desc);
        }
        return node.getProperties();
    }

    public ContentData getContentDataForRead(AVMNodeDescriptor desc) {
        AVMNode node = this.fAVMNodeDAO.getByID(desc.getId());
        if (node == null) {
            throw new AVMNotFoundException("Node not found: " + desc);
        }
        if (!this.can(null, node, "ReadContent", false)) {
            throw new AccessDeniedException("Not allowed to read: " + desc);
        }
        if (node.getType() == 0) {
            PlainFileNode file = (PlainFileNode)node;
            return file.getContentData();
        }
        if (node.getType() == 1) {
            LayeredFileNode file = (LayeredFileNode)node;
            return file.getContentData(null);
        }
        throw new AVMWrongTypeException("Not a file: " + desc);
    }

    public Set<QName> getAspects(AVMNodeDescriptor desc) {
        AVMNode node = this.fAVMNodeDAO.getByID(desc.getId());
        if (node == null) {
            throw new AVMNotFoundException("Node not found: " + desc);
        }
        if (!this.can(null, node, "ReadProperties", false)) {
            throw new AccessDeniedException("Not allowed to read properties: " + desc);
        }
        Set<QName> aspectQNames = node.getAspects();
        return aspectQNames;
    }

    public boolean can(AVMStore store, AVMNode node, String permission, boolean isDirectlyContained) {
        Acl storeAcl;
        String storeOwner;
        Acl acl = node.getAcl();
        QName type = node.getType() == 2 ? WCMModel.TYPE_AVM_PLAIN_FOLDER : (node.getType() == 0 ? WCMModel.TYPE_AVM_PLAIN_CONTENT : (node.getType() == 3 ? WCMModel.TYPE_AVM_LAYERED_FOLDER : WCMModel.TYPE_AVM_LAYERED_CONTENT));
        PermissionContext context = new PermissionContext(type);
        context.addDynamicAuthorityAssignment(node.getBasicAttributes().getOwner(), "ROLE_OWNER");
        if (store != null && isDirectlyContained && (storeOwner = AVMRepository.getStoreUserName(store.getName())) != null) {
            context.addDynamicAuthorityAssignment(storeOwner, "ROLE_WCM_STORE_OWNER");
        }
        Set<QName> nodeAspectQNames = node.getAspects();
        HashSet contextQNames = context.getAspects();
        contextQNames.addAll(nodeAspectQNames);
        Long aclId = null;
        if (acl != null) {
            aclId = acl.getId();
        }
        if (store != null && (storeAcl = store.getStoreAcl()) != null) {
            Long storeAclID = storeAcl.getId();
            context.setStoreAcl(storeAclID);
        }
        return this.fPermissionService.hasPermission(aclId, context, permission) == AccessStatus.ALLOWED;
    }

    private static String getStoreUserName(String storeName) {
        int author;
        int workflow;
        String storeOwner = null;
        int preview = storeName.indexOf(WCM_STORE_PREVIEW);
        if (preview >= 0) {
            storeName = storeName.substring(0, preview);
        }
        if ((workflow = storeName.indexOf(WCM_STORE_WORKFLOW)) >= 0) {
            storeName = storeName.substring(0, workflow);
        }
        if ((author = storeName.indexOf(WCM_STORE_SEPARATOR)) >= 0) {
            storeOwner = storeName.substring(author + 2);
        }
        return storeOwner;
    }

    public boolean can(String storeName, int version, String path, String permission) {
        Lookup lookup = AVMRepository.GetInstance().lookup(version, path, true);
        if (lookup != null) {
            AVMNode node = lookup.getCurrentNode();
            AVMStore store = this.getAVMStoreByName(storeName);
            return this.can(store, node, permission, lookup.getDirectlyContained());
        }
        return true;
    }

    public void setStoreAcl(String storeName, Acl acl) {
        AVMStore store = this.getAVMStoreByName(storeName);
        if (store == null) {
            throw new AVMNotFoundException("Store not found: " + storeName);
        }
        store.setStoreAcl(acl);
        AVMDAOs.Instance().fAVMStoreDAO.update(store);
    }

    public Acl getStoreAcl(String storeName) {
        AVMStore store = this.getAVMStoreByName(storeName);
        if (store == null) {
            throw new AVMNotFoundException("Store not found: " + storeName);
        }
        return store.getStoreAcl();
    }

    public List<VersionDescriptor> getAVMStoreVersionsTo(String name, int version) {
        AVMStore store = this.getAVMStoreByName(name);
        if (store == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        return store.getVersionsTo(version);
    }

    public List<VersionDescriptor> getAVMStoreVersionsFrom(String name, int version) {
        AVMStore store = this.getAVMStoreByName(name);
        if (store == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        return store.getVersionsFrom(version);
    }

    public List<VersionDescriptor> getAVMStoreVersionsBetween(String name, int startVersion, int endVersion) {
        AVMStore store = this.getAVMStoreByName(name);
        if (store == null) {
            throw new AVMNotFoundException("Store not found.");
        }
        return store.getVersionsBetween(startVersion, endVersion);
    }
}

