/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.avm.PurgeVersionCallback;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.util.Pair;

public class PurgeVersionTxnListener
extends TransactionListenerAdapter {
    private ThreadLocal<List<Pair<String, Integer>>> fPurgedVersions = new ThreadLocal();
    private List<PurgeVersionCallback> fCallbacks = new ArrayList<PurgeVersionCallback>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCommit() {
        List<Pair<String, Integer>> created = this.fPurgedVersions.get();
        if (created != null) {
            for (Pair<String, Integer> version : created) {
                PurgeVersionTxnListener purgeVersionTxnListener = this;
                synchronized (purgeVersionTxnListener) {
                    for (PurgeVersionCallback cb : this.fCallbacks) {
                        cb.versionPurged((String)version.getFirst(), (Integer)version.getSecond());
                    }
                }
            }
            this.fPurgedVersions.set(null);
        }
    }

    public void afterRollback() {
        this.fPurgedVersions.set(null);
    }

    public void versionPurged(String storeName, int versionID) {
        List<Pair<String, Integer>> purged = this.fPurgedVersions.get();
        if (purged == null) {
            purged = new ArrayList<Pair<String, Integer>>();
            this.fPurgedVersions.set(purged);
        }
        purged.add((Pair<String, Integer>)new Pair((Object)storeName, (Object)versionID));
    }

    public synchronized void addCallback(PurgeVersionCallback cb) {
        this.fCallbacks.add(cb);
    }
}

