/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.actions;

import java.util.List;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncException;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAVMPromoteAction
extends ActionExecuterAbstractBase {
    public static final String NAME = "simple-avm-promote";
    public static final String PARAM_TARGET_STORE = "target-store";
    private AVMSyncService fAVMSyncService;

    public void setAvmSyncService(AVMSyncService avmSyncService) {
        this.fAVMSyncService = avmSyncService;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        String targetStoreName = (String)((Object)action.getParameterValue(PARAM_TARGET_STORE));
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(actionedUponNodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        String path = (String)avmVersionPath.getSecond();
        String[] storePath = path.split(":");
        if (storePath.length != 2) {
            throw new AVMSyncException("Malformed source path: " + path);
        }
        String targetPath = targetStoreName + ":" + storePath[1];
        List<AVMDifference> diffs = this.fAVMSyncService.compare(version, path, -1, targetPath, null);
        this.fAVMSyncService.update(diffs, null, true, true, false, false, null, null);
        this.fAVMSyncService.flatten(storePath[0] + ":/" + "www", targetStoreName + ":/" + "www");
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_TARGET_STORE, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_TARGET_STORE)));
    }
}

