/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.util;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.util.VersionPathStuffer;
import org.alfresco.repo.avm.util.VersionPathUnstuffer;
import org.alfresco.util.Pair;

public class VersionPathTest
extends TestCase {
    public void testVersionPath() {
        VersionPathStuffer stuffer = new VersionPathStuffer();
        stuffer.add(-1, "figs:/bottom/top");
        stuffer.add(1, "piggy:/back/ride");
        stuffer.add(2, "main:/boring/path/to/nowhere");
        String stuffed = stuffer.toString();
        VersionPathUnstuffer unstuffer = new VersionPathUnstuffer(stuffed);
        List<Pair<Integer, String>> items = unstuffer.getVersionPaths();
        VersionPathTest.assertEquals((int)3, (int)items.size());
        VersionPathTest.assertEquals((int)-1, (int)((Integer)items.get(0).getFirst()));
        VersionPathTest.assertEquals((String)"figs:/bottom/top", (String)((String)items.get(0).getSecond()));
        VersionPathTest.assertEquals((int)1, (int)((Integer)items.get(1).getFirst()));
        VersionPathTest.assertEquals((String)"piggy:/back/ride", (String)((String)items.get(1).getSecond()));
        VersionPathTest.assertEquals((int)2, (int)((Integer)items.get(2).getFirst()));
        VersionPathTest.assertEquals((String)"main:/boring/path/to/nowhere", (String)((String)items.get(2).getSecond()));
        stuffer = new VersionPathStuffer();
        for (Pair<Integer, String> item : items) {
            stuffer.add(AVMNodeConverter.ToNodeRef((Integer)item.getFirst(), (String)item.getSecond()));
        }
        String stuffed2 = stuffer.toString();
        VersionPathTest.assertEquals((String)stuffed, (String)stuffed2);
        System.out.println(stuffed2);
    }
}

