/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.batch;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.batch.BatchMonitor;
import org.alfresco.repo.batch.BatchMonitorEvent;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.util.TraceableThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchProcessor<T>
implements BatchMonitor {
    private TraceableThreadFactory threadFactory = new TraceableThreadFactory();
    private final Log logger;
    private final RetryingTransactionHelper retryingTransactionHelper;
    private BatchProcessWorkProvider<T> workProvider;
    private final String processName;
    private final int loggingInterval;
    private final int workerThreads;
    private final int batchSize;
    private String currentEntryId;
    private int executingCount;
    private Throwable lastError;
    private String lastErrorEntryId;
    private int totalErrors;
    private int successfullyProcessedEntries;
    private Date startTime;
    private Date endTime;

    public BatchProcessor(String processName, RetryingTransactionHelper retryingTransactionHelper, final Collection<T> collection, int workerThreads, int batchSize, ApplicationEventPublisher applicationEventPublisher, Log logger, int loggingInterval) {
        this(processName, retryingTransactionHelper, new BatchProcessWorkProvider<T>(){
            boolean hasMore = true;

            @Override
            public int getTotalEstimatedWorkSize() {
                return collection.size();
            }

            @Override
            public Collection<T> getNextWork() {
                if (this.hasMore) {
                    this.hasMore = false;
                    return collection;
                }
                return Collections.emptyList();
            }
        }, workerThreads, batchSize, applicationEventPublisher, logger, loggingInterval);
    }

    public BatchProcessor(String processName, RetryingTransactionHelper retryingTransactionHelper, BatchProcessWorkProvider<T> workProvider, int workerThreads, int batchSize, ApplicationEventPublisher applicationEventPublisher, Log logger, int loggingInterval) {
        this.threadFactory.setNamePrefix(processName);
        this.threadFactory.setThreadDaemon(true);
        this.processName = processName;
        this.retryingTransactionHelper = retryingTransactionHelper;
        this.workProvider = workProvider;
        this.workerThreads = workerThreads;
        this.batchSize = batchSize;
        this.logger = logger == null ? LogFactory.getLog(this.getClass()) : logger;
        this.loggingInterval = loggingInterval;
        if (applicationEventPublisher != null) {
            applicationEventPublisher.publishEvent((ApplicationEvent)new BatchMonitorEvent(this));
        }
    }

    @Override
    public synchronized String getCurrentEntryId() {
        return this.currentEntryId;
    }

    @Override
    public synchronized String getLastError() {
        if (this.lastError == null) {
            return null;
        }
        StringWriter buff = new StringWriter(1024);
        PrintWriter out = new PrintWriter(buff);
        this.lastError.printStackTrace(out);
        out.close();
        return ((Object)buff).toString();
    }

    @Override
    public synchronized String getLastErrorEntryId() {
        return this.lastErrorEntryId;
    }

    @Override
    public synchronized String getProcessName() {
        return this.processName;
    }

    @Override
    public synchronized int getSuccessfullyProcessedEntries() {
        return this.successfullyProcessedEntries;
    }

    @Override
    public synchronized String getPercentComplete() {
        int processed = this.successfullyProcessedEntries + this.totalErrors;
        int totalResults = this.workProvider.getTotalEstimatedWorkSize();
        return processed <= totalResults ? NumberFormat.getPercentInstance().format(totalResults == 0 ? 1.0 : (double)((float)processed / (float)totalResults)) : "Unknown";
    }

    @Override
    public synchronized int getTotalErrors() {
        return this.totalErrors;
    }

    @Override
    public int getTotalResults() {
        return this.workProvider.getTotalEstimatedWorkSize();
    }

    @Override
    public synchronized Date getEndTime() {
        return this.endTime;
    }

    @Override
    public synchronized Date getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(BatchProcessWorker<T> worker, boolean splitTxns) {
        int n;
        int count;
        block28: {
            count = this.workProvider.getTotalEstimatedWorkSize();
            BatchProcessor batchProcessor = this;
            synchronized (batchProcessor) {
                this.startTime = new Date();
                if (this.logger.isInfoEnabled()) {
                    if (count >= 0) {
                        this.logger.info((Object)(this.getProcessName() + ": Commencing batch of " + count + " entries"));
                    } else {
                        this.logger.info((Object)(this.getProcessName() + ": Commencing batch"));
                    }
                }
            }
            ThreadPoolExecutor executorService = splitTxns && this.workerThreads > 1 ? new ThreadPoolExecutor(this.workerThreads, this.workerThreads, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new ArrayBlockingQueue<Runnable>(this.workerThreads * this.batchSize * 10){

                @Override
                public boolean offer(Runnable o) {
                    try {
                        this.put(o);
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                    return true;
                }
            }, this.threadFactory) : null;
            try {
                WorkProviderIterator iterator = new WorkProviderIterator(this.workProvider);
                ArrayList batch = new ArrayList(this.batchSize);
                while (iterator.hasNext()) {
                    batch.add(iterator.next());
                    boolean hasNext = iterator.hasNext();
                    if (batch.size() < this.batchSize && hasNext) continue;
                    TxnCallback callback = new TxnCallback(worker, batch, splitTxns);
                    if (hasNext) {
                        batch = new ArrayList(this.batchSize);
                    }
                    if (executorService == null) {
                        callback.run();
                        continue;
                    }
                    executorService.execute(callback);
                }
                n = count;
                Object var10_10 = null;
                if (executorService == null) break block28;
                executorService.shutdown();
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (executorService != null) {
                    executorService.shutdown();
                    try {
                        executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                BatchProcessor batchProcessor2 = this;
                synchronized (batchProcessor2) {
                    this.reportProgress(true);
                    this.endTime = new Date();
                    if (this.logger.isInfoEnabled()) {
                        if (count >= 0) {
                            this.logger.info((Object)(this.getProcessName() + ": Completed batch of " + count + " entries"));
                        } else {
                            this.logger.info((Object)(this.getProcessName() + ": Completed batch"));
                        }
                    }
                    if (this.totalErrors > 0 && this.logger.isErrorEnabled()) {
                        this.logger.error((Object)(this.getProcessName() + ": " + this.totalErrors + " error(s) detected. Last error from entry \"" + this.lastErrorEntryId + "\""), this.lastError);
                    }
                }
                throw throwable;
            }
            try {
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        BatchProcessor batchProcessor = this;
        synchronized (batchProcessor) {
            this.reportProgress(true);
            this.endTime = new Date();
            if (this.logger.isInfoEnabled()) {
                if (count >= 0) {
                    this.logger.info((Object)(this.getProcessName() + ": Completed batch of " + count + " entries"));
                } else {
                    this.logger.info((Object)(this.getProcessName() + ": Completed batch"));
                }
            }
            if (this.totalErrors > 0 && this.logger.isErrorEnabled()) {
                this.logger.error((Object)(this.getProcessName() + ": " + this.totalErrors + " error(s) detected. Last error from entry \"" + this.lastErrorEntryId + "\""), this.lastError);
            }
        }
        return n;
    }

    private synchronized void reportProgress(boolean last) {
        int processed = this.successfullyProcessedEntries + this.totalErrors;
        if (processed % this.loggingInterval == 0 ^ last) {
            long duration;
            StringBuilder message = new StringBuilder(100).append(this.getProcessName()).append(": Processed ").append(processed).append(" entries");
            int totalResults = this.workProvider.getTotalEstimatedWorkSize();
            if (totalResults >= processed) {
                message.append(" out of ").append(totalResults).append(". ").append(NumberFormat.getPercentInstance().format(totalResults == 0 ? 1.0 : (double)((float)processed / (float)totalResults))).append(" complete");
            }
            if ((duration = System.currentTimeMillis() - this.startTime.getTime()) > 0L) {
                message.append(". Rate: ").append((long)processed * 1000L / duration).append(" per second");
            }
            message.append(". " + this.totalErrors + " failures detected.");
            this.logger.info((Object)message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TxnCallback
    extends TransactionListenerAdapter
    implements RetryingTransactionHelper.RetryingTransactionCallback<Object>,
    Runnable {
        private final BatchProcessWorker<T> worker;
        private final List<T> batch;
        private final boolean splitTxns;
        private int txnErrors;
        private int txnSuccesses;
        private String txnEntryId;
        private Throwable txnLastError;
        private String txnLastErrorEntryId;
        private boolean hadRetryFailure;

        public TxnCallback(BatchProcessWorker<T> worker, List<T> batch, boolean splitTxns) {
            this.worker = worker;
            this.batch = batch;
            this.splitTxns = splitTxns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute() throws Throwable {
            this.reset();
            if (this.batch.isEmpty()) {
                return null;
            }
            AlfrescoTransactionSupport.bindListener(this);
            BatchProcessor batchProcessor = BatchProcessor.this;
            synchronized (batchProcessor) {
                if (this.hadRetryFailure) {
                    while (BatchProcessor.this.executingCount > 0) {
                        if (BatchProcessor.this.logger.isDebugEnabled()) {
                            BatchProcessor.this.logger.debug((Object)(Thread.currentThread().getName() + " Recoverable failure: waiting for other batches to complete"));
                        }
                        BatchProcessor.this.wait();
                    }
                    if (BatchProcessor.this.logger.isDebugEnabled()) {
                        BatchProcessor.this.logger.debug((Object)(Thread.currentThread().getName() + " ready to execute"));
                    }
                }
                BatchProcessor.this.currentEntryId = this.worker.getIdentifier(this.batch.get(0));
                BatchProcessor.this.executingCount++;
            }
            for (Object entry : this.batch) {
                this.txnEntryId = this.worker.getIdentifier(entry);
                try {
                    this.worker.process(entry);
                    ++this.txnSuccesses;
                }
                catch (Throwable t) {
                    if (RetryingTransactionHelper.extractRetryCause(t) == null) {
                        if (BatchProcessor.this.logger.isWarnEnabled()) {
                            BatchProcessor.this.logger.warn((Object)(BatchProcessor.this.getProcessName() + ": Failed to process entry \"" + this.txnEntryId + "\"."), t);
                        }
                        this.txnLastError = t;
                        this.txnLastErrorEntryId = this.txnEntryId;
                        ++this.txnErrors;
                        continue;
                    }
                    this.hadRetryFailure = true;
                    throw t;
                }
            }
            return null;
        }

        @Override
        public void run() {
            TxnCallback callback = this;
            try {
                this.worker.beforeProcess();
                BatchProcessor.this.retryingTransactionHelper.doInTransaction(callback, false, this.splitTxns);
                this.worker.afterProcess();
            }
            catch (Throwable t) {
                if (this.splitTxns) {
                    this.txnLastError = t;
                    this.txnLastErrorEntryId = this.txnEntryId;
                    ++this.txnErrors;
                    if (BatchProcessor.this.logger.isWarnEnabled()) {
                        BatchProcessor.this.logger.warn((Object)(BatchProcessor.this.getProcessName() + ": Failed to process entry \"" + BatchProcessor.this.currentEntryId + "\"."), t);
                    }
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new AlfrescoRuntimeException("Transactional error during " + BatchProcessor.this.getProcessName(), t);
            }
            this.commitProgress();
        }

        private void reset() {
            this.txnLastError = null;
            this.txnLastErrorEntryId = null;
            this.txnErrors = 0;
            this.txnSuccesses = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commitProgress() {
            BatchProcessor batchProcessor = BatchProcessor.this;
            synchronized (batchProcessor) {
                int intervals;
                int currentIncrement;
                int processed;
                if (this.txnErrors > 0) {
                    processed = BatchProcessor.this.successfullyProcessedEntries + BatchProcessor.this.totalErrors;
                    currentIncrement = processed % BatchProcessor.this.loggingInterval;
                    int newErrors = BatchProcessor.this.totalErrors + this.txnErrors;
                    intervals = (this.txnErrors + currentIncrement) / BatchProcessor.this.loggingInterval;
                    if (intervals > 0) {
                        BatchProcessor.this.totalErrors += BatchProcessor.this.loggingInterval - currentIncrement;
                        BatchProcessor.this.reportProgress(false);
                        while (--intervals > 0) {
                            BatchProcessor.this.totalErrors += BatchProcessor.this.loggingInterval;
                            BatchProcessor.this.reportProgress(false);
                        }
                    }
                    BatchProcessor.this.totalErrors = newErrors;
                }
                if (this.txnSuccesses > 0) {
                    processed = BatchProcessor.this.successfullyProcessedEntries + BatchProcessor.this.totalErrors;
                    currentIncrement = processed % BatchProcessor.this.loggingInterval;
                    int newSuccess = BatchProcessor.this.successfullyProcessedEntries + this.txnSuccesses;
                    intervals = (this.txnSuccesses + currentIncrement) / BatchProcessor.this.loggingInterval;
                    if (intervals > 0) {
                        BatchProcessor.this.successfullyProcessedEntries += BatchProcessor.this.loggingInterval - currentIncrement;
                        BatchProcessor.this.reportProgress(false);
                        while (--intervals > 0) {
                            BatchProcessor.this.successfullyProcessedEntries += BatchProcessor.this.loggingInterval;
                            BatchProcessor.this.reportProgress(false);
                        }
                    }
                    BatchProcessor.this.successfullyProcessedEntries = newSuccess;
                }
                if (this.txnLastError != null) {
                    BatchProcessor.this.lastError = this.txnLastError;
                    BatchProcessor.this.lastErrorEntryId = this.txnLastErrorEntryId;
                }
                this.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterCommit() {
            BatchProcessor batchProcessor = BatchProcessor.this;
            synchronized (batchProcessor) {
                BatchProcessor.this.executingCount--;
                BatchProcessor.this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterRollback() {
            BatchProcessor batchProcessor = BatchProcessor.this;
            synchronized (batchProcessor) {
                BatchProcessor.this.executingCount--;
                BatchProcessor.this.notifyAll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkProviderIterator<T>
    implements Iterator<T> {
        private BatchProcessWorkProvider<T> workProvider;
        private Iterator<T> currentIterator;

        private WorkProviderIterator(BatchProcessWorkProvider<T> workProvider) {
            this.workProvider = workProvider;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = false;
            if (this.workProvider == null) {
                hasNext = false;
            } else {
                if (this.currentIterator != null) {
                    hasNext = this.currentIterator.hasNext();
                }
                if (!hasNext) {
                    Collection<T> nextWork = this.workProvider.getNextWork();
                    if (nextWork == null) {
                        throw new RuntimeException("BatchProcessWorkProvider returned 'null' work: " + this.workProvider);
                    }
                    if (nextWork.size() == 0) {
                        this.workProvider = null;
                        this.currentIterator = null;
                        hasNext = false;
                    } else {
                        this.currentIterator = nextWork.iterator();
                        hasNext = this.currentIterator.hasNext();
                    }
                }
            }
            return hasNext;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BatchProcessWorkerAdaptor<TT>
    implements BatchProcessWorker<TT> {
        @Override
        public String getIdentifier(TT entry) {
            return entry.toString();
        }

        @Override
        public void beforeProcess() throws Throwable {
        }

        @Override
        public void afterProcess() throws Throwable {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BatchProcessWorker<T> {
        public String getIdentifier(T var1);

        public void beforeProcess() throws Throwable;

        public void process(T var1) throws Throwable;

        public void afterProcess() throws Throwable;
    }
}

