/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.blog;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.BlogIntegrationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.blog.BlogDetails;
import org.alfresco.repo.blog.BlogIntegrationImplementation;
import org.alfresco.repo.blog.BlogIntegrationRuntimeException;
import org.alfresco.repo.blog.BlogIntegrationService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.BaseAlfrescoSpringTest;

public class BlogIntegrationServiceSystemTest
extends BaseAlfrescoSpringTest
implements BlogIntegrationModel {
    private static final String BLOG = "wordpress";
    private static final String BLOG_URL = "http://paulhh.wordpress.com";
    private static final String BLOG_USER = "paulhh";
    private static final String BLOG_PWD = "114eb1";
    private static final String BLOG_ID = "0";
    private static final String BLOG_NAME = "Test blog details";
    private static final String BLOG_DESCRIPTION = "These are the details used to test the blog integration service";
    private static final String TITLE = "My Test Post @ " + new Date().toString();
    private static final String MODIFIED_TITLE = "My Test Post Modified @ " + new Date().toString();
    private static final String DESCRIPTION = "This is a description of my test post.";
    private static final String POST_CONTENT = "Hello and welcome to my test post.  This has been posted from the blog integration system test @ " + new Date().toString();
    private static final String MODIFIED_POST_CONTENT = "Hello and welcome to my MODIFIED test post.  This has been posted and MODIFIED from the blog integration system test @ " + new Date().toString();
    private static final boolean PUBLISH = true;
    private NodeService nodeService;
    private ContentService contentService;
    private SearchService searchService;
    private BlogIntegrationService blogService;
    private NodeRef nodeRef;
    private NodeRef blogDetailsNodeRef;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.searchService = (SearchService)this.applicationContext.getBean("searchService");
        this.blogService = (BlogIntegrationService)this.applicationContext.getBean("blogIntegrationService");
        ResultSet results1 = this.searchService.query(new StoreRef("workspace", "SpacesStore"), "xpath", "app:company_home");
        NodeRef companyHome = (NodeRef)results1.getNodeRefs().get(0);
        results1.close();
        this.blogDetailsNodeRef = this.nodeService.createNode(companyHome, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.blogDetailsNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"testFolder"));
        HashMap<QName, String> props2 = new HashMap<QName, String>(5);
        props2.put(PROP_BLOG_IMPLEMENTATION, BLOG);
        props2.put(PROP_ID, BLOG_ID);
        props2.put(PROP_NAME, BLOG_NAME);
        props2.put(PROP_DESCRIPTION, BLOG_DESCRIPTION);
        props2.put(PROP_URL, BLOG_URL);
        props2.put(PROP_USER_NAME, BLOG_USER);
        props2.put(PROP_PASSWORD, BLOG_PWD);
        this.nodeService.addAspect(this.blogDetailsNodeRef, ASPECT_BLOG_DETAILS, props2);
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "myBlogEntry.txt");
        this.nodeRef = this.nodeService.createNode(this.blogDetailsNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"myBlogEntry.txt"), ContentModel.TYPE_CONTENT, props).getChildRef();
        HashMap<QName, String> titledProps = new HashMap<QName, String>(2);
        titledProps.put(ContentModel.PROP_TITLE, TITLE);
        titledProps.put(ContentModel.PROP_DESCRIPTION, DESCRIPTION);
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_TITLED, titledProps);
        ContentWriter contentWriter = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent(POST_CONTENT);
    }

    public void testGetBlogIntegrationImplementations() {
        List<BlogIntegrationImplementation> list = this.blogService.getBlogIntegrationImplementations();
        BlogIntegrationServiceSystemTest.assertNotNull(list);
        BlogIntegrationServiceSystemTest.assertEquals((int)2, (int)list.size());
        BlogIntegrationImplementation blog = this.blogService.getBlogIntegrationImplementation(BLOG);
        BlogIntegrationServiceSystemTest.assertNotNull((Object)blog);
        BlogIntegrationServiceSystemTest.assertEquals((String)BLOG, (String)blog.getName());
    }

    public void testGetBlogDetails() {
        List<BlogDetails> details = this.blogService.getBlogDetails(this.nodeRef);
        BlogIntegrationServiceSystemTest.assertNotNull(details);
        BlogIntegrationServiceSystemTest.assertEquals((int)1, (int)details.size());
        BlogIntegrationServiceSystemTest.assertEquals((String)BLOG_URL, (String)details.get(0).getUrl());
        List<BlogDetails> details2 = this.blogService.getBlogDetails(this.blogDetailsNodeRef);
        BlogIntegrationServiceSystemTest.assertNotNull(details2);
        BlogIntegrationServiceSystemTest.assertEquals((int)1, (int)details2.size());
        BlogIntegrationServiceSystemTest.assertEquals((String)BLOG_URL, (String)details2.get(0).getUrl());
    }

    public void testNewPost() {
        BlogDetails blogDetails = BlogDetails.createBlogDetails(this.nodeService, this.blogDetailsNodeRef);
        BlogIntegrationServiceSystemTest.assertEquals((Object)this.blogDetailsNodeRef, (Object)blogDetails.getNodeRef());
        BlogIntegrationServiceSystemTest.assertEquals((String)BLOG, (String)blogDetails.getImplementationName());
        BlogIntegrationServiceSystemTest.assertEquals((String)BLOG_ID, (String)blogDetails.getBlogId());
        BlogIntegrationServiceSystemTest.assertEquals((String)BLOG_NAME, (String)blogDetails.getName());
        BlogIntegrationServiceSystemTest.assertEquals((String)BLOG_DESCRIPTION, (String)blogDetails.getDescription());
        BlogIntegrationServiceSystemTest.assertEquals((String)BLOG_URL, (String)blogDetails.getUrl());
        BlogIntegrationServiceSystemTest.assertEquals((String)BLOG_USER, (String)blogDetails.getUserName());
        BlogIntegrationServiceSystemTest.assertEquals((String)BLOG_PWD, (String)blogDetails.getPassword());
        this.blogService.newPost(blogDetails, this.nodeRef, ContentModel.PROP_CONTENT, true);
        BlogIntegrationServiceSystemTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ASPECT_BLOG_POST));
        BlogIntegrationServiceSystemTest.assertNotNull((Object)this.nodeService.getProperty(this.nodeRef, PROP_POST_ID));
        System.out.println("The newly create post has id " + this.nodeService.getProperty(this.nodeRef, PROP_POST_ID));
        List assocs = this.nodeService.getTargetAssocs(this.nodeRef, (QNamePattern)ASSOC_BLOG_DETAILS);
        BlogIntegrationServiceSystemTest.assertEquals((int)1, (int)assocs.size());
        NodeRef testRef = ((AssociationRef)assocs.get(0)).getTargetRef();
        BlogIntegrationServiceSystemTest.assertEquals((Object)this.blogDetailsNodeRef, (Object)testRef);
        try {
            this.blogService.newPost(blogDetails, this.nodeRef, ContentModel.PROP_CONTENT, true);
        }
        catch (BlogIntegrationRuntimeException e) {
            // empty catch block
        }
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)MODIFIED_TITLE));
    }

    public void testUpdatePost() {
        BlogDetails blogDetails = BlogDetails.createBlogDetails(this.nodeService, this.blogDetailsNodeRef);
        this.blogService.newPost(blogDetails, this.nodeRef, ContentModel.PROP_CONTENT, true);
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)MODIFIED_TITLE));
        ContentWriter contentWriter = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.putContent(MODIFIED_POST_CONTENT);
        this.blogService.updatePost(this.nodeRef, ContentModel.PROP_CONTENT, true);
    }

    public void testDeletePost() {
        BlogDetails blogDetails = BlogDetails.createBlogDetails(this.nodeService, this.blogDetailsNodeRef);
        this.blogService.newPost(blogDetails, this.nodeRef, ContentModel.PROP_CONTENT, true);
        this.blogService.deletePost(this.nodeRef);
        BlogIntegrationServiceSystemTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ASPECT_BLOG_POST));
    }
}

