/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracterTest;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.RFC822MetadataExtracter;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RFC822MetadataExtracterTest
extends AbstractMetadataExtracterTest {
    private RFC822MetadataExtracter extracter;
    private static final QName MESSAGE_FROM_TEST_PROPERTY = QName.createQName((String)"MessageToTest");
    private static final QName MESSAGE_TO_TEST_PROPERTY = QName.createQName((String)"MessageFromTest");
    private static final QName MESSAGE_CC_TEST_PROPERTY = QName.createQName((String)"MessageCCTest");

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.extracter = (RFC822MetadataExtracter)this.ctx.getBean("extracter.RFC822");
        HashMap<String, Set<QName>> newMap = new HashMap<String, Set<QName>>(this.extracter.getMapping());
        HashSet<QName> fromSet = new HashSet<QName>();
        fromSet.add(MESSAGE_FROM_TEST_PROPERTY);
        fromSet.addAll((Collection)this.extracter.getCurrentMapping().get("messageFrom"));
        newMap.put("messageFrom", fromSet);
        HashSet<QName> toSet = new HashSet<QName>();
        toSet.add(MESSAGE_TO_TEST_PROPERTY);
        toSet.addAll((Collection)this.extracter.getCurrentMapping().get("messageTo"));
        newMap.put("messageTo", toSet);
        HashSet<QName> ccSet = new HashSet<QName>();
        ccSet.add(MESSAGE_CC_TEST_PROPERTY);
        ccSet.addAll((Collection)this.extracter.getCurrentMapping().get("messageCc"));
        newMap.put("messageCc", ccSet);
        this.extracter.setMapping(newMap);
    }

    @Override
    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    public void testHasDateFormats() throws Exception {
        Field sdf = RFC822MetadataExtracter.class.getSuperclass().getDeclaredField("supportedDateFormats");
        sdf.setAccessible(true);
        Set supportedDateFormats = (Set)sdf.get(this.extracter);
        if (supportedDateFormats.size() == 0) {
            RFC822MetadataExtracterTest.fail((String)"No supportedDateFormats injected into RFC822MetadataExtracter - spring setup broken and date parsing will break all of the extraction process");
        }
    }

    public void testSupports() throws Exception {
        for (String mimetype : RFC822MetadataExtracter.SUPPORTED_MIMETYPES) {
            boolean supports = this.extracter.isSupported(mimetype);
            RFC822MetadataExtracterTest.assertTrue((String)("Mimetype should be supported: " + mimetype), (boolean)supports);
        }
    }

    public void testEmailExtraction() throws Exception {
        this.testExtractFromMimetype("message/rfc822");
    }

    @Override
    protected void testCommonMetadata(String mimetype, Map<QName, Serializable> properties) {
        RFC822MetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_TITLE + " not found for mimetype " + mimetype), (String)"The quick brown fox jumps over the lazy dog", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_TITLE))));
        RFC822MetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_DESCRIPTION + " not found for mimetype " + mimetype), (String)"The quick brown fox jumps over the lazy dog", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_DESCRIPTION))));
    }

    @Override
    public void testFileSpecificMetadata(String mimetype, Map<QName, Serializable> properties) {
        RFC822MetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_ORIGINATOR + " not found for mimetype " + mimetype), (String)"Nevin Nollop <nevin.nollop@alfresco.com>", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_ORIGINATOR))));
        RFC822MetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_SENTDATE + " not found for mimetype " + mimetype), (String)"2004-06-04T13:23:22.000+01:00", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_SENTDATE))));
        RFC822MetadataExtracterTest.assertEquals((String)("Test Property " + MESSAGE_FROM_TEST_PROPERTY + " incorrect for mimetype " + mimetype), (String)"Nevin Nollop <nevin.nollop@alfresco.com>", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(MESSAGE_FROM_TEST_PROPERTY))));
        RFC822MetadataExtracterTest.assertEquals((String)("Test Property " + MESSAGE_FROM_TEST_PROPERTY + " incorrect for mimetype " + mimetype), (String)"Nevin Nollop <nevin.nollop@alfresco.com>", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(MESSAGE_FROM_TEST_PROPERTY))));
        RFC822MetadataExtracterTest.assertEquals((String)("Test Property " + MESSAGE_TO_TEST_PROPERTY + " incorrect for mimetype " + mimetype), (String)"Nevin Nollop <nevin.nollop@alfresco.com>", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(MESSAGE_TO_TEST_PROPERTY))));
        RFC822MetadataExtracterTest.assertTrue((String)("Test Property " + MESSAGE_FROM_TEST_PROPERTY + " not found for mimetype " + mimetype), (boolean)properties.containsKey(MESSAGE_FROM_TEST_PROPERTY));
        RFC822MetadataExtracterTest.assertTrue((String)("Test Property " + MESSAGE_TO_TEST_PROPERTY + " not found for mimetype " + mimetype), (boolean)properties.containsKey(MESSAGE_TO_TEST_PROPERTY));
        RFC822MetadataExtracterTest.assertTrue((String)("Test Property " + MESSAGE_CC_TEST_PROPERTY + " not found for mimetype " + mimetype), (boolean)properties.containsKey(MESSAGE_CC_TEST_PROPERTY));
        RFC822MetadataExtracterTest.assertEquals((String)("Test Property " + MESSAGE_FROM_TEST_PROPERTY + " incorrect for mimetype " + mimetype), (String)"Nevin Nollop <nevin.nollop@alfresco.com>", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(MESSAGE_FROM_TEST_PROPERTY))));
        RFC822MetadataExtracterTest.assertEquals((String)("Test Property " + MESSAGE_TO_TEST_PROPERTY + " incorrect for mimetype " + mimetype), (String)"Nevin Nollop <nevin.nollop@alfresco.com>", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(MESSAGE_TO_TEST_PROPERTY))));
        RFC822MetadataExtracterTest.assertEquals((String)("Test Property " + MESSAGE_CC_TEST_PROPERTY + " incorrect for mimetype " + mimetype), (String)"Nevin Nollop <nevinn@alfresco.com>", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(MESSAGE_CC_TEST_PROPERTY))));
    }
}

