/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.el.MethodNotFoundException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexContentTransformer
extends AbstractContentTransformer2
implements InitializingBean {
    private static Log logger = LogFactory.getLog(ComplexContentTransformer.class);
    private List<ContentTransformer> transformers;
    private List<String> intermediateMimetypes;
    private Map<String, Serializable> transformationOptionOverrides;

    public void setTransformers(List<ContentTransformer> transformers) {
        this.transformers = transformers;
    }

    public void setIntermediateMimetypes(List<String> intermediateMimetypes) {
        this.intermediateMimetypes = intermediateMimetypes;
    }

    public void setTransformationOptionOverrides(Map<String, Serializable> transformationOptionOverrides) {
        this.transformationOptionOverrides = transformationOptionOverrides;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.transformers == null || this.transformers.size() == 0) {
            throw new AlfrescoRuntimeException("At least one inner transformer must be supplied: " + this);
        }
        if (this.intermediateMimetypes == null || this.intermediateMimetypes.size() != this.transformers.size() - 1) {
            throw new AlfrescoRuntimeException("There must be n-1 intermediate mimetypes, where n is the number of transformers");
        }
        if (this.getMimetypeService() == null) {
            throw new AlfrescoRuntimeException("'mimetypeService' is a required property");
        }
    }

    @Override
    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        boolean result = true;
        String currentSourceMimetype = sourceMimetype;
        if (options != null && this.transformationOptionOverrides != null) {
            for (String key : this.transformationOptionOverrides.keySet()) {
                if (PropertyUtils.isWriteable((Object)options, (String)key)) {
                    try {
                        PropertyUtils.setProperty((Object)options, (String)key, (Object)this.transformationOptionOverrides.get(key));
                    }
                    catch (MethodNotFoundException mnfe) {
                    }
                    catch (NoSuchMethodException nsme) {
                    }
                    catch (InvocationTargetException ite) {
                    }
                    catch (IllegalAccessException iae) {}
                    continue;
                }
                logger.warn((Object)("Unable to set override Transformation Option " + key + " on " + options));
            }
        }
        Iterator<ContentTransformer> transformerIterator = this.transformers.iterator();
        Iterator<String> intermediateMimetypeIterator = this.intermediateMimetypes.iterator();
        while (transformerIterator.hasNext()) {
            ContentTransformer transformer = transformerIterator.next();
            String currentTargetMimetype = null;
            currentTargetMimetype = !transformerIterator.hasNext() ? targetMimetype : intermediateMimetypeIterator.next();
            if (!transformer.isTransformable(currentSourceMimetype, currentTargetMimetype, options)) {
                result = false;
                break;
            }
            currentSourceMimetype = currentTargetMimetype;
        }
        return result;
    }

    @Override
    public void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        ContentReader currentReader = reader;
        Iterator<ContentTransformer> transformerIterator = this.transformers.iterator();
        Iterator<String> intermediateMimetypeIterator = this.intermediateMimetypes.iterator();
        while (transformerIterator.hasNext()) {
            ContentTransformer transformer = transformerIterator.next();
            ContentWriter currentWriter = null;
            if (!transformerIterator.hasNext()) {
                currentWriter = writer;
            } else {
                String nextMimetype = intermediateMimetypeIterator.next();
                String sourceExt = this.getMimetypeService().getExtension(currentReader.getMimetype());
                String targetExt = this.getMimetypeService().getExtension(nextMimetype);
                File tempFile = TempFileProvider.createTempFile((String)("ComplextTransformer_intermediate_" + sourceExt + "_"), (String)("." + targetExt));
                currentWriter = new FileContentWriter(tempFile);
                currentWriter.setMimetype(nextMimetype);
            }
            transformer.transform(currentReader, currentWriter, options);
            currentReader = currentWriter.getReader();
        }
    }

    public List<String> getIntermediateMimetypes() {
        return Collections.unmodifiableList(this.intermediateMimetypes);
    }
}

