/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.imageio.ImageIO;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PdfToImageContentTransformer
extends AbstractContentTransformer2 {
    private static final Log logger = LogFactory.getLog(PdfToImageContentTransformer.class);

    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return "application/pdf".equals(sourceMimetype) && "image/png".equals(targetMimetype);
    }

    protected void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        try {
            File file = TempFileProvider.createTempFile((String)"pdfToImage", (String)".pdf");
            reader.getContent(file);
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            FileChannel channel = raf.getChannel();
            MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            PDFFile pdffile = new PDFFile((ByteBuffer)buf);
            if (logger.isInfoEnabled()) {
                int pdfMajorVersion = pdffile.getMajorVersion();
                int pdfMinorVersion = pdffile.getMinorVersion();
                StringBuilder msg = new StringBuilder();
                msg.append("File being transformed is of pdf version ").append(pdfMajorVersion).append(".").append(pdfMinorVersion);
                logger.info((Object)msg.toString());
            }
            PDFPage page = pdffile.getPage(0, true);
            int width = (int)page.getBBox().getWidth();
            int height = (int)page.getBBox().getHeight();
            Rectangle rect = new Rectangle(0, 0, width, height);
            int rotation = page.getRotation();
            Rectangle rect1 = rect;
            if (rotation == 90 || rotation == 270) {
                rect1 = new Rectangle(0, 0, rect.height, rect.width);
            }
            BufferedImage img = (BufferedImage)page.getImage(rect.width, rect.height, (Rectangle2D)rect1, null, true, true);
            File outputFile = TempFileProvider.createTempFile((String)"pdfToImageOutput", (String)".png");
            ImageIO.write((RenderedImage)img, "png", outputFile);
            writer.putContent(outputFile);
        }
        catch (FileNotFoundException e1) {
            throw new AlfrescoRuntimeException("Unable to create image from pdf file.", (Throwable)e1);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Unable to create image from pdf file.", (Throwable)e);
        }
    }
}

