/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.PoiContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class PoiContentTransformerTest
extends AbstractContentTransformerTest {
    private ContentTransformer transformer;

    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new PoiContentTransformer();
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testIsTransformable() throws Exception {
        PoiContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", "application/msword", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/msword", "text/plain", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/msword", "text/html", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/msword", "text/xml", new TransformationOptions()));
        PoiContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", "application/vnd.ms-powerpoint", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-powerpoint", "text/plain", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-powerpoint", "text/html", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-powerpoint", "text/xml", new TransformationOptions()));
        PoiContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", "application/vnd.ms-outlook", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-outlook", "text/plain", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-outlook", "text/html", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-outlook", "text/xml", new TransformationOptions()));
        PoiContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("application/vnd.ms-excel", "text/plain", new TransformationOptions()));
    }
}

