/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.TextToPdfContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class TextToPdfContentTransformerTest
extends AbstractContentTransformerTest {
    private TextToPdfContentTransformer transformer;

    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new TextToPdfContentTransformer();
        this.transformer.setStandardFont("Times-Roman");
        this.transformer.setFontSize(20);
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testReliability() throws Exception {
        boolean reliability = this.transformer.isTransformable("application/pdf", "text/plain", new TransformationOptions());
        TextToPdfContentTransformerTest.assertEquals((String)"Mimetype should not be supported", (boolean)false, (boolean)reliability);
        reliability = this.transformer.isTransformable("text/plain", "application/pdf", new TransformationOptions());
        TextToPdfContentTransformerTest.assertEquals((String)"Mimetype should be supported", (boolean)true, (boolean)reliability);
        reliability = this.transformer.isTransformable("text/xml", "application/pdf", new TransformationOptions());
        TextToPdfContentTransformerTest.assertEquals((String)"Mimetype should be supported", (boolean)true, (boolean)reliability);
    }
}

