/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.TikaPoweredContentTransformer;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;

public class TikaSpringConfiguredContentTransformer
extends TikaPoweredContentTransformer {
    private Parser tikaParser;
    private String tikaParserClassName;
    private Class<? extends Parser> tikaParserClass;

    public void setTikaParserName(String className) {
        this.tikaParserClassName = className;
        try {
            this.tikaParserClass = Class.forName(this.tikaParserClassName);
            this.setTikaParser(this.getParser());
        }
        catch (ClassNotFoundException e) {
            throw new AlfrescoRuntimeException("Specified Tika Parser '" + this.tikaParserClassName + "' not found");
        }
    }

    public void setTikaParser(Parser tikaParser) {
        this.tikaParser = tikaParser;
        for (MediaType mt : tikaParser.getSupportedTypes(new ParseContext())) {
            this.sourceMimeTypes.add(mt.toString());
        }
    }

    public TikaSpringConfiguredContentTransformer() {
        super(new ArrayList<String>());
    }

    protected Parser getParser() {
        if (this.tikaParser != null) {
            return this.tikaParser;
        }
        try {
            return this.tikaParserClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new AlfrescoRuntimeException("Unable to create specified Parser", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AlfrescoRuntimeException("Unable to create specified Parser", (Throwable)e);
        }
    }
}

