/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.encoding.ibatis;

import org.alfresco.repo.domain.encoding.AbstractEncodingDAOImpl;
import org.alfresco.repo.domain.encoding.EncodingEntity;
import org.alfresco.repo.domain.mimetype.MimetypeEntity;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

public class EncodingDAOImpl
extends AbstractEncodingDAOImpl {
    private static final String SELECT_ENCODING_BY_ID = "alfresco.content.select_EncodingById";
    private static final String SELECT_ENCODING_BY_KEY = "alfresco.content.select_EncodingByKey";
    private static final String INSERT_ENCODING = "alfresco.content.insert_Encoding";
    private SqlMapClientTemplate template;

    public void setSqlMapClientTemplate(SqlMapClientTemplate sqlMapClientTemplate) {
        this.template = sqlMapClientTemplate;
    }

    protected EncodingEntity getEncodingEntity(Long id) {
        EncodingEntity encodingEntity = new EncodingEntity();
        encodingEntity.setId(id);
        encodingEntity = (EncodingEntity)this.template.queryForObject(SELECT_ENCODING_BY_ID, (Object)encodingEntity);
        return encodingEntity;
    }

    protected EncodingEntity getEncodingEntity(String encoding) {
        EncodingEntity encodingEntity = new EncodingEntity();
        encodingEntity.setEncoding(encoding == null ? null : encoding.toLowerCase());
        encodingEntity = (EncodingEntity)this.template.queryForObject(SELECT_ENCODING_BY_KEY, (Object)encodingEntity);
        return encodingEntity;
    }

    protected EncodingEntity createEncodingEntity(String encoding) {
        EncodingEntity encodingEntity = new EncodingEntity();
        encodingEntity.setVersion(MimetypeEntity.CONST_LONG_ZERO);
        encodingEntity.setEncoding(encoding == null ? null : encoding.toLowerCase());
        Long id = (Long)this.template.insert(INSERT_ENCODING, (Object)encodingEntity);
        encodingEntity.setId(id);
        return encodingEntity;
    }
}

