/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.locks;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.TestCase;
import org.alfresco.repo.domain.locks.LockDAO;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class LockDAOTest
extends TestCase {
    public static final String NAMESPACE = "http://www.alfresco.org/test/LockDAOTest";
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private LockDAO lockDAO;
    private QName lockA;
    private QName lockAA;
    private QName lockAAA;
    private QName lockAAB;
    private QName lockAAC;
    private QName lockAB;
    private QName lockABA;
    private QName lockABB;
    private QName lockABC;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.txnHelper.setMinRetryWaitMs(10);
        this.txnHelper.setRetryWaitIncrementMs(10);
        this.txnHelper.setMaxRetryWaitMs(50);
        this.lockDAO = (LockDAO)this.ctx.getBean("lockDAO");
        String testName = this.getName();
        this.lockA = QName.createQName((String)NAMESPACE, (String)("a-" + testName));
        this.lockAA = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName));
        this.lockAAA = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName + ".a-" + testName));
        this.lockAAB = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName + ".b-" + testName));
        this.lockAAC = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName + ".c-" + testName));
        this.lockAB = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName));
        this.lockABA = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName + ".a-" + testName));
        this.lockABB = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName + ".b-" + testName));
        this.lockABC = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName + ".c-" + testName));
    }

    private String lock(QName lockName, long timeToLive, boolean expectSuccess) {
        try {
            String token = this.lock(lockName, timeToLive);
            if (!expectSuccess) {
                LockDAOTest.fail((String)("Expected lock " + lockName + " to have been denied"));
            }
            return token;
        }
        catch (LockAcquisitionException e) {
            if (expectSuccess) {
                throw new RuntimeException("Expected to get lock " + lockName + " with TTL of " + timeToLive, (Throwable)((Object)e));
            }
            return null;
        }
    }

    private String lock(final QName lockName, final long timeToLive) {
        RetryingTransactionHelper.RetryingTransactionCallback<String> callback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Throwable {
                String txnId = AlfrescoTransactionSupport.getTransactionId();
                LockDAOTest.this.lockDAO.getLock(lockName, txnId, timeToLive);
                return txnId;
            }
        };
        return this.txnHelper.doInTransaction(callback);
    }

    private void refresh(final QName lockName, final String lockToken, final long timeToLive, boolean expectSuccess) {
        block3: {
            RetryingTransactionHelper.RetryingTransactionCallback<Boolean> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                @Override
                public Boolean execute() throws Throwable {
                    LockDAOTest.this.lockDAO.refreshLock(lockName, lockToken, timeToLive);
                    return Boolean.TRUE;
                }
            };
            try {
                this.txnHelper.doInTransaction(callback);
                if (!expectSuccess) {
                    LockDAOTest.fail((String)("Expected to have failed to refresh lock " + lockName));
                }
            }
            catch (LockAcquisitionException e) {
                if (!expectSuccess) break block3;
                throw new RuntimeException("Expected to have refreshed lock " + lockName, (Throwable)((Object)e));
            }
        }
    }

    private void release(final QName lockName, final String lockToken, boolean expectSuccess) {
        block3: {
            RetryingTransactionHelper.RetryingTransactionCallback<Boolean> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                @Override
                public Boolean execute() throws Throwable {
                    LockDAOTest.this.lockDAO.releaseLock(lockName, lockToken);
                    return Boolean.TRUE;
                }
            };
            try {
                this.txnHelper.doInTransaction(callback);
                if (!expectSuccess) {
                    LockDAOTest.fail((String)("Expected to have failed to release lock " + lockName));
                }
            }
            catch (LockAcquisitionException e) {
                if (!expectSuccess) break block3;
                throw new RuntimeException("Expected to have released lock " + lockName, (Throwable)((Object)e));
            }
        }
    }

    public void testGetLockBasic() throws Exception {
        this.lock(this.lockAAA, 500L, true);
    }

    public void testLockTableScaling() throws Exception {
        int count = 500;
        long before = System.currentTimeMillis();
        for (int i = 1; i <= count; ++i) {
            QName lockName = QName.createQName((String)this.lockAAA.getNamespaceURI(), (String)(this.lockAAA.getLocalName() + "-" + i));
            this.lock(lockName, 500L, true);
            if (i % 100 != 0) continue;
            long after = System.currentTimeMillis();
            System.out.println("Creation of " + i + " locks took " + (after - before) / 1000L + "s");
        }
    }

    public void testGetLockFailureBasic() throws Exception {
        this.lock(this.lockAAA, 500L, true);
        this.lock(this.lockAAA, 0L, false);
    }

    public void testSharedLocks() throws Exception {
        this.lock(this.lockAAA, 500L, true);
        this.lock(this.lockAAB, 500L, true);
        this.lock(this.lockAAC, 500L, true);
        this.lock(this.lockABA, 500L, true);
        this.lock(this.lockABB, 500L, true);
        this.lock(this.lockABC, 500L, true);
    }

    public void testExclusiveLockBlockedByShared() throws Exception {
        this.lock(this.lockAAA, 100L, true);
        this.lock(this.lockAA, 100L, false);
        this.lock(this.lockAB, 100L, true);
        this.lock(this.lockA, 100L, false);
        this.lock(this.lockABA, 100L, false);
    }

    public void testReleaseLockBasic() throws Exception {
        String token = this.lock(this.lockAAA, 500000L, true);
        this.release(this.lockAAA, token, true);
        token = this.lock(this.lockAAA, 0L, true);
    }

    public void testSharedLockAndRelease() throws Exception {
        String tokenAAA = this.lock(this.lockAAA, 5000L, true);
        String tokenAAB = this.lock(this.lockAAB, 5000L, true);
        String tokenAAC = this.lock(this.lockAAC, 5000L, true);
        String tokenABA = this.lock(this.lockABA, 5000L, true);
        String tokenABB = this.lock(this.lockABB, 5000L, true);
        String tokenABC = this.lock(this.lockABC, 5000L, true);
        this.lock(this.lockAA, 0L, false);
        this.lock(this.lockAB, 0L, false);
        this.lock(this.lockA, 0L, false);
        this.release(this.lockAAA, tokenAAA, true);
        this.lock(this.lockAA, 0L, false);
        this.lock(this.lockAB, 0L, false);
        this.lock(this.lockA, 0L, false);
        this.release(this.lockAAB, tokenAAB, true);
        this.lock(this.lockAA, 0L, false);
        this.lock(this.lockAB, 0L, false);
        this.lock(this.lockA, 0L, false);
        this.release(this.lockAAC, tokenAAC, true);
        String tokenAA = this.lock(this.lockAA, 5000L, true);
        this.lock(this.lockAB, 0L, false);
        this.lock(this.lockA, 0L, false);
        this.release(this.lockABA, tokenABA, true);
        this.lock(this.lockAB, 0L, false);
        this.lock(this.lockA, 0L, false);
        this.release(this.lockABB, tokenABB, true);
        this.lock(this.lockAB, 0L, false);
        this.lock(this.lockA, 0L, false);
        this.release(this.lockABC, tokenABC, true);
        String tokenAB = this.lock(this.lockAB, 5000L, true);
        this.lock(this.lockA, 0L, false);
        this.release(this.lockAA, tokenAA, true);
        this.release(this.lockAB, tokenAB, true);
        String tokenA = this.lock(this.lockA, 5000L, true);
        this.release(this.lockA, tokenA, true);
    }

    public synchronized void testLockExpiry() throws Exception {
        this.lock(this.lockAAA, 50L, true);
        ((Object)((Object)this)).wait(100L);
        this.lock(this.lockAA, 50L, true);
        ((Object)((Object)this)).wait(100L);
        this.lock(this.lockA, 100L, true);
    }

    public synchronized void testLockExpiryAndRelease() throws Exception {
        String tokenAAA = this.lock(this.lockAAA, 500L, true);
        this.release(this.lockAAA, tokenAAA, true);
        tokenAAA = this.lock(this.lockAAA, 50L, true);
        ((Object)((Object)this)).wait(100L);
        String grabbedTokenAAAA = this.lock(this.lockAAA, 50L, true);
        this.release(this.lockAAA, tokenAAA, false);
        ((Object)((Object)this)).wait(100L);
        this.release(this.lockAAA, grabbedTokenAAAA, true);
    }

    public synchronized void testLockRefresh() throws Exception {
        String tokenAAA = this.lock(this.lockAAA, 1000L, true);
        for (int i = 0; i < 40; ++i) {
            ((Object)((Object)this)).wait(50L);
            this.refresh(this.lockAAA, tokenAAA, 1000L, true);
            this.lock(this.lockAAA, 0L, false);
        }
    }

    public synchronized void testConcurrentLockAquisition() throws Exception {
        int i;
        ReentrantLock threadLock = new ReentrantLock();
        GetLockThread[] threads = new GetLockThread[5];
        for (int i2 = 0; i2 < threads.length; ++i2) {
            threads[i2] = new GetLockThread(threadLock);
            threads[i2].start();
        }
        boolean allDone = false;
        block1: for (int waitLoop = 0; waitLoop < 50; ++waitLoop) {
            ((Object)((Object)this)).wait(1000L);
            for (i = 0; i < threads.length; ++i) {
                if (!threads[i].done) continue block1;
            }
            allDone = true;
            break;
        }
        if (!allDone) {
            LockDAOTest.fail((String)"Not all threads managed to acquire the lock");
        }
        StringBuilder errors = new StringBuilder(512);
        for (i = 0; i < threads.length; ++i) {
            if (threads[i].error == null) continue;
            errors.append("\nThread ").append(i).append(" error: ").append(threads[i].error);
        }
        if (errors.toString().length() > 0) {
            LockDAOTest.fail((String)errors.toString());
        }
    }

    private class GetLockThread
    extends Thread {
        private final ReentrantLock threadLock;
        private boolean done;
        private String error;

        private GetLockThread(ReentrantLock threadLock) {
            this.threadLock = threadLock;
            this.done = false;
            this.error = null;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void run() {
            boolean gotLock = false;
            try {
                try {
                    String tokenAAA = null;
                    while (true) {
                        try {
                            tokenAAA = LockDAOTest.this.lock(LockDAOTest.this.lockAAA, 100000L);
                        }
                        catch (LockAcquisitionException e) {
                            try {
                                this.wait(20L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        break;
                    }
                    gotLock = this.threadLock.tryLock(0L, TimeUnit.MILLISECONDS);
                    if (!gotLock) {
                        this.error = "Got lock via DAO but not via thread lock";
                        Object var5_7 = null;
                        this.done = true;
                        if (!gotLock) return;
                        this.threadLock.unlock();
                        return;
                    }
                    LockDAOTest.this.release(LockDAOTest.this.lockAAA, tokenAAA, true);
                }
                catch (Throwable e) {
                    this.error = e.getMessage();
                    Object var5_9 = null;
                    this.done = true;
                    if (!gotLock) return;
                    this.threadLock.unlock();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                this.done = true;
                if (!gotLock) throw throwable;
                this.threadLock.unlock();
                throw throwable;
            }
            Object var5_8 = null;
            this.done = true;
            if (!gotLock) return;
            this.threadLock.unlock();
        }
    }
}

