/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.locks.ibatis;

import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.domain.locks.AbstractLockDAOImpl;
import org.alfresco.repo.domain.locks.LockEntity;
import org.alfresco.repo.domain.locks.LockResourceEntity;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockDAOImpl
extends AbstractLockDAOImpl {
    private static final String SELECT_LOCKRESOURCE_BY_QNAME = "alfresco.lock.select_LockResourceByQName";
    private static final String SELECT_LOCK_BY_ID = "alfresco.lock.select_LockByID";
    private static final String SELECT_LOCK_BY_KEY = "alfresco.lock.select_LockByKey";
    private static final String SELECT_LOCK_BY_SHARED_IDS = "alfresco.lock.select_LockBySharedIds";
    private static final String INSERT_LOCKRESOURCE = "alfresco.lock.insert_LockResource";
    private static final String INSERT_LOCK = "alfresco.lock.insert_Lock";
    private static final String UPDATE_LOCK = "alfresco.lock.update_Lock";
    private static final String UPDATE_EXCLUSIVE_LOCK = "alfresco.lock.update_ExclusiveLock";
    private SqlMapClientTemplate template;

    public void setSqlMapClientTemplate(SqlMapClientTemplate sqlMapClientTemplate) {
        this.template = sqlMapClientTemplate;
    }

    @Override
    protected LockResourceEntity getLockResource(Long qnameNamespaceId, String qnameLocalName) {
        LockResourceEntity lockResource = new LockResourceEntity();
        lockResource.setQnameNamespaceId(qnameNamespaceId);
        lockResource.setQnameLocalName(qnameLocalName == null ? null : qnameLocalName.toLowerCase());
        lockResource = (LockResourceEntity)this.template.queryForObject(SELECT_LOCKRESOURCE_BY_QNAME, (Object)lockResource);
        return lockResource;
    }

    @Override
    protected LockResourceEntity createLockResource(Long qnameNamespaceId, String qnameLocalName) {
        LockResourceEntity lockResource = new LockResourceEntity();
        lockResource.setVersion(LockEntity.CONST_LONG_ZERO);
        lockResource.setQnameNamespaceId(qnameNamespaceId);
        lockResource.setQnameLocalName(qnameLocalName == null ? null : qnameLocalName.toLowerCase());
        Long id = (Long)this.template.insert(INSERT_LOCKRESOURCE, (Object)lockResource);
        lockResource.setId(id);
        return lockResource;
    }

    @Override
    protected List<LockEntity> getLocksBySharedResourceIds(List<Long> sharedLockResourceIds) {
        List locks = this.template.queryForList(SELECT_LOCK_BY_SHARED_IDS, sharedLockResourceIds);
        return locks;
    }

    @Override
    protected LockEntity getLock(Long id) {
        LockEntity lock = new LockEntity();
        lock.setId(id);
        lock = (LockEntity)this.template.queryForObject(SELECT_LOCK_BY_ID, (Object)lock);
        return lock;
    }

    @Override
    protected LockEntity getLock(Long sharedResourceId, Long exclusiveResourceId) {
        LockEntity lock = new LockEntity();
        lock.setSharedResourceId(sharedResourceId);
        lock.setExclusiveResourceId(exclusiveResourceId);
        lock = (LockEntity)this.template.queryForObject(SELECT_LOCK_BY_KEY, (Object)lock);
        return lock;
    }

    @Override
    protected LockEntity createLock(Long sharedResourceId, Long exclusiveResourceId, String lockToken, long timeToLive) {
        LockEntity lock = new LockEntity();
        lock.setVersion(LockEntity.CONST_LONG_ZERO);
        lock.setSharedResourceId(sharedResourceId);
        lock.setExclusiveResourceId(exclusiveResourceId);
        lock.setLockToken(lockToken == null ? null : lockToken.toLowerCase());
        long now = System.currentTimeMillis();
        long exp = now + timeToLive;
        lock.setStartTime(now);
        lock.setExpiryTime(exp);
        Long id = (Long)this.template.insert(INSERT_LOCK, (Object)lock);
        lock.setId(id);
        return lock;
    }

    @Override
    protected LockEntity updateLock(LockEntity lockEntity, String lockToken, long timeToLive) {
        LockEntity updateLockEntity = new LockEntity();
        updateLockEntity.setId(lockEntity.getId());
        updateLockEntity.setVersion(lockEntity.getVersion());
        updateLockEntity.incrementVersion();
        updateLockEntity.setSharedResourceId(lockEntity.getSharedResourceId());
        updateLockEntity.setExclusiveResourceId(lockEntity.getExclusiveResourceId());
        updateLockEntity.setLockToken(lockToken == null ? null : lockToken.toLowerCase());
        long now = timeToLive > 0L ? System.currentTimeMillis() : 0L;
        long exp = timeToLive > 0L ? now + timeToLive : 0L;
        updateLockEntity.setStartTime(new Long(now));
        updateLockEntity.setExpiryTime(new Long(exp));
        this.template.update(UPDATE_LOCK, (Object)updateLockEntity, 1);
        return updateLockEntity;
    }

    @Override
    protected int updateLocks(Long exclusiveLockResourceId, String oldLockToken, String newLockToken, long timeToLive) {
        HashMap<String, Object> params = new HashMap<String, Object>(11);
        params.put("exclusiveLockResourceId", exclusiveLockResourceId);
        params.put("oldLockToken", oldLockToken);
        params.put("newLockToken", newLockToken == null ? null : newLockToken.toLowerCase());
        long now = timeToLive > 0L ? System.currentTimeMillis() : 0L;
        long exp = timeToLive > 0L ? now + timeToLive : 0L;
        params.put("newStartTime", new Long(now));
        params.put("newExpiryTime", new Long(exp));
        int updateCount = this.template.update(UPDATE_EXCLUSIVE_LOCK, params);
        return updateCount;
    }
}

