/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.view.ExportPackageHandler;
import org.alfresco.service.cmr.view.ExporterException;
import org.alfresco.util.TempFileProvider;

public class FileExportPackageHandler
implements ExportPackageHandler {
    protected MimetypeService mimetypeService = null;
    protected File contentDir;
    protected File absContentDir;
    protected File absDataFile;
    protected boolean overwrite;
    protected OutputStream absDataStream = null;

    public FileExportPackageHandler(File destDir, File dataFile, File contentDir, boolean overwrite, MimetypeService mimetypeService) {
        this.contentDir = contentDir;
        this.absContentDir = new File(destDir, contentDir.getPath());
        this.absDataFile = new File(destDir, dataFile.getPath());
        this.overwrite = overwrite;
        this.mimetypeService = mimetypeService;
    }

    public void startExport() {
        this.log("Exporting to package " + this.absDataFile.getAbsolutePath());
        if (this.absContentDir.exists()) {
            if (!this.overwrite) {
                throw new ExporterException("Package content dir " + this.absContentDir.getAbsolutePath() + " already exists.");
            }
            this.log("Warning: Overwriting existing package dir " + this.absContentDir.getAbsolutePath());
        }
    }

    public OutputStream createDataStream() {
        if (this.absDataFile.exists()) {
            if (!this.overwrite) {
                throw new ExporterException("Package data file " + this.absDataFile.getAbsolutePath() + " already exists.");
            }
            this.log("Warning: Overwriting existing package file " + this.absDataFile.getAbsolutePath());
            this.absDataFile.delete();
        }
        try {
            this.absDataFile.createNewFile();
            this.absDataStream = new FileOutputStream(this.absDataFile);
            return this.absDataStream;
        }
        catch (IOException e) {
            throw new ExporterException("Failed to create package file " + this.absDataFile.getAbsolutePath() + " due to " + e.getMessage());
        }
    }

    public ContentData exportContent(InputStream content, ContentData contentData) {
        String mimetype;
        if (content == null) {
            return contentData;
        }
        try {
            this.absContentDir.mkdirs();
        }
        catch (SecurityException e) {
            throw new ExporterException("Failed to create package dir " + this.absContentDir.getAbsolutePath() + " due to " + e.getMessage());
        }
        String extension = "bin";
        if (this.mimetypeService != null && (mimetype = contentData.getMimetype()) != null && mimetype.length() > 0) {
            try {
                extension = this.mimetypeService.getExtension(mimetype);
            }
            catch (AlfrescoRuntimeException e) {
                // empty catch block
            }
        }
        File outputFile = TempFileProvider.createTempFile((String)"export", (String)("." + extension), (File)this.absContentDir);
        try {
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            byte[] buffer = new byte[20480];
            int read = content.read(buffer, 0, 20480);
            while (read != -1) {
                outputStream.write(buffer, 0, read);
                read = content.read(buffer, 0, 20480);
            }
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            throw new ExporterException("Failed to create export package file due to " + e.getMessage());
        }
        catch (IOException e) {
            throw new ExporterException("Failed to export content due to " + e.getMessage());
        }
        File url = new File(this.contentDir, outputFile.getName());
        return new ContentData(url.getPath(), contentData.getMimetype(), contentData.getSize(), contentData.getEncoding());
    }

    public void endExport() {
        if (this.absDataStream != null) {
            try {
                this.absDataStream.close();
            }
            catch (IOException e) {
                throw new ExporterException("Failed to close package data file " + this.absDataFile + " due to" + e.getMessage());
            }
        }
    }

    protected void log(String message) {
    }
}

