/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.util.List;
import org.alfresco.repo.forms.processor.node.AbstractAssocCommand;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RemoveAssocCommand
extends AbstractAssocCommand {
    private static final Log logger = LogFactory.getLog(RemoveAssocCommand.class);

    public RemoveAssocCommand(NodeRef sourceNodeRef, NodeRef targetNodeRef, QName assocQName) {
        super(sourceNodeRef, targetNodeRef, assocQName);
    }

    protected void updateAssociations(NodeService nodeService) {
        List existingAssocs = nodeService.getTargetAssocs(this.sourceNodeRef, (QNamePattern)this.assocQName);
        boolean assocDoesNotExist = true;
        for (AssociationRef assoc : existingAssocs) {
            if (!assoc.getTargetRef().equals((Object)this.targetNodeRef)) continue;
            assocDoesNotExist = false;
            break;
        }
        if (assocDoesNotExist) {
            if (logger.isWarnEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Attempt to remove non-existent association prevented. ").append(this.sourceNodeRef).append("|").append(this.targetNodeRef).append(this.assocQName);
                logger.warn((Object)msg.toString());
            }
            return;
        }
        nodeService.removeAssociation(this.sourceNodeRef, this.targetNodeRef, this.assocQName);
    }
}

