/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.util.List;
import org.alfresco.repo.forms.processor.node.AbstractAssocCommand;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RemoveChildAssocCommand
extends AbstractAssocCommand {
    private static final Log logger = LogFactory.getLog(RemoveChildAssocCommand.class);

    public RemoveChildAssocCommand(NodeRef sourceNodeRef, NodeRef targetNodeRef, QName assocQName) {
        super(sourceNodeRef, targetNodeRef, assocQName);
    }

    protected void updateAssociations(NodeService nodeService) {
        List existingChildren = nodeService.getChildAssocs(this.sourceNodeRef);
        boolean childAssocDoesNotExist = true;
        for (ChildAssociationRef assoc : existingChildren) {
            if (!assoc.getChildRef().equals((Object)this.targetNodeRef)) continue;
            childAssocDoesNotExist = false;
            break;
        }
        if (childAssocDoesNotExist) {
            if (logger.isWarnEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Attempt to remove non-existent child association prevented. ").append(this.sourceNodeRef).append("|").append(this.targetNodeRef).append(this.assocQName);
                logger.warn((Object)msg.toString());
            }
            return;
        }
        nodeService.removeChild(this.sourceNodeRef, this.targetNodeRef);
    }
}

