/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.UID;
import java.io.IOException;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import junit.framework.TestCase;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;

public class ImapMessageTest
extends TestCase {
    private static Log logger = LogFactory.getLog(ImapMessageTest.class);
    private static final String PROTOCOL = "imap";
    private static final String ADMIN_USER_NAME = "admin";
    private static final String ADMIN_USER_PASSWORD = "admin";
    private static final String IMAP_FOLDER_NAME = "test";
    private Session session = null;
    private Store store = null;
    private IMAPFolder folder = null;
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private NodeService nodeService;
    private ImporterService importerService;
    private PersonService personService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private FileFolderService fileFolderService;
    private MutableAuthenticationService authenticationService;
    String anotherUserName;
    private NodeRef testImapFolderNodeRef;
    private NodeRef storeRootNodeRef;
    private final String storePath = "workspace://SpacesStore";
    private final String companyHomePathInStore = "/app:company_home";
    private static final String TEST_FOLDER = "Alfresco IMAP/test/___-___folder_a/___-___folder_a_a";
    private static final String TEST_FILE = "/cm:test/cm:___-___folder_a/cm:___-___folder_a_a/cm:___-___file_a_a";

    public void testAllTestsCommentedOut() {
    }

    public void setUp() throws Exception {
    }

    private void importInternal(String acpName, NodeRef space) throws IOException {
        ClassPathResource acpResource = new ClassPathResource(acpName);
        ACPImportPackageHandler acpHandler = new ACPImportPackageHandler(acpResource.getFile(), null);
        Location importLocation = new Location(space);
        this.importerService.importView(acpHandler, importLocation, null, null);
    }

    private static BODY getMessageBodyPart(IMAPFolder folder, final Long uid, final Integer from, final Integer count) throws MessagingException {
        return (BODY)folder.doCommand(new IMAPFolder.ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                Response[] r = p.command("UID FETCH " + uid + " (FLAGS BODY.PEEK[]<" + from + "." + count + ">)", null);
                ImapMessageTest.logResponse(r);
                Response response = r[r.length - 1];
                if (!response.isOK()) {
                    throw new ProtocolException("Unable to retrieve message part <" + from + "." + count + ">");
                }
                FetchResponse fetchResponse = (FetchResponse)r[0];
                BODY body = (BODY)fetchResponse.getItem(BODY.class);
                return body;
            }
        });
    }

    private NodeRef findNode(String path) {
        List nodeRefs = this.searchService.selectNodes(this.storeRootNodeRef, path, null, (NamespacePrefixResolver)this.namespaceService, false);
        return nodeRefs.size() > 0 ? (NodeRef)nodeRefs.get(0) : null;
    }

    private static Long getMessageUid(IMAPFolder folder, final int msn) throws MessagingException {
        return (Long)folder.doCommand(new IMAPFolder.ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                Response[] r = p.command("FETCH " + msn + " (UID)", null);
                ImapMessageTest.logResponse(r);
                Response response = r[r.length - 1];
                if (!response.isOK()) {
                    throw new ProtocolException("Unable to retrieve message UID");
                }
                FetchResponse fetchResponse = (FetchResponse)r[0];
                UID uid = (UID)fetchResponse.getItem(UID.class);
                return uid.uid;
            }
        });
    }

    private static Integer getMessageSize(IMAPFolder folder, final Long uid) throws MessagingException {
        return (Integer)folder.doCommand(new IMAPFolder.ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                Response[] r = p.command("UID FETCH " + uid + " (FLAGS BODY.PEEK[])", null);
                ImapMessageTest.logResponse(r);
                Response response = r[r.length - 1];
                if (!response.isOK()) {
                    throw new ProtocolException("Unable to retrieve message size");
                }
                FetchResponse fetchResponse = (FetchResponse)r[0];
                BODY body = (BODY)fetchResponse.getItem(BODY.class);
                return body.data.getCount();
            }
        });
    }

    private static void logResponse(Response[] r) {
        for (int i = 0; i < r.length; ++i) {
            logger.debug((Object)r[i]);
        }
    }

    public void tearDown() throws Exception {
    }
}

