/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.Serializable;
import java.util.Date;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public final class ScriptUtils
extends BaseScopableProcessorExtension {
    private static final String NAMESPACE_BEGIN = "{";
    private ServiceRegistry services;

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
    }

    public String pad(String s, int len) {
        String result = s;
        for (int i = 0; i < len - s.length(); ++i) {
            result = "0" + result;
        }
        return result;
    }

    public ScriptNode getNodeFromString(String nodeRefString) {
        NodeRef nodeRef = new NodeRef(nodeRefString);
        return (ScriptNode)new ValueConverter().convertValueForScript(this.services, this.getScope(), null, (Serializable)nodeRef);
    }

    public boolean toBoolean(String booleanString) {
        return Boolean.parseBoolean(booleanString);
    }

    public boolean moduleInstalled(String moduleName) {
        ModuleService moduleService = (ModuleService)this.services.getService(QName.createQName((String)"http://www.alfresco.org", (String)"ModuleService"));
        if (moduleService != null) {
            ModuleDetails moduleDetail = moduleService.getModule(moduleName);
            return moduleDetail != null;
        }
        return false;
    }

    public String toISO8601(long timeInMillis) {
        return ISO8601DateFormat.format((Date)new Date(timeInMillis));
    }

    public String toISO8601(Date date) {
        return ISO8601DateFormat.format((Date)date);
    }

    public Date fromISO8601(String isoDateString) {
        return ISO8601DateFormat.parse((String)isoDateString);
    }

    public String shortQName(String s) {
        return this.createQName(s).toPrefixString((NamespacePrefixResolver)this.services.getNamespaceService());
    }

    public String longQName(String s) {
        return this.createQName(s).toString();
    }

    private QName createQName(String s) {
        QName qname = s.indexOf(NAMESPACE_BEGIN) != -1 ? QName.createQName((String)s) : QName.createQName((String)s, (NamespacePrefixResolver)this.services.getNamespaceService());
        return qname;
    }

    public String toLocalizedString(String messageId, Object ... params) {
        return I18NUtil.getMessage((String)messageId, (Object[])params);
    }

    public void disableRules() {
        this.services.getRuleService().disableRules();
    }

    public void enableRules() {
        this.services.getRuleService().enableRules();
    }
}

