/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.alfresco.repo.jscript.Association;
import org.alfresco.repo.jscript.ChildAssociation;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class ValueConverter {
    private static final String TYPE_DATE = "Date";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable convertValueForScript(ServiceRegistry services, Scriptable scope, QName qname, Serializable value) {
        if (value == null) {
            return null;
        }
        if (value instanceof NodeRef) {
            value = new ScriptNode((NodeRef)value, services, scope);
        } else if (value instanceof QName || value instanceof StoreRef) {
            value = value.toString();
        } else if (value instanceof ChildAssociationRef) {
            value = new ChildAssociation(services, (ChildAssociationRef)value, scope);
        } else if (value instanceof AssociationRef) {
            value = new Association(services, (AssociationRef)value, scope);
        } else {
            if (value instanceof Date) {
                Date date = (Date)value;
                try {
                    Context.enter();
                    Scriptable val = ScriptRuntime.newObject((Context)Context.getCurrentContext(), (Scriptable)scope, (String)TYPE_DATE, (Object[])new Object[]{date.getTime()});
                    value = (Serializable)val;
                }
                finally {
                    Context.exit();
                }
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Object[] array = new Object[collection.size()];
                int index = 0;
                for (Serializable obj : collection) {
                    array[index++] = this.convertValueForScript(services, scope, qname, obj);
                }
                try {
                    Context.enter();
                    value = (Serializable)Context.getCurrentContext().newArray(scope, array);
                }
                finally {
                    Context.exit();
                }
            }
        }
        return value;
    }

    public Serializable convertValueForRepo(Serializable value) {
        Object converted = this.convertValueForJava(value);
        return converted instanceof Serializable ? (Serializable)converted : value;
    }

    public final Object convertValueForJava(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ScriptNode) {
            value = ((ScriptNode)((Object)value)).getNodeRef();
        } else if (value instanceof ChildAssociation) {
            value = ((ChildAssociation)((Object)value)).getChildAssociationRef();
        } else if (value instanceof Association) {
            value = ((Association)((Object)value)).getAssociationRef();
        } else if (value instanceof Wrapper) {
            value = this.convertValueForJava(((Wrapper)value).unwrap());
        } else if (value instanceof Scriptable) {
            Scriptable values = (Scriptable)value;
            if (value instanceof IdScriptableObject) {
                if (TYPE_DATE.equals(((IdScriptableObject)value).getClassName())) {
                    value = Context.jsToJava((Object)value, Date.class);
                } else if (value instanceof NativeArray) {
                    Object[] propIds = values.getIds();
                    if (this.isArray(propIds)) {
                        ArrayList<Object> propValues = new ArrayList<Object>(propIds.length);
                        for (int i = 0; i < propIds.length; ++i) {
                            Object propId = propIds[i];
                            if (!(propId instanceof Integer)) continue;
                            Object val = values.get(((Integer)propId).intValue(), values);
                            propValues.add(this.convertValueForJava(val));
                        }
                        value = propValues;
                    } else {
                        HashMap<Object, Object> propValues = new HashMap<Object, Object>(propIds.length);
                        for (Object propId : propIds) {
                            Object val = values.get(propId.toString(), values);
                            propValues.put(this.convertValueForJava(propId), this.convertValueForJava(val));
                        }
                        value = propValues;
                    }
                } else {
                    Object[] propIds = values.getIds();
                    HashMap<String, Object> propValues = new HashMap<String, Object>(propIds.length);
                    for (int i = 0; i < propIds.length; ++i) {
                        Object propId = propIds[i];
                        if (!(propId instanceof String)) continue;
                        Object val = values.get((String)propId, values);
                        propValues.put((String)propId, this.convertValueForJava(val));
                    }
                    value = propValues;
                }
            } else {
                Object[] propIds = values.getIds();
                HashMap<String, Object> propValues = new HashMap<String, Object>(propIds.length);
                for (int i = 0; i < propIds.length; ++i) {
                    Object propId = propIds[i];
                    if (!(propId instanceof String)) continue;
                    Object val = values.get((String)propId, values);
                    propValues.put((String)propId, this.convertValueForJava(val));
                }
                value = propValues;
            }
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(this.convertValueForJava(Array.get(value, i)));
            }
            value = list;
        }
        return value;
    }

    private boolean isArray(Object[] ids) {
        boolean result = true;
        for (Object id : ids) {
            if (id instanceof Integer) continue;
            result = false;
            break;
        }
        return result;
    }
}

