/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.alfresco.repo.management.subsystems.PropertyBackedBean;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanRegistry;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanStartedEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanState;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanStoppedEvent;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.PropertyPlaceholderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyBackedBean
implements PropertyBackedBean,
ApplicationContextAware,
ApplicationListener<ApplicationEvent>,
InitializingBean,
DisposableBean,
BeanNameAware {
    protected static final String DEFAULT_INSTANCE_NAME = "default";
    private ApplicationContext parent;
    private PropertyBackedBeanRegistry registry;
    private String category;
    private String beanName;
    private List<String> instancePath = Collections.singletonList("default");
    private List<String> id;
    private boolean autoStart;
    private Properties propertyDefaults;
    private DefaultResolver defaultResolver = new DefaultResolver();
    private boolean isStarted;
    private PropertyBackedBeanState state;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parent = applicationContext;
    }

    public void setRegistry(PropertyBackedBeanRegistry registry) {
        this.registry = registry;
    }

    protected PropertyBackedBeanRegistry getRegistry() {
        return this.registry;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setInstancePath(List<String> instancePath) {
        this.instancePath = instancePath;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setPropertyDefaults(Properties propertyDefaults) {
        this.propertyDefaults = propertyDefaults;
    }

    protected Properties getPropertyDefaults() {
        return this.propertyDefaults;
    }

    protected String resolveDefault(String name) {
        String value = this.propertyDefaults.getProperty(name);
        if (value != null) {
            value = this.defaultResolver.resolveValue(value);
        }
        return value;
    }

    protected ApplicationContext getParent() {
        return this.parent;
    }

    protected synchronized PropertyBackedBeanState getState(boolean start) {
        if (start) {
            this.start();
        }
        return this.state;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.category == null) {
            if (this.beanName == null) {
                throw new IllegalStateException("Category not provided");
            }
            this.category = this.beanName;
        }
        List<String> path = this.getInstancePath();
        this.id = new ArrayList<String>(path.size() + 1);
        this.id.add(this.category);
        this.id.addAll(this.getInstancePath());
        this.init();
    }

    public void init() {
        if (this.state == null) {
            try {
                this.state = this.createInitialState();
                this.applyDefaultOverrides(this.state);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.registry.register(this);
        }
    }

    @Override
    public synchronized void revert() {
        this.stop();
        this.destroy(true);
        this.init();
    }

    protected abstract PropertyBackedBeanState createInitialState() throws IOException;

    protected void applyDefaultOverrides(PropertyBackedBeanState state) throws IOException {
        for (String name : state.getPropertyNames()) {
            String override = this.resolveDefault(name);
            if (override == null) continue;
            state.setProperty(name, override);
        }
    }

    @Override
    public List<String> getId() {
        return this.id;
    }

    protected String getCategory() {
        return this.category;
    }

    protected List<String> getInstancePath() {
        return this.instancePath;
    }

    public void destroy() {
        this.destroy(false);
    }

    protected synchronized void destroy(boolean isPermanent) {
        if (this.state != null) {
            this.stop(false);
            this.registry.deregister(this, isPermanent);
            this.state = null;
        }
    }

    @Override
    public boolean isUpdateable(String name) {
        return true;
    }

    @Override
    public String getDescription(String name) {
        return this.isUpdateable(name) ? "Editable Property " + name : "Read-only Property " + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationEvent event) {
        if (this.autoStart && event instanceof ContextRefreshedEvent && event.getSource() == this.parent) {
            this.start(false);
        } else if (event instanceof PropertyBackedBeanStartedEvent) {
            AbstractPropertyBackedBean abstractPropertyBackedBean = this;
            synchronized (abstractPropertyBackedBean) {
                if (!this.isStarted) {
                    this.destroy(false);
                    this.start(false);
                }
            }
        } else if (event instanceof PropertyBackedBeanStoppedEvent) {
            this.destroy(false);
        }
    }

    @Override
    public synchronized String getProperty(String name) {
        this.init();
        return this.state.getProperty(name);
    }

    @Override
    public synchronized Set<String> getPropertyNames() {
        this.init();
        return this.state.getPropertyNames();
    }

    @Override
    public synchronized void setProperty(String name, String value) {
        this.init();
        this.state.setProperty(name, value);
    }

    @Override
    public synchronized void start() {
        this.start(true);
    }

    protected synchronized void start(boolean broadcast) {
        if (!this.isStarted) {
            this.init();
            if (broadcast) {
                this.registry.broadcastStart(this);
            }
            this.state.start();
            this.isStarted = true;
        }
    }

    @Override
    public void stop() {
        this.stop(true);
    }

    protected synchronized void stop(boolean broadcast) {
        if (this.isStarted) {
            if (broadcast) {
                this.registry.broadcastStop(this);
            }
            this.state.stop();
            this.isStarted = false;
        }
    }

    public class DefaultResolver
    extends PropertyPlaceholderHelper {
        public DefaultResolver() {
            super("${", "}", ":", true);
        }

        public String resolveValue(String val) {
            return AbstractPropertyBackedBean.this.propertyDefaults == null ? null : this.replacePlaceholders(val, AbstractPropertyBackedBean.this.propertyDefaults);
        }
    }
}

