/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.alfresco.config.JndiPropertiesFactoryBean;
import org.alfresco.repo.management.subsystems.AbstractPropertyBackedBean;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.alfresco.repo.management.subsystems.CompositeDataBean;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanRegistry;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildApplicationContextFactory
extends AbstractPropertyBackedBean
implements ApplicationContextFactory {
    private static final String TYPE_NAME_PROPERTY = "$type";
    private static final String PROPERTIES_SUFFIX = "/*.properties";
    private static final String CONTEXT_SUFFIX = "/*-context.xml";
    private static final String CLASSPATH_PREFIX = "classpath*:alfresco/subsystems/";
    private static final String EXTENSION_CLASSPATH_PREFIX = "classpath*:alfresco/extension/subsystems/";
    private static Log logger = LogFactory.getLog(ChildApplicationContextFactory.class);
    private String typeName;
    private Map<String, Class<?>> compositePropertyTypes = Collections.emptyMap();

    protected ChildApplicationContextFactory() {
    }

    public ChildApplicationContextFactory(ApplicationContext parent, PropertyBackedBeanRegistry registry, Properties propertyDefaults, String category, String typeName, List<String> instancePath) throws IOException {
        this.setApplicationContext(parent);
        this.setRegistry(registry);
        this.setPropertyDefaults(propertyDefaults);
        this.setCategory(category);
        this.setTypeName(typeName);
        this.setInstancePath(instancePath);
        try {
            this.afterPropertiesSet();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setCompositePropertyTypes(Map<String, Class<?>> compositePropertyTypes) {
        this.compositePropertyTypes = compositePropertyTypes;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        List<String> idList = this.getInstancePath();
        if (idList.isEmpty()) {
            throw new IllegalStateException("Invalid instance path");
        }
        if (this.getTypeName() == null) {
            this.setTypeName(idList.get(0));
        }
        super.afterPropertiesSet();
    }

    @Override
    protected PropertyBackedBeanState createInitialState() throws IOException {
        return new ApplicationContextState();
    }

    @Override
    protected void applyDefaultOverrides(PropertyBackedBeanState state) throws IOException {
        super.applyDefaultOverrides(state);
        List<String> idList = this.getId();
        JndiPropertiesFactoryBean overrideFactory = new JndiPropertiesFactoryBean();
        overrideFactory.setSystemPropertiesMode(2);
        overrideFactory.setLocations(this.getParent().getResources(EXTENSION_CLASSPATH_PREFIX + this.getCategory() + '/' + this.getTypeName() + '/' + idList.get(idList.size() - 1) + '/' + PROPERTIES_SUFFIX));
        overrideFactory.setProperties(((ApplicationContextState)state).properties);
        overrideFactory.afterPropertiesSet();
        ((ApplicationContextState)state).properties = overrideFactory.getObject();
    }

    @Override
    public boolean isUpdateable(String name) {
        return !name.equals(TYPE_NAME_PROPERTY);
    }

    @Override
    public String getDescription(String name) {
        return name.equals(TYPE_NAME_PROPERTY) ? "Read-only subsystem type name" : (this.compositePropertyTypes.containsKey(name) ? "Comma separated list of child object names" : super.getDescription(name));
    }

    @Override
    protected synchronized void destroy(boolean permanent) {
        ApplicationContextState state = (ApplicationContextState)this.getState(false);
        if (state != null) {
            state.destroy(permanent);
        }
        super.destroy(permanent);
    }

    @Override
    public synchronized ApplicationContext getApplicationContext() {
        return ((ApplicationContextState)this.getState(true)).getApplicationContext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ApplicationContextState
    implements PropertyBackedBeanState {
        private Properties properties;
        private Map<String, Map<String, CompositeDataBean>> compositeProperties = new TreeMap<String, Map<String, CompositeDataBean>>();
        private ClassPathXmlApplicationContext applicationContext;

        protected ApplicationContextState() throws IOException {
            PropertiesFactoryBean factory = new PropertiesFactoryBean();
            factory.setLocations(ChildApplicationContextFactory.this.getParent().getResources(ChildApplicationContextFactory.CLASSPATH_PREFIX + ChildApplicationContextFactory.this.getCategory() + '/' + ChildApplicationContextFactory.this.getTypeName() + ChildApplicationContextFactory.PROPERTIES_SUFFIX));
            factory.afterPropertiesSet();
            this.properties = factory.getObject();
        }

        @Override
        public synchronized Set<String> getPropertyNames() {
            TreeSet<String> result = new TreeSet<String>(this.properties.keySet());
            result.add(ChildApplicationContextFactory.TYPE_NAME_PROPERTY);
            result.addAll(ChildApplicationContextFactory.this.compositePropertyTypes.keySet());
            return result;
        }

        @Override
        public synchronized String getProperty(String name) {
            if (name.equals(ChildApplicationContextFactory.TYPE_NAME_PROPERTY)) {
                return ChildApplicationContextFactory.this.getTypeName();
            }
            if (ChildApplicationContextFactory.this.compositePropertyTypes.containsKey(name)) {
                Map<String, CompositeDataBean> beans = this.compositeProperties.get(name);
                if (beans != null) {
                    StringBuilder list = new StringBuilder(100);
                    for (String id : beans.keySet()) {
                        if (list.length() > 0) {
                            list.append(',');
                        }
                        list.append(id);
                    }
                    return list.toString();
                }
                return "";
            }
            return this.properties.getProperty(name);
        }

        @Override
        public void setProperty(String name, String value) {
            if (name.equals(ChildApplicationContextFactory.TYPE_NAME_PROPERTY)) {
                throw new IllegalStateException("Illegal write to property \"$type\"");
            }
            Class type = (Class)ChildApplicationContextFactory.this.compositePropertyTypes.get(name);
            if (type != null) {
                this.updateCompositeProperty(name, value, type);
            } else {
                this.properties.setProperty(name, value);
            }
        }

        private void updateCompositeProperty(String name, String value, Class<?> type) {
            Map<String, CompositeDataBean> propertyValues = this.compositeProperties.get(name);
            if (propertyValues == null) {
                propertyValues = Collections.emptyMap();
            }
            try {
                LinkedHashMap<String, CompositeDataBean> newPropertyValues = new LinkedHashMap<String, CompositeDataBean>(11);
                StringTokenizer tkn = new StringTokenizer(value, ", \t\n\r\f");
                while (tkn.hasMoreTokens()) {
                    String id = tkn.nextToken();
                    ArrayList<String> childPath = new ArrayList<String>(4);
                    childPath.addAll(ChildApplicationContextFactory.this.getInstancePath());
                    childPath.add(name);
                    childPath.add(id);
                    CompositeDataBean child = propertyValues.get(id);
                    if (child == null) {
                        child = new CompositeDataBean(ChildApplicationContextFactory.this.getParent(), ChildApplicationContextFactory.this, ChildApplicationContextFactory.this.getRegistry(), ChildApplicationContextFactory.this.getPropertyDefaults(), ChildApplicationContextFactory.this.getCategory(), type, childPath);
                    }
                    newPropertyValues.put(id, child);
                }
                TreeSet<String> idsToRemove = new TreeSet<String>(propertyValues.keySet());
                idsToRemove.removeAll(newPropertyValues.keySet());
                for (String id : idsToRemove) {
                    CompositeDataBean child = propertyValues.get(id);
                    child.destroy(true);
                }
                this.compositeProperties.put(name, newPropertyValues);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public synchronized void start() {
            if (this.applicationContext == null) {
                logger.info((Object)("Starting '" + ChildApplicationContextFactory.this.getCategory() + "' subsystem, ID: " + ChildApplicationContextFactory.this.getId()));
                ChildApplicationContextFactory childApplicationContextFactory = ChildApplicationContextFactory.this;
                childApplicationContextFactory.getClass();
                this.applicationContext = childApplicationContextFactory.new ChildApplicationContext(this.properties, this.compositeProperties);
                this.applicationContext.refresh();
                logger.info((Object)("Startup of '" + ChildApplicationContextFactory.this.getCategory() + "' subsystem, ID: " + ChildApplicationContextFactory.this.getId() + " complete"));
            }
        }

        @Override
        public void stop() {
            if (this.applicationContext != null) {
                logger.info((Object)("Stopping '" + ChildApplicationContextFactory.this.getCategory() + "' subsystem, ID: " + ChildApplicationContextFactory.this.getId()));
                try {
                    this.applicationContext.close();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                this.applicationContext = null;
                logger.info((Object)("Stopped '" + ChildApplicationContextFactory.this.getCategory() + "' subsystem, ID: " + ChildApplicationContextFactory.this.getId()));
            }
        }

        public void destroy(boolean permanent) {
            for (Map<String, CompositeDataBean> beans : this.compositeProperties.values()) {
                for (CompositeDataBean bean : beans.values()) {
                    bean.destroy(permanent);
                }
            }
        }

        public synchronized ApplicationContext getApplicationContext() {
            this.start();
            return this.applicationContext;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChildApplicationContext
    extends ClassPathXmlApplicationContext {
        private Map<String, Map<String, CompositeDataBean>> compositeProperties;

        private ChildApplicationContext(Properties properties, Map<String, Map<String, CompositeDataBean>> compositeProperties) throws BeansException {
            super(new String[]{ChildApplicationContextFactory.CLASSPATH_PREFIX + ChildApplicationContextFactory.this.getCategory() + '/' + ChildApplicationContextFactory.this.getTypeName() + ChildApplicationContextFactory.CONTEXT_SUFFIX, ChildApplicationContextFactory.EXTENSION_CLASSPATH_PREFIX + ChildApplicationContextFactory.this.getCategory() + '/' + ChildApplicationContextFactory.this.getTypeName() + '/' + ChildApplicationContextFactory.this.getId().get(ChildApplicationContextFactory.this.getId().size() - 1) + '/' + ChildApplicationContextFactory.CONTEXT_SUFFIX}, false, ChildApplicationContextFactory.this.getParent());
            this.compositeProperties = compositeProperties;
            PropertyPlaceholderConfigurer configurer = new PropertyPlaceholderConfigurer();
            configurer.setProperties(properties);
            configurer.setIgnoreUnresolvablePlaceholders(true);
            this.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurer);
            for (BeanFactoryPostProcessor postProcessor : this.getParent().getBeansOfType(BeanFactoryPostProcessor.class).values()) {
                this.addBeanFactoryPostProcessor(postProcessor);
            }
            this.setClassLoader(ChildApplicationContextFactory.this.getParent().getClassLoader());
        }

        protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            beanFactory.addBeanPostProcessor(new BeanPostProcessor(){

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }

                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    if (bean instanceof ListFactoryBean && ChildApplicationContextFactory.this.compositePropertyTypes.containsKey(beanName)) {
                        List beanList;
                        Map beans = (Map)ChildApplicationContext.this.compositeProperties.get(beanName);
                        if (beans != null) {
                            beanList = new ArrayList(beans.size());
                            for (CompositeDataBean wrapped : beans.values()) {
                                beanList.add(wrapped.getBean());
                            }
                        } else {
                            beanList = Collections.emptyList();
                        }
                        ((ListFactoryBean)bean).setSourceList(beanList);
                    }
                    return bean;
                }
            });
        }
    }
}

