/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder.loader;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.error.StackTraceUtil;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.loader.LoaderClientException;
import org.alfresco.repo.model.filefolder.loader.LoaderServerProxy;
import org.alfresco.repo.remote.FileFolderRemoteClient;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.remote.LoaderRemote;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.springframework.remoting.rmi.RmiProxyFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoaderSession {
    public static final ThreadGroup THREAD_GROUP = new ThreadGroup("FileFolderRemoteLoader");
    private String username;
    private String password;
    private String name;
    private Set<String> rmiUrls;
    private Set<StoreRef> storeRefs;
    private File outputFile;
    private File sourceDir;
    private int[] folderProfiles;
    private List<LoaderServerProxy> remoteServers;
    private List<NodeRef> workingRootNodeRefs;
    private File[] sourceFiles;
    private OutputStream outVerbose;
    private OutputStream outSummary;
    private OutputStream outError;
    private long startTime;

    public LoaderSession(String username, String password, String name, Set<String> rmiUrls, Set<StoreRef> storeRefs, File sourceDir, int[] folderProfiles) {
        this.username = username;
        this.password = password;
        this.name = name;
        this.rmiUrls = rmiUrls;
        this.storeRefs = storeRefs;
        this.sourceDir = sourceDir;
        this.folderProfiles = folderProfiles;
    }

    public String getName() {
        return this.name;
    }

    public List<LoaderServerProxy> getRemoteServers() {
        return this.remoteServers;
    }

    public List<NodeRef> getWorkingRootNodeRefs() {
        return this.workingRootNodeRefs;
    }

    public File[] getSourceFiles() {
        return this.sourceFiles;
    }

    public int[] getFolderProfiles() {
        return this.folderProfiles;
    }

    public synchronized void initialize() throws Exception {
        if (this.remoteServers != null) {
            throw new AlfrescoRuntimeException("The client has already been initialized");
        }
        this.remoteServers = LoaderSession.connect(this.rmiUrls, this.username, this.password);
        this.workingRootNodeRefs = LoaderSession.makeStores(this.remoteServers, this.storeRefs);
        LoaderSession.checkClustering(this.remoteServers, this.workingRootNodeRefs);
        if (this.outputFile != null) {
            File outputDir = this.outputFile.getParentFile();
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            if (this.outputFile.exists()) {
                System.out.println("The output file " + this.outputFile + " already exists.");
                System.out.println("Are you sure you want to overwrite the file?");
                int in = System.in.read();
                if (in != 89 && in != 121) {
                    throw new LoaderClientException("The output file " + this.outputFile + " already exists");
                }
            }
        }
        this.sourceFiles = LoaderSession.getSourceFiles(this.sourceDir);
        long time = System.currentTimeMillis();
        File fileVerbose = new File("./LoaderSession-" + this.name + "-" + time + "-verbose.tsv");
        File fileSummary = new File("./LoaderSession-" + this.name + "-" + time + "-summary.tsv");
        File fileError = new File("./LoaderSession-" + this.name + "-" + time + "-error.tsv");
        this.outVerbose = new BufferedOutputStream(new FileOutputStream(fileVerbose));
        this.outSummary = new BufferedOutputStream(new FileOutputStream(fileSummary));
        this.outError = new BufferedOutputStream(new FileOutputStream(fileError));
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void close() {
        try {
            this.outVerbose.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.outSummary.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.outError.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.outVerbose = null;
        this.outSummary = null;
        this.outError = null;
    }

    private static List<LoaderServerProxy> connect(Set<String> rmiUrls, String username, String password) throws Exception {
        ArrayList<LoaderServerProxy> remoteServers = new ArrayList<LoaderServerProxy>(rmiUrls.size());
        for (String rmiUrl : rmiUrls) {
            try {
                if (!rmiUrl.endsWith("/")) {
                    rmiUrl = rmiUrl + "/";
                }
                FileFolderRemoteClient fileFolderRemote = new FileFolderRemoteClient(rmiUrl);
                RmiProxyFactoryBean loaderFactory = new RmiProxyFactoryBean();
                loaderFactory.setRefreshStubOnConnectFailure(true);
                loaderFactory.setServiceInterface(LoaderRemote.class);
                loaderFactory.setServiceUrl(rmiUrl + "org.alfresco.LoaderRemote");
                loaderFactory.afterPropertiesSet();
                LoaderRemote loaderRemote = (LoaderRemote)loaderFactory.getObject();
                String ticket = loaderRemote.authenticate(username, password);
                LoaderServerProxy remoteServer = new LoaderServerProxy(rmiUrl, ticket, fileFolderRemote, loaderRemote);
                remoteServers.add(remoteServer);
            }
            catch (Throwable e) {
                System.err.println("\nERROR: Failed to establish connection to server: \n   Server: " + rmiUrl + "\n" + "   Error:  " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (remoteServers.size() == 0) {
            throw new LoaderClientException("No remote servers are available");
        }
        return remoteServers;
    }

    private static List<NodeRef> makeStores(List<LoaderServerProxy> remoteServers, Set<StoreRef> storeRefs) throws Exception {
        LoaderServerProxy remoteServer = remoteServers.get(0);
        ArrayList<NodeRef> workingRootNodeRefs = new ArrayList<NodeRef>(10);
        for (StoreRef storeRef : storeRefs) {
            NodeRef workingRootNodeRef = remoteServer.loaderRemote.getOrCreateWorkingRoot(remoteServer.ticket, storeRef);
            workingRootNodeRefs.add(workingRootNodeRef);
        }
        return workingRootNodeRefs;
    }

    private static void checkClustering(List<LoaderServerProxy> remoteServers, List<NodeRef> workingRootNodeRefs) throws Exception {
        ArrayList<String> problems = new ArrayList<String>(10);
        for (LoaderServerProxy remoteServer : remoteServers) {
            String ticket = remoteServer.ticket;
            for (NodeRef workingRootNodeRef : workingRootNodeRefs) {
                try {
                    byte[] bytes;
                    FileInfo fileInfo = remoteServer.fileFolderRemote.getFileInfo(ticket, workingRootNodeRef);
                    if (fileInfo == null) {
                        problems.add("Cannot find the working root node on server: " + remoteServer.rmiUrl);
                        continue;
                    }
                    String sampleFilename = "InitialSample.txt";
                    String sampleContent = "Sample content";
                    NodeRef sampleNodeRef = remoteServer.fileFolderRemote.searchSimple(ticket, workingRootNodeRef, sampleFilename);
                    if (sampleNodeRef == null) {
                        FileInfo sampleFileInfo = remoteServer.fileFolderRemote.create(ticket, workingRootNodeRef, sampleFilename, ContentModel.TYPE_CONTENT);
                        sampleNodeRef = sampleFileInfo.getNodeRef();
                        byte[] bytes2 = sampleContent.getBytes("UTF-8");
                        remoteServer.fileFolderRemote.putContent(ticket, sampleNodeRef, bytes2, sampleFilename);
                    }
                    if ((bytes = remoteServer.fileFolderRemote.getContent(ticket, sampleNodeRef)) == null) {
                        problems.add("Sample content was not found on server: " + remoteServer.rmiUrl);
                        continue;
                    }
                    String checkContent = new String(bytes, "UTF-8");
                    if (checkContent.equals(sampleContent)) continue;
                    problems.add("The sample content differed from expected: " + remoteServer.rmiUrl);
                }
                catch (Throwable e) {
                    System.err.println("ERROR: Failure whilst checking server: " + remoteServer.rmiUrl);
                    e.printStackTrace();
                    problems.add(e.getMessage());
                }
            }
        }
        if (problems.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n").append("The working root node references could not be found on all the remote servers.\n").append("Please ensure that all the remote servers listed are active in a single cluster.");
            for (String problem : problems) {
                sb.append("\n").append("   ").append(problem);
            }
            throw new LoaderClientException(sb.toString());
        }
    }

    private static File[] getSourceFiles(File sourceDir) throws Exception {
        if (sourceDir != null) {
            if (!sourceDir.exists()) {
                throw new LoaderClientException("The source directory to contain upload files is missing: " + sourceDir);
            }
            File[] allFiles = sourceDir.listFiles();
            ArrayList<File> sourceFiles = new ArrayList<File>(allFiles.length);
            for (File file : allFiles) {
                if (file.isDirectory()) continue;
                sourceFiles.add(file);
            }
            File[] ret = new File[sourceFiles.size()];
            return sourceFiles.toArray(ret);
        }
        return new File[0];
    }

    public static String getLineEnding() {
        return System.getProperty("line.separator", "\n");
    }

    public synchronized void logVerbose(String msg, boolean verbose) {
        if (!verbose || this.outVerbose == null) {
            return;
        }
        try {
            byte[] bytes = msg.getBytes("UTF-8");
            this.outVerbose.write(bytes);
            this.outVerbose.write(LoaderSession.getLineEnding().getBytes("UTF-8"));
            this.outVerbose.flush();
        }
        catch (Throwable e) {
            System.err.println("Failed to write message to verbose file: " + e.getMessage());
        }
    }

    public synchronized void logSummary(String msg) {
        if (this.outSummary == null) {
            return;
        }
        try {
            byte[] bytes = msg.getBytes("UTF-8");
            this.outSummary.write(bytes);
            this.outSummary.write(LoaderSession.getLineEnding().getBytes("UTF-8"));
            this.outSummary.flush();
        }
        catch (Throwable e) {
            System.err.println("Failed to write message to summary file: " + e.getMessage());
        }
    }

    public synchronized void logError(String msg) {
        if (this.outSummary == null) {
            return;
        }
        try {
            byte[] bytes = msg.getBytes("UTF-8");
            this.outError.write(bytes);
            this.outError.write(LoaderSession.getLineEnding().getBytes("UTF-8"));
            this.outError.flush();
        }
        catch (Throwable e) {
            System.err.println("Failed to write message to error file: " + e.getMessage());
        }
    }

    public synchronized void logError(String msg, Throwable e) {
        if (this.outSummary == null) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder(1024);
            StackTraceUtil.buildStackTrace((String)msg, (StackTraceElement[])e.getStackTrace(), (StringBuilder)sb, (int)50);
            byte[] bytes = sb.toString().getBytes("UTF-8");
            this.outError.write(bytes);
            this.outError.write(LoaderSession.getLineEnding().getBytes("UTF-8"));
            this.outError.flush();
        }
        catch (Throwable ee) {
            System.err.println("Failed to write message to error file: " + e.getMessage());
        }
    }

    public String getSummary() {
        ArrayList<Integer> folderProfilesAsList = new ArrayList<Integer>(10);
        for (int folderProfile : this.folderProfiles) {
            folderProfilesAsList.add(folderProfile);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Session name:     ").append(this.name).append(LoaderSession.getLineEnding()).append("RMI URLS:         ").append(this.rmiUrls).append(LoaderSession.getLineEnding()).append("Store References: ").append(this.storeRefs).append(LoaderSession.getLineEnding()).append("Folder Profiles:  ").append(folderProfilesAsList).append(LoaderSession.getLineEnding()).append("Start Time:       ").append(new Date(this.startTime));
        return sb.toString();
    }
}

