/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.InputStream;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentNodeServiceTest
extends TestCase {
    public static final String NAMESPACE = "http://www.alfresco.org/test/BaseNodeServiceTest";
    public static final String TEST_PREFIX = "test";
    public static final QName TYPE_QNAME_TEST_CONTENT = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"content");
    public static final QName ASPECT_QNAME_TEST_TITLED = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"titled");
    public static final QName PROP_QNAME_TEST_TITLE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"title");
    public static final QName PROP_QNAME_TEST_MIMETYPE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"mimetype");
    public static final int COUNT = 10;
    public static final int REPEATS = 20;
    static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private NodeService nodeService;
    private TransactionService transactionService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private NodeRef rootNodeRef;
    private FullTextSearchIndexer luceneFTS;
    private AuthenticationComponent authenticationComponent;

    protected void setUp() throws Exception {
        DictionaryDAO dictionaryDao = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/systemModel.xml");
        ConcurrentNodeServiceTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        ConcurrentNodeServiceTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        this.nodeService = (NodeService)ctx.getBean("dbNodeService");
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.retryingTransactionHelper = (RetryingTransactionHelper)ctx.getBean("retryingTransactionHelper");
        this.luceneFTS = (FullTextSearchIndexer)ctx.getBean("LuceneFullTextSearchIndexer");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> createRootNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                StoreRef storeRef = ConcurrentNodeServiceTest.this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
                ConcurrentNodeServiceTest.this.rootNodeRef = ConcurrentNodeServiceTest.this.nodeService.getRootNode(storeRef);
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction(createRootNodeCallback);
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.tearDown();
    }

    protected Map<QName, ChildAssociationRef> buildNodeGraph() throws Exception {
        return BaseNodeServiceTest.buildNodeGraph(this.nodeService, this.rootNodeRef);
    }

    protected Map<QName, ChildAssociationRef> commitNodeGraph() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Map<QName, ChildAssociationRef>> buildGraphCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Map<QName, ChildAssociationRef>>(){

            @Override
            public Map<QName, ChildAssociationRef> execute() throws Exception {
                Map<QName, ChildAssociationRef> answer = ConcurrentNodeServiceTest.this.buildNodeGraph();
                return answer;
            }
        };
        return this.retryingTransactionHelper.doInTransaction(buildGraphCallback);
    }

    public void xtest1() throws Exception {
        this.testConcurrent();
    }

    public void xtest2() throws Exception {
        this.testConcurrent();
    }

    public void xtest3() throws Exception {
        this.testConcurrent();
    }

    public void xtest4() throws Exception {
        this.testConcurrent();
    }

    public void xtest5() throws Exception {
        this.testConcurrent();
    }

    public void xtest6() throws Exception {
        this.testConcurrent();
    }

    public void xtest7() throws Exception {
        this.testConcurrent();
    }

    public void xtest8() throws Exception {
        this.testConcurrent();
    }

    public void xtest9() throws Exception {
        this.testConcurrent();
    }

    public void xtest10() throws Exception {
        this.testConcurrent();
    }

    public void testConcurrent() throws Exception {
        this.luceneFTS.pause();
        Map<QName, ChildAssociationRef> assocRefs = this.commitNodeGraph();
        Thread runner = null;
        for (int i = 0; i < 10; ++i) {
            runner = new Nester("Concurrent-" + i, runner, 20);
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
                System.out.println("Query thread has waited for " + runner.getName());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Object> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                Assert.assertEquals((int)402, (int)ConcurrentNodeServiceTest.this.nodeService.getChildAssocs(ConcurrentNodeServiceTest.this.rootNodeRef).size());
                SearchService searcher = (SearchService)ctx.getBean(ServiceRegistry.SEARCH_SERVICE.getLocalName());
                Assert.assertEquals((int)402, (int)searcher.selectNodes(ConcurrentNodeServiceTest.this.rootNodeRef, "/*", null, ConcurrentNodeServiceTest.this.getNamespacePrefixReolsver(""), false).size());
                ResultSet results = null;
                results = searcher.query(ConcurrentNodeServiceTest.this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*\"");
                Assert.assertEquals((int)603, (int)results.length());
                results.close();
                results = searcher.query(ConcurrentNodeServiceTest.this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*\"");
                Assert.assertEquals((int)804, (int)results.length());
                results.close();
                results = searcher.query(ConcurrentNodeServiceTest.this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*/*\"");
                Assert.assertEquals((int)402, (int)results.length());
                results.close();
                results = searcher.query(ConcurrentNodeServiceTest.this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*/*/*\"");
                Assert.assertEquals((int)201, (int)results.length());
                results.close();
                results = searcher.query(ConcurrentNodeServiceTest.this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*/*/*/*\"");
                Assert.assertEquals((int)0, (int)results.length());
                results.close();
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction(testCallback);
    }

    private NamespacePrefixResolver getNamespacePrefixReolsver(String defaultURI) {
        DynamicNamespacePrefixResolver nspr = new DynamicNamespacePrefixResolver(null);
        nspr.registerNamespace("sys", "http://www.alfresco.org/model/system/1.0");
        nspr.registerNamespace("cm", "http://www.alfresco.org/model/content/1.0");
        nspr.registerNamespace("app", "http://www.alfresco.org/model/application/1.0");
        nspr.registerNamespace("namespace", "namespace");
        nspr.registerNamespace("", defaultURI);
        return nspr;
    }

    private class Nester
    extends Thread {
        Thread waiter;
        int repeats;

        Nester(String name, Thread waiter, int repeats) {
            super(name);
            this.setDaemon(true);
            this.waiter = waiter;
            this.repeats = repeats;
        }

        public void run() {
            ConcurrentNodeServiceTest.this.authenticationComponent.setSystemUserAsCurrentUser();
            if (this.waiter != null) {
                System.out.println("Starting " + this.waiter.getName());
                this.waiter.start();
            }
            try {
                System.out.println("Start " + this.getName());
                for (int i = 0; i < this.repeats; ++i) {
                    Map<QName, ChildAssociationRef> assocRefs = ConcurrentNodeServiceTest.this.commitNodeGraph();
                    System.out.println(" " + this.getName() + " " + i);
                }
                System.out.println("End " + this.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.waiter != null) {
                try {
                    this.waiter.join();
                    System.out.println("Thread " + this.getName() + " has waited for " + (this.waiter == null ? "null" : this.waiter.getName()));
                }
                catch (InterruptedException e) {
                    System.err.println(e);
                }
            }
        }
    }
}

