/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.node.index.AbstractReindexComponent;
import org.alfresco.repo.node.index.NodeIndexer;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexTransactionTracker
extends AbstractReindexComponent {
    private static Log logger = LogFactory.getLog(IndexTransactionTracker.class);
    private IndexTransactionTrackerListener listener;
    private NodeIndexer nodeIndexer;
    private long maxTxnDurationMs = 3600000L;
    private long reindexLagMs = 1000L;
    private int maxRecordSetSize = 1000;
    private int maxTransactionsPerLuceneCommit = 100;
    private boolean disableInTransactionIndexing = false;
    private boolean started = false;
    private List<Long> previousTxnIds;
    private Long lastMaxTxnId;
    private long fromTimeInclusive = -1L;
    private Map<Long, TxnRecord> voids;
    private boolean forceReindex = false;
    private long fromTxnId = 0L;
    private String statusMsg = "No reindex in progress";
    private static final String NO_REINDEX = "No reindex in progress";
    RetryingTransactionHelper.RetryingTransactionCallback<Long> getStartingCommitTimeWork = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

        @Override
        public Long execute() throws Exception {
            return IndexTransactionTracker.this.getStartingTxnCommitTime();
        }
    };
    RetryingTransactionHelper.RetryingTransactionCallback<Boolean> reindexWork = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

        @Override
        public Boolean execute() throws Exception {
            return IndexTransactionTracker.this.reindexInTransaction();
        }
    };
    private static final long ONE_HOUR_MS = 3600000L;
    private static final int VOID_BATCH_SIZE = 100;

    public IndexTransactionTracker() {
        this.previousTxnIds = Collections.emptyList();
        this.lastMaxTxnId = Long.MAX_VALUE;
        this.voids = new TreeMap<Long, TxnRecord>();
    }

    public synchronized void setListener(IndexTransactionTrackerListener listener) {
        this.listener = listener;
    }

    public void setNodeIndexer(NodeIndexer nodeIndexer) {
        this.nodeIndexer = nodeIndexer;
    }

    public void setMaxTxnDurationMinutes(long maxTxnDurationMinutes) {
        if (maxTxnDurationMinutes < 1L) {
            throw new AlfrescoRuntimeException("Maximum transaction duration must be at least one minute.");
        }
        this.maxTxnDurationMs = maxTxnDurationMinutes * 60L * 1000L;
    }

    public void setReindexLagMs(long reindexLagMs) {
        if (reindexLagMs < 1L) {
            throw new AlfrescoRuntimeException("Reindex lag must be at least 1 millisecond.");
        }
        this.reindexLagMs = reindexLagMs;
    }

    public void setMaxRecordSetSize(int maxRecordSetSize) {
        this.maxRecordSetSize = maxRecordSetSize;
    }

    public void setMaxTransactionsPerLuceneCommit(int maxTransactionsPerLuceneCommit) {
        this.maxTransactionsPerLuceneCommit = maxTransactionsPerLuceneCommit;
    }

    public void setDisableInTransactionIndexing(boolean disableInTransactionIndexing) {
        this.disableInTransactionIndexing = disableInTransactionIndexing;
    }

    @Override
    protected boolean requireTransaction() {
        return false;
    }

    public void resetFromTxn(long txnId) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("resetFromTxn: " + txnId));
        }
        this.fromTxnId = txnId;
        this.started = false;
    }

    @Override
    protected void reindexImpl() {
        Boolean repeat;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("reindexImpl started: " + this));
        }
        RetryingTransactionHelper retryingTransactionHelper = this.transactionService.getRetryingTransactionHelper();
        if (!this.started) {
            if (this.disableInTransactionIndexing && this.nodeIndexer != null) {
                logger.warn((Object)"In-transaction indexing is being disabled.");
                this.nodeIndexer.setEnabled(false);
            }
            this.voids.clear();
            this.previousTxnIds = new ArrayList<Long>(this.maxRecordSetSize);
            this.lastMaxTxnId = null;
            if (this.fromTxnId != 0L) {
                Long fromTxnCommitTime;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("reindexImpl: start fromTxnId: " + this.fromTxnId));
                }
                if ((fromTxnCommitTime = this.getTxnCommitTime(this.fromTxnId)) == null) {
                    return;
                }
                this.fromTimeInclusive = fromTxnCommitTime;
            } else {
                this.fromTimeInclusive = retryingTransactionHelper.doInTransaction(this.getStartingCommitTimeWork, true, true);
            }
            this.fromTxnId = 0L;
            this.started = true;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("reindexImpl: start fromTimeInclusive: " + ISO8601DateFormat.format((Date)new Date(this.fromTimeInclusive))));
            }
        }
        while ((repeat = retryingTransactionHelper.doInTransaction(this.reindexWork, true, true)) != null && repeat.booleanValue()) {
        }
        this.waitForAsynchronousReindexing();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("reindexImpl: completed: " + this));
        }
        this.statusMsg = NO_REINDEX;
    }

    private Long getTxnCommitTime(final long txnId) {
        RetryingTransactionHelper retryingTransactionHelper = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Long> getTxnCommitTimeWork = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Exception {
                Transaction txn = IndexTransactionTracker.this.nodeDAO.getTxnById(txnId);
                if (txn != null) {
                    return txn.getCommitTimeMs();
                }
                logger.warn((Object)("Txn not found: " + txnId));
                return null;
            }
        };
        return retryingTransactionHelper.doInTransaction(getTxnCommitTimeWork, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reindexInTransaction() {
        List<Transaction> txns = null;
        long toTimeExclusive = System.currentTimeMillis() - this.reindexLagMs;
        long minLiveVoidTime = this.checkVoids();
        if (minLiveVoidTime <= this.fromTimeInclusive) {
            this.fromTimeInclusive = minLiveVoidTime;
            this.previousTxnIds.clear();
        }
        if ((txns = this.getNextTransactions(this.fromTimeInclusive, toTimeExclusive, this.previousTxnIds)).size() == 0) {
            this.forceReindex = false;
            return false;
        }
        this.statusMsg = String.format("Reindexing batch of %d transactions from %s (txnId=%s)", txns.size(), new Date(this.fromTimeInclusive).toString(), txns.isEmpty() ? "---" : txns.get(0).getId().toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.statusMsg);
        }
        long maxProcessedTxnCommitTime = this.reindexTransactions(txns);
        IndexTransactionTracker indexTransactionTracker = this;
        synchronized (indexTransactionTracker) {
            if (this.listener != null) {
                this.listener.indexedTransactions(this.fromTimeInclusive, maxProcessedTxnCommitTime);
            }
        }
        if (this.fromTimeInclusive != maxProcessedTxnCommitTime) {
            this.fromTimeInclusive = maxProcessedTxnCommitTime;
            this.previousTxnIds.clear();
        }
        for (Transaction txn : txns) {
            this.previousTxnIds.add(txn.getId());
        }
        return !this.isShuttingDown() && this.started;
    }

    public String getReindexStatus() {
        return this.statusMsg;
    }

    protected long getStartingTxnCommitTime() {
        long now = System.currentTimeMillis();
        long lastIndexedAllCommitTimeMs = this.getLastIndexedCommitTime(now, false);
        long lastIndexedRemoteCommitTimeMs = this.getLastIndexedCommitTime(now, true);
        long startTime = Math.min(lastIndexedAllCommitTimeMs, lastIndexedRemoteCommitTimeMs);
        return startTime - this.maxTxnDurationMs;
    }

    private long getLastIndexedCommitTime(long maxCommitTimeMs, boolean remoteOnly) {
        List<Transaction> nextTransactions;
        long maxToTimeExclusive;
        long toTimeExclusive = maxToTimeExclusive = maxCommitTimeMs - this.maxTxnDurationMs;
        long fromTimeInclusive = 0L;
        double stepFactor = 1.0;
        boolean firstWasInIndex = true;
        block4: while ((nextTransactions = this.nodeDAO.getTxnsByCommitTimeDescending(0L, toTimeExclusive, 1, null, remoteOnly)).size() != 0) {
            Transaction txn = nextTransactions.get(0);
            long txnCommitTime = txn.getCommitTimeMs();
            AbstractReindexComponent.InIndex txnInIndex = this.isTxnPresentInIndex(txn);
            switch (txnInIndex) {
                case YES: {
                    fromTimeInclusive = txnCommitTime;
                    break block4;
                }
                case INDETERMINATE: {
                    firstWasInIndex = false;
                    toTimeExclusive = txnCommitTime - 1000L;
                    continue block4;
                }
                default: {
                    firstWasInIndex = false;
                    long decrement = Math.min(3600000L, (long)(60000.0 * stepFactor));
                    toTimeExclusive = txnCommitTime - decrement;
                    stepFactor *= 1.1;
                    continue block4;
                }
            }
        }
        if (firstWasInIndex) {
            return maxToTimeExclusive;
        }
        return fromTimeInclusive;
    }

    private long checkVoids() {
        long maxHistoricalTime = this.fromTimeInclusive - this.maxTxnDurationMs;
        long fromTimeAdjusted = Long.MAX_VALUE;
        ArrayList<Long> toExpireTxnIds = new ArrayList<Long>(1);
        Iterator<Long> voidTxnIdIterator = this.voids.keySet().iterator();
        ArrayList<Long> voidTxnIdBatch = new ArrayList<Long>(100);
        while (voidTxnIdIterator.hasNext()) {
            TxnRecord voidTxnRecord;
            Long voidTxnId = voidTxnIdIterator.next();
            voidTxnIdBatch.add(voidTxnId);
            if (voidTxnIdBatch.size() == 100 || !voidTxnIdIterator.hasNext()) {
                List<Transaction> filledTxns = this.nodeDAO.getTxnsByCommitTimeAscending(voidTxnIdBatch);
                for (Transaction txn : filledTxns) {
                    if (txn.getCommitTimeMs() == null) continue;
                    if (this.isTxnPresentInIndex(txn) != AbstractReindexComponent.InIndex.NO) {
                        toExpireTxnIds.add(txn.getId());
                        continue;
                    }
                    long txnCommitTimeMs = txn.getCommitTimeMs();
                    if (txnCommitTimeMs >= fromTimeAdjusted) break;
                    fromTimeAdjusted = txnCommitTimeMs;
                    break;
                }
                voidTxnIdBatch.clear();
            }
            if ((voidTxnRecord = this.voids.get(voidTxnId)).txnCommitTime >= maxHistoricalTime) continue;
            toExpireTxnIds.add(voidTxnId);
        }
        int voidCountBefore = this.voids.size();
        for (Long toRemoveTxnId : toExpireTxnIds) {
            this.voids.remove(toRemoveTxnId);
        }
        int voidCountAfter = this.voids.size();
        if (logger.isDebugEnabled() && voidCountBefore != voidCountAfter) {
            logger.debug((Object)("Void count " + voidCountBefore + " -> " + voidCountAfter));
        }
        if (logger.isDebugEnabled() && fromTimeAdjusted < Long.MAX_VALUE) {
            logger.debug((Object)("Returning to void time " + fromTimeAdjusted));
        }
        return fromTimeAdjusted;
    }

    private List<Transaction> getNextTransactions(long fromTimeInclusive, long toTimeExclusive, List<Long> previousTxnIds) {
        List<Transaction> txns = this.nodeDAO.getTxnsByCommitTimeAscending(fromTimeInclusive, toTimeExclusive, this.maxRecordSetSize, previousTxnIds, false);
        return txns;
    }

    private long reindexTransactions(List<Transaction> txns) {
        if (txns.isEmpty()) {
            throw new IllegalArgumentException("There are no transactions to process");
        }
        long now = System.currentTimeMillis();
        long oldestVoidRetentionTime = now - this.maxTxnDurationMs;
        TreeMap<Long, TxnRecord> processedTxnRecords = new TreeMap<Long, TxnRecord>();
        ArrayList<Long> txnIdBuffer = new ArrayList<Long>(this.maxTransactionsPerLuceneCommit);
        Iterator<Transaction> txnIterator = txns.iterator();
        while (txnIterator.hasNext()) {
            Transaction txn = txnIterator.next();
            Long txnId = txn.getId();
            Long txnCommitTimeMs = txn.getCommitTimeMs();
            if (txnCommitTimeMs == null) continue;
            TxnRecord processedTxnRecord = new TxnRecord();
            processedTxnRecord.txnCommitTime = txnCommitTimeMs;
            processedTxnRecords.put(txnId, processedTxnRecord);
            this.voids.remove(txnId);
            if (this.forceReindex || this.isTxnPresentInIndex(txn) == AbstractReindexComponent.InIndex.NO) {
                this.forceReindex = true;
                txnIdBuffer.add(txnId);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reindexing transaction: " + txn));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reindex skipping transaction: " + txn));
            }
            if (this.isShuttingDown() || !this.started) break;
            if (txnIdBuffer.size() < this.maxTransactionsPerLuceneCommit && (txnIterator.hasNext() || txnIdBuffer.size() <= 0)) continue;
            try {
                this.reindexTransactionAsynchronously(txnIdBuffer);
            }
            catch (Throwable e) {
                logger.warn((Object)("\nReindex of transactions failed: \n   Transaction IDs: " + txnIdBuffer + "\n" + "   Error: " + e.getMessage()), e);
            }
            txnIdBuffer = new ArrayList(this.maxTransactionsPerLuceneCommit);
        }
        Long lastId = this.lastMaxTxnId;
        long lastCommitTime = -1L;
        for (Map.Entry entry : processedTxnRecords.entrySet()) {
            boolean voidsAreYoungEnough;
            Long processedTxnId = (Long)entry.getKey();
            TxnRecord processedTxnRecord = (TxnRecord)entry.getValue();
            boolean bl = voidsAreYoungEnough = processedTxnRecord.txnCommitTime >= oldestVoidRetentionTime;
            if (lastId != null && voidsAreYoungEnough) {
                int voidCount = 0;
                for (long i = lastId + 1L; i < processedTxnId; ++i) {
                    TxnRecord voidRecord = new TxnRecord();
                    voidRecord.txnCommitTime = processedTxnRecord.txnCommitTime;
                    this.voids.put(new Long(i), voidRecord);
                    ++voidCount;
                }
                if (logger.isDebugEnabled() && voidCount > 0) {
                    logger.debug((Object)("Voids detected: " + voidCount + " in range [" + lastId + ", " + processedTxnId + "]"));
                }
            }
            lastId = processedTxnId;
            lastCommitTime = processedTxnRecord.txnCommitTime;
        }
        this.lastMaxTxnId = lastId;
        return lastCommitTime;
    }

    public static interface IndexTransactionTrackerListener {
        public void indexedTransactions(long var1, long var3);
    }

    private class TxnRecord {
        private long txnCommitTime;

        private TxnRecord() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("TxnRecord").append("[time=").append(this.txnCommitTime <= 0L ? "---" : new Date(this.txnCommitTime)).append("]");
            return sb.toString();
        }
    }
}

