/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.node.integrity.IntegrityEvent;
import org.alfresco.repo.node.integrity.IntegrityRecord;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntegrityEvent
implements IntegrityEvent {
    protected final NodeService nodeService;
    protected final DictionaryService dictionaryService;
    private List<StackTraceElement[]> traces;
    private final NodeRef nodeRef;
    private final QName typeQName;
    private final QName qname;
    private int hashCode = 0;

    protected AbstractIntegrityEvent(NodeService nodeService, DictionaryService dictionaryService, NodeRef nodeRef, QName typeQName, QName qname) {
        this.nodeService = nodeService;
        this.dictionaryService = dictionaryService;
        this.traces = new ArrayList<StackTraceElement[]>(0);
        this.nodeRef = nodeRef;
        this.typeQName = typeQName;
        this.qname = qname;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 0 + 1 * (this.nodeRef == null ? 0 : this.nodeRef.hashCode()) - 17 * (this.typeQName == null ? 0 : this.typeQName.hashCode()) + 17 * (this.qname == null ? 0 : this.qname.hashCode());
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractIntegrityEvent that = (AbstractIntegrityEvent)obj;
        return EqualsHelper.nullSafeEquals((Object)this.nodeRef, (Object)that.nodeRef) && EqualsHelper.nullSafeEquals((Object)this.typeQName, (Object)that.typeQName) && EqualsHelper.nullSafeEquals((Object)this.qname, (Object)that.qname);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(56);
        sb.append("IntegrityEvent").append("[ name=").append(this.getClass().getName());
        if (this.nodeRef != null) {
            sb.append(", nodeRef=").append(this.nodeRef);
        }
        if (this.typeQName != null) {
            sb.append(", typeQName=").append(this.typeQName);
        }
        if (this.qname != null) {
            sb.append(", qname=").append(this.qname);
        }
        sb.append("]");
        return sb.toString();
    }

    protected QName getNodeType(NodeRef nodeRef) {
        try {
            return this.nodeService.getType(nodeRef);
        }
        catch (InvalidNodeRefException e) {
            return null;
        }
    }

    @Override
    public List<StackTraceElement[]> getTraces() {
        return this.traces;
    }

    @Override
    public void addTrace(StackTraceElement[] trace) {
        this.traces.add(trace);
    }

    protected NodeRef getNodeRef() {
        return this.nodeRef;
    }

    protected QName getTypeQName() {
        return this.typeQName;
    }

    protected QName getQName() {
        return this.qname;
    }

    protected AssociationDefinition getAssocDef(List<IntegrityRecord> eventResults, QName assocTypeQName) {
        return this.dictionaryService.getAssociation(assocTypeQName);
    }

    protected String getMultiplicityString(boolean mandatory, boolean allowMany) {
        StringBuilder sb = new StringBuilder(4);
        sb.append(mandatory ? "1" : "0");
        sb.append("..");
        sb.append(allowMany ? "*" : "1");
        return sb.toString();
    }
}

