/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remote;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.alfresco.repo.remote.ClientTicketHolder;
import org.alfresco.repo.remote.RepoRemoteInputStream;
import org.alfresco.repo.remote.RepoRemoteOutputStream;
import org.alfresco.service.cmr.remote.RepoRemote;
import org.alfresco.service.cmr.remote.RepoRemoteTransport;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoRemoteImpl
implements RepoRemote {
    private RepoRemoteTransport fTransport;
    private ClientTicketHolder fTicketHolder;

    public void setRepoRemoteTransport(RepoRemoteTransport transport) {
        this.fTransport = transport;
    }

    public void setClientTicketHolder(ClientTicketHolder ticketHolder) {
        this.fTicketHolder = ticketHolder;
    }

    @Override
    public NodeRef createDirectory(NodeRef base, String path) {
        return this.fTransport.createDirectory(this.fTicketHolder.getTicket(), base, path);
    }

    @Override
    public OutputStream createFile(NodeRef base, String path) {
        return new RepoRemoteOutputStream(this.fTransport.createFile(this.fTicketHolder.getTicket(), base, path), this.fTransport, this.fTicketHolder);
    }

    @Override
    public Map<String, Pair<NodeRef, Boolean>> getListing(NodeRef dir) {
        return this.fTransport.getListing(this.fTicketHolder.getTicket(), dir);
    }

    @Override
    public NodeRef getRoot() {
        return this.fTransport.getRoot(this.fTicketHolder.getTicket());
    }

    @Override
    public Pair<NodeRef, Boolean> lookup(NodeRef base, String path) {
        return this.fTransport.lookup(this.fTicketHolder.getTicket(), base, path);
    }

    @Override
    public InputStream readFile(NodeRef fileRef) {
        return new RepoRemoteInputStream(this.fTransport.readFile(this.fTicketHolder.getTicket(), fileRef), this.fTransport, this.fTicketHolder);
    }

    @Override
    public InputStream readFile(NodeRef base, String path) {
        return new RepoRemoteInputStream(this.fTransport.readFile(this.fTicketHolder.getTicket(), base, path), this.fTransport, this.fTicketHolder);
    }

    @Override
    public void removeNode(NodeRef toRemove) {
        this.fTransport.removeNode(this.fTicketHolder.getTicket(), toRemove);
    }

    @Override
    public void removeNode(NodeRef base, String path) {
        this.fTransport.removeNode(this.fTicketHolder.getTicket(), base, path);
    }

    @Override
    public void rename(NodeRef base, String src, String dst) {
        this.fTransport.rename(this.fTicketHolder.getTicket(), base, src, dst);
    }

    @Override
    public OutputStream writeFile(NodeRef base, String path) {
        return new RepoRemoteOutputStream(this.fTransport.writeFile(this.fTicketHolder.getTicket(), base, path), this.fTransport, this.fTicketHolder);
    }
}

