/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.rendition.RenditionDefinitionPersisterImpl;
import org.alfresco.repo.rendition.RenditionLocationResolver;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.rendition.CompositeRenditionDefinition;
import org.alfresco.service.cmr.rendition.RenderCallback;
import org.alfresco.service.cmr.rendition.RenderingEngineDefinition;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.Pair;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenditionServiceIntegrationTest
extends BaseAlfrescoSpringTest {
    private static final QName REFORMAT_RENDER_DEFN_NAME = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("reformat" + System.currentTimeMillis()));
    private static final QName RESCALE_RENDER_DEFN_NAME = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("imageRenderingEngine" + System.currentTimeMillis()));
    private static final String QUICK_CONTENT = "The quick brown fox jumps over the lazy dog";
    private static final String FM_TEMPLATE = "/org/alfresco/repo/rendition/renditionTestTemplate.ftl";
    private NodeRef nodeWithDocContent;
    private NodeRef nodeWithImageContent;
    private NodeRef nodeWithFreeMarkerContent;
    private NodeRef testTargetFolder;
    private NodeRef renditionNode = null;
    private NamespaceService namespaceService;
    private RenditionService renditionService;
    private Repository repositoryHelper;
    private ScriptService scriptService;
    private RetryingTransactionHelper transactionHelper;

    @Override
    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("namespaceService");
        this.renditionService = (RenditionService)this.applicationContext.getBean("renditionService");
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.scriptService = (ScriptService)this.applicationContext.getBean("scriptService");
        this.transactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        DummyHelloWorldRenditionEngine.registerIfNeeded(this.applicationContext);
        NodeRef companyHome = this.repositoryHelper.getCompanyHome();
        this.testTargetFolder = this.createNode(companyHome, "testFolder", ContentModel.TYPE_FOLDER);
        this.nodeWithDocContent = this.createContentNode(companyHome, "testDocContent");
        File pdfQuickFile = AbstractContentTransformerTest.loadQuickTestFile("pdf");
        RenditionServiceIntegrationTest.assertNotNull((String)"Failed to load required test file.", (Object)pdfQuickFile);
        this.nodeService.setProperty(this.nodeWithDocContent, ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "application/pdf", 0L, null));
        ContentWriter writer = this.contentService.getWriter(this.nodeWithDocContent, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("application/pdf");
        writer.setEncoding("UTF-8");
        writer.putContent(pdfQuickFile);
        HashMap<QName, String> titledProps = new HashMap<QName, String>();
        titledProps.put(ContentModel.PROP_TITLE, "Original test title");
        titledProps.put(ContentModel.PROP_DESCRIPTION, "Dummy description");
        this.nodeService.addAspect(this.nodeWithDocContent, ContentModel.ASPECT_TITLED, titledProps);
        this.nodeWithImageContent = this.createContentNode(companyHome, "testImageNode");
        URL url = RenditionServiceIntegrationTest.class.getClassLoader().getResource("images/gray21.512.png");
        RenditionServiceIntegrationTest.assertNotNull((String)"url of test image was null", (Object)url);
        File imageFile = new File(url.getFile());
        RenditionServiceIntegrationTest.assertTrue((boolean)imageFile.exists());
        this.nodeService.setProperty(this.nodeWithImageContent, ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "image/png", 0L, null));
        writer = this.contentService.getWriter(this.nodeWithImageContent, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("image/png");
        writer.setEncoding("UTF-8");
        writer.putContent(imageFile);
        this.nodeWithFreeMarkerContent = this.createFreeMarkerNode(companyHome);
    }

    private NodeRef createContentNode(NodeRef companyHome, String name) {
        return this.createNode(companyHome, name, ContentModel.TYPE_CONTENT);
    }

    private NodeRef createNode(NodeRef companyHome, String name, QName type) {
        HashMap<QName, String> props = new HashMap<QName, String>();
        String fullName = name + System.currentTimeMillis();
        props.put(ContentModel.PROP_NAME, fullName);
        QName docContentQName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)fullName);
        NodeRef node = this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, docContentQName, type, props).getChildRef();
        return node;
    }

    private NodeRef createFreeMarkerNode(NodeRef companyHome) {
        NodeRef fmNode = this.createContentNode(companyHome, "testFreeMarkerNode");
        this.nodeService.setProperty(fmNode, ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "text/plain", 0L, null));
        URL url = ((Object)((Object)this)).getClass().getResource(FM_TEMPLATE);
        RenditionServiceIntegrationTest.assertNotNull((String)"The url is null", (Object)url);
        File templateFile = new File(url.getFile());
        RenditionServiceIntegrationTest.assertTrue((String)"The template file does not exist", (boolean)templateFile.exists());
        ContentWriter fmWriter = this.contentService.getWriter(fmNode, ContentModel.PROP_CONTENT, true);
        fmWriter.setMimetype("text/plain");
        fmWriter.setEncoding("UTF-8");
        fmWriter.putContent(templateFile);
        return fmNode;
    }

    @Override
    protected void onTearDownInTransaction() throws Exception {
        this.nodeService.deleteNode(this.nodeWithImageContent);
        this.nodeService.deleteNode(this.nodeWithDocContent);
        this.nodeService.deleteNode(this.nodeWithFreeMarkerContent);
        this.nodeService.deleteNode(this.testTargetFolder);
    }

    public void testRenderFreeMarkerTemplate() throws Exception {
        this.setComplete();
        this.endTransaction();
        final QName renditionName = QName.createQName((String)"http://www.alfresco.org/model/rendition/1.0", (String)"freemarkerRenderingEngine");
        this.renditionNode = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                RenditionDefinition definition = RenditionServiceIntegrationTest.this.renditionService.createRenditionDefinition(renditionName, "freemarkerRenderingEngine");
                definition.setParameterValue("template_node", (Serializable)RenditionServiceIntegrationTest.this.nodeWithFreeMarkerContent);
                ChildAssociationRef renditionAssoc = RenditionServiceIntegrationTest.this.renditionService.render(RenditionServiceIntegrationTest.this.nodeWithDocContent, definition);
                Assert.assertNotNull((String)"The rendition association was null", (Object)renditionAssoc);
                return renditionAssoc.getChildRef();
            }
        });
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                String output = RenditionServiceIntegrationTest.this.readTextContent(RenditionServiceIntegrationTest.this.renditionNode);
                Assert.assertNotNull((String)"The rendition content was null.", (Object)output);
                Assert.assertTrue((boolean)output.contains(RenditionServiceIntegrationTest.this.nodeWithDocContent.getId()));
                return null;
            }
        });
    }

    public void testRenderFreeMarkerTemplateOneTransaction() throws Exception {
        this.setComplete();
        this.endTransaction();
        final QName renditionName = QName.createQName((String)"http://www.alfresco.org/model/rendition/1.0", (String)"freemarkerRenderingEngine");
        this.renditionNode = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                RenditionDefinition definition = RenditionServiceIntegrationTest.this.renditionService.createRenditionDefinition(renditionName, "freemarkerRenderingEngine");
                definition.setParameterValue("template_node", (Serializable)RenditionServiceIntegrationTest.this.nodeWithFreeMarkerContent);
                ChildAssociationRef renditionAssoc = RenditionServiceIntegrationTest.this.renditionService.render(RenditionServiceIntegrationTest.this.nodeWithDocContent, definition);
                Assert.assertNotNull((String)"The rendition association was null", (Object)renditionAssoc);
                String output = RenditionServiceIntegrationTest.this.readTextContent(renditionAssoc.getChildRef());
                Assert.assertNotNull((String)"The rendition content was null.", (Object)output);
                Assert.assertTrue((boolean)output.contains(RenditionServiceIntegrationTest.this.nodeWithDocContent.getId()));
                return null;
            }
        });
    }

    public void testRenderFreemarkerTemplatePath() throws Exception {
        this.setComplete();
        this.endTransaction();
        final QName renditionName1 = QName.createQName((String)"http://www.alfresco.org/model/rendition/1.0", (String)"freemarkerRenderingEngine_UpdateOnAnyPropChange");
        final QName renditionName2 = QName.createQName((String)"http://www.alfresco.org/model/rendition/1.0", (String)"freemarkerRenderingEngine_UpdateOnContentPropChange");
        final Pair<NodeRef, NodeRef> renditions = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Pair<NodeRef, NodeRef>>(){

            @Override
            public Pair<NodeRef, NodeRef> execute() throws Throwable {
                ChildAssociationRef parentAssoc = RenditionServiceIntegrationTest.this.nodeService.getPrimaryParent(RenditionServiceIntegrationTest.this.nodeWithFreeMarkerContent);
                QName assocName = parentAssoc.getQName();
                String templatePath = "/app:company_home/" + assocName.toPrefixString((NamespacePrefixResolver)RenditionServiceIntegrationTest.this.namespaceService);
                RenditionDefinition definition1 = RenditionServiceIntegrationTest.this.renditionService.createRenditionDefinition(renditionName1, "freemarkerRenderingEngine");
                definition1.setParameterValue("template_path", (Serializable)((Object)templatePath));
                definition1.setParameterValue("update-renditions-on-any-property-change", Boolean.TRUE);
                RenditionDefinition definition2 = RenditionServiceIntegrationTest.this.renditionService.createRenditionDefinition(renditionName2, "freemarkerRenderingEngine");
                definition2.setParameterValue("template_path", (Serializable)((Object)templatePath));
                definition2.setParameterValue("update-renditions-on-any-property-change", Boolean.FALSE);
                if (null == RenditionServiceIntegrationTest.this.renditionService.loadRenditionDefinition(renditionName1)) {
                    RenditionServiceIntegrationTest.this.renditionService.saveRenditionDefinition(definition1);
                }
                if (null == RenditionServiceIntegrationTest.this.renditionService.loadRenditionDefinition(renditionName2)) {
                    RenditionServiceIntegrationTest.this.renditionService.saveRenditionDefinition(definition2);
                }
                ChildAssociationRef renditionAssoc1 = RenditionServiceIntegrationTest.this.renditionService.render(RenditionServiceIntegrationTest.this.nodeWithDocContent, definition1);
                Assert.assertNotNull((String)"The rendition association was null", (Object)renditionAssoc1);
                ChildAssociationRef renditionAssoc2 = RenditionServiceIntegrationTest.this.renditionService.render(RenditionServiceIntegrationTest.this.nodeWithDocContent, definition2);
                Assert.assertNotNull((String)"The rendition association was null", (Object)renditionAssoc2);
                Pair result = new Pair((Object)renditionAssoc1.getChildRef(), (Object)renditionAssoc2.getChildRef());
                return result;
            }
        });
        String titleInitialValue = "Original test title";
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((String)"The source node should have title Original test title", (Object)"Original test title", (Object)RenditionServiceIntegrationTest.this.nodeService.getProperty(RenditionServiceIntegrationTest.this.nodeWithDocContent, ContentModel.PROP_TITLE));
                String output1 = RenditionServiceIntegrationTest.this.readTextContent((NodeRef)renditions.getFirst());
                Assert.assertNotNull((String)"The rendition content was null.", (Object)output1);
                RenditionServiceIntegrationTest.this.assertRenditionContainsTitle("Original test title", output1);
                Assert.assertTrue((boolean)output1.contains(RenditionServiceIntegrationTest.this.nodeWithDocContent.getId()));
                String output2 = RenditionServiceIntegrationTest.this.readTextContent((NodeRef)renditions.getSecond());
                Assert.assertNotNull((String)"The rendition content was null.", (Object)output2);
                RenditionServiceIntegrationTest.this.assertRenditionContainsTitle("Original test title", output2);
                return null;
            }
        });
        String updatedTitle = "updatedTitle";
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                RenditionServiceIntegrationTest.this.nodeService.setProperty(RenditionServiceIntegrationTest.this.nodeWithDocContent, ContentModel.PROP_TITLE, (Serializable)((Object)"updatedTitle"));
                return null;
            }
        });
        Thread.sleep(30000L);
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                String output1 = RenditionServiceIntegrationTest.this.readTextContent((NodeRef)renditions.getFirst());
                Assert.assertNotNull((String)"The rendition content was null.", (Object)output1);
                RenditionServiceIntegrationTest.this.assertRenditionContainsTitle("updatedTitle", output1);
                String output2 = RenditionServiceIntegrationTest.this.readTextContent((NodeRef)renditions.getSecond());
                Assert.assertNotNull((String)"The rendition content was null.", (Object)output2);
                RenditionServiceIntegrationTest.this.assertRenditionContainsTitle("Original test title", output2);
                return null;
            }
        });
    }

    private void assertRenditionContainsTitle(String titleValue, String output) {
        String titleMarker = "TestTitle=";
        String beforeAfterMarker = "xxx";
        int indexOfTitleMarker = output.indexOf("TestTitle=");
        int indexOfStartMarker = output.indexOf("xxx", indexOfTitleMarker);
        int indexOfEndMarker = output.indexOf("xxx", indexOfStartMarker + "xxx".length());
        String titleAsTakenFromRendition = output.substring(indexOfStartMarker + "xxx".length(), indexOfEndMarker);
        RenditionServiceIntegrationTest.assertEquals((String)("The rendition should contain title " + titleValue), (String)titleValue, (String)titleAsTakenFromRendition);
    }

    public void testRenderDocumentInAnotherFormatInSitu() throws Exception {
        this.setComplete();
        this.endTransaction();
        this.renditionNode = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                Assert.assertFalse((String)"Source node has unexpected renditioned aspect.", (boolean)RenditionServiceIntegrationTest.this.nodeService.hasAspect(RenditionServiceIntegrationTest.this.nodeWithDocContent, RenditionModel.ASPECT_RENDITIONED));
                Assert.assertTrue((String)"Renditions should have been empty", (boolean)RenditionServiceIntegrationTest.this.renditionService.getRenditions(RenditionServiceIntegrationTest.this.nodeWithDocContent).isEmpty());
                Assert.assertNull((String)"Renditions should have been null", (Object)RenditionServiceIntegrationTest.this.renditionService.getRenditionByName(RenditionServiceIntegrationTest.this.nodeWithDocContent, REFORMAT_RENDER_DEFN_NAME));
                RenditionServiceIntegrationTest.this.validateRenderingActionDefinition("reformat");
                RenditionDefinition action = RenditionServiceIntegrationTest.this.makeReformatAction(null, "text/plain");
                ChildAssociationRef renditionAssoc = RenditionServiceIntegrationTest.this.renditionService.render(RenditionServiceIntegrationTest.this.nodeWithDocContent, action);
                NodeRef rendition = renditionAssoc.getChildRef();
                Assert.assertEquals((String)"The parent node was not correct", (Object)RenditionServiceIntegrationTest.this.nodeWithDocContent, (Object)renditionAssoc.getParentRef());
                RenditionServiceIntegrationTest.this.validateRenditionAssociation(renditionAssoc, REFORMAT_RENDER_DEFN_NAME);
                Assert.assertEquals((String)"Wrong value for rendition node parent count.", (int)1, (int)RenditionServiceIntegrationTest.this.nodeService.getParentAssocs(rendition).size());
                Assert.assertTrue((String)"Source node is missing renditioned aspect.", (boolean)RenditionServiceIntegrationTest.this.nodeService.hasAspect(RenditionServiceIntegrationTest.this.nodeWithDocContent, RenditionModel.ASPECT_RENDITIONED));
                Assert.assertEquals((String)"Renditions size wrong", (int)1, (int)RenditionServiceIntegrationTest.this.renditionService.getRenditions(RenditionServiceIntegrationTest.this.nodeWithDocContent).size());
                Assert.assertNotNull((String)"Renditions should not have been null", (Object)RenditionServiceIntegrationTest.this.renditionService.getRenditionByName(RenditionServiceIntegrationTest.this.nodeWithDocContent, REFORMAT_RENDER_DEFN_NAME));
                return rendition;
            }
        });
        RenditionServiceIntegrationTest.assertNotNull((String)"The rendition node was null.", (Object)this.renditionNode);
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                String contentAsString = RenditionServiceIntegrationTest.this.readTextContent(RenditionServiceIntegrationTest.this.renditionNode);
                Assert.assertTrue((String)"Wrong content in rendition", (boolean)contentAsString.contains(RenditionServiceIntegrationTest.QUICK_CONTENT));
                return null;
            }
        });
    }

    public void testRenderPdfDocumentToFlash() throws Exception {
        this.setComplete();
        this.endTransaction();
        this.renditionNode = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                Assert.assertFalse((String)"Source node has unexpected renditioned aspect.", (boolean)RenditionServiceIntegrationTest.this.nodeService.hasAspect(RenditionServiceIntegrationTest.this.nodeWithDocContent, RenditionModel.ASPECT_RENDITIONED));
                RenditionServiceIntegrationTest.this.validateRenderingActionDefinition("reformat");
                RenditionDefinition action = RenditionServiceIntegrationTest.this.makeReformatAction(null, "application/x-shockwave-flash");
                action.setParameterValue("flashVersion", (Serializable)((Object)"9"));
                ChildAssociationRef renditionAssoc = RenditionServiceIntegrationTest.this.renditionService.render(RenditionServiceIntegrationTest.this.nodeWithDocContent, action);
                Assert.assertEquals((String)"The parent node was not correct", (Object)RenditionServiceIntegrationTest.this.nodeWithDocContent, (Object)renditionAssoc.getParentRef());
                RenditionServiceIntegrationTest.this.validateRenditionAssociation(renditionAssoc, REFORMAT_RENDER_DEFN_NAME);
                Assert.assertEquals((String)"Wrong value for rendition node parent count.", (int)1, (int)RenditionServiceIntegrationTest.this.nodeService.getParentAssocs(renditionAssoc.getChildRef()).size());
                Assert.assertTrue((String)"Source node is missing renditioned aspect.", (boolean)RenditionServiceIntegrationTest.this.nodeService.hasAspect(RenditionServiceIntegrationTest.this.nodeWithDocContent, RenditionModel.ASPECT_RENDITIONED));
                return renditionAssoc.getChildRef();
            }
        });
        RenditionServiceIntegrationTest.assertNotNull((String)"The rendition node was null.", (Object)this.renditionNode);
    }

    public void testCompositeReformatAndResizeRendition() throws Exception {
        this.setComplete();
        this.endTransaction();
        final QName renditionName = QName.createQName((String)"http://www.alfresco.org/model/rendition/1.0", (String)"composite");
        int newX = 20;
        int newY = 30;
        this.renditionNode = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                CompositeRenditionDefinition compositeDefinition = RenditionServiceIntegrationTest.this.makeCompositeReformatAndResizeDefinition(renditionName, 20, 30);
                ChildAssociationRef renditionAssoc = RenditionServiceIntegrationTest.this.renditionService.render(RenditionServiceIntegrationTest.this.nodeWithDocContent, compositeDefinition);
                RenditionServiceIntegrationTest.this.validateRenditionAssociation(renditionAssoc, renditionName);
                return renditionAssoc.getChildRef();
            }
        });
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                List<ChildAssociationRef> renditions = RenditionServiceIntegrationTest.this.renditionService.getRenditions(RenditionServiceIntegrationTest.this.nodeWithDocContent);
                Assert.assertEquals((String)"There should only be one rendition", (int)1, (int)renditions.size());
                ChildAssociationRef renditionAssoc = renditions.get(0);
                Assert.assertEquals((String)"The association name should match the composite rendition name", (Object)renditionName, (Object)renditionAssoc.getQName());
                NodeRef rendition = renditionAssoc.getChildRef();
                ContentReader reader = RenditionServiceIntegrationTest.this.contentService.getReader(rendition, ContentModel.PROP_CONTENT);
                Assert.assertEquals((String)"The mimetype is wrong", (String)"image/jpeg", (String)reader.getMimetype());
                Assert.assertNotNull((String)"Reader to rendered image was null", (Object)reader);
                BufferedImage img = ImageIO.read(reader.getContentInputStream());
                Assert.assertEquals((String)"Rendered image had wrong height", (int)30, (int)img.getHeight());
                Assert.assertEquals((String)"Rendered image had wrong width", (int)20, (int)img.getWidth());
                return null;
            }
        });
    }

    public void testRenderDocumentInAnotherFormatUnderSpecifiedFolder() throws Exception {
        this.setComplete();
        this.endTransaction();
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Assert.assertFalse((String)"Source node has unexpected renditioned aspect.", (boolean)RenditionServiceIntegrationTest.this.nodeService.hasAspect(RenditionServiceIntegrationTest.this.nodeWithDocContent, RenditionModel.ASPECT_RENDITIONED));
                RenditionServiceIntegrationTest.this.validateRenderingActionDefinition("reformat");
                RenditionDefinition definition = RenditionServiceIntegrationTest.this.makeReformatAction(ContentModel.TYPE_CONTENT, "text/plain");
                Serializable targetFolderName = RenditionServiceIntegrationTest.this.nodeService.getProperty(RenditionServiceIntegrationTest.this.testTargetFolder, ContentModel.PROP_NAME);
                String path = "${companyHome.name}/" + targetFolderName + "/test.txt";
                definition.setParameterValue("destination-path-template", (Serializable)((Object)path));
                ChildAssociationRef renditionAssoc = RenditionServiceIntegrationTest.this.renditionService.render(RenditionServiceIntegrationTest.this.nodeWithDocContent, definition);
                NodeRef rendition = renditionAssoc.getChildRef();
                Assert.assertEquals((String)"The parent node was not correct", (Object)RenditionServiceIntegrationTest.this.nodeWithDocContent, (Object)renditionAssoc.getParentRef());
                RenditionServiceIntegrationTest.this.validateRenditionAssociation(renditionAssoc, REFORMAT_RENDER_DEFN_NAME);
                List parentAssocs = RenditionServiceIntegrationTest.this.nodeService.getParentAssocs(rendition);
                Assert.assertEquals((String)"Wrong value for rendition node parent count.", (int)2, (int)parentAssocs.size());
                ArrayList<NodeRef> parents = new ArrayList<NodeRef>(2);
                parents.add(((ChildAssociationRef)parentAssocs.get(0)).getParentRef());
                parents.add(((ChildAssociationRef)parentAssocs.get(1)).getParentRef());
                Assert.assertTrue((String)"Missing containing folder as parent", (boolean)parents.contains(RenditionServiceIntegrationTest.this.testTargetFolder));
                Assert.assertTrue((String)"Missing source node as parent", (boolean)parents.contains(RenditionServiceIntegrationTest.this.nodeWithDocContent));
                Assert.assertTrue((String)"Source node is missing renditioned aspect.", (boolean)RenditionServiceIntegrationTest.this.nodeService.hasAspect(RenditionServiceIntegrationTest.this.nodeWithDocContent, RenditionModel.ASPECT_RENDITIONED));
                return null;
            }
        });
    }

    public void testRenderCropImage() throws Exception {
        this.setComplete();
        this.endTransaction();
        int originalImageWidth = 512;
        int originalImageHeight = 512;
        int imageNewXSize = 36;
        int imageNewYSize = 47;
        HashMap<String, Serializable> parameterValues = new HashMap<String, Serializable>();
        parameterValues.put("crop_width", Integer.valueOf(36));
        parameterValues.put("crop_height", Integer.valueOf(47));
        ImageTransformationOptions imageTransformationOptions = new ImageTransformationOptions();
        final NodeRef newRenditionNode = this.performImageRendition(parameterValues);
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                List children = RenditionServiceIntegrationTest.this.nodeService.getChildAssocs(RenditionServiceIntegrationTest.this.nodeWithImageContent, (QNamePattern)new RegexQNamePattern(RenditionServiceIntegrationTest.this.getLongNameWithEscapedBraces(RenditionModel.ASSOC_RENDITION)), (QNamePattern)new RegexQNamePattern(RenditionServiceIntegrationTest.this.getLongNameWithEscapedBraces(RESCALE_RENDER_DEFN_NAME)));
                Assert.assertEquals((String)"Unexpected number of children", (int)1, (int)children.size());
                NodeRef newImageRendition = ((ChildAssociationRef)children.get(0)).getChildRef();
                Assert.assertEquals((Object)newRenditionNode, (Object)newImageRendition);
                ContentReader reader = RenditionServiceIntegrationTest.this.contentService.getReader(newImageRendition, ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"Reader to rendered image was null", (Object)reader);
                BufferedImage img = ImageIO.read(reader.getContentInputStream());
                Assert.assertEquals((String)"Rendered image had wrong height", (int)47, (int)img.getHeight());
                Assert.assertEquals((String)"Rendered image had wrong width", (int)36, (int)img.getWidth());
                ContentReader srcReader = RenditionServiceIntegrationTest.this.contentService.getReader(RenditionServiceIntegrationTest.this.nodeWithImageContent, ContentModel.PROP_CONTENT);
                BufferedImage srcImg = ImageIO.read(srcReader.getContentInputStream());
                int rgbAtTopLeft = img.getRGB(1, 1);
                int expRgbAtTopLeft = img.getRGB(1, 1);
                Assert.assertEquals((String)"Incorrect image content.", (int)expRgbAtTopLeft, (int)rgbAtTopLeft);
                int rightIndex = img.getWidth() - 1;
                int bottomIndex = img.getHeight() - 1;
                int rgbAtBottomRight = img.getRGB(rightIndex, bottomIndex);
                int expRgbAtBottomRight = srcImg.getRGB(rightIndex, bottomIndex);
                Assert.assertEquals((String)"Incorrect image content.", (int)expRgbAtBottomRight, (int)rgbAtBottomRight);
                return null;
            }
        });
        parameterValues.clear();
        parameterValues.put("crop_width", Integer.valueOf(50));
        parameterValues.put("crop_height", Integer.valueOf(25));
        parameterValues.put("percent_crop", Boolean.valueOf(true));
        final NodeRef secondRenditionNode = this.performImageRendition(parameterValues);
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                List children = RenditionServiceIntegrationTest.this.nodeService.getChildAssocs(RenditionServiceIntegrationTest.this.nodeWithImageContent, (QNamePattern)new RegexQNamePattern(RenditionServiceIntegrationTest.this.getLongNameWithEscapedBraces(RenditionModel.ASSOC_RENDITION)), (QNamePattern)new RegexQNamePattern(RenditionServiceIntegrationTest.this.getLongNameWithEscapedBraces(RESCALE_RENDER_DEFN_NAME)));
                Assert.assertEquals((String)"Unexpected number of children", (int)1, (int)children.size());
                NodeRef newImageRendition = ((ChildAssociationRef)children.get(0)).getChildRef();
                Assert.assertEquals((Object)secondRenditionNode, (Object)newImageRendition);
                ContentReader srcReader = RenditionServiceIntegrationTest.this.contentService.getReader(RenditionServiceIntegrationTest.this.nodeWithImageContent, ContentModel.PROP_CONTENT);
                BufferedImage srcImg = ImageIO.read(srcReader.getContentInputStream());
                ContentReader reader = RenditionServiceIntegrationTest.this.contentService.getReader(newImageRendition, ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"Reader to rendered image was null", (Object)reader);
                BufferedImage img = ImageIO.read(reader.getContentInputStream());
                Assert.assertEquals((String)"Rendered image had wrong height", (int)128, (int)img.getHeight());
                Assert.assertEquals((String)"Rendered image had wrong width", (int)256, (int)img.getWidth());
                int rgbAtTopLeft = img.getRGB(1, 1);
                int expRgbAtTopLeft = srcImg.getRGB(1, 1);
                Assert.assertEquals((String)"Incorrect image content.", (int)expRgbAtTopLeft, (int)rgbAtTopLeft);
                int widthIndex = img.getWidth() - 1;
                int heightIndex = img.getHeight() - 1;
                int rgbAtBottomRight = img.getRGB(widthIndex, heightIndex);
                int expRgbAtBottomRight = srcImg.getRGB(widthIndex, heightIndex);
                Assert.assertEquals((String)"Incorrect image content.", (int)expRgbAtBottomRight, (int)rgbAtBottomRight);
                return null;
            }
        });
    }

    public void testRenderRescaledImage() throws Exception {
        this.setComplete();
        this.endTransaction();
        int originalImageWidth = 512;
        int originalImageHeight = 512;
        final Integer imageNewXSize = new Integer(36);
        final Integer imageNewYSize = new Integer(48);
        HashMap<String, Serializable> parameterValues = new HashMap<String, Serializable>();
        parameterValues.put("xsize", imageNewXSize);
        parameterValues.put("ysize", imageNewYSize);
        final NodeRef newRenditionNode = this.performImageRendition(parameterValues);
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                List children = RenditionServiceIntegrationTest.this.nodeService.getChildAssocs(RenditionServiceIntegrationTest.this.nodeWithImageContent, (QNamePattern)new RegexQNamePattern(RenditionServiceIntegrationTest.this.getLongNameWithEscapedBraces(RenditionModel.ASSOC_RENDITION)), (QNamePattern)new RegexQNamePattern(RenditionServiceIntegrationTest.this.getLongNameWithEscapedBraces(RESCALE_RENDER_DEFN_NAME)));
                Assert.assertEquals((String)"Unexpected number of children", (int)1, (int)children.size());
                NodeRef newImageRendition = ((ChildAssociationRef)children.get(0)).getChildRef();
                Assert.assertEquals((Object)newRenditionNode, (Object)newImageRendition);
                ContentReader reader = RenditionServiceIntegrationTest.this.contentService.getReader(newImageRendition, ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"Reader to rendered image was null", (Object)reader);
                BufferedImage img = ImageIO.read(reader.getContentInputStream());
                Assert.assertEquals((String)"Rendered image had wrong height", (Object)imageNewYSize, (Object)new Integer(img.getHeight()));
                Assert.assertEquals((String)"Rendered image had wrong width", (Object)imageNewXSize, (Object)new Integer(img.getWidth()));
                int rgbAtTopLeft = img.getRGB(1, 1);
                Assert.assertTrue((String)"Incorrect image content.", (boolean)Integer.toHexString(rgbAtTopLeft).endsWith("000000"));
                int rgbAtBottomRight = img.getRGB(img.getWidth() - 1, img.getHeight() - 1);
                Assert.assertTrue((String)"Incorrect image content.", (boolean)Integer.toHexString(rgbAtBottomRight).endsWith("ffffff"));
                return null;
            }
        });
        parameterValues.clear();
        parameterValues.put("xsize", Integer.valueOf(200));
        parameterValues.put("ysize", Integer.valueOf(200));
        parameterValues.put("isAbsolute", Boolean.valueOf(true));
        final NodeRef secondRenditionNode = this.performImageRendition(parameterValues);
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                List children = RenditionServiceIntegrationTest.this.nodeService.getChildAssocs(RenditionServiceIntegrationTest.this.nodeWithImageContent, (QNamePattern)new RegexQNamePattern(RenditionServiceIntegrationTest.this.getLongNameWithEscapedBraces(RenditionModel.ASSOC_RENDITION)), (QNamePattern)new RegexQNamePattern(RenditionServiceIntegrationTest.this.getLongNameWithEscapedBraces(RESCALE_RENDER_DEFN_NAME)));
                Assert.assertEquals((String)"Unexpected number of children", (int)1, (int)children.size());
                NodeRef newImageRendition = ((ChildAssociationRef)children.get(0)).getChildRef();
                Assert.assertEquals((Object)secondRenditionNode, (Object)newImageRendition);
                ContentReader reader = RenditionServiceIntegrationTest.this.contentService.getReader(newImageRendition, ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"Reader to rendered image was null", (Object)reader);
                BufferedImage img = ImageIO.read(reader.getContentInputStream());
                Assert.assertEquals((String)"Rendered image had wrong height", (int)1024, (int)img.getHeight());
                Assert.assertEquals((String)"Rendered image had wrong width", (int)1024, (int)img.getWidth());
                int rgbAtTopLeft = img.getRGB(1, 1);
                Assert.assertTrue((String)"Incorrect image content.", (boolean)Integer.toHexString(rgbAtTopLeft).endsWith("000000"));
                int rgbAtBottomRight = img.getRGB(img.getWidth() - 1, img.getHeight() - 1);
                Assert.assertTrue((String)"Incorrect image content.", (boolean)Integer.toHexString(rgbAtBottomRight).endsWith("ffffff"));
                return null;
            }
        });
    }

    public void testReformatImage() throws Exception {
        this.setComplete();
        this.endTransaction();
        this.renditionNode = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                Assert.assertFalse((String)"Source node has unexpected renditioned aspect.", (boolean)RenditionServiceIntegrationTest.this.nodeService.hasAspect(RenditionServiceIntegrationTest.this.nodeWithImageContent, RenditionModel.ASPECT_RENDITIONED));
                RenditionDefinition action = RenditionServiceIntegrationTest.this.makeReformatAction(null, "text/plain");
                action.setParameterValue("mime-type", (Serializable)((Object)"image/jpeg"));
                ChildAssociationRef renditionAssoc = RenditionServiceIntegrationTest.this.renditionService.render(RenditionServiceIntegrationTest.this.nodeWithImageContent, action);
                return renditionAssoc.getChildRef();
            }
        });
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentReader reader = RenditionServiceIntegrationTest.this.contentService.getReader(RenditionServiceIntegrationTest.this.renditionNode, ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"Reader to rendered image was null", (Object)reader);
                Assert.assertEquals((String)"image/jpeg", (String)reader.getMimetype());
                BufferedImage img = ImageIO.read(reader.getContentInputStream());
                Assert.assertEquals((String)"Rendered image had wrong height", (int)512, (int)img.getHeight());
                Assert.assertEquals((String)"Rendered image had wrong width", (int)512, (int)img.getWidth());
                int rgbAtTopLeft = img.getRGB(1, 1);
                Assert.assertTrue((String)"Incorrect image content.", (boolean)Integer.toHexString(rgbAtTopLeft).endsWith("000000"));
                int rgbAtBottomRight = img.getRGB(img.getWidth() - 1, img.getHeight() - 1);
                Assert.assertTrue((String)"Incorrect image content.", (boolean)Integer.toHexString(rgbAtBottomRight).endsWith("ffffff"));
                return null;
            }
        });
    }

    public void testSuccessfulAsynchronousRendition() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AsyncResultsHolder results = new AsyncResultsHolder();
        RenderCallback callback = new RenderCallback(){

            public void handleFailedRendition(Throwable t) {
                results.setMessage("Rendition failed unexpectedly.");
                latch.countDown();
            }

            public void handleSuccessfulRendition(ChildAssociationRef primaryParentOfNewRendition) {
                results.setAssoc(primaryParentOfNewRendition);
                latch.countDown();
            }
        };
        this.performAsyncRendition(this.nodeWithImageContent, callback, latch, results);
        RenditionServiceIntegrationTest.assertNotNull((String)"ChildAssociationRef was null.", (Object)results.getAssoc());
        RenditionServiceIntegrationTest.assertEquals((Object)this.nodeWithImageContent, (Object)results.getAssoc().getParentRef());
        RenditionServiceIntegrationTest.assertNull((Object)results.getThrowable());
    }

    public void testFailedAsynchronousRendition() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AsyncResultsHolder results = new AsyncResultsHolder();
        RenderCallback callback = new RenderCallback(){

            public void handleFailedRendition(Throwable t) {
                results.setThrowable(t);
                latch.countDown();
            }

            public void handleSuccessfulRendition(ChildAssociationRef primaryParentOfNewRendition) {
                results.setMessage("Rendition succeeded unexpectedly.");
                latch.countDown();
            }
        };
        this.performAsyncRendition(this.testTargetFolder, callback, latch, results);
        RenditionServiceIntegrationTest.assertNull((Object)results.getAssoc());
        RenditionServiceIntegrationTest.assertEquals((String)"Expected a RenditionServiceException", RenditionServiceException.class, results.getThrowable().getClass());
    }

    private void performAsyncRendition(final NodeRef nodeToRender, final RenderCallback callback, CountDownLatch latch, AsyncResultsHolder failureMessage) throws InterruptedException {
        this.setComplete();
        this.endTransaction();
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                RenditionDefinition action = RenditionServiceIntegrationTest.this.makeReformatAction(null, "text/plain");
                action.setParameterValue("mime-type", (Serializable)((Object)"image/jpeg"));
                RenditionServiceIntegrationTest.this.renditionService.render(nodeToRender, action, callback);
                return null;
            }
        });
        boolean endedNormally = latch.await(30L, TimeUnit.SECONDS);
        String failedString = failureMessage.getValue();
        if (failedString != null) {
            RenditionServiceIntegrationTest.fail((String)failedString);
        }
        if (!endedNormally) {
            RenditionServiceIntegrationTest.fail((String)"ActionService thread took too long to perform rendering.");
        }
    }

    public void testGetRenditionsForNode() throws Exception {
        this.setComplete();
        this.endTransaction();
        this.renditionNode = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                Assert.assertTrue((String)"Test node should have no renditions initially", (boolean)RenditionServiceIntegrationTest.this.renditionService.getRenditions(RenditionServiceIntegrationTest.this.nodeWithImageContent).isEmpty());
                QName rendName1 = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("definition1" + System.currentTimeMillis()));
                RenditionDefinition action1 = RenditionServiceIntegrationTest.this.renditionService.createRenditionDefinition(rendName1, "reformat");
                action1.setParameterValue("mime-type", (Serializable)((Object)"image/gif"));
                QName rendName2 = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("definition2" + System.currentTimeMillis()));
                RenditionDefinition action2 = RenditionServiceIntegrationTest.this.renditionService.createRenditionDefinition(rendName2, "reformat");
                action2.setParameterValue("mime-type", (Serializable)((Object)"image/jpeg"));
                QName rendName3 = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("definition3" + System.currentTimeMillis()));
                RenditionDefinition action3 = RenditionServiceIntegrationTest.this.renditionService.createRenditionDefinition(rendName3, "imageRenderingEngine");
                action3.setParameterValue("xsize", Integer.valueOf(64));
                action3.setParameterValue("ysize", Integer.valueOf(64));
                action3.setParameterValue("mime-type", (Serializable)((Object)"image/png"));
                QName rendName4 = rendName3;
                RenditionDefinition action4 = RenditionServiceIntegrationTest.this.renditionService.createRenditionDefinition(rendName4, "imageRenderingEngine");
                action4.setParameterValue("xsize", Integer.valueOf(128));
                action4.setParameterValue("ysize", Integer.valueOf(128));
                action4.setParameterValue("mime-type", (Serializable)((Object)"image/png"));
                ChildAssociationRef createdRendition1 = RenditionServiceIntegrationTest.this.renditionService.render(RenditionServiceIntegrationTest.this.nodeWithImageContent, action1);
                ChildAssociationRef createdRendition2 = RenditionServiceIntegrationTest.this.renditionService.render(RenditionServiceIntegrationTest.this.nodeWithImageContent, action2);
                ChildAssociationRef createdRendition3 = RenditionServiceIntegrationTest.this.renditionService.render(RenditionServiceIntegrationTest.this.nodeWithImageContent, action3);
                ChildAssociationRef createdRendition4 = RenditionServiceIntegrationTest.this.renditionService.render(RenditionServiceIntegrationTest.this.nodeWithImageContent, action4);
                List<ChildAssociationRef> allRenditions = RenditionServiceIntegrationTest.this.renditionService.getRenditions(RenditionServiceIntegrationTest.this.nodeWithImageContent);
                ChildAssociationRef retrievedRendition1 = RenditionServiceIntegrationTest.this.renditionService.getRenditionByName(RenditionServiceIntegrationTest.this.nodeWithImageContent, rendName1);
                ChildAssociationRef retrievedRendition2 = RenditionServiceIntegrationTest.this.renditionService.getRenditionByName(RenditionServiceIntegrationTest.this.nodeWithImageContent, rendName2);
                ChildAssociationRef retrievedRendition3 = RenditionServiceIntegrationTest.this.renditionService.getRenditionByName(RenditionServiceIntegrationTest.this.nodeWithImageContent, rendName3);
                ChildAssociationRef retrievedRendition4 = RenditionServiceIntegrationTest.this.renditionService.getRenditionByName(RenditionServiceIntegrationTest.this.nodeWithImageContent, rendName4);
                Assert.assertEquals((int)3, (int)allRenditions.size());
                Assert.assertTrue((boolean)allRenditions.contains(createdRendition1));
                Assert.assertTrue((boolean)allRenditions.contains(createdRendition2));
                Assert.assertTrue((boolean)allRenditions.contains(createdRendition4));
                for (ChildAssociationRef rendition : allRenditions) {
                    Assert.assertNotSame((Object)createdRendition3, (Object)rendition);
                }
                Assert.assertEquals((Object)createdRendition1, (Object)retrievedRendition1);
                Assert.assertEquals((Object)createdRendition2, (Object)retrievedRendition2);
                Assert.assertEquals((Object)createdRendition4, (Object)retrievedRendition3);
                Assert.assertEquals((Object)createdRendition4, (Object)retrievedRendition4);
                List<ChildAssociationRef> imageRenditions = RenditionServiceIntegrationTest.this.renditionService.getRenditions(RenditionServiceIntegrationTest.this.nodeWithImageContent, "image");
                Assert.assertEquals((int)3, (int)imageRenditions.size());
                List<ChildAssociationRef> imageSlashJRenditions = RenditionServiceIntegrationTest.this.renditionService.getRenditions(RenditionServiceIntegrationTest.this.nodeWithImageContent, "image/j");
                Assert.assertEquals((int)1, (int)imageSlashJRenditions.size());
                return null;
            }
        });
    }

    private NodeRef performImageRendition(final Map<String, Serializable> parameterValues) {
        NodeRef newRenditionNode = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                RenditionServiceIntegrationTest.this.validateRenderingActionDefinition("imageRenderingEngine");
                RenditionDefinition action = RenditionServiceIntegrationTest.this.renditionService.createRenditionDefinition(RESCALE_RENDER_DEFN_NAME, "imageRenderingEngine");
                for (String s : parameterValues.keySet()) {
                    action.setParameterValue(s, (Serializable)parameterValues.get(s));
                }
                ChildAssociationRef renditionAssoc = RenditionServiceIntegrationTest.this.renditionService.render(RenditionServiceIntegrationTest.this.nodeWithImageContent, action);
                RenditionServiceIntegrationTest.this.validateRenditionAssociation(renditionAssoc, RESCALE_RENDER_DEFN_NAME);
                return renditionAssoc.getChildRef();
            }
        });
        return newRenditionNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveRenderingAction() throws Exception {
        this.setComplete();
        this.endTransaction();
        final ArrayList<RenditionDefinition> savedRenditionsToDelete = new ArrayList<RenditionDefinition>();
        try {
            this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    Assert.assertTrue((String)"The rendering action space has not been created in the repository!", (boolean)RenditionServiceIntegrationTest.this.nodeService.exists(RenditionDefinitionPersisterImpl.RENDERING_ACTION_ROOT_NODE_REF));
                    List childAssocs = RenditionServiceIntegrationTest.this.nodeService.getChildAssocs(RenditionDefinitionPersisterImpl.RENDERING_ACTION_ROOT_NODE_REF, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)REFORMAT_RENDER_DEFN_NAME);
                    Assert.assertTrue((String)("There should be no persisted rendering actions of name: " + REFORMAT_RENDER_DEFN_NAME + " at the start of this test!"), (boolean)childAssocs.isEmpty());
                    RenditionDefinition action = RenditionServiceIntegrationTest.this.makeReformatAction(null, "text/plain");
                    savedRenditionsToDelete.add(action);
                    RenditionServiceIntegrationTest.this.renditionService.saveRenditionDefinition(action);
                    List results = RenditionServiceIntegrationTest.this.nodeService.getChildAssocs(RenditionDefinitionPersisterImpl.RENDERING_ACTION_ROOT_NODE_REF, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)REFORMAT_RENDER_DEFN_NAME);
                    Assert.assertEquals((String)("There should be one persisted rendering action of name: " + REFORMAT_RENDER_DEFN_NAME), (int)1, (int)results.size());
                    return null;
                }
            });
            this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    List childAssocs = RenditionServiceIntegrationTest.this.nodeService.getChildAssocs(RenditionDefinitionPersisterImpl.RENDERING_ACTION_ROOT_NODE_REF, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)REFORMAT_RENDER_DEFN_NAME);
                    Assert.assertEquals((String)("There should be one persisted rendering action of name: " + REFORMAT_RENDER_DEFN_NAME), (int)1, (int)childAssocs.size());
                    NodeRef actionNode = ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
                    RenditionDefinition action = RenditionServiceIntegrationTest.this.makeReformatAction(null, "text/plain");
                    savedRenditionsToDelete.add(action);
                    RenditionServiceIntegrationTest.this.renditionService.saveRenditionDefinition(action);
                    List results = RenditionServiceIntegrationTest.this.nodeService.getChildAssocs(RenditionDefinitionPersisterImpl.RENDERING_ACTION_ROOT_NODE_REF, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)REFORMAT_RENDER_DEFN_NAME);
                    Assert.assertEquals((String)("There should be one persisted rendering action of name: " + REFORMAT_RENDER_DEFN_NAME), (int)1, (int)results.size());
                    Assert.assertEquals((String)"The node in which the action is stored should be the same.", (Object)actionNode, (Object)((ChildAssociationRef)results.get(0)).getChildRef());
                    return null;
                }
            });
            Object var3_2 = null;
            this.cleanUpPersistedActions(savedRenditionsToDelete);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cleanUpPersistedActions(savedRenditionsToDelete);
            throw throwable;
        }
    }

    public void off_test_CleanPersistedRenditionsAndCreateExportedACP() throws Exception {
        this.setComplete();
        this.endTransaction();
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Assert.assertTrue((String)"The rendering action space has not been created in the repository!", (boolean)RenditionServiceIntegrationTest.this.nodeService.exists(RenditionDefinitionPersisterImpl.RENDERING_ACTION_ROOT_NODE_REF));
                for (ChildAssociationRef chRef : RenditionServiceIntegrationTest.this.nodeService.getChildAssocs(RenditionDefinitionPersisterImpl.RENDERING_ACTION_ROOT_NODE_REF)) {
                    System.out.println("Deleting rendition Definition " + RenditionServiceIntegrationTest.this.nodeService.getProperty(chRef.getChildRef(), ContentModel.PROP_NAME));
                    RenditionServiceIntegrationTest.this.nodeService.deleteNode(chRef.getChildRef());
                }
                HashMap<String, Serializable> parameterValues = new HashMap<String, Serializable>();
                parameterValues.put("mime-type", (Serializable)((Object)"image/jpeg"));
                parameterValues.put("xsize", Integer.valueOf(100));
                parameterValues.put("ysize", Integer.valueOf(100));
                parameterValues.put("maintainAspectRatio", Boolean.valueOf(true));
                parameterValues.put("resizeToThumbnail", Boolean.valueOf(true));
                parameterValues.put("placeHolderResourcePath", (Serializable)((Object)"alfresco/thumbnail/thumbnail_placeholder_medium.jpg"));
                parameterValues.put("runAs", (Serializable)((Object)AuthenticationUtil.getSystemUserName()));
                RenditionDefinition action = this.createAction("imageRenderingEngine", "medium", parameterValues);
                RenditionServiceIntegrationTest.this.renditionService.saveRenditionDefinition(action);
                parameterValues.clear();
                parameterValues.put("mime-type", (Serializable)((Object)"image/png"));
                parameterValues.put("xsize", Integer.valueOf(100));
                parameterValues.put("ysize", Integer.valueOf(100));
                parameterValues.put("maintainAspectRatio", Boolean.valueOf(true));
                parameterValues.put("resizeToThumbnail", Boolean.valueOf(true));
                parameterValues.put("placeHolderResourcePath", (Serializable)((Object)"alfresco/thumbnail/thumbnail_placeholder_doclib.png"));
                parameterValues.put("runAs", (Serializable)((Object)AuthenticationUtil.getSystemUserName()));
                action = this.createAction("imageRenderingEngine", "doclib", parameterValues);
                RenditionServiceIntegrationTest.this.renditionService.saveRenditionDefinition(action);
                parameterValues.clear();
                parameterValues.put("mime-type", (Serializable)((Object)"application/x-shockwave-flash"));
                parameterValues.put("flashVersion", (Serializable)((Object)"9"));
                parameterValues.put("runAs", (Serializable)((Object)AuthenticationUtil.getSystemUserName()));
                action = this.createAction("reformat", "webpreview", parameterValues);
                RenditionServiceIntegrationTest.this.renditionService.saveRenditionDefinition(action);
                parameterValues.clear();
                parameterValues.put("mime-type", (Serializable)((Object)"image/png"));
                parameterValues.put("xsize", Integer.valueOf(480));
                parameterValues.put("ysize", Integer.valueOf(480));
                parameterValues.put("maintainAspectRatio", Boolean.valueOf(true));
                parameterValues.put("resizeToThumbnail", Boolean.valueOf(true));
                parameterValues.put("placeHolderResourcePath", (Serializable)((Object)"alfresco/thumbnail/thumbnail_placeholder_imgpreview.png"));
                parameterValues.put("runAs", (Serializable)((Object)AuthenticationUtil.getSystemUserName()));
                action = this.createAction("imageRenderingEngine", "imgpreview", parameterValues);
                RenditionServiceIntegrationTest.this.renditionService.saveRenditionDefinition(action);
                parameterValues.clear();
                parameterValues.put("mime-type", (Serializable)((Object)"image/png"));
                parameterValues.put("xsize", Integer.valueOf(64));
                parameterValues.put("ysize", Integer.valueOf(64));
                parameterValues.put("maintainAspectRatio", Boolean.valueOf(true));
                parameterValues.put("resizeToThumbnail", Boolean.valueOf(true));
                parameterValues.put("placeHolderResourcePath", (Serializable)((Object)"alfresco/thumbnail/thumbnail_placeholder_avatar.png"));
                parameterValues.put("runAs", (Serializable)((Object)AuthenticationUtil.getSystemUserName()));
                action = this.createAction("imageRenderingEngine", "avatar", parameterValues);
                RenditionServiceIntegrationTest.this.renditionService.saveRenditionDefinition(action);
                return null;
            }

            private RenditionDefinition createAction(String renderingEngineName, String renditionLocalName, Map<String, Serializable> parameterValues) {
                QName renditionName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)renditionLocalName);
                RenditionDefinition action = RenditionServiceIntegrationTest.this.renditionService.createRenditionDefinition(renditionName, renderingEngineName);
                for (String paramKey : parameterValues.keySet()) {
                    action.setParameterValue(paramKey, parameterValues.get(paramKey));
                }
                return action;
            }
        });
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Action exportAction = RenditionServiceIntegrationTest.this.actionService.createAction("export");
                exportAction.setParameterValue("store", (Serializable)((Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.toString()));
                exportAction.setParameterValue("package-name", (Serializable)((Object)"systemRenditionDefinitions"));
                exportAction.setParameterValue("encoding", (Serializable)((Object)"UTF-8"));
                exportAction.setParameterValue("destination", (Serializable)RenditionDefinitionPersisterImpl.RENDERING_ACTION_ROOT_NODE_REF);
                exportAction.setParameterValue("include-self", Boolean.valueOf(true));
                exportAction.setParameterValue("include-children", Boolean.valueOf(true));
                RenditionServiceIntegrationTest.this.actionService.executeAction(exportAction, RenditionDefinitionPersisterImpl.RENDERING_ACTION_ROOT_NODE_REF);
                return null;
            }
        });
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                List children = RenditionServiceIntegrationTest.this.nodeService.getChildAssocs(RenditionDefinitionPersisterImpl.RENDERING_ACTION_ROOT_NODE_REF);
                for (ChildAssociationRef car : children) {
                    System.err.println(car.getChildRef() + "  " + RenditionServiceIntegrationTest.this.nodeService.getProperty(car.getChildRef(), ContentModel.PROP_NAME));
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadRenderingAction() throws Exception {
        this.setComplete();
        this.endTransaction();
        final RenditionDefinition reformatAction = this.makeReformatAction(null, "text/plain");
        final RenditionDefinition rescaleAction = this.makeRescaleImageAction();
        final ArrayList<RenditionDefinition> savedRenditionDefinitions = new ArrayList<RenditionDefinition>();
        try {
            this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    savedRenditionDefinitions.add(reformatAction);
                    RenditionServiceIntegrationTest.this.renditionService.saveRenditionDefinition(reformatAction);
                    return null;
                }
            });
            this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    QName renditionName = reformatAction.getRenditionName();
                    RenditionDefinition result = RenditionServiceIntegrationTest.this.renditionService.loadRenditionDefinition(renditionName);
                    Assert.assertEquals((Object)renditionName, (Object)result.getRenditionName());
                    Assert.assertEquals((String)reformatAction.getActionDefinitionName(), (String)result.getActionDefinitionName());
                    Assert.assertEquals((Object)reformatAction.getCompensatingAction(), (Object)result.getCompensatingAction());
                    Assert.assertEquals((String)reformatAction.getDescription(), (String)result.getDescription());
                    Assert.assertEquals((boolean)reformatAction.getExecuteAsychronously(), (boolean)result.getExecuteAsychronously());
                    Assert.assertEquals((Object)reformatAction.getModifiedDate(), (Object)result.getModifiedDate());
                    Assert.assertEquals((String)reformatAction.getModifier(), (String)result.getModifier());
                    Assert.assertEquals((String)reformatAction.getTitle(), (String)result.getTitle());
                    return null;
                }
            });
            this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    savedRenditionDefinitions.add(rescaleAction);
                    RenditionServiceIntegrationTest.this.renditionService.saveRenditionDefinition(rescaleAction);
                    return null;
                }
            });
            this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    RenditionDefinition firstLoadedAction = RenditionServiceIntegrationTest.this.renditionService.loadRenditionDefinition(reformatAction.getRenditionName());
                    RenditionDefinition secondLoadedAction = RenditionServiceIntegrationTest.this.renditionService.loadRenditionDefinition(rescaleAction.getRenditionName());
                    Assert.assertNotNull((String)"The reformat action was null.", (Object)firstLoadedAction);
                    Assert.assertNotNull((String)"The rescale action was null.", (Object)secondLoadedAction);
                    Assert.assertEquals((Object)reformatAction.getRenditionName(), (Object)firstLoadedAction.getRenditionName());
                    Assert.assertEquals((Object)rescaleAction.getRenditionName(), (Object)secondLoadedAction.getRenditionName());
                    return null;
                }
            });
            Object var5_4 = null;
            this.cleanUpPersistedActions(savedRenditionDefinitions);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanUpPersistedActions(savedRenditionDefinitions);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveAndLoadCompositeRenditionDefinition() throws Exception {
        this.setComplete();
        this.endTransaction();
        final QName renditionName = QName.createQName((String)"http://www.alfresco.org/model/rendition/1.0", (String)"composite");
        final CompositeRenditionDefinition compositeDefinition = this.makeCompositeReformatAndResizeDefinition(renditionName, 20, 30);
        final ArrayList<RenditionDefinition> savedRenditionDefinitions = new ArrayList<RenditionDefinition>();
        try {
            this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    RenditionServiceIntegrationTest.this.renditionService.saveRenditionDefinition(compositeDefinition);
                    return null;
                }
            });
            this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    RenditionDefinition result = RenditionServiceIntegrationTest.this.renditionService.loadRenditionDefinition(renditionName);
                    Assert.assertEquals((Object)renditionName, (Object)result.getRenditionName());
                    Assert.assertEquals((String)compositeDefinition.getActionDefinitionName(), (String)result.getActionDefinitionName());
                    Assert.assertEquals((Object)compositeDefinition.getCompensatingAction(), (Object)result.getCompensatingAction());
                    Assert.assertEquals((String)compositeDefinition.getDescription(), (String)result.getDescription());
                    Assert.assertEquals((boolean)compositeDefinition.getExecuteAsychronously(), (boolean)result.getExecuteAsychronously());
                    Assert.assertEquals((Object)compositeDefinition.getModifiedDate(), (Object)result.getModifiedDate());
                    Assert.assertEquals((String)compositeDefinition.getModifier(), (String)result.getModifier());
                    Assert.assertEquals((String)compositeDefinition.getTitle(), (String)result.getTitle());
                    if (result instanceof CompositeRenditionDefinition) {
                        CompositeRenditionDefinition compositeResult = (CompositeRenditionDefinition)result;
                        savedRenditionDefinitions.add(compositeResult);
                        List subDefinitions = compositeResult.getActions();
                        Assert.assertEquals((int)2, (int)subDefinitions.size());
                        RenditionDefinition firstDef = (RenditionDefinition)subDefinitions.get(0);
                        Assert.assertEquals((String)"reformat", (String)firstDef.getActionDefinitionName());
                        RenditionDefinition secondDef = (RenditionDefinition)subDefinitions.get(1);
                        Assert.assertEquals((String)"imageRenderingEngine", (String)secondDef.getActionDefinitionName());
                    } else {
                        Assert.fail((String)"The retrieved rendition should be a CompositeRenditionDefinition.");
                    }
                    return null;
                }
            });
            Object var5_4 = null;
            this.cleanUpPersistedActions(savedRenditionDefinitions);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanUpPersistedActions(savedRenditionDefinitions);
            throw throwable;
        }
    }

    private void cleanUpPersistedActions(final List<RenditionDefinition> savedRenditionDefinitions) {
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                for (RenditionDefinition savedRenditionDefinition : savedRenditionDefinitions) {
                    NodeRef actionNodeRef = savedRenditionDefinition.getNodeRef();
                    if (actionNodeRef == null) continue;
                    RenditionServiceIntegrationTest.this.nodeService.deleteNode(actionNodeRef);
                }
                return null;
            }
        });
    }

    public void testBuiltinRenditionDefinitions() throws Exception {
        RenditionDefinition mediumRenditionDef = this.loadAndValidateRenditionDefinition("medium");
        RenditionDefinition doclibRenditionDef = this.loadAndValidateRenditionDefinition("doclib");
        RenditionDefinition imgpreviewRenditionDef = this.loadAndValidateRenditionDefinition("imgpreview");
        RenditionDefinition webpreviewRenditionDef = this.loadAndValidateRenditionDefinition("webpreview");
        RenditionDefinition avatarRenditionDef = this.loadAndValidateRenditionDefinition("avatar");
        RenditionServiceIntegrationTest.assertEquals((Object)"image/jpeg", (Object)mediumRenditionDef.getParameterValue("mime-type"));
        RenditionServiceIntegrationTest.assertEquals((Object)"image/png", (Object)doclibRenditionDef.getParameterValue("mime-type"));
        RenditionServiceIntegrationTest.assertEquals((Object)"image/png", (Object)imgpreviewRenditionDef.getParameterValue("mime-type"));
        RenditionServiceIntegrationTest.assertEquals((Object)"application/x-shockwave-flash", (Object)webpreviewRenditionDef.getParameterValue("mime-type"));
        RenditionServiceIntegrationTest.assertEquals((Object)"image/png", (Object)avatarRenditionDef.getParameterValue("mime-type"));
    }

    public void testALF3733() throws Exception {
        QName renditionDefName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"myDummyRendition");
        String renderingEngineName = "imageRenderingEngine";
        RenditionDefinition renditionDef = this.renditionService.createRenditionDefinition(renditionDefName, renderingEngineName);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("xsize", Integer.valueOf(99));
        params.put("ysize", Integer.valueOf(99));
        params.put("destination-path-template", (Serializable)((Object)"${cwd}/resized/${name}_Thumb.${extension}"));
        renditionDef.addParameterValues(params);
        ChildAssociationRef rendition = this.renditionService.render(this.nodeWithImageContent, renditionDef);
        RenditionServiceIntegrationTest.assertNotNull((String)"rendition was null.", (Object)rendition);
        RenditionServiceIntegrationTest.assertTrue((boolean)this.nodeService.hasAspect(rendition.getChildRef(), RenditionModel.ASPECT_VISIBLE_RENDITION));
        List allParents = this.nodeService.getParentAssocs(rendition.getChildRef());
        RenditionServiceIntegrationTest.assertEquals((int)2, (int)allParents.size());
        NodeRef primaryParent = this.nodeService.getPrimaryParent(rendition.getChildRef()).getParentRef();
        RenditionServiceIntegrationTest.assertEquals((Object)"resized", (Object)this.nodeService.getProperty(primaryParent, ContentModel.PROP_NAME));
        RenditionServiceIntegrationTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(primaryParent));
        NodeRef nonPrimaryParent = null;
        for (ChildAssociationRef chAss : allParents) {
            if (chAss.getParentRef().equals((Object)primaryParent)) continue;
            nonPrimaryParent = chAss.getParentRef();
        }
        RenditionServiceIntegrationTest.assertNotNull((String)"Non-primary parent was not found.", nonPrimaryParent);
        RenditionServiceIntegrationTest.assertEquals((Object)this.nodeWithImageContent, nonPrimaryParent);
    }

    public void testPathBasedRenditionOverwrite() throws Exception {
    }

    public void testRenditionPlacements() throws Exception {
        QName plainQName = QName.createQName((String)"Plain");
        RenditionDefinition rdPlain = this.renditionService.createRenditionDefinition(plainQName, "helloWorldRenderingEngine");
        QName compositeQName = QName.createQName((String)"Composite");
        CompositeRenditionDefinition rdComposite = this.renditionService.createCompositeRenditionDefinition(compositeQName);
        rdComposite.addAction(this.renditionService.createRenditionDefinition(QName.createQName((String)"CompositePart1"), "helloWorldRenderingEngine"));
        rdComposite.addAction(this.renditionService.createRenditionDefinition(QName.createQName((String)"CompositePart2"), "helloWorldRenderingEngine"));
        RenditionServiceIntegrationTest.assertNotNull((Object)this.nodeWithDocContent);
        RenditionServiceIntegrationTest.assertEquals((int)0, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(this.nodeWithDocContent).size());
        this.renditionService.render(this.nodeWithDocContent, rdPlain);
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((Object)plainQName, (Object)((ChildAssociationRef)this.nodeService.getChildAssocs(this.nodeWithDocContent).get(0)).getQName());
        this.nodeService.deleteNode(this.renditionService.getRenditions(this.nodeWithDocContent).get(0).getChildRef());
        RenditionServiceIntegrationTest.assertNotNull((Object)this.nodeWithDocContent);
        RenditionServiceIntegrationTest.assertEquals((int)0, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(this.nodeWithDocContent).size());
        this.renditionService.render(this.nodeWithDocContent, rdComposite);
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((Object)compositeQName, (Object)((ChildAssociationRef)this.nodeService.getChildAssocs(this.nodeWithDocContent).get(0)).getQName());
        this.nodeService.deleteNode(this.renditionService.getRenditions(this.nodeWithDocContent).get(0).getChildRef());
        this.renditionService.render(this.nodeWithDocContent, rdPlain);
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.nodeWithDocContent).size());
        NodeRef renditionNode = ((ChildAssociationRef)this.nodeService.getChildAssocs(this.nodeWithDocContent).get(0)).getChildRef();
        this.renditionService.render(this.nodeWithDocContent, rdPlain);
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((Object)renditionNode, (Object)((ChildAssociationRef)this.nodeService.getChildAssocs(this.nodeWithDocContent).get(0)).getChildRef());
        RenditionServiceIntegrationTest.assertEquals((Object)plainQName, (Object)((ChildAssociationRef)this.nodeService.getChildAssocs(this.nodeWithDocContent).get(0)).getQName());
        this.nodeService.deleteNode(this.renditionService.getRenditions(this.nodeWithDocContent).get(0).getChildRef());
        this.renditionService.render(this.nodeWithDocContent, rdComposite);
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.nodeWithDocContent).size());
        renditionNode = ((ChildAssociationRef)this.nodeService.getChildAssocs(this.nodeWithDocContent).get(0)).getChildRef();
        this.renditionService.render(this.nodeWithDocContent, rdComposite);
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((Object)renditionNode, (Object)((ChildAssociationRef)this.nodeService.getChildAssocs(this.nodeWithDocContent).get(0)).getChildRef());
        RenditionServiceIntegrationTest.assertEquals((Object)compositeQName, (Object)((ChildAssociationRef)this.nodeService.getChildAssocs(this.nodeWithDocContent).get(0)).getQName());
        this.nodeService.deleteNode(this.renditionService.getRenditions(this.nodeWithDocContent).get(0).getChildRef());
        String path = "/" + (String)((Object)this.nodeService.getProperty(this.repositoryHelper.getCompanyHome(), ContentModel.PROP_NAME)) + "/" + (String)((Object)this.nodeService.getProperty(this.testTargetFolder, ContentModel.PROP_NAME)) + "/" + "HelloWorld.txt";
        rdPlain.setParameterValue("destination-path-template", (Serializable)((Object)path));
        rdComposite.setParameterValue("destination-path-template", (Serializable)((Object)path));
        RenditionServiceIntegrationTest.assertNotNull((Object)this.nodeWithDocContent);
        RenditionServiceIntegrationTest.assertEquals((int)0, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(this.testTargetFolder).size());
        this.renditionService.render(this.nodeWithDocContent, rdPlain);
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertTrue((!((ChildAssociationRef)this.nodeService.getChildAssocs(this.nodeWithDocContent).get(0)).isPrimary() ? 1 : 0) != 0);
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.testTargetFolder).size());
        RenditionServiceIntegrationTest.assertEquals((Object)plainQName, (Object)((ChildAssociationRef)this.nodeService.getChildAssocs(this.testTargetFolder).get(0)).getQName());
        this.nodeService.deleteNode(this.renditionService.getRenditions(this.nodeWithDocContent).get(0).getChildRef());
        RenditionServiceIntegrationTest.assertNotNull((Object)this.nodeWithDocContent);
        RenditionServiceIntegrationTest.assertEquals((int)0, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(this.testTargetFolder).size());
        this.renditionService.render(this.nodeWithDocContent, rdComposite);
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.testTargetFolder).size());
        RenditionServiceIntegrationTest.assertEquals((Object)compositeQName, (Object)((ChildAssociationRef)this.nodeService.getChildAssocs(this.testTargetFolder).get(0)).getQName());
        this.nodeService.deleteNode(this.renditionService.getRenditions(this.nodeWithDocContent).get(0).getChildRef());
        this.renditionService.render(this.nodeWithDocContent, rdPlain);
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.testTargetFolder).size());
        renditionNode = ((ChildAssociationRef)this.nodeService.getChildAssocs(this.testTargetFolder).get(0)).getChildRef();
        this.renditionService.render(this.nodeWithDocContent, rdPlain);
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.testTargetFolder).size());
        RenditionServiceIntegrationTest.assertEquals((Object)renditionNode, (Object)((ChildAssociationRef)this.nodeService.getChildAssocs(this.testTargetFolder).get(0)).getChildRef());
        RenditionServiceIntegrationTest.assertEquals((Object)plainQName, (Object)((ChildAssociationRef)this.nodeService.getChildAssocs(this.testTargetFolder).get(0)).getQName());
        this.nodeService.deleteNode(this.renditionService.getRenditions(this.nodeWithDocContent).get(0).getChildRef());
        this.renditionService.render(this.nodeWithDocContent, rdComposite);
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.testTargetFolder).size());
        renditionNode = ((ChildAssociationRef)this.nodeService.getChildAssocs(this.testTargetFolder).get(0)).getChildRef();
        this.renditionService.render(this.nodeWithDocContent, rdComposite);
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.renditionService.getRenditions(this.nodeWithDocContent).size());
        RenditionServiceIntegrationTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.testTargetFolder).size());
        RenditionServiceIntegrationTest.assertEquals((Object)renditionNode, (Object)((ChildAssociationRef)this.nodeService.getChildAssocs(this.testTargetFolder).get(0)).getChildRef());
        RenditionServiceIntegrationTest.assertEquals((Object)compositeQName, (Object)((ChildAssociationRef)this.nodeService.getChildAssocs(this.testTargetFolder).get(0)).getQName());
        RenditionServiceIntegrationTest.assertEquals((Object)compositeQName, (Object)((ChildAssociationRef)this.nodeService.getChildAssocs(this.testTargetFolder).get(0)).getQName());
        renditionNode = ((ChildAssociationRef)this.nodeService.getChildAssocs(this.testTargetFolder).get(0)).getChildRef();
        boolean exceptionThrown = false;
        try {
            this.renditionService.render(this.nodeWithDocContent, rdPlain);
        }
        catch (RenditionServiceException expected) {
            exceptionThrown = true;
        }
        RenditionServiceIntegrationTest.assertTrue((String)"Expected RenditionServiceException not thrown", (boolean)exceptionThrown);
    }

    private RenditionDefinition loadAndValidateRenditionDefinition(String renditionLocalName) {
        QName renditionQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)renditionLocalName);
        RenditionDefinition renditionDefinition = this.renditionService.loadRenditionDefinition(renditionQName);
        RenditionServiceIntegrationTest.assertNotNull((String)("'" + renditionLocalName + "' rendition definition was missing."), (Object)renditionDefinition);
        RenditionServiceIntegrationTest.assertEquals((String)("'" + renditionLocalName + "' renditionDefinition had wrong renditionName"), (Object)renditionQName, (Object)renditionDefinition.getRenditionName());
        RenditionServiceIntegrationTest.assertNotNull((String)("'" + renditionLocalName + "' renditionDefinition had null " + "renderingActionName" + " parameter"), (Object)renditionDefinition.getParameterValue("renderingActionName"));
        RenditionServiceIntegrationTest.assertEquals((Object)AuthenticationUtil.getSystemUserName(), (Object)renditionDefinition.getParameterValue("runAs"));
        return renditionDefinition;
    }

    private RenditionDefinition makeReformatAction(QName renditionObjectType, String targetMimetype) {
        RenditionDefinition action = this.renditionService.createRenditionDefinition(REFORMAT_RENDER_DEFN_NAME, "reformat");
        action.setParameterValue("mime-type", (Serializable)((Object)targetMimetype));
        if (renditionObjectType != null) {
            action.setParameterValue("rendition-nodetype", (Serializable)renditionObjectType);
        }
        return action;
    }

    private RenditionDefinition makeRescaleImageAction() {
        RenditionDefinition action = this.renditionService.createRenditionDefinition(RESCALE_RENDER_DEFN_NAME, "imageRenderingEngine");
        action.setParameterValue("xsize", Integer.valueOf(42));
        return action;
    }

    private void validateRenderingActionDefinition(String renderingEngineName) {
        RenderingEngineDefinition renderingActionDefn = this.renditionService.getRenderingEngineDefinition(renderingEngineName);
        RenditionServiceIntegrationTest.assertNotNull((String)"renderingActionDefn was null", (Object)renderingActionDefn);
        RenditionServiceIntegrationTest.assertEquals((String)"Incorrect renderingActionDefn name", (String)renderingEngineName, (String)renderingActionDefn.getName());
    }

    private void validateRenditionAssociation(ChildAssociationRef chAssRef, QName renderingActionQName) {
        RenditionServiceIntegrationTest.assertEquals((String)"The assoc type name was wrong", (Object)RenditionModel.ASSOC_RENDITION, (Object)chAssRef.getTypeQName());
        RenditionServiceIntegrationTest.assertEquals((String)"The assoc name was wrong", (Object)renderingActionQName, (Object)chAssRef.getQName());
        RenditionServiceIntegrationTest.assertTrue((String)"The source node should have the rn:renditioned aspect applied", (boolean)this.nodeService.hasAspect(chAssRef.getParentRef(), RenditionModel.ASPECT_RENDITIONED));
        NodeRef newRenditionNodeRef = chAssRef.getChildRef();
        RenditionServiceIntegrationTest.assertTrue((String)"The new rendition node was not a rendition.", (boolean)this.renditionService.isRendition(newRenditionNodeRef));
        NodeRef renditionSource = this.renditionService.getSourceNode(newRenditionNodeRef).getParentRef();
        NodeRef renditionPrimaryParent = this.nodeService.getPrimaryParent(newRenditionNodeRef).getParentRef();
        if (renditionSource.equals((Object)renditionPrimaryParent)) {
            RenditionServiceIntegrationTest.assertTrue((String)"Rendition node was missing the hiddenRendition aspect", (boolean)this.nodeService.hasAspect(newRenditionNodeRef, RenditionModel.ASPECT_HIDDEN_RENDITION));
        } else {
            RenditionServiceIntegrationTest.assertTrue((String)"Rendition node was missing the visibleRendition aspect", (boolean)this.nodeService.hasAspect(newRenditionNodeRef, RenditionModel.ASPECT_VISIBLE_RENDITION));
        }
        RenditionServiceIntegrationTest.assertEquals((Object)ContentModel.PROP_CONTENT, (Object)this.nodeService.getProperty(newRenditionNodeRef, ContentModel.PROP_CONTENT_PROPERTY_NAME));
    }

    private String getLongNameWithEscapedBraces(QName qn) {
        String longName = qn.toString();
        String escapedBraces = longName.replace("{", "\\{").replace("}", "\\}");
        return escapedBraces;
    }

    private String readTextContent(NodeRef nodeRef) {
        ContentReader reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        RenditionServiceIntegrationTest.assertNotNull((String)"reader was null", (Object)reader);
        reader.setMimetype("text/plain");
        return reader.getContentString();
    }

    private CompositeRenditionDefinition makeCompositeReformatAndResizeDefinition(QName renditionName, int newX, int newY) {
        CompositeRenditionDefinition compositeDefinition = this.renditionService.createCompositeRenditionDefinition(renditionName);
        RenditionDefinition reformatDefinition = this.makeReformatAction(null, "image/jpeg");
        RenditionDefinition rescaleImageDefinition = this.makeRescaleImageAction();
        rescaleImageDefinition.setParameterValue("xsize", Integer.valueOf(newX));
        rescaleImageDefinition.setParameterValue("ysize", Integer.valueOf(newY));
        compositeDefinition.addAction(reformatDefinition);
        compositeDefinition.addAction(rescaleImageDefinition);
        return compositeDefinition;
    }

    public void testJavascriptAPI() throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("testSourceNode", this.nodeWithImageContent);
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/rendition/script/test_renditionService.js");
        this.scriptService.executeScript(location, model);
    }

    private static class DummyHelloWorldRenditionEngine
    extends AbstractRenderingEngine {
        private static final String ENGINE_NAME = "helloWorldRenderingEngine";

        private DummyHelloWorldRenditionEngine() {
        }

        public static void registerIfNeeded(ConfigurableApplicationContext ctx) {
            if (!ctx.containsBean(ENGINE_NAME)) {
                DummyHelloWorldRenditionEngine hw = new DummyHelloWorldRenditionEngine();
                hw.setRuntimeActionService((RuntimeActionService)ctx.getBean("actionService"));
                hw.setNodeService((NodeService)ctx.getBean("NodeService"));
                hw.setContentService((ContentService)ctx.getBean("ContentService"));
                hw.setRenditionService((RenditionService)ctx.getBean("RenditionService"));
                hw.setBehaviourFilter((BehaviourFilter)ctx.getBean("policyBehaviourFilter"));
                hw.setRenditionLocationResolver((RenditionLocationResolver)ctx.getBean("renditionLocationResolver"));
                ctx.getBeanFactory().registerSingleton(ENGINE_NAME, (Object)hw);
                hw.init();
            }
        }

        protected void render(AbstractRenderingEngine.RenderingContext context) {
            ContentWriter contentWriter = context.makeContentWriter();
            contentWriter.setMimetype("text/plain");
            contentWriter.putContent("Hello, world!");
        }
    }

    private static class AsyncResultsHolder {
        private String message;
        private ChildAssociationRef assoc;
        private Throwable throwable;

        private AsyncResultsHolder() {
        }

        public synchronized String getValue() {
            return this.message;
        }

        public synchronized void setMessage(String message) {
            this.message = message;
        }

        public synchronized ChildAssociationRef getAssoc() {
            return this.assoc;
        }

        public synchronized void setAssoc(ChildAssociationRef assoc) {
            this.assoc = assoc;
        }

        public synchronized Throwable getThrowable() {
            return this.throwable;
        }

        public synchronized void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

