/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NoTransformerException;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTransformationRenderingEngine
extends AbstractRenderingEngine {
    private static Log logger = LogFactory.getLog(AbstractTransformationRenderingEngine.class);
    private static final String TRANSFORMER_NOT_EXISTS_MESSAGE_PATTERN = "Transformer for '%s' source mime type and '%s' target mime type was not found. Operation can't be performed";
    private static final String NOT_TRANSFORMABLE_MESSAGE_PATTERN = "Content not transformable for '%s' source mime type and '%s' target mime type. Operation can't be performed";
    private static final String TRANSFORMING_ERROR_MESSAGE = "Some error occurred during document transforming. Error message: ";

    protected void render(AbstractRenderingEngine.RenderingContext context) {
        TransformationOptions options;
        String targetMimeType;
        ContentReader contentReader = context.makeContentReader();
        String sourceMimeType = contentReader.getMimetype();
        ContentTransformer transformer = this.contentService.getTransformer(sourceMimeType, targetMimeType = this.getTargetMimeType(context), options = this.getTransformOptions(context));
        if (null == transformer) {
            throw new RenditionServiceException(String.format(TRANSFORMER_NOT_EXISTS_MESSAGE_PATTERN, sourceMimeType, targetMimeType));
        }
        if (transformer.isTransformable(sourceMimeType, targetMimeType, options)) {
            ContentWriter contentWriter = context.makeContentWriter();
            try {
                this.contentService.transform(contentReader, contentWriter, options);
            }
            catch (NoTransformerException ntx) {
                logger.debug((Object)("No transformer found to execute rule: \n   reader: " + contentReader + "\n" + "   writer: " + contentWriter + "\n" + "   action: " + this));
                throw new RenditionServiceException(TRANSFORMING_ERROR_MESSAGE + ntx.getMessage(), (Throwable)((Object)ntx));
            }
        } else {
            throw new RenditionServiceException(String.format(NOT_TRANSFORMABLE_MESSAGE_PATTERN, sourceMimeType, targetMimeType));
        }
    }

    protected abstract TransformationOptions getTransformOptions(AbstractRenderingEngine.RenderingContext var1);
}

