/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResultSetRow
implements ResultSetRow {
    private ResultSet resultSet;
    private int index;
    protected Map<String, Serializable> properties;

    public AbstractResultSetRow(ResultSet resultSet, int index) {
        this.resultSet = resultSet;
        this.index = index;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public int getIndex() {
        return this.index;
    }

    public NodeRef getNodeRef() {
        return this.getResultSet().getNodeRef(this.getIndex());
    }

    public QName getQName() {
        return this.getResultSet().getChildAssocRef(this.getIndex()).getQName();
    }

    public ChildAssociationRef getChildAssocRef() {
        return this.getResultSet().getChildAssocRef(this.getIndex());
    }

    public float getScore() {
        return this.getResultSet().getScore(this.getIndex());
    }

    public Map<String, Serializable> getValues() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Serializable>();
            this.setProperties(this.getDirectProperties());
        }
        return Collections.unmodifiableMap(this.properties);
    }

    public Serializable getValue(String columnName) {
        return this.properties.get(columnName);
    }

    protected Map<QName, Serializable> getDirectProperties() {
        return Collections.emptyMap();
    }

    protected void setProperties(Map<QName, Serializable> byQname) {
        for (QName qname : byQname.keySet()) {
            Serializable value = byQname.get(qname);
            this.properties.put(qname.toString(), value);
        }
    }

    public Serializable getValue(QName qname) {
        return this.getValues().get(qname.toString());
    }
}

