/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.search.impl.lucene.ADMLuceneIndexerImpl;
import org.alfresco.repo.search.impl.lucene.ADMLuceneSearcherImpl;
import org.alfresco.repo.search.impl.lucene.LuceneCategoryServiceImpl;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADMLuceneCategoryTest
extends TestCase {
    private ServiceRegistry serviceRegistry;
    static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    NodeService nodeService;
    DictionaryService dictionaryService;
    private NodeRef rootNodeRef;
    private NodeRef n1;
    private NodeRef n2;
    private NodeRef n3;
    private NodeRef n4;
    private NodeRef n6;
    private NodeRef n5;
    private NodeRef n7;
    private NodeRef n8;
    private NodeRef n9;
    private NodeRef n10;
    private NodeRef n11;
    private NodeRef n12;
    private NodeRef n13;
    private NodeRef n14;
    private NodeRef catContainer;
    private NodeRef catRoot;
    private NodeRef catACBase;
    private NodeRef catACOne;
    private NodeRef catACTwo;
    private NodeRef catACThree;
    private FullTextSearchIndexer luceneFTS;
    private DictionaryDAO dictionaryDAO;
    private String TEST_NAMESPACE = "http://www.alfresco.org/test/lucenecategorytest";
    private QName regionCategorisationQName;
    private QName assetClassCategorisationQName;
    private QName investmentRegionCategorisationQName;
    private QName marketingRegionCategorisationQName;
    private NodeRef catRBase;
    private NodeRef catROne;
    private NodeRef catRTwo;
    private NodeRef catRThree;
    private SearchService searcher;
    private LuceneIndexerAndSearcher indexerAndSearcher;
    private TenantService tenantService;
    private CategoryService categoryService;

    public ADMLuceneCategoryTest() {
    }

    public ADMLuceneCategoryTest(String arg0) {
        super(arg0);
    }

    public void setUp() throws Exception {
        this.nodeService = (NodeService)ctx.getBean("dbNodeService");
        this.dictionaryService = (DictionaryService)ctx.getBean("dictionaryService");
        this.luceneFTS = (FullTextSearchIndexer)ctx.getBean("LuceneFullTextSearchIndexer");
        this.dictionaryDAO = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        this.searcher = (SearchService)ctx.getBean("searchService");
        this.indexerAndSearcher = (LuceneIndexerAndSearcher)ctx.getBean("admLuceneIndexerAndSearcherFactory");
        this.categoryService = (CategoryService)ctx.getBean("categoryService");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.tenantService = (TenantService)ctx.getBean("tenantService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.createTestTypes();
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction tx = transactionService.getUserTransaction();
        tx.begin();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.setProperty(this.n1, QName.createQName((String)"{namespace}property-1"), (Serializable)((Object)"value-1"));
        this.n2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.setProperty(this.n2, QName.createQName((String)"{namespace}property-1"), (Serializable)((Object)"value-1"));
        this.nodeService.setProperty(this.n2, QName.createQName((String)"{namespace}property-2"), (Serializable)((Object)"value-2"));
        this.n3 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}three"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n4 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}four"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n5 = this.nodeService.createNode(this.n1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}five"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n6 = this.nodeService.createNode(this.n1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}six"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n7 = this.nodeService.createNode(this.n2, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}seven"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n8 = this.nodeService.createNode(this.n2, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}eight-2"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n9 = this.nodeService.createNode(this.n5, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}nine"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n10 = this.nodeService.createNode(this.n5, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}ten"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n11 = this.nodeService.createNode(this.n5, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}eleven"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n12 = this.nodeService.createNode(this.n5, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}twelve"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n13 = this.nodeService.createNode(this.n12, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}thirteen"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n14 = this.nodeService.createNode(this.n13, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}fourteen"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.addChild(this.rootNodeRef, this.n8, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}eight-0"));
        this.nodeService.addChild(this.n1, this.n8, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}eight-1"));
        this.nodeService.addChild(this.n2, this.n13, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}link"));
        this.nodeService.addChild(this.n1, this.n14, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n2, this.n14, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n5, this.n14, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n6, this.n14, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n12, this.n14, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n13, this.n14, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}common"));
        this.catContainer = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryContainer"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.catRoot = this.nodeService.createNode(this.catContainer, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryRoot"), ContentModel.TYPE_CATEGORYROOT).getChildRef();
        this.catRBase = this.nodeService.createNode(this.catRoot, ContentModel.ASSOC_CATEGORIES, QName.createQName((String)this.TEST_NAMESPACE, (String)"region"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catROne = this.nodeService.createNode(this.catRBase, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName((String)this.TEST_NAMESPACE, (String)"Europe"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catRTwo = this.nodeService.createNode(this.catRBase, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName((String)this.TEST_NAMESPACE, (String)"RestOfWorld"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catRThree = this.nodeService.createNode(this.catRTwo, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName((String)this.TEST_NAMESPACE, (String)"US"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.nodeService.addChild(this.catRoot, this.catRBase, ContentModel.ASSOC_CATEGORIES, QName.createQName((String)this.TEST_NAMESPACE, (String)"investmentRegion"));
        this.nodeService.addChild(this.catRoot, this.catRBase, ContentModel.ASSOC_CATEGORIES, QName.createQName((String)this.TEST_NAMESPACE, (String)"marketingRegion"));
        this.catACBase = this.nodeService.createNode(this.catRoot, ContentModel.ASSOC_CATEGORIES, QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catACOne = this.nodeService.createNode(this.catACBase, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName((String)this.TEST_NAMESPACE, (String)"Fixed"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catACTwo = this.nodeService.createNode(this.catACBase, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName((String)this.TEST_NAMESPACE, (String)"Equity"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catACThree = this.nodeService.createNode(this.catACTwo, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName((String)this.TEST_NAMESPACE, (String)"SpecialEquity"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.nodeService.addAspect(this.n1, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACBase));
        this.nodeService.addAspect(this.n1, this.regionCategorisationQName, this.createMap("region", this.catRBase));
        this.nodeService.addAspect(this.n2, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne));
        this.nodeService.addAspect(this.n3, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne));
        this.nodeService.addAspect(this.n4, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne));
        this.nodeService.addAspect(this.n5, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne));
        this.nodeService.addAspect(this.n6, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne));
        this.nodeService.addAspect(this.n7, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACTwo));
        this.nodeService.addAspect(this.n8, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACTwo));
        this.nodeService.addAspect(this.n9, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACTwo));
        this.nodeService.addAspect(this.n10, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACTwo));
        this.nodeService.addAspect(this.n11, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACTwo));
        this.nodeService.addAspect(this.n12, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne, this.catACTwo));
        this.nodeService.addAspect(this.n13, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne, this.catACTwo, this.catACThree));
        this.nodeService.addAspect(this.n14, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne, this.catACTwo));
        this.nodeService.addAspect(this.n2, this.regionCategorisationQName, this.createMap("region", this.catROne));
        this.nodeService.addAspect(this.n3, this.regionCategorisationQName, this.createMap("region", this.catROne));
        this.nodeService.addAspect(this.n4, this.regionCategorisationQName, this.createMap("region", this.catRTwo));
        this.nodeService.addAspect(this.n5, this.regionCategorisationQName, this.createMap("region", this.catRTwo));
        this.nodeService.addAspect(this.n5, this.investmentRegionCategorisationQName, this.createMap("investmentRegion", this.catRBase));
        this.nodeService.addAspect(this.n5, this.marketingRegionCategorisationQName, this.createMap("marketingRegion", this.catRBase));
        this.nodeService.addAspect(this.n6, this.investmentRegionCategorisationQName, this.createMap("investmentRegion", this.catRBase));
        this.nodeService.addAspect(this.n7, this.investmentRegionCategorisationQName, this.createMap("investmentRegion", this.catRBase));
        this.nodeService.addAspect(this.n8, this.investmentRegionCategorisationQName, this.createMap("investmentRegion", this.catRBase));
        this.nodeService.addAspect(this.n9, this.investmentRegionCategorisationQName, this.createMap("investmentRegion", this.catRBase));
        this.nodeService.addAspect(this.n10, this.marketingRegionCategorisationQName, this.createMap("marketingRegion", this.catRBase));
        this.nodeService.addAspect(this.n11, this.marketingRegionCategorisationQName, this.createMap("marketingRegion", this.catRBase));
        this.nodeService.addAspect(this.n12, this.marketingRegionCategorisationQName, this.createMap("marketingRegion", this.catRBase));
        this.nodeService.addAspect(this.n13, this.marketingRegionCategorisationQName, this.createMap("marketingRegion", this.catRBase));
        this.nodeService.addAspect(this.n14, this.marketingRegionCategorisationQName, this.createMap("marketingRegion", this.catRBase));
        tx.commit();
    }

    protected void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    private HashMap<QName, Serializable> createMap(String name, NodeRef[] nodeRefs) {
        HashMap<QName, Serializable> map = new HashMap<QName, Serializable>();
        Serializable value = (Serializable)((Object)Arrays.asList(nodeRefs));
        map.put(QName.createQName((String)this.TEST_NAMESPACE, (String)name), value);
        return map;
    }

    private HashMap<QName, Serializable> createMap(String name, NodeRef nodeRef) {
        return this.createMap(name, new NodeRef[]{nodeRef});
    }

    private HashMap<QName, Serializable> createMap(String name, NodeRef nodeRef1, NodeRef nodeRef2) {
        return this.createMap(name, new NodeRef[]{nodeRef1, nodeRef2});
    }

    private HashMap<QName, Serializable> createMap(String name, NodeRef nodeRef1, NodeRef nodeRef2, NodeRef nodeRef3) {
        return this.createMap(name, new NodeRef[]{nodeRef1, nodeRef2, nodeRef3});
    }

    private void createTestTypes() {
        M2Model model = M2Model.createModel((String)"test:lucenecategory");
        model.createNamespace(this.TEST_NAMESPACE, "test");
        model.createImport("http://www.alfresco.org/model/dictionary/1.0", "d");
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        this.regionCategorisationQName = QName.createQName((String)this.TEST_NAMESPACE, (String)"region");
        M2Aspect generalCategorisation = model.createAspect("test:" + this.regionCategorisationQName.getLocalName());
        generalCategorisation.setParentName("cm:" + ContentModel.ASPECT_CLASSIFIABLE.getLocalName());
        M2Property genCatProp = generalCategorisation.createProperty("test:region");
        genCatProp.setIndexed(true);
        genCatProp.setIndexedAtomically(true);
        genCatProp.setMandatory(true);
        genCatProp.setMultiValued(true);
        genCatProp.setStoredInIndex(true);
        genCatProp.setIndexTokenisationMode(IndexTokenisationMode.FALSE);
        genCatProp.setType("d:" + DataTypeDefinition.CATEGORY.getLocalName());
        this.assetClassCategorisationQName = QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass");
        M2Aspect assetClassCategorisation = model.createAspect("test:" + this.assetClassCategorisationQName.getLocalName());
        assetClassCategorisation.setParentName("cm:" + ContentModel.ASPECT_CLASSIFIABLE.getLocalName());
        M2Property acProp = assetClassCategorisation.createProperty("test:assetClass");
        acProp.setIndexed(true);
        acProp.setIndexedAtomically(true);
        acProp.setMandatory(true);
        acProp.setMultiValued(true);
        acProp.setStoredInIndex(true);
        acProp.setIndexTokenisationMode(IndexTokenisationMode.FALSE);
        acProp.setType("d:" + DataTypeDefinition.CATEGORY.getLocalName());
        this.investmentRegionCategorisationQName = QName.createQName((String)this.TEST_NAMESPACE, (String)"investmentRegion");
        M2Aspect investmentRegionCategorisation = model.createAspect("test:" + this.investmentRegionCategorisationQName.getLocalName());
        investmentRegionCategorisation.setParentName("cm:" + ContentModel.ASPECT_CLASSIFIABLE.getLocalName());
        M2Property irProp = investmentRegionCategorisation.createProperty("test:investmentRegion");
        irProp.setIndexed(true);
        irProp.setIndexedAtomically(true);
        irProp.setMandatory(true);
        irProp.setMultiValued(true);
        irProp.setStoredInIndex(true);
        irProp.setIndexTokenisationMode(IndexTokenisationMode.FALSE);
        irProp.setType("d:" + DataTypeDefinition.CATEGORY.getLocalName());
        this.marketingRegionCategorisationQName = QName.createQName((String)this.TEST_NAMESPACE, (String)"marketingRegion");
        M2Aspect marketingRegionCategorisation = model.createAspect("test:" + this.marketingRegionCategorisationQName.getLocalName());
        marketingRegionCategorisation.setParentName("cm:" + ContentModel.ASPECT_CLASSIFIABLE.getLocalName());
        M2Property mrProp = marketingRegionCategorisation.createProperty("test:marketingRegion");
        mrProp.setIndexed(true);
        mrProp.setIndexedAtomically(true);
        mrProp.setMandatory(true);
        mrProp.setMultiValued(true);
        mrProp.setStoredInIndex(true);
        mrProp.setIndexTokenisationMode(IndexTokenisationMode.FALSE);
        mrProp.setType("d:" + DataTypeDefinition.CATEGORY.getLocalName());
        this.dictionaryDAO.putModel(model);
    }

    private void buildBaseIndex() {
        ADMLuceneIndexerImpl indexer = ADMLuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis() + "_" + new Random().nextInt(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setTenantService(this.tenantService);
        indexer.setFullTextSearchIndexer(this.luceneFTS);
        indexer.createNode(new ChildAssociationRef(null, null, null, this.rootNodeRef));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName((String)"{namespace}one"), this.n1));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName((String)"{namespace}two"), this.n2));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName((String)"{namespace}three"), this.n3));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName((String)"{namespace}four"), this.n4));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName((String)"{namespace}categoryContainer"), this.catContainer));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.catContainer, QName.createQName((String)"{cat}categoryRoot"), this.catRoot));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.catRoot, QName.createQName((String)this.TEST_NAMESPACE, (String)"AssetClass"), this.catACBase));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_SUBCATEGORIES, this.catACBase, QName.createQName((String)this.TEST_NAMESPACE, (String)"Fixed"), this.catACOne));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_SUBCATEGORIES, this.catACBase, QName.createQName((String)this.TEST_NAMESPACE, (String)"Equity"), this.catACTwo));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_SUBCATEGORIES, this.catACTwo, QName.createQName((String)this.TEST_NAMESPACE, (String)"SpecialEquity"), this.catACThree));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.catRoot, QName.createQName((String)this.TEST_NAMESPACE, (String)"Region"), this.catRBase));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_SUBCATEGORIES, this.catRBase, QName.createQName((String)this.TEST_NAMESPACE, (String)"Europe"), this.catROne));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_SUBCATEGORIES, this.catRBase, QName.createQName((String)this.TEST_NAMESPACE, (String)"RestOfWorld"), this.catRTwo));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_SUBCATEGORIES, this.catRTwo, QName.createQName((String)this.TEST_NAMESPACE, (String)"US"), this.catRThree));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n1, QName.createQName((String)"{namespace}five"), this.n5));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n1, QName.createQName((String)"{namespace}six"), this.n6));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n2, QName.createQName((String)"{namespace}seven"), this.n7));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n2, QName.createQName((String)"{namespace}eight"), this.n8));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n5, QName.createQName((String)"{namespace}nine"), this.n9));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n5, QName.createQName((String)"{namespace}ten"), this.n10));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n5, QName.createQName((String)"{namespace}eleven"), this.n11));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n5, QName.createQName((String)"{namespace}twelve"), this.n12));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n12, QName.createQName((String)"{namespace}thirteen"), this.n13));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n13, QName.createQName((String)"{namespace}fourteen"), this.n14));
        indexer.prepare();
        indexer.commit();
    }

    public void testMulti() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction tx = transactionService.getUserTransaction();
        tx.begin();
        this.buildBaseIndex();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver(""));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*\" AND (PATH:\"/test:assetClass/test:Equity/member\" PATH:\"/test:marketingRegion/member\")", null);
        ADMLuceneCategoryTest.assertEquals((int)9, (int)results.length());
        results.close();
        tx.rollback();
    }

    public void testBasic() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction tx = transactionService.getUserTransaction();
        tx.begin();
        this.buildBaseIndex();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver(""));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:marketingRegion\"", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:marketingRegion//member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer\"", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot\"", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot\"", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot/test:assetClass\"", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot/test:assetClass/member\" ", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot/test:assetClass/test:Fixed\"", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot/test:assetClass/test:Equity\"", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:assetClass\"", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:assetClass/test:Fixed\"", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:assetClass/test:Equity\"", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:assetClass/test:*\"", null);
        ADMLuceneCategoryTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:assetClass//test:*\"", null);
        ADMLuceneCategoryTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:assetClass/test:Fixed/member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:assetClass/test:Equity/member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:assetClass/test:Equity/test:SpecialEquity/member//.\"", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:assetClass/test:Equity/test:SpecialEquity/member//*\"", null);
        ADMLuceneCategoryTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:assetClass/test:Equity/test:SpecialEquity/member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "+PATH:\"/test:assetClass/test:Equity/member\" AND +PATH:\"/test:assetClass/test:Fixed/member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:assetClass/test:Equity/member\" PATH:\"/test:assetClass/test:Fixed/member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)13, (int)results.length());
        results.close();
        ADMLuceneCategoryTest.assertEquals((int)4, (int)this.nodeService.getChildAssocs(this.catRoot).size());
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:region\"", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:region/member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:region/test:Europe/member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:region/test:RestOfWorld/member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:region//member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:investmentRegion//member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:marketingRegion//member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "+PATH:\"/test:assetClass/test:Fixed/member\" AND +PATH:\"/test:region/test:Europe/member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "+PATH:\"/cm:categoryContainer/cm:categoryRoot/test:assetClass/test:Fixed/member\" AND +PATH:\"/cm:categoryContainer/cm:categoryRoot/test:region/test:Europe/member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:assetClass/test:Equity/member\" PATH:\"/test:marketingRegion/member\"", null);
        ADMLuceneCategoryTest.assertEquals((int)9, (int)results.length());
        results.close();
        tx.rollback();
    }

    public void testCategoryServiceImpl() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction tx = transactionService.getUserTransaction();
        tx.begin();
        this.buildBaseIndex();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver(""));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot/test:assetClass/*\" ", null);
        ADMLuceneCategoryTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot/test:assetClass/member\" ", null);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)results.length());
        results.close();
        LuceneCategoryServiceImpl impl = new LuceneCategoryServiceImpl();
        impl.setNodeService(this.nodeService);
        impl.setNamespacePrefixResolver(this.getNamespacePrefixReolsver(""));
        impl.setIndexerAndSearcher(this.indexerAndSearcher);
        impl.setTenantService(this.tenantService);
        impl.setDictionaryService(this.dictionaryService);
        Collection<ChildAssociationRef> result = impl.getChildren(this.catACBase, CategoryService.Mode.MEMBERS, CategoryService.Depth.IMMEDIATE);
        ADMLuceneCategoryTest.assertEquals((int)1, (int)result.size());
        result = impl.getChildren(this.catACBase, CategoryService.Mode.ALL, CategoryService.Depth.IMMEDIATE);
        ADMLuceneCategoryTest.assertEquals((int)3, (int)result.size());
        result = impl.getChildren(this.catACBase, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE);
        ADMLuceneCategoryTest.assertEquals((int)2, (int)result.size());
        result = impl.getChildren(this.catACBase, CategoryService.Mode.MEMBERS, CategoryService.Depth.ANY);
        ADMLuceneCategoryTest.assertEquals((int)14, (int)result.size());
        result = impl.getChildren(this.catACBase, CategoryService.Mode.ALL, CategoryService.Depth.ANY);
        ADMLuceneCategoryTest.assertEquals((int)17, (int)result.size());
        result = impl.getChildren(this.catACBase, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.ANY);
        ADMLuceneCategoryTest.assertEquals((int)3, (int)result.size());
        result = impl.getClassifications(this.rootNodeRef.getStoreRef());
        ADMLuceneCategoryTest.assertEquals((int)2, (int)result.size());
        result = impl.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), CategoryService.Depth.IMMEDIATE);
        ADMLuceneCategoryTest.assertEquals((int)2, (int)result.size());
        Collection<QName> aspects = impl.getClassificationAspects();
        ADMLuceneCategoryTest.assertEquals((int)7, (int)aspects.size());
        tx.rollback();
    }

    private NamespacePrefixResolver getNamespacePrefixReolsver(String defaultURI) {
        DynamicNamespacePrefixResolver nspr = new DynamicNamespacePrefixResolver(null);
        nspr.registerNamespace("cm", "http://www.alfresco.org/model/content/1.0");
        nspr.registerNamespace("namespace", "namespace");
        nspr.registerNamespace("test", this.TEST_NAMESPACE);
        nspr.registerNamespace("", defaultURI);
        return nspr;
    }

    public void testCategoryService() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction tx = transactionService.getUserTransaction();
        tx.begin();
        this.buildBaseIndex();
        ADMLuceneCategoryTest.assertEquals((int)1, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.MEMBERS, CategoryService.Depth.IMMEDIATE).size());
        ADMLuceneCategoryTest.assertEquals((int)2, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE).size());
        ADMLuceneCategoryTest.assertEquals((int)3, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.ALL, CategoryService.Depth.IMMEDIATE).size());
        ADMLuceneCategoryTest.assertEquals((int)14, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.MEMBERS, CategoryService.Depth.ANY).size());
        ADMLuceneCategoryTest.assertEquals((int)3, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.ANY).size());
        ADMLuceneCategoryTest.assertEquals((int)17, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.ALL, CategoryService.Depth.ANY).size());
        ADMLuceneCategoryTest.assertEquals((int)2, (int)this.categoryService.getClassifications(this.rootNodeRef.getStoreRef()).size());
        ADMLuceneCategoryTest.assertEquals((int)2, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), CategoryService.Depth.IMMEDIATE).size());
        ADMLuceneCategoryTest.assertEquals((int)3, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), CategoryService.Depth.ANY).size());
        ADMLuceneCategoryTest.assertEquals((int)7, (int)this.categoryService.getClassificationAspects().size());
        ADMLuceneCategoryTest.assertEquals((int)2, (int)this.categoryService.getRootCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass")).size());
        NodeRef newRoot = this.categoryService.createRootCategory(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), "Fruit");
        tx.commit();
        tx = transactionService.getUserTransaction();
        tx.begin();
        ADMLuceneCategoryTest.assertEquals((int)3, (int)this.categoryService.getRootCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass")).size());
        ADMLuceneCategoryTest.assertEquals((int)3, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), CategoryService.Depth.IMMEDIATE).size());
        ADMLuceneCategoryTest.assertEquals((int)4, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), CategoryService.Depth.ANY).size());
        NodeRef newCat = this.categoryService.createCategory(newRoot, "Banana");
        tx.commit();
        tx = transactionService.getUserTransaction();
        tx.begin();
        ADMLuceneCategoryTest.assertEquals((int)3, (int)this.categoryService.getRootCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass")).size());
        ADMLuceneCategoryTest.assertEquals((int)3, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), CategoryService.Depth.IMMEDIATE).size());
        ADMLuceneCategoryTest.assertEquals((int)5, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), CategoryService.Depth.ANY).size());
        this.categoryService.deleteCategory(newCat);
        tx.commit();
        tx = transactionService.getUserTransaction();
        tx.begin();
        ADMLuceneCategoryTest.assertEquals((int)3, (int)this.categoryService.getRootCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass")).size());
        ADMLuceneCategoryTest.assertEquals((int)3, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), CategoryService.Depth.IMMEDIATE).size());
        ADMLuceneCategoryTest.assertEquals((int)4, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), CategoryService.Depth.ANY).size());
        this.categoryService.deleteCategory(newRoot);
        tx.commit();
        tx = transactionService.getUserTransaction();
        tx.begin();
        ADMLuceneCategoryTest.assertEquals((int)2, (int)this.categoryService.getRootCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass")).size());
        ADMLuceneCategoryTest.assertEquals((int)2, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), CategoryService.Depth.IMMEDIATE).size());
        ADMLuceneCategoryTest.assertEquals((int)3, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), CategoryService.Depth.ANY).size());
        tx.rollback();
    }

    public void xtestManyCategories() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction tx = transactionService.getUserTransaction();
        tx.begin();
        long start = System.nanoTime();
        int startCount = this.categoryService.getRootCategories(this.serviceRegistry.getPersonService().getPeopleContainer().getStoreRef(), ContentModel.ASPECT_GEN_CLASSIFIABLE).size();
        System.out.println("1 Query complete in " + (float)(System.nanoTime() - start) / 1.0E9f);
        tx.commit();
        tx = transactionService.getUserTransaction();
        tx.begin();
        start = System.nanoTime();
        startCount = this.categoryService.getRootCategories(this.serviceRegistry.getPersonService().getPeopleContainer().getStoreRef(), ContentModel.ASPECT_GEN_CLASSIFIABLE).size();
        System.out.println("2 Query complete in " + (float)(System.nanoTime() - start) / 1.0E9f);
        tx.commit();
        for (int i = 0; i < 0; ++i) {
            tx = transactionService.getUserTransaction();
            tx.begin();
            this.categoryService.createRootCategory(this.serviceRegistry.getPersonService().getPeopleContainer().getStoreRef(), ContentModel.ASPECT_GEN_CLASSIFIABLE, "first" + i);
            tx.commit();
        }
        for (int j = 0; j < 10; ++j) {
            tx = transactionService.getUserTransaction();
            tx.begin();
            for (int i = 0; i < 1; ++i) {
                NodeRef topref = this.categoryService.createRootCategory(this.serviceRegistry.getPersonService().getPeopleContainer().getStoreRef(), ContentModel.ASPECT_GEN_CLASSIFIABLE, "third" + j * 100 + i);
                for (int k = 0; k < 5; ++k) {
                    NodeRef oneRef = this.categoryService.createCategory(topref, "child_" + i + "_" + j + "_" + k);
                    for (int l = 0; l < 5; ++l) {
                        NodeRef twoRef = this.categoryService.createCategory(oneRef, "child_" + i + "_" + j + "_" + k + "_" + l);
                        for (int m = 0; m < 5; ++m) {
                            NodeRef threeRef = this.categoryService.createCategory(twoRef, "child_" + i + "_" + j + "_" + k + "_" + l + "_" + m);
                            for (int n = 0; n < 5; ++n) {
                                NodeRef fourRef = this.categoryService.createCategory(threeRef, "child_" + i + "_" + j + "_" + k + "_" + l + "_" + m + "_" + n);
                                for (int o = 0; o < 5; ++o) {
                                    NodeRef fiveRef = this.categoryService.createCategory(fourRef, "child_" + i + "_" + j + "_" + k + "_" + l + "_" + m + "_" + n + "_" + o);
                                    for (int p = 0; p < 5; ++p) {
                                        NodeRef sixRef = this.categoryService.createCategory(fiveRef, "child_" + i + "_" + j + "_" + k + "_" + l + "_" + m + "_" + n + "_" + o + "_" + p);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            tx.commit();
        }
        tx = transactionService.getUserTransaction();
        tx.begin();
        start = System.nanoTime();
        ADMLuceneCategoryTest.assertEquals((int)(startCount + 10), (int)this.categoryService.getRootCategories(this.serviceRegistry.getPersonService().getPeopleContainer().getStoreRef(), ContentModel.ASPECT_GEN_CLASSIFIABLE).size());
        System.out.println("3 Query complete in " + (float)(System.nanoTime() - start) / 1.0E9f);
        tx.commit();
        tx = transactionService.getUserTransaction();
        tx.begin();
        start = System.nanoTime();
        ADMLuceneCategoryTest.assertEquals((int)(startCount + 10), (int)this.categoryService.getRootCategories(this.serviceRegistry.getPersonService().getPeopleContainer().getStoreRef(), ContentModel.ASPECT_GEN_CLASSIFIABLE).size());
        System.out.println("4 Query complete in " + (float)(System.nanoTime() - start) / 1.0E9f);
        tx.commit();
        tx = transactionService.getUserTransaction();
        tx.begin();
        start = System.nanoTime();
        ResultSet set = this.searcher.query(this.serviceRegistry.getPersonService().getPeopleContainer().getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.ASPECT_GEN_CLASSIFIABLE.toString()) + ":second*");
        System.out.println("Query complete in " + (float)(System.nanoTime() - start) / 1.0E9f);
        set.close();
        tx.commit();
    }

    public void testCatCount() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction tx = transactionService.getUserTransaction();
        tx.begin();
        ADMLuceneCategoryTest.assertEquals((int)1, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.MEMBERS, CategoryService.Depth.IMMEDIATE).size());
        ADMLuceneCategoryTest.assertEquals((int)2, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE).size());
        ADMLuceneCategoryTest.assertEquals((int)3, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.ALL, CategoryService.Depth.IMMEDIATE).size());
        ADMLuceneCategoryTest.assertEquals((int)14, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.MEMBERS, CategoryService.Depth.ANY).size());
        ADMLuceneCategoryTest.assertEquals((int)3, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.ANY).size());
        ADMLuceneCategoryTest.assertEquals((int)17, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.ALL, CategoryService.Depth.ANY).size());
        ADMLuceneCategoryTest.assertEquals((int)2, (int)this.categoryService.getClassifications(this.rootNodeRef.getStoreRef()).size());
        ADMLuceneCategoryTest.assertEquals((int)2, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), CategoryService.Depth.IMMEDIATE).size());
        ADMLuceneCategoryTest.assertEquals((int)3, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), CategoryService.Depth.ANY).size());
        ADMLuceneCategoryTest.assertEquals((int)7, (int)this.categoryService.getClassificationAspects().size());
        ADMLuceneCategoryTest.assertEquals((int)2, (int)this.categoryService.getRootCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass")).size());
        List<Pair<NodeRef, Integer>> top = this.categoryService.getTopCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"assetClass"), 10);
        for (Pair<NodeRef, Integer> current : top) {
            System.out.println("" + this.nodeService.getPaths((NodeRef)current.getFirst(), true) + " " + current.getSecond());
        }
        top = this.categoryService.getTopCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"investmentRegion"), 10);
        for (Pair<NodeRef, Integer> current : top) {
            System.out.println("" + this.nodeService.getPaths((NodeRef)current.getFirst(), true) + " " + current.getSecond());
        }
        top = this.categoryService.getTopCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"marketingRegion"), 10);
        for (Pair<NodeRef, Integer> current : top) {
            System.out.println("" + this.nodeService.getPaths((NodeRef)current.getFirst(), true) + " " + current.getSecond());
        }
        top = this.categoryService.getTopCategories(this.rootNodeRef.getStoreRef(), QName.createQName((String)this.TEST_NAMESPACE, (String)"region"), 10);
        for (Pair<NodeRef, Integer> current : top) {
            System.out.println("" + this.nodeService.getPaths((NodeRef)current.getFirst(), true) + " " + current.getSecond());
        }
        tx.commit();
    }

    private int getTotalScore(ResultSet results) {
        int totalScore = 0;
        for (ResultSetRow row : results) {
            totalScore = (int)((float)totalScore + row.getScore());
        }
        return totalScore;
    }
}

