/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.security.authority.UnknownAuthorityException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.alfresco.util.SearchLanguageConversion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorityDAOImpl
implements AuthorityDAO,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy {
    private StoreRef storeRef;
    private NodeService nodeService;
    private NamespacePrefixResolver namespacePrefixResolver;
    private QName qnameAssocSystem;
    private QName qnameAssocAuthorities;
    private QName qnameAssocZones;
    private SearchService searchService;
    private DictionaryService dictionaryService;
    private PersonService personService;
    private TenantService tenantService;
    private SimpleCache<Pair<String, String>, NodeRef> authorityLookupCache;
    private SimpleCache<String, Set<String>> userAuthorityCache;
    private Map<String, NodeRef> systemContainerRefs = new ConcurrentHashMap<String, NodeRef>(4);
    private AclDAO aclDao;
    private PolicyComponent policyComponent;

    public void setStoreUrl(String storeUrl) {
        this.storeRef = new StoreRef(storeUrl);
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
        this.qnameAssocSystem = QName.createQName((String)"sys", (String)"system", (NamespacePrefixResolver)namespacePrefixResolver);
        this.qnameAssocAuthorities = QName.createQName((String)"sys", (String)"authorities", (NamespacePrefixResolver)namespacePrefixResolver);
        this.qnameAssocZones = QName.createQName((String)"sys", (String)"zones", (NamespacePrefixResolver)namespacePrefixResolver);
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setAuthorityLookupCache(SimpleCache<Pair<String, String>, NodeRef> authorityLookupCache) {
        this.authorityLookupCache = authorityLookupCache;
    }

    public void setUserAuthorityCache(SimpleCache<String, Set<String>> userAuthorityCache) {
        this.userAuthorityCache = userAuthorityCache;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setAclDAO(AclDAO aclDao) {
        this.aclDao = aclDao;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    @Override
    public boolean authorityExists(String name) {
        NodeRef ref = this.getAuthorityOrNull(name);
        return ref != null;
    }

    @Override
    public void addAuthority(Collection<String> parentNames, String childName) {
        HashSet<NodeRef> parentRefs = new HashSet<NodeRef>(parentNames.size() * 2);
        AuthorityType authorityType = AuthorityType.getAuthorityType((String)childName);
        boolean isUser = authorityType.equals((Object)AuthorityType.USER);
        boolean notUserOrGroup = !isUser && !authorityType.equals((Object)AuthorityType.GROUP);
        for (String parentName : parentNames) {
            NodeRef parentRef = this.getAuthorityOrNull(parentName);
            if (parentRef == null) {
                throw new UnknownAuthorityException("An authority was not found for " + parentName);
            }
            if (!(!notUserOrGroup || authorityType.equals((Object)AuthorityType.ROLE) && AuthorityType.getAuthorityType((String)parentName).equals((Object)AuthorityType.ROLE))) {
                throw new AlfrescoRuntimeException("Authorities of the type " + authorityType + " may not be added to other authorities");
            }
            parentRefs.add(parentRef);
        }
        NodeRef childRef = this.getAuthorityOrNull(childName);
        if (childRef == null) {
            throw new UnknownAuthorityException("An authority was not found for " + childName);
        }
        if (isUser) {
            childName = (String)((Object)this.nodeService.getProperty(childRef, ContentModel.PROP_USERNAME));
        }
        this.nodeService.addChild(parentRefs, childRef, ContentModel.ASSOC_MEMBER, QName.createQName((String)"cm", (String)childName, (NamespacePrefixResolver)this.namespacePrefixResolver));
        if (isUser) {
            this.userAuthorityCache.remove((Serializable)((Object)childName));
        } else {
            this.userAuthorityCache.clear();
        }
    }

    @Override
    public void createAuthority(String name, String authorityDisplayName, Set<String> authorityZones) {
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_AUTHORITY_NAME, name);
        props.put(ContentModel.PROP_AUTHORITY_DISPLAY_NAME, authorityDisplayName);
        NodeRef authorityContainerRef = this.getAuthorityContainer();
        NodeRef childRef = this.nodeService.createNode(authorityContainerRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)name, (NamespacePrefixResolver)this.namespacePrefixResolver), ContentModel.TYPE_AUTHORITY_CONTAINER, props).getChildRef();
        if (authorityZones != null) {
            HashSet<NodeRef> zoneRefs = new HashSet<NodeRef>(authorityZones.size() * 2);
            for (String authorityZone : authorityZones) {
                zoneRefs.add(this.getOrCreateZone(authorityZone));
            }
            this.nodeService.addChild(zoneRefs, childRef, ContentModel.ASSOC_IN_ZONE, QName.createQName((String)"cm", (String)name, (NamespacePrefixResolver)this.namespacePrefixResolver));
        }
        this.authorityLookupCache.put(this.cacheKey(name), (Object)childRef);
    }

    private Pair<String, String> cacheKey(String authorityName) {
        String tenantDomain = AuthorityType.getAuthorityType((String)authorityName) == AuthorityType.USER ? this.tenantService.getDomain(authorityName) : this.tenantService.getCurrentUserDomain();
        return new Pair((Object)tenantDomain, (Object)authorityName);
    }

    @Override
    public void deleteAuthority(String name) {
        NodeRef nodeRef = this.getAuthorityOrNull(name);
        if (nodeRef == null) {
            throw new UnknownAuthorityException("An authority was not found for " + name);
        }
        this.nodeService.deleteNode(nodeRef);
        this.authorityLookupCache.remove(this.cacheKey(name));
        this.userAuthorityCache.clear();
    }

    @Override
    public Set<String> getAllAuthorities(AuthorityType type) {
        NodeRef container;
        TreeSet<String> authorities = new TreeSet<String>();
        if (type == null || type == AuthorityType.USER) {
            for (NodeRef nodeRef : this.personService.getAllPeople()) {
                authorities.add((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME)));
            }
        }
        if (type != AuthorityType.USER && (container = this.getAuthorityContainer()) != null) {
            for (ChildAssociationRef childRef : this.nodeService.getChildAssocs(container, (QNamePattern)ContentModel.ASSOC_CHILDREN, RegexQNamePattern.MATCH_ALL, false)) {
                this.addAuthorityNameIfMatches(authorities, childRef.getQName().getLocalName(), type, null);
            }
        }
        return authorities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<String> findAuthorities(AuthorityType type, String parentAuthority, boolean immediate, String displayNamePattern, String zoneName) {
        TreeSet<String> treeSet;
        Pattern pattern = displayNamePattern == null ? null : Pattern.compile(SearchLanguageConversion.convert((SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_LUCENE, (SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_REGEX, (String)displayNamePattern), 2);
        Set<String> rootAuthorities = null;
        if (parentAuthority == null && immediate) {
            NodeRef container;
            NodeRef nodeRef = container = zoneName == null ? this.getAuthorityContainer() : this.getZone(zoneName);
            if (container == null) {
                return Collections.emptySet();
            }
            rootAuthorities = this.getRootAuthoritiesUnderContainer(container, type);
            if (pattern == null) {
                return rootAuthorities;
            }
        }
        TreeSet<String> authorities = new TreeSet<String>();
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.storeRef);
        sp.setLanguage("lucene");
        StringBuilder query = new StringBuilder(500);
        if (type == null || type == AuthorityType.USER) {
            if (type == null) {
                query.append("((");
            }
            query.append("TYPE:\"").append(ContentModel.TYPE_PERSON).append("\"");
            if (displayNamePattern != null) {
                query.append(" AND @").append(LuceneQueryParser.escape((String)("{" + ContentModel.PROP_USERNAME.getNamespaceURI() + "}" + ISO9075.encode((String)ContentModel.PROP_USERNAME.getLocalName())))).append(":\"").append(LuceneQueryParser.escape((String)displayNamePattern)).append("\"");
            }
            if (type == null) {
                query.append(") OR (");
            }
        }
        if (type != AuthorityType.USER) {
            query.append("TYPE:\"").append(ContentModel.TYPE_AUTHORITY_CONTAINER).append("\"");
            if (displayNamePattern != null) {
                query.append(" AND (@").append(LuceneQueryParser.escape((String)("{" + ContentModel.PROP_AUTHORITY_NAME.getNamespaceURI() + "}" + ISO9075.encode((String)ContentModel.PROP_AUTHORITY_NAME.getLocalName())))).append(":\"");
                if (type == null && !displayNamePattern.startsWith("*")) {
                    query.append("*").append(LuceneQueryParser.escape((String)displayNamePattern));
                } else {
                    query.append(this.getName(type, LuceneQueryParser.escape((String)displayNamePattern)));
                }
                query.append("\" OR @").append(LuceneQueryParser.escape((String)("{" + ContentModel.PROP_AUTHORITY_DISPLAY_NAME.getNamespaceURI() + "}" + ISO9075.encode((String)ContentModel.PROP_AUTHORITY_DISPLAY_NAME.getLocalName())))).append(":\"").append(LuceneQueryParser.escape((String)displayNamePattern)).append("\")");
            }
            if (type == null) {
                query.append("))");
            }
        }
        if (parentAuthority != null) {
            if (immediate) {
                NodeRef parentAuthorityNodeRef = this.getAuthorityNodeRefOrNull(parentAuthority);
                if (parentAuthorityNodeRef == null) throw new UnknownAuthorityException("An authority was not found for " + parentAuthority);
                query.append(" AND PARENT:\"").append(LuceneQueryParser.escape((String)parentAuthorityNodeRef.toString())).append("\"");
            } else {
                query.append(" AND PATH:\"/sys:system/sys:authorities/cm:").append(ISO9075.encode((String)parentAuthority));
                query.append("//*\"");
            }
        }
        if (zoneName != null) {
            NodeRef zoneNodeRef = this.getZone(zoneName);
            if (zoneNodeRef == null) throw new UnknownAuthorityException("A zone was not found for " + zoneName);
            query.append(" AND PARENT:\"").append(LuceneQueryParser.escape((String)zoneNodeRef.toString())).append("\"");
        }
        sp.setQuery(query.toString());
        sp.setMaxItems(100);
        ResultSet rs = null;
        try {
            rs = this.searchService.query(sp);
            for (ResultSetRow row : rs) {
                NodeRef nodeRef = row.getNodeRef();
                QName idProp = type != AuthorityType.USER || this.dictionaryService.isSubClass(this.nodeService.getType(nodeRef), ContentModel.TYPE_AUTHORITY_CONTAINER) ? ContentModel.PROP_AUTHORITY_NAME : ContentModel.PROP_USERNAME;
                this.addAuthorityNameIfMatches(authorities, (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, idProp)), type, pattern);
            }
            if (rootAuthorities != null) {
                authorities.retainAll(rootAuthorities);
            }
            treeSet = authorities;
            Object var17_16 = null;
            if (rs == null) return treeSet;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
        return treeSet;
    }

    @Override
    public Set<String> getContainedAuthorities(AuthorityType type, String name, boolean immediate) {
        if (AuthorityType.getAuthorityType((String)name).equals((Object)AuthorityType.USER)) {
            return Collections.emptySet();
        }
        NodeRef nodeRef = this.getAuthorityOrNull(name);
        if (nodeRef == null) {
            throw new UnknownAuthorityException("An authority was not found for " + name);
        }
        TreeSet<String> authorities = new TreeSet<String>();
        this.findAuthorities(type, nodeRef, authorities, false, !immediate, false);
        return authorities;
    }

    @Override
    public void removeAuthority(String parentName, String childName) {
        NodeRef parentRef = this.getAuthorityOrNull(parentName);
        if (parentRef == null) {
            throw new UnknownAuthorityException("An authority was not found for " + parentName);
        }
        NodeRef childRef = this.getAuthorityOrNull(childName);
        if (childRef == null) {
            throw new UnknownAuthorityException("An authority was not found for " + childName);
        }
        this.nodeService.removeChild(parentRef, childRef);
        if (AuthorityType.getAuthorityType((String)childName) == AuthorityType.USER) {
            this.userAuthorityCache.remove((Serializable)((Object)childName));
        } else {
            this.userAuthorityCache.clear();
        }
    }

    @Override
    public Set<String> getContainingAuthorities(AuthorityType type, String name, boolean immediate) {
        if (!immediate && AuthorityType.getAuthorityType((String)name) == AuthorityType.USER) {
            TreeSet<String> authorities = (TreeSet<String>)this.userAuthorityCache.get((Serializable)((Object)name));
            if (authorities == null) {
                authorities = new TreeSet<String>();
                this.findAuthorities(null, name, authorities, true, true);
                this.userAuthorityCache.put((Serializable)((Object)name), authorities);
            }
            if (type == null) {
                return authorities;
            }
            TreeSet<String> filteredAuthorities = new TreeSet<String>();
            for (String authority : authorities) {
                this.addAuthorityNameIfMatches(filteredAuthorities, authority, type, null);
            }
            return filteredAuthorities;
        }
        TreeSet<String> authorities = new TreeSet<String>();
        this.findAuthorities(type, name, authorities, true, !immediate);
        return authorities;
    }

    @Override
    public String getShortName(String name) {
        AuthorityType type = AuthorityType.getAuthorityType((String)name);
        if (type.isFixedString()) {
            return "";
        }
        if (type.isPrefixed()) {
            return name.substring(type.getPrefixString().length());
        }
        return name;
    }

    @Override
    public String getName(AuthorityType type, String shortName) {
        if (type.isFixedString()) {
            return type.getFixedString();
        }
        if (type.isPrefixed()) {
            return type.getPrefixString() + shortName;
        }
        return shortName;
    }

    private void addAuthorityNameIfMatches(Set<String> authorities, String authorityName, AuthorityType type, Pattern pattern) {
        if (type == null || AuthorityType.getAuthorityType((String)authorityName).equals((Object)type)) {
            if (pattern == null) {
                authorities.add(authorityName);
            } else if (pattern.matcher(this.getShortName(authorityName)).matches()) {
                authorities.add(authorityName);
            } else {
                String displayName = this.getAuthorityDisplayName(authorityName);
                if (displayName != null && pattern.matcher(displayName).matches()) {
                    authorities.add(authorityName);
                }
            }
        }
    }

    private void findAuthorities(AuthorityType type, String name, Set<String> authorities, boolean parents, boolean recursive) {
        AuthorityType localType = AuthorityType.getAuthorityType((String)name);
        if (!localType.equals((Object)AuthorityType.GUEST)) {
            NodeRef ref = this.getAuthorityOrNull(name);
            if (ref != null) {
                this.findAuthorities(type, ref, authorities, parents, recursive, false);
            } else if (!localType.equals((Object)AuthorityType.USER)) {
                throw new UnknownAuthorityException("An authority was not found for " + name);
            }
        }
    }

    private void findAuthorities(AuthorityType type, NodeRef nodeRef, Set<String> authorities, boolean parents, boolean recursive, boolean includeNode) {
        block5: {
            List cars;
            if (includeNode) {
                String authorityName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, this.dictionaryService.isSubClass(this.nodeService.getType(nodeRef), ContentModel.TYPE_AUTHORITY_CONTAINER) ? ContentModel.PROP_AUTHORITY_NAME : ContentModel.PROP_USERNAME));
                this.addAuthorityNameIfMatches(authorities, authorityName, type, null);
            }
            if (includeNode && !recursive) break block5;
            if (parents) {
                cars = this.nodeService.getParentAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_MEMBER, RegexQNamePattern.MATCH_ALL);
                for (ChildAssociationRef car : cars) {
                    this.findAuthorities(type, car.getParentRef(), authorities, true, recursive, true);
                }
            } else {
                cars = this.nodeService.getChildAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false);
                for (ChildAssociationRef car : cars) {
                    String childName = car.getQName().getLocalName();
                    AuthorityType childType = AuthorityType.getAuthorityType((String)childName);
                    this.addAuthorityNameIfMatches(authorities, childName, type, null);
                    if (!recursive || childType == AuthorityType.USER) continue;
                    this.findAuthorities(type, car.getChildRef(), authorities, false, true, false);
                }
            }
        }
    }

    private NodeRef getAuthorityOrNull(String name) {
        try {
            List results;
            if (AuthorityType.getAuthorityType((String)name).equals((Object)AuthorityType.USER)) {
                return this.personService.getPerson(name, false);
            }
            if (AuthorityType.getAuthorityType((String)name).equals((Object)AuthorityType.GUEST)) {
                return this.personService.getPerson(name, false);
            }
            if (AuthorityType.getAuthorityType((String)name).equals((Object)AuthorityType.ADMIN)) {
                return this.personService.getPerson(name, false);
            }
            Pair<String, String> cacheKey = this.cacheKey(name);
            NodeRef result = (NodeRef)this.authorityLookupCache.get(cacheKey);
            if (result == null && !(results = this.nodeService.getChildAssocs(this.getAuthorityContainer(), (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)QName.createQName((String)"cm", (String)name, (NamespacePrefixResolver)this.namespacePrefixResolver), false)).isEmpty()) {
                result = ((ChildAssociationRef)results.get(0)).getChildRef();
                this.authorityLookupCache.put(cacheKey, (Object)result);
            }
            return result;
        }
        catch (NoSuchPersonException e) {
            return null;
        }
    }

    private NodeRef getAuthorityContainer() {
        return this.getSystemContainer(this.qnameAssocAuthorities);
    }

    private NodeRef getZoneContainer() {
        return this.getSystemContainer(this.qnameAssocZones);
    }

    private NodeRef getSystemContainer(QName assocQName) {
        String cacheKey = this.tenantService.getCurrentUserDomain() + assocQName.toString();
        NodeRef systemContainerRef = this.systemContainerRefs.get(cacheKey);
        if (systemContainerRef == null) {
            NodeRef rootNodeRef = this.nodeService.getRootNode(this.storeRef);
            List results = this.nodeService.getChildAssocs(rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)this.qnameAssocSystem, false);
            if (results.size() == 0) {
                throw new AlfrescoRuntimeException("Required system path not found: " + this.qnameAssocSystem);
            }
            NodeRef sysNodeRef = ((ChildAssociationRef)results.get(0)).getChildRef();
            if ((results = this.nodeService.getChildAssocs(sysNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)assocQName, false)).size() == 0) {
                throw new AlfrescoRuntimeException("Required path not found: " + assocQName);
            }
            systemContainerRef = ((ChildAssociationRef)results.get(0)).getChildRef();
            this.systemContainerRefs.put(cacheKey, systemContainerRef);
        }
        return systemContainerRef;
    }

    @Override
    public NodeRef getAuthorityNodeRefOrNull(String name) {
        return this.getAuthorityOrNull(name);
    }

    @Override
    public String getAuthorityName(NodeRef authorityRef) {
        String name = null;
        if (this.nodeService.exists(authorityRef)) {
            QName type = this.nodeService.getType(authorityRef);
            if (this.dictionaryService.isSubClass(type, ContentModel.TYPE_AUTHORITY_CONTAINER)) {
                name = (String)((Object)this.nodeService.getProperty(authorityRef, ContentModel.PROP_AUTHORITY_NAME));
            } else if (this.dictionaryService.isSubClass(type, ContentModel.TYPE_PERSON)) {
                name = (String)((Object)this.nodeService.getProperty(authorityRef, ContentModel.PROP_USERNAME));
            }
        }
        return name;
    }

    @Override
    public String getAuthorityDisplayName(String authorityName) {
        NodeRef ref = this.getAuthorityOrNull(authorityName);
        if (ref == null) {
            return null;
        }
        Serializable value = this.nodeService.getProperty(ref, ContentModel.PROP_AUTHORITY_DISPLAY_NAME);
        if (value == null) {
            return null;
        }
        return (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
    }

    @Override
    public void setAuthorityDisplayName(String authorityName, String authorityDisplayName) {
        NodeRef ref = this.getAuthorityOrNull(authorityName);
        if (ref == null) {
            return;
        }
        this.nodeService.setProperty(ref, ContentModel.PROP_AUTHORITY_DISPLAY_NAME, (Serializable)((Object)authorityDisplayName));
    }

    @Override
    public NodeRef getOrCreateZone(String zoneName) {
        return this.getOrCreateZone(zoneName, true);
    }

    private NodeRef getOrCreateZone(String zoneName, boolean create) {
        QName zoneQName;
        NodeRef zoneContainerRef = this.getZoneContainer();
        List results = this.nodeService.getChildAssocs(zoneContainerRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)(zoneQName = QName.createQName((String)"cm", (String)zoneName, (NamespacePrefixResolver)this.namespacePrefixResolver)), false);
        if (results.isEmpty()) {
            if (create) {
                HashMap<QName, String> props = new HashMap<QName, String>();
                props.put(ContentModel.PROP_NAME, zoneName);
                return this.nodeService.createNode(zoneContainerRef, ContentModel.ASSOC_CHILDREN, zoneQName, ContentModel.TYPE_ZONE, props).getChildRef();
            }
            return null;
        }
        return ((ChildAssociationRef)results.get(0)).getChildRef();
    }

    @Override
    public NodeRef getZone(String zoneName) {
        return this.getOrCreateZone(zoneName, false);
    }

    @Override
    public Set<String> getAuthorityZones(String name) {
        TreeSet<String> zones = new TreeSet<String>();
        NodeRef childRef = this.getAuthorityOrNull(name);
        if (childRef == null) {
            return null;
        }
        List results = this.nodeService.getParentAssocs(childRef, (QNamePattern)ContentModel.ASSOC_IN_ZONE, RegexQNamePattern.MATCH_ALL);
        if (results.isEmpty()) {
            return zones;
        }
        for (ChildAssociationRef current : results) {
            NodeRef zoneRef = current.getParentRef();
            Serializable value = this.nodeService.getProperty(zoneRef, ContentModel.PROP_NAME);
            if (value == null) continue;
            String zone = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            zones.add(zone);
        }
        return zones;
    }

    @Override
    public Set<String> getAllAuthoritiesInZone(String zoneName, AuthorityType type) {
        TreeSet<String> authorities = new TreeSet<String>();
        NodeRef zoneRef = this.getZone(zoneName);
        if (zoneRef != null) {
            for (ChildAssociationRef childRef : this.nodeService.getChildAssocs(zoneRef, (QNamePattern)ContentModel.ASSOC_IN_ZONE, RegexQNamePattern.MATCH_ALL, false)) {
                this.addAuthorityNameIfMatches(authorities, childRef.getQName().getLocalName(), type, null);
            }
        }
        return authorities;
    }

    @Override
    public void addAuthorityToZones(String authorityName, Set<String> zones) {
        if (zones != null && zones.size() > 0) {
            HashSet<NodeRef> zoneRefs = new HashSet<NodeRef>(zones.size() * 2);
            for (String authorityZone : zones) {
                zoneRefs.add(this.getOrCreateZone(authorityZone));
            }
            NodeRef authRef = this.getAuthorityOrNull(authorityName);
            if (authRef != null) {
                if (AuthorityType.getAuthorityType((String)authorityName) == AuthorityType.USER) {
                    authorityName = (String)((Object)this.nodeService.getProperty(authRef, ContentModel.PROP_USERNAME));
                }
                this.nodeService.addChild(zoneRefs, authRef, ContentModel.ASSOC_IN_ZONE, QName.createQName((String)"cm", (String)authorityName, (NamespacePrefixResolver)this.namespacePrefixResolver));
            }
        }
    }

    @Override
    public void removeAuthorityFromZones(String authorityName, Set<String> zones) {
        if (zones != null && zones.size() > 0) {
            NodeRef authRef = this.getAuthorityOrNull(authorityName);
            List results = this.nodeService.getParentAssocs(authRef, (QNamePattern)ContentModel.ASSOC_IN_ZONE, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef current : results) {
                String testZone;
                NodeRef zoneRef = current.getParentRef();
                Serializable value = this.nodeService.getProperty(zoneRef, ContentModel.PROP_NAME);
                if (value == null || !zones.contains(testZone = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value))) continue;
                this.nodeService.removeChildAssociation(current);
            }
        }
    }

    private Set<String> getRootAuthoritiesUnderContainer(NodeRef container, AuthorityType type) {
        if (type != null && type.equals((Object)AuthorityType.USER)) {
            return Collections.emptySet();
        }
        Collection childRefs = this.nodeService.getChildAssocsWithoutParentAssocsOfType(container, ContentModel.ASSOC_MEMBER);
        TreeSet<String> authorities = new TreeSet<String>();
        for (ChildAssociationRef childRef : childRefs) {
            this.addAuthorityNameIfMatches(authorities, childRef.getQName().getLocalName(), type, null);
        }
        return authorities;
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        this.userAuthorityCache.remove((Serializable)((Object)this.getAuthorityName(nodeRef)));
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        boolean isAuthority = this.dictionaryService.isSubClass(this.nodeService.getType(nodeRef), ContentModel.TYPE_AUTHORITY_CONTAINER);
        QName idProp = isAuthority ? ContentModel.PROP_AUTHORITY_NAME : ContentModel.PROP_USERNAME;
        String authBefore = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)before.get(idProp));
        if (authBefore == null) {
            return;
        }
        String authAfter = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)after.get(idProp));
        if (!EqualsHelper.nullSafeEquals((Object)authBefore, (Object)authAfter)) {
            if (authBefore.equalsIgnoreCase(authAfter)) {
                if (isAuthority) {
                    if (authBefore != null) {
                        this.aclDao.renameAuthority(authBefore, authAfter);
                    }
                    QName newAssocQName = QName.createQName((String)"cm", (String)authAfter, (NamespacePrefixResolver)this.namespacePrefixResolver);
                    ChildAssociationRef assoc = this.nodeService.getPrimaryParent(nodeRef);
                    this.nodeService.moveNode(nodeRef, assoc.getParentRef(), assoc.getTypeQName(), newAssocQName);
                    QName oldAssocQName = QName.createQName((String)"cm", (String)authBefore, (NamespacePrefixResolver)this.namespacePrefixResolver);
                    newAssocQName = QName.createQName((String)"cm", (String)authAfter, (NamespacePrefixResolver)this.namespacePrefixResolver);
                    for (ChildAssociationRef parent : this.nodeService.getParentAssocs(nodeRef)) {
                        if (parent.isPrimary() || !parent.getQName().equals((Object)oldAssocQName)) continue;
                        this.nodeService.removeChildAssociation(parent);
                        this.nodeService.addChild(parent.getParentRef(), parent.getChildRef(), parent.getTypeQName(), newAssocQName);
                    }
                    this.authorityLookupCache.clear();
                    this.userAuthorityCache.clear();
                } else {
                    this.userAuthorityCache.remove((Serializable)((Object)authBefore));
                }
            } else {
                throw new UnsupportedOperationException("The name of an authority can not be changed");
            }
        }
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), ContentModel.TYPE_AUTHORITY, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
    }
}

