/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.AbstractPermissionReference;
import org.alfresco.repo.security.permissions.impl.PermissionReferenceImpl;
import org.alfresco.repo.security.permissions.impl.model.PermissionModel;
import org.alfresco.repo.security.permissions.impl.model.XMLModelInitialisable;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.dom4j.Attribute;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PermissionGroup
extends AbstractPermissionReference
implements XMLModelInitialisable {
    private static final long serialVersionUID = 7879839657714155737L;
    private static final String NAME = "name";
    private static final String EXTENDS = "extends";
    private static final String ALLOW_FULL_CONTOL = "allowFullControl";
    private static final String INCLUDE_PERMISSION_GROUP = "includePermissionGroup";
    private static final String PERMISSION_GROUP = "permissionGroup";
    private static final String TYPE = "type";
    private static final String EXPOSE = "expose";
    private static final String REQUIRES_TYPE = "requiresType";
    private String name;
    private QName type;
    private boolean extendz;
    private boolean isExposed;
    private boolean allowFullControl;
    private QName container;
    private Set<PermissionReference> includedPermissionGroups = new HashSet<PermissionReference>(4, 1.0f);
    private boolean requiresType;

    public PermissionGroup(QName container) {
        this.container = container;
    }

    @Override
    public void initialise(Element element, NamespacePrefixResolver nspr, PermissionModel permissionModel) {
        this.name = element.attributeValue(NAME);
        Attribute att = element.attribute(ALLOW_FULL_CONTOL);
        this.allowFullControl = att != null ? Boolean.parseBoolean(att.getStringValue()) : false;
        att = element.attribute(REQUIRES_TYPE);
        this.requiresType = att != null ? Boolean.parseBoolean(att.getStringValue()) : true;
        att = element.attribute(EXTENDS);
        this.extendz = att != null ? Boolean.parseBoolean(att.getStringValue()) : false;
        att = element.attribute(EXPOSE);
        this.isExposed = att != null ? Boolean.parseBoolean(att.getStringValue()) : true;
        att = element.attribute(TYPE);
        this.type = att != null ? QName.createQName((String)att.getStringValue(), (NamespacePrefixResolver)nspr) : null;
        Iterator ipgit = element.elementIterator(INCLUDE_PERMISSION_GROUP);
        while (ipgit.hasNext()) {
            Element includePermissionGroupElement = (Element)ipgit.next();
            Attribute typeAttribute = includePermissionGroupElement.attribute(TYPE);
            QName qName = typeAttribute != null ? QName.createQName((String)typeAttribute.getStringValue(), (NamespacePrefixResolver)nspr) : this.container;
            String refName = includePermissionGroupElement.attributeValue(PERMISSION_GROUP);
            PermissionReferenceImpl permissionReference = PermissionReferenceImpl.getPermissionReference(qName, refName);
            this.includedPermissionGroups.add(permissionReference);
        }
    }

    public Set<PermissionReference> getIncludedPermissionGroups() {
        return Collections.unmodifiableSet(this.includedPermissionGroups);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isAllowFullControl() {
        return this.allowFullControl;
    }

    @Override
    public QName getQName() {
        return this.container;
    }

    public boolean isExtends() {
        return this.extendz;
    }

    public QName getTypeQName() {
        return this.type;
    }

    public boolean isExposed() {
        return this.isExposed;
    }

    public boolean isTypeRequired() {
        return this.requiresType;
    }
}

