/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.noop;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.security.permissions.NodePermissionEntry;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.permissions.impl.PermissionReferenceImpl;
import org.alfresco.repo.security.permissions.impl.SimpleNodePermissionEntry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionContext;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionServiceNOOPImpl
implements PermissionServiceSPI {
    public String getOwnerAuthority() {
        return "ROLE_OWNER";
    }

    public String getAllAuthorities() {
        return "GROUP_EVERYONE";
    }

    public String getAllPermission() {
        return "All";
    }

    public Set<AccessPermission> getPermissions(NodeRef nodeRef) {
        return Collections.emptySet();
    }

    public Set<AccessPermission> getAllSetPermissions(NodeRef nodeRef) {
        return Collections.emptySet();
    }

    public Set<String> getSettablePermissions(NodeRef nodeRef) {
        return this.getSettablePermissions((QName)null);
    }

    public Set<String> getSettablePermissions(QName type) {
        HashSet<String> permissions = new HashSet<String>();
        permissions.add("All");
        return permissions;
    }

    public AccessStatus hasPermission(NodeRef nodeRef, String perm) {
        return AccessStatus.ALLOWED;
    }

    public void deletePermissions(NodeRef nodeRef) {
    }

    public void deletePermission(NodeRef nodeRef, String authority, String perm) {
    }

    public void setPermission(NodeRef nodeRef, String authority, String perm, boolean allow) {
    }

    public void setInheritParentPermissions(NodeRef nodeRef, boolean inheritParentPermissions) {
    }

    public boolean getInheritParentPermissions(NodeRef nodeRef) {
        return true;
    }

    public void clearPermission(NodeRef nodeRef, String authority) {
    }

    @Override
    public void deletePermission(PermissionEntry permissionEntry) {
    }

    @Override
    public void deletePermissions(NodePermissionEntry nodePermissionEntry) {
    }

    @Override
    public void deletePermissions(String recipient) {
    }

    @Override
    public NodePermissionEntry explainPermission(NodeRef nodeRef, PermissionReference perm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PermissionReference getAllPermissionReference() {
        return this.getPermissionReference("All");
    }

    @Override
    public String getPermission(PermissionReference permissionReference) {
        return permissionReference.toString();
    }

    @Override
    public PermissionReference getPermissionReference(QName qname, String permissionName) {
        return PermissionReferenceImpl.getPermissionReference(qname, permissionName);
    }

    @Override
    public PermissionReference getPermissionReference(String permissionName) {
        return PermissionReferenceImpl.getPermissionReference(QName.createQName((String)"uri", (String)"local"), permissionName);
    }

    @Override
    public NodePermissionEntry getSetPermissions(NodeRef nodeRef) {
        return new SimpleNodePermissionEntry(nodeRef, true, Collections.emptyList());
    }

    @Override
    public Set<PermissionReference> getSettablePermissionReferences(NodeRef nodeRef) {
        return Collections.emptySet();
    }

    @Override
    public Set<PermissionReference> getSettablePermissionReferences(QName type) {
        return Collections.emptySet();
    }

    @Override
    public AccessStatus hasPermission(NodeRef nodeRef, PermissionReference perm) {
        return AccessStatus.ALLOWED;
    }

    public AccessStatus hasPermission(Long aclID, PermissionContext context, String permission) {
        return AccessStatus.ALLOWED;
    }

    @Override
    public void setPermission(NodePermissionEntry nodePermissionEntry) {
    }

    @Override
    public void setPermission(PermissionEntry permissionEntry) {
    }

    public Map<NodeRef, Set<AccessPermission>> getAllSetPermissionsForCurrentUser() {
        return Collections.emptyMap();
    }

    public Map<NodeRef, Set<AccessPermission>> getAllSetPermissionsForAuthority(String authority) {
        return Collections.emptyMap();
    }

    public Set<NodeRef> findNodesByAssignedPermissionForCurrentUser(String permission, boolean allow, boolean includeContainingAuthorities, boolean exactPermissionMatch) {
        return Collections.emptySet();
    }

    public Set<NodeRef> findNodesByAssignedPermission(String authority, String permission, boolean allow, boolean includeContainingAuthorities, boolean exactPermissionMatch) {
        return Collections.emptySet();
    }

    public void clearPermission(StoreRef storeRef, String authority) {
    }

    public void deletePermission(StoreRef storeRef, String authority, String permission) {
    }

    public void deletePermissions(StoreRef storeRef) {
    }

    public void setPermission(StoreRef storeRef, String authority, String permission, boolean allow) {
    }

    public Set<AccessPermission> getAllSetPermissions(StoreRef storeRef) {
        return Collections.emptySet();
    }

    @Override
    public NodePermissionEntry getSetPermissions(StoreRef storeRef) {
        return new SimpleNodePermissionEntry(null, true, Collections.emptyList());
    }

    public AccessStatus hasReadPermission(NodeRef nodeRef) {
        return AccessStatus.ALLOWED;
    }

    public Set<String> getAuthorisations() {
        return new HashSet<String>();
    }
}

