/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.person.HomeFolderManager;
import org.alfresco.repo.security.person.PermissionsManager;
import org.alfresco.repo.security.person.PersonException;
import org.alfresco.repo.security.person.UserNameMatcher;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonServiceImpl
extends TransactionListenerAdapter
implements PersonService,
NodeServicePolicies.BeforeCreateNodePolicy,
NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy {
    private static Log logger = LogFactory.getLog(PersonServiceImpl.class);
    private static final String DELETE = "DELETE";
    private static final String SPLIT = "SPLIT";
    private static final String LEAVE = "LEAVE";
    public static final String SYSTEM_FOLDER_SHORT_QNAME = "sys:system";
    public static final String PEOPLE_FOLDER_SHORT_QNAME = "sys:people";
    private StoreRef storeRef;
    private TransactionService transactionService;
    private NodeService nodeService;
    private TenantService tenantService;
    private SearchService searchService;
    private AuthorityService authorityService;
    private MutableAuthenticationService authenticationService;
    private DictionaryService dictionaryService;
    private PermissionServiceSPI permissionServiceSPI;
    private NamespacePrefixResolver namespacePrefixResolver;
    private HomeFolderManager homeFolderManager;
    private PolicyComponent policyComponent;
    private BehaviourFilter policyBehaviourFilter;
    private boolean createMissingPeople;
    private static Set<QName> mutableProperties;
    private String defaultHomeFolderProvider;
    private boolean processDuplicates = true;
    private String duplicateMode = "LEAVE";
    private boolean lastIsBest = true;
    private boolean includeAutoCreated = false;
    private AclDAO aclDao;
    private PermissionsManager permissionsManager;
    private SimpleCache<String, Set<NodeRef>> personCache;
    private Map<String, NodeRef> peopleContainerRefs = new ConcurrentHashMap<String, NodeRef>(4);
    private UserNameMatcher userNameMatcher;
    private JavaBehaviour beforeCreateNodeValidationBehaviour;
    private JavaBehaviour beforeDeleteNodeValidationBehaviour;
    private static final String KEY_POST_TXN_DUPLICATES = "PersonServiceImpl.KEY_POST_TXN_DUPLICATES";
    private static final String KEY_ALLOW_UID_UPDATE = "PersonServiceImpl.KEY_ALLOW_UID_UPDATE";

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return 1;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"storeUrl", (Object)this.storeRef);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"permissionServiceSPI", (Object)this.permissionServiceSPI);
        PropertyCheck.mandatory((Object)this, (String)"authorityService", (Object)this.authorityService);
        PropertyCheck.mandatory((Object)this, (String)"authenticationService", (Object)this.authenticationService);
        PropertyCheck.mandatory((Object)this, (String)"namespacePrefixResolver", (Object)this.namespacePrefixResolver);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"personCache", this.personCache);
        PropertyCheck.mandatory((Object)this, (String)"aclDao", (Object)this.aclDao);
        PropertyCheck.mandatory((Object)this, (String)"homeFolderManager", (Object)this.homeFolderManager);
        this.beforeCreateNodeValidationBehaviour = new JavaBehaviour(this, "beforeCreateNodeValidation");
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeCreateNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)this.beforeCreateNodeValidationBehaviour);
        this.beforeDeleteNodeValidationBehaviour = new JavaBehaviour(this, "beforeDeleteNodeValidation");
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)this.beforeDeleteNodeValidationBehaviour);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
    }

    public UserNameMatcher getUserNameMatcher() {
        return this.userNameMatcher;
    }

    public void setUserNameMatcher(UserNameMatcher userNameMatcher) {
        this.userNameMatcher = userNameMatcher;
    }

    void setDefaultHomeFolderProvider(String defaultHomeFolderProvider) {
        this.defaultHomeFolderProvider = defaultHomeFolderProvider;
    }

    public void setDuplicateMode(String duplicateMode) {
        this.duplicateMode = duplicateMode;
    }

    public void setIncludeAutoCreated(boolean includeAutoCreated) {
        this.includeAutoCreated = includeAutoCreated;
    }

    public void setLastIsBest(boolean lastIsBest) {
        this.lastIsBest = lastIsBest;
    }

    public void setProcessDuplicates(boolean processDuplicates) {
        this.processDuplicates = processDuplicates;
    }

    public void setHomeFolderManager(HomeFolderManager homeFolderManager) {
        this.homeFolderManager = homeFolderManager;
    }

    public void setAclDAO(AclDAO aclDao) {
        this.aclDao = aclDao;
    }

    public void setPermissionsManager(PermissionsManager permissionsManager) {
        this.permissionsManager = permissionsManager;
    }

    public void setPersonCache(SimpleCache<String, Set<NodeRef>> personCache) {
        this.personCache = personCache;
    }

    @Override
    public NodeRef getPerson(String userName) {
        return this.getPerson(userName, true);
    }

    @Override
    public NodeRef getPerson(final String userName, final boolean autoCreate) {
        if (this.tenantService.isEnabled() && "System".equals(AuthenticationUtil.getRunAsUser()) && this.tenantService.isTenantUser(userName)) {
            String tenantDomain = this.tenantService.getUserDomain(userName);
            return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return PersonServiceImpl.this.getPersonImpl(userName, autoCreate);
                }
            }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
        }
        return this.getPersonImpl(userName, autoCreate);
    }

    private NodeRef getPersonImpl(String userName, boolean autoCreate) {
        if (userName == null) {
            return null;
        }
        if (userName.length() == 0) {
            return null;
        }
        NodeRef personNode = this.getPersonOrNull(userName);
        if (personNode == null) {
            AlfrescoTransactionSupport.TxnReadState txnReadState = AlfrescoTransactionSupport.getTransactionReadState();
            if (autoCreate && this.createMissingPeople() && txnReadState == AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
                return this.createMissingPerson(userName);
            }
            throw new NoSuchPersonException(userName);
        }
        if (autoCreate) {
            this.makeHomeFolderIfRequired(personNode);
        }
        return personNode;
    }

    @Override
    public boolean personExists(String caseSensitiveUserName) {
        return this.getPersonOrNull(caseSensitiveUserName) != null;
    }

    private NodeRef getPersonOrNull(String searchUserName) {
        Set<NodeRef> allRefs = this.getFromCache(searchUserName);
        boolean addToCache = false;
        if (allRefs == null) {
            List childRefs = this.nodeService.getChildAssocs(this.getPeopleContainer(), (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)this.getChildNameLower(searchUserName), false);
            allRefs = new LinkedHashSet<NodeRef>(childRefs.size() * 2);
            for (ChildAssociationRef childRef : childRefs) {
                NodeRef nodeRef = childRef.getChildRef();
                allRefs.add(nodeRef);
            }
            addToCache = true;
        }
        ArrayList<NodeRef> refs = new ArrayList<NodeRef>(allRefs.size());
        for (NodeRef nodeRef : allRefs) {
            Serializable value = this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME);
            String realUserName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            if (!this.userNameMatcher.matches(searchUserName, realUserName)) continue;
            refs.add(nodeRef);
        }
        NodeRef returnRef = null;
        if (refs.size() > 1) {
            returnRef = this.handleDuplicates(refs, searchUserName);
        } else if (refs.size() == 1) {
            returnRef = (NodeRef)refs.get(0);
            if (addToCache) {
                this.putToCache(searchUserName, allRefs);
            }
        }
        return returnRef;
    }

    private NodeRef handleDuplicates(List<NodeRef> refs, String searchUserName) {
        if (this.processDuplicates) {
            NodeRef best = this.findBest(refs);
            HashSet<NodeRef> toHandle = new HashSet<NodeRef>();
            toHandle.addAll(refs);
            toHandle.remove(best);
            this.addDuplicateNodeRefsToHandle(toHandle);
            return best;
        }
        String userNameSensitivity = " (user name is case-" + (this.userNameMatcher.getUserNamesAreCaseSensitive() ? "sensitive" : "insensitive") + ")";
        String domainNameSensitivity = "";
        if (!this.userNameMatcher.getDomainSeparator().equals("")) {
            domainNameSensitivity = " (domain name is case-" + (this.userNameMatcher.getDomainNamesAreCaseSensitive() ? "sensitive" : "insensitive") + ")";
        }
        throw new AlfrescoRuntimeException("Found more than one user for " + searchUserName + userNameSensitivity + domainNameSensitivity);
    }

    private Set<NodeRef> getPostTxnDuplicates() {
        HashSet postTxnDuplicates = (HashSet)AlfrescoTransactionSupport.getResource(KEY_POST_TXN_DUPLICATES);
        if (postTxnDuplicates == null) {
            postTxnDuplicates = new HashSet();
            AlfrescoTransactionSupport.bindResource(KEY_POST_TXN_DUPLICATES, postTxnDuplicates);
        }
        return postTxnDuplicates;
    }

    private void addDuplicateNodeRefsToHandle(Set<NodeRef> refs) {
        AlfrescoTransactionSupport.bindListener(this);
        Set<NodeRef> postTxnDuplicates = this.getPostTxnDuplicates();
        postTxnDuplicates.addAll(refs);
    }

    @Override
    public void afterCommit() {
        final Set<NodeRef> postTxnDuplicates = this.getPostTxnDuplicates();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> processDuplicateWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute() throws Throwable {
                try {
                    PersonServiceImpl.this.policyBehaviourFilter.disableBehaviour(ContentModel.TYPE_PERSON);
                    if (PersonServiceImpl.this.duplicateMode.equalsIgnoreCase(PersonServiceImpl.SPLIT)) {
                        AlfrescoTransactionSupport.bindResource(PersonServiceImpl.KEY_ALLOW_UID_UPDATE, Boolean.TRUE);
                        PersonServiceImpl.this.split(postTxnDuplicates);
                        logger.info((Object)"Split duplicate person objects");
                    } else if (PersonServiceImpl.this.duplicateMode.equalsIgnoreCase(PersonServiceImpl.DELETE)) {
                        PersonServiceImpl.this.delete(postTxnDuplicates);
                        logger.info((Object)"Deleted duplicate person objects");
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Duplicate person objects exist");
                    }
                    Object var2_1 = null;
                    PersonServiceImpl.this.policyBehaviourFilter.enableBehaviour(ContentModel.TYPE_PERSON);
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    PersonServiceImpl.this.policyBehaviourFilter.enableBehaviour(ContentModel.TYPE_PERSON);
                    throw throwable;
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(processDuplicateWork, false, true);
    }

    private void delete(Set<NodeRef> toDelete) {
        for (NodeRef nodeRef : toDelete) {
            this.nodeService.deleteNode(nodeRef);
        }
    }

    private void split(Set<NodeRef> toSplit) {
        for (NodeRef nodeRef : toSplit) {
            String userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_USERNAME, (Serializable)((Object)(userName + GUID.generate())));
        }
    }

    private NodeRef findBest(List<NodeRef> refs) {
        if (this.lastIsBest) {
            Collections.sort(refs, new NodeIdComparator(this.nodeService, false));
        } else {
            Collections.sort(refs, new NodeIdComparator(this.nodeService, true));
        }
        NodeRef fallBack = null;
        for (NodeRef nodeRef : refs) {
            if (fallBack == null) {
                fallBack = nodeRef;
            }
            if (!this.includeAutoCreated && this.wasAutoCreated(nodeRef)) continue;
            return nodeRef;
        }
        return fallBack;
    }

    private boolean wasAutoCreated(NodeRef nodeRef) {
        String userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
        String testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_FIRSTNAME));
        if (testString == null || !testString.equals(userName)) {
            return false;
        }
        testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LASTNAME));
        if (testString == null || !testString.equals("")) {
            return false;
        }
        testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_EMAIL));
        if (testString == null || !testString.equals("")) {
            return false;
        }
        testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_ORGID));
        if (testString == null || !testString.equals("")) {
            return false;
        }
        testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_HOME_FOLDER_PROVIDER));
        return testString != null && testString.equals(this.defaultHomeFolderProvider);
    }

    @Override
    public boolean createMissingPeople() {
        return this.createMissingPeople;
    }

    @Override
    public Set<QName> getMutableProperties() {
        return mutableProperties;
    }

    @Override
    public void setPersonProperties(String userName, Map<QName, Serializable> properties) {
        this.setPersonProperties(userName, properties, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setPersonProperties(String userName, Map<QName, Serializable> properties, boolean autoCreate) {
        NodeRef personNode = this.getPersonOrNull(userName);
        if (personNode == null) {
            if (!this.createMissingPeople()) throw new PersonException("No person found for user name " + userName);
            personNode = this.createMissingPerson(userName);
        } else {
            String suggestedUserName;
            if (autoCreate) {
                this.makeHomeFolderIfRequired(personNode);
            }
            String realUserName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(personNode, ContentModel.PROP_USERNAME));
            if (this.getUserNamesAreCaseSensitive() || (suggestedUserName = (String)((Object)properties.get(ContentModel.PROP_USERNAME))) == null || !suggestedUserName.equalsIgnoreCase(realUserName)) {
                properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)realUserName));
            }
        }
        Map update = this.nodeService.getProperties(personNode);
        update.putAll(properties);
        this.nodeService.setProperties(personNode, update);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    private NodeRef createMissingPerson(String userName) {
        HashMap<QName, Serializable> properties = this.getDefaultProperties(userName);
        NodeRef person = this.createPerson(properties);
        return person;
    }

    private void makeHomeFolderIfRequired(NodeRef person) {
        NodeRef homeFolder;
        if (person != null && (homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER))) == null) {
            final ChildAssociationRef ref = this.nodeService.getPrimaryParent(person);
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    PersonServiceImpl.this.homeFolderManager.makeHomeFolder(ref);
                    return null;
                }
            }, this.transactionService.isReadOnly(), this.transactionService.isReadOnly() ? false : AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY);
        }
    }

    private HashMap<QName, Serializable> getDefaultProperties(String userName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        properties.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)this.tenantService.getBaseNameUser(userName)));
        properties.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)""));
        properties.put(ContentModel.PROP_EMAIL, (Serializable)((Object)""));
        properties.put(ContentModel.PROP_ORGID, (Serializable)((Object)""));
        properties.put(ContentModel.PROP_HOME_FOLDER_PROVIDER, (Serializable)((Object)this.defaultHomeFolderProvider));
        properties.put(ContentModel.PROP_SIZE_CURRENT, Long.valueOf(0L));
        properties.put(ContentModel.PROP_SIZE_QUOTA, Long.valueOf(-1L));
        return properties;
    }

    @Override
    public NodeRef createPerson(Map<QName, Serializable> properties) {
        return this.createPerson(properties, this.authorityService.getDefaultZones());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef createPerson(Map<QName, Serializable> properties, Set<String> zones) {
        String userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_USERNAME));
        AuthorityType authorityType = AuthorityType.getAuthorityType((String)userName);
        if (authorityType != AuthorityType.USER) {
            throw new AlfrescoRuntimeException("Attempt to create person for an authority which is not a user");
        }
        this.tenantService.checkDomainUser(userName);
        if (this.personExists(userName)) {
            throw new AlfrescoRuntimeException("Person '" + userName + "' already exists.");
        }
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        properties.put(ContentModel.PROP_SIZE_CURRENT, Long.valueOf(0L));
        NodeRef personRef = null;
        try {
            this.beforeCreateNodeValidationBehaviour.disable();
            personRef = this.nodeService.createNode(this.getPeopleContainer(), ContentModel.ASSOC_CHILDREN, this.getChildNameLower(userName), ContentModel.TYPE_PERSON, properties).getChildRef();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.beforeCreateNodeValidationBehaviour.enable();
            throw throwable;
        }
        this.beforeCreateNodeValidationBehaviour.enable();
        if (zones != null) {
            for (String zone : zones) {
                this.nodeService.addChild(this.authorityService.getOrCreateZone(zone), personRef, ContentModel.ASSOC_IN_ZONE, QName.createQName((String)"cm", (String)userName, (NamespacePrefixResolver)this.namespacePrefixResolver));
            }
        }
        this.removeFromCache(userName);
        return personRef;
    }

    @Override
    public NodeRef getPeopleContainer() {
        String cacheKey = this.tenantService.getCurrentUserDomain();
        NodeRef peopleNodeRef = this.peopleContainerRefs.get(cacheKey);
        if (peopleNodeRef == null) {
            NodeRef rootNodeRef = this.nodeService.getRootNode(this.tenantService.getName(this.storeRef));
            List children = this.nodeService.getChildAssocs(rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)SYSTEM_FOLDER_SHORT_QNAME, (NamespacePrefixResolver)this.namespacePrefixResolver), false);
            if (children.size() == 0) {
                throw new AlfrescoRuntimeException("Required people system path not found: sys:system");
            }
            NodeRef systemNodeRef = ((ChildAssociationRef)children.get(0)).getChildRef();
            if ((children = this.nodeService.getChildAssocs(systemNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)PEOPLE_FOLDER_SHORT_QNAME, (NamespacePrefixResolver)this.namespacePrefixResolver), false)).size() == 0) {
                throw new AlfrescoRuntimeException("Required people system path not found: sys:people");
            }
            peopleNodeRef = ((ChildAssociationRef)children.get(0)).getChildRef();
            this.peopleContainerRefs.put(cacheKey, peopleNodeRef);
        }
        return peopleNodeRef;
    }

    @Override
    public void deletePerson(String userName) {
        if ((userName = this.getUserIdentifier(userName)) == null) {
            return;
        }
        NodeRef personRef = this.getPersonOrNull(userName);
        this.deletePersonImpl(userName, personRef);
    }

    @Override
    public void deletePerson(NodeRef personRef) {
        QName typeQName = this.nodeService.getType(personRef);
        if (!typeQName.equals((Object)ContentModel.TYPE_PERSON)) {
            throw new AlfrescoRuntimeException("deletePerson: invalid type of node " + personRef + " (actual=" + typeQName + ", expected=" + ContentModel.TYPE_PERSON + ")");
        }
        String userName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME));
        this.deletePersonImpl(userName, personRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePersonImpl(String userName, NodeRef personRef) {
        if (userName != null) {
            try {
                this.authenticationService.deleteAuthentication(userName);
            }
            catch (AuthenticationException e) {
                // empty catch block
            }
            try {
                this.authenticationService.invalidateUserSession(userName);
            }
            catch (AuthenticationException authenticationException) {
                // empty catch block
            }
            this.permissionServiceSPI.deletePermissions(userName);
        }
        if (personRef != null) {
            try {
                this.beforeDeleteNodeValidationBehaviour.disable();
                this.nodeService.deleteNode(personRef);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.beforeDeleteNodeValidationBehaviour.enable();
                throw throwable;
            }
            this.beforeDeleteNodeValidationBehaviour.enable();
            {
            }
        }
    }

    @Override
    public Set<NodeRef> getAllPeople() {
        List childRefs = this.nodeService.getChildAssocs(this.getPeopleContainer(), (QNamePattern)ContentModel.ASSOC_CHILDREN, RegexQNamePattern.MATCH_ALL, false);
        HashSet<NodeRef> refs = new HashSet<NodeRef>(childRefs.size() * 2);
        for (ChildAssociationRef childRef : childRefs) {
            refs.add(childRef.getChildRef());
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<NodeRef> getPeopleFilteredByProperty(QName propertyKey, Serializable propertyValue) {
        if (this.dictionaryService.getProperty(ContentModel.TYPE_PERSON, propertyKey) == null) {
            throw new AlfrescoRuntimeException("Property '" + propertyKey + "' is not defined " + "for content model type cm:person");
        }
        LinkedHashSet<NodeRef> people = new LinkedHashSet<NodeRef>();
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("lucene");
        sp.setQuery("@cm\\:" + propertyKey.getLocalName() + ":\"" + propertyValue + "\"");
        sp.addStore(this.tenantService.getName(this.storeRef));
        sp.excludeDataInTheCurrentTransaction(false);
        ResultSet rs = null;
        try {
            rs = this.searchService.query(sp);
            for (ResultSetRow row : rs) {
                NodeRef nodeRef = row.getNodeRef();
                if (!this.nodeService.exists(nodeRef)) continue;
                people.add(nodeRef);
            }
            Object var10_9 = null;
            if (rs == null) return people;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
        return people;
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef personRef = childAssocRef.getChildRef();
        String userName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME));
        if (this.getPeopleContainer().equals((Object)childAssocRef.getParentRef())) {
            this.removeFromCache(userName);
        }
        this.permissionsManager.setPermissions(personRef, userName, userName);
        this.homeFolderManager.onCreateNode(childAssocRef);
    }

    private QName getChildNameLower(String userName) {
        return QName.createQName((String)"cm", (String)userName.toLowerCase(), (NamespacePrefixResolver)this.namespacePrefixResolver);
    }

    @Override
    public void beforeCreateNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) {
    }

    public void beforeCreateNodeValidation(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) {
        if (this.getPeopleContainer().equals((Object)parentRef)) {
            throw new AlfrescoRuntimeException("beforeCreateNode: use PersonService to create person");
        }
        logger.info((Object)("Person node is not being created under the people container (actual=" + parentRef + ", expected=" + this.getPeopleContainer() + ")"));
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        String userName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
        if (this.authorityService.isGuestAuthority(userName)) {
            throw new AlfrescoRuntimeException("The " + userName + " user cannot be deleted.");
        }
        NodeRef parentRef = null;
        ChildAssociationRef parentAssocRef = this.nodeService.getPrimaryParent(nodeRef);
        if (parentAssocRef != null) {
            parentRef = parentAssocRef.getParentRef();
            if (this.getPeopleContainer().equals((Object)parentRef)) {
                this.removeFromCache(userName);
            }
        }
    }

    public void beforeDeleteNodeValidation(NodeRef nodeRef) {
        NodeRef parentRef = null;
        ChildAssociationRef parentAssocRef = this.nodeService.getPrimaryParent(nodeRef);
        if (parentAssocRef != null) {
            parentRef = parentAssocRef.getParentRef();
        }
        if (this.getPeopleContainer().equals((Object)parentRef)) {
            throw new AlfrescoRuntimeException("beforeDeleteNode: use PersonService to delete person");
        }
        logger.info((Object)("Person node that is being deleted is not under the parent people container (actual=" + parentRef + ", expected=" + this.getPeopleContainer() + ")"));
    }

    private Set<NodeRef> getFromCache(String userName) {
        return (Set)this.personCache.get((Serializable)((Object)userName.toLowerCase()));
    }

    private void putToCache(String userName, Set<NodeRef> refs) {
        this.personCache.put((Serializable)((Object)userName.toLowerCase()), refs);
    }

    private void removeFromCache(String userName) {
        this.personCache.remove((Serializable)((Object)userName.toLowerCase()));
    }

    @Override
    public void setCreateMissingPeople(boolean createMissingPeople) {
        this.createMissingPeople = createMissingPeople;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPermissionServiceSPI(PermissionServiceSPI permissionServiceSPI) {
        this.permissionServiceSPI = permissionServiceSPI;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }

    public void setStoreUrl(String storeUrl) {
        this.storeRef = new StoreRef(storeUrl);
    }

    @Override
    public String getUserIdentifier(String caseSensitiveUserName) {
        NodeRef nodeRef = this.getPersonOrNull(caseSensitiveUserName);
        if (nodeRef != null && this.nodeService.exists(nodeRef)) {
            String realUserName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
            return realUserName;
        }
        return null;
    }

    @Override
    public boolean getUserNamesAreCaseSensitive() {
        return this.userNameMatcher.getUserNamesAreCaseSensitive();
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        String uidBefore = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)before.get(ContentModel.PROP_USERNAME));
        if (uidBefore == null) {
            return;
        }
        String uidAfter = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)after.get(ContentModel.PROP_USERNAME));
        if (!EqualsHelper.nullSafeEquals((Object)uidBefore, (Object)uidAfter)) {
            if (AlfrescoTransactionSupport.getResource(KEY_ALLOW_UID_UPDATE) != null || uidBefore.equalsIgnoreCase(uidAfter)) {
                if (uidBefore != null) {
                    this.aclDao.renameAuthority(uidBefore, uidAfter);
                }
                QName newAssocQName = this.getChildNameLower(uidAfter);
                ChildAssociationRef assoc = this.nodeService.getPrimaryParent(nodeRef);
                this.nodeService.moveNode(nodeRef, assoc.getParentRef(), assoc.getTypeQName(), newAssocQName);
                QName oldAssocQName = QName.createQName((String)"cm", (String)uidBefore, (NamespacePrefixResolver)this.namespacePrefixResolver);
                newAssocQName = QName.createQName((String)"cm", (String)uidAfter, (NamespacePrefixResolver)this.namespacePrefixResolver);
                for (ChildAssociationRef parent : this.nodeService.getParentAssocs(nodeRef)) {
                    if (parent.isPrimary() || !parent.getQName().equals((Object)oldAssocQName)) continue;
                    this.nodeService.removeChildAssociation(parent);
                    this.nodeService.addChild(parent.getParentRef(), parent.getChildRef(), parent.getTypeQName(), newAssocQName);
                }
                this.removeFromCache(uidBefore);
            } else {
                throw new UnsupportedOperationException("The user name on a person can not be changed");
            }
        }
    }

    static {
        HashSet<QName> props = new HashSet<QName>();
        props.add(ContentModel.PROP_HOMEFOLDER);
        props.add(ContentModel.PROP_FIRSTNAME);
        props.add(ContentModel.PROP_LASTNAME);
        props.add(ContentModel.PROP_EMAIL);
        props.add(ContentModel.PROP_ORGID);
        mutableProperties = Collections.unmodifiableSet(props);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeIdComparator
    implements Comparator<NodeRef> {
        private NodeService nodeService;
        boolean ascending;

        NodeIdComparator(NodeService nodeService, boolean ascending) {
            this.nodeService = nodeService;
            this.ascending = ascending;
        }

        @Override
        public int compare(NodeRef first, NodeRef second) {
            Long firstId = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.nodeService.getProperty(first, ContentModel.PROP_NODE_DBID));
            Long secondId = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.nodeService.getProperty(second, ContentModel.PROP_NODE_DBID));
            if (firstId != null) {
                if (secondId != null) {
                    return firstId.compareTo(secondId) * (this.ascending ? 1 : -1);
                }
                return this.ascending ? -1 : 1;
            }
            if (secondId != null) {
                return this.ascending ? 1 : -1;
            }
            return 0;
        }
    }
}

