/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tagging.TagDetailsImpl;
import org.alfresco.repo.tagging.TaggingServiceImpl;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.tagging.TagDetails;
import org.alfresco.service.cmr.tagging.TaggingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshTagScopeActionExecuter
extends ActionExecuterAbstractBase {
    private NodeService nodeService;
    private ContentService contentService;
    private TaggingService taggingService;
    public static final String NAME = "refresh-tagscope";

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    @Override
    protected void executeImpl(Action action, final NodeRef actionedUponNodeRef) {
        if (this.nodeService.exists(actionedUponNodeRef) && this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_TAGSCOPE)) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    ArrayList<TagDetails> tags = new ArrayList<TagDetails>(10);
                    RefreshTagScopeActionExecuter.this.countTags(actionedUponNodeRef, tags);
                    Collections.sort(tags);
                    String tagContent = TaggingServiceImpl.tagDetailsToString(tags);
                    if (tagContent.length() > 0) {
                        ContentWriter contentWriter = RefreshTagScopeActionExecuter.this.contentService.getWriter(actionedUponNodeRef, ContentModel.PROP_TAGSCOPE_CACHE, true);
                        contentWriter.setEncoding("UTF-8");
                        contentWriter.setMimetype("text/plain");
                        contentWriter.putContent(tagContent);
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    private void countTags(NodeRef nodeRef, List<TagDetails> tagDetailsList) {
        List<String> tags = this.taggingService.getTags(nodeRef);
        for (String tag : tags) {
            this.addDetails(tag, tagDetailsList);
        }
        List assocs = this.nodeService.getChildAssocs(nodeRef);
        for (ChildAssociationRef assoc : assocs) {
            if (!assoc.isPrimary()) continue;
            this.countTags(assoc.getChildRef(), tagDetailsList);
        }
    }

    private void addDetails(String tag, List<TagDetails> tagDetailsList) {
        TagDetails currentTag = null;
        for (TagDetails tagDetails : tagDetailsList) {
            if (!tagDetails.getName().equals(tag)) continue;
            currentTag = tagDetails;
            break;
        }
        if (currentTag == null) {
            tagDetailsList.add(new TagDetailsImpl(tag, 1));
        } else {
            ((TagDetailsImpl)currentTag).incrementCount();
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }
}

