/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.impl.MigrateVersionStorePatch;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.node.MLPropertyInterceptor;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.version.Version2ServiceImpl;
import org.alfresco.repo.version.VersionModel;
import org.alfresco.repo.version.VersionServiceImpl;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionMigrator
implements ApplicationEventPublisherAware {
    protected static Log logger = LogFactory.getLog(VersionMigrator.class);
    public static final StoreRef VERSION_STORE_REF_OLD = new StoreRef("workspace", "lightWeightVersionStore");
    public static final StoreRef VERSION_STORE_REF_NEW = new StoreRef("workspace", "version2Store");
    private static final String MSG_PATCH_NOOP = "version_service.migration.patch.noop";
    private static final String MSG_PATCH_COMPLETE = "version_service.migration.patch.complete";
    private static final String MSG_PATCH_IN_PROGRESS = "version_service.migration.patch.in_progress";
    private static final String MSG_PATCH_SKIP1 = "version_service.migration.patch.warn.skip1";
    private static final String MSG_PATCH_SKIP2 = "version_service.migration.patch.warn.skip2";
    private static final String MSG_DELETE_COMPLETE = "version_service.migration.delete.complete";
    private static final String MSG_DELETE_SKIP1 = "version_service.migration.delete.warn.skip1";
    private static final String MSG_DELETE_SKIP2 = "version_service.migration.delete.warn.skip2";
    private static boolean busy = false;
    public static final String PREFIX_MIGRATED = "migrated-";
    private VersionServiceImpl version1Service = new VersionServiceImpl();
    private Version2ServiceImpl version2Service;
    private NodeService dbNodeService;
    private BehaviourFilter policyBehaviourFilter;
    private DictionaryService dictionaryService;
    private TransactionService transactionService;
    private NodeService versionNodeService;
    private RuleService ruleService;
    private JobLockService jobLockService;
    private ApplicationEventPublisher applicationEventPublisher;
    private Boolean migrationComplete = null;
    private int loggingInterval = 500;

    public void setVersion2ServiceImpl(Version2ServiceImpl versionService) {
        this.version2Service = versionService;
    }

    public void setDbNodeService(NodeService nodeService) {
        this.dbNodeService = nodeService;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setVersionNodeService(NodeService versionNodeService) {
        this.versionNodeService = versionNodeService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void init() {
        this.version1Service.setNodeService(this.dbNodeService);
        this.version1Service.setDbNodeService(this.dbNodeService);
        this.version2Service.setDbNodeService(this.dbNodeService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRef migrateVersionHistory(NodeRef oldVHNodeRef, NodeRef versionedNodeRef) {
        VersionHistory vh = this.v1BuildVersionHistory(oldVHNodeRef, versionedNodeRef);
        NodeRef newVHNodeRef = this.v2CreateVersionHistory(versionedNodeRef);
        Version[] oldVersions = vh.getAllVersions().toArray(new Version[0]);
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        try {
            for (int i = oldVersions.length - 1; i >= 0; --i) {
                this.v2CreateNewVersion(newVHNodeRef, oldVersions[i]);
            }
            Object var8_7 = null;
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
            throw throwable;
        }
        return newVHNodeRef;
    }

    private NodeRef v2CreateVersionHistory(NodeRef nodeRef) {
        return this.version2Service.createVersionHistory(nodeRef);
    }

    private NodeRef v2CreateNewVersion(NodeRef newVersionHistoryRef, Version oldVersion) {
        NodeRef versionedNodeRef = oldVersion.getVersionedNodeRef();
        NodeRef frozenStateNodeRef = oldVersion.getFrozenStateNodeRef();
        String versionLabel = oldVersion.getVersionLabel();
        String versionDescription = oldVersion.getDescription();
        QName sourceType = this.versionNodeService.getType(frozenStateNodeRef);
        Set nodeAspects = this.versionNodeService.getAspects(frozenStateNodeRef);
        Map nodeProperties = this.versionNodeService.getProperties(frozenStateNodeRef);
        List nodeChildAssocs = this.versionNodeService.getChildAssocs(frozenStateNodeRef);
        List nodeAssocs = this.versionNodeService.getTargetAssocs(frozenStateNodeRef, RegexQNamePattern.MATCH_ALL);
        long nodeDbId = (Long)nodeProperties.get(ContentModel.PROP_NODE_DBID);
        nodeProperties.put(ContentModel.PROP_NODE_UUID, frozenStateNodeRef.getId());
        int versionNumber = 0;
        NodeRef versionNode = VersionUtil.convertNodeRef(frozenStateNodeRef);
        Date versionCreated = (Date)this.dbNodeService.getProperty(versionNode, ContentModel.PROP_CREATED);
        String versionCreator = (String)((Object)this.dbNodeService.getProperty(versionNode, ContentModel.PROP_CREATOR));
        Date versionModified = (Date)this.dbNodeService.getProperty(versionNode, ContentModel.PROP_MODIFIED);
        String versionModifier = (String)((Object)this.dbNodeService.getProperty(versionNode, ContentModel.PROP_MODIFIER));
        Date versionAccessed = (Date)this.dbNodeService.getProperty(versionNode, ContentModel.PROP_ACCESSED);
        Map<String, Serializable> versionMetaDataProperties = this.version1Service.getVersionMetaData(versionNode);
        PolicyScope nodeDetails = new PolicyScope(sourceType);
        for (Map.Entry entry : nodeProperties.entrySet()) {
            nodeDetails.addProperty(sourceType, (QName)entry.getKey(), (Serializable)entry.getValue());
        }
        nodeDetails.addProperty(sourceType, ContentModel.PROP_CREATED, versionCreated);
        nodeDetails.addProperty(sourceType, ContentModel.PROP_CREATOR, (Serializable)((Object)versionCreator));
        nodeDetails.addProperty(sourceType, ContentModel.PROP_MODIFIED, versionModified);
        nodeDetails.addProperty(sourceType, ContentModel.PROP_MODIFIER, (Serializable)((Object)versionModifier));
        nodeDetails.addProperty(sourceType, ContentModel.PROP_ACCESSED, versionAccessed);
        for (QName aspect : nodeAspects) {
            nodeDetails.addAspect(aspect);
            ClassDefinition classDefinition = this.dictionaryService.getClass(aspect);
            if (classDefinition == null) continue;
            Map propertyDefinitions = classDefinition.getProperties();
            for (QName propertyName : propertyDefinitions.keySet()) {
                Serializable propValue = (Serializable)nodeProperties.get(propertyName);
                nodeDetails.addProperty(aspect, propertyName, propValue);
            }
        }
        for (ChildAssociationRef childAssoc : nodeChildAssocs) {
            nodeDetails.addChildAssociation(sourceType, childAssoc);
        }
        for (AssociationRef assoc : nodeAssocs) {
            nodeDetails.addAssociation(sourceType, assoc);
        }
        NodeRef newVersionRef = this.version2Service.createNewVersion(sourceType, newVersionHistoryRef, this.version2Service.getStandardVersionProperties(versionedNodeRef, nodeDbId, nodeAspects, versionNumber, versionLabel, versionDescription), versionMetaDataProperties, versionNumber, nodeDetails);
        return newVersionRef;
    }

    protected boolean v1CheckForVersionedWorkingCopy(NodeRef oldVersionHistoryRef) {
        boolean valid = true;
        List versions = this.dbNodeService.getChildAssocs(oldVersionHistoryRef);
        if (versions.size() > 0) {
            Iterator itr = versions.iterator();
            ChildAssociationRef childAssocRef = (ChildAssociationRef)itr.next();
            NodeRef versionRef = childAssocRef.getChildRef();
            Version version = this.version1Service.getVersion(versionRef);
            List frozenAspects = (List)((Object)this.dbNodeService.getProperty(versionRef, VersionModel.PROP_QNAME_FROZEN_ASPECTS));
            if (frozenAspects.contains(ContentModel.ASPECT_WORKING_COPY) && frozenAspects.contains(ContentModel.ASPECT_VERSIONABLE)) {
                valid = false;
            }
        }
        return valid;
    }

    protected NodeRef v1GetVersionedNodeRef(NodeRef oldVersionHistoryRef) {
        NodeRef versionedNodeRef = null;
        List versions = this.dbNodeService.getChildAssocs(oldVersionHistoryRef);
        if (versions.size() > 0) {
            Iterator itr = versions.iterator();
            ChildAssociationRef childAssocRef = (ChildAssociationRef)itr.next();
            NodeRef versionRef = childAssocRef.getChildRef();
            Version version = this.version1Service.getVersion(versionRef);
            versionedNodeRef = version.getVersionedNodeRef();
        }
        return versionedNodeRef;
    }

    private VersionHistory v1BuildVersionHistory(NodeRef oldVersionHistoryRef, NodeRef versionedNodeRef) {
        return this.version1Service.buildVersionHistory(oldVersionHistoryRef, versionedNodeRef);
    }

    protected void v1DeleteVersionHistory(NodeRef oldVersionHistoryRef) {
        this.dbNodeService.deleteNode(oldVersionHistoryRef);
    }

    private void v1MarkVersionHistory(NodeRef oldVersionHistoryRef) {
        String migratedName = PREFIX_MIGRATED + oldVersionHistoryRef.getId();
        this.dbNodeService.setProperty(oldVersionHistoryRef, ContentModel.PROP_NAME, (Serializable)((Object)migratedName));
    }

    public List<ChildAssociationRef> getVersionHistories(NodeRef rootNodeRef) {
        return this.dbNodeService.getChildAssocs(rootNodeRef);
    }

    protected void migrateVersion(NodeRef oldVHNodeRef, boolean deleteImmediately) throws Throwable {
        if (this.v1CheckForVersionedWorkingCopy(oldVHNodeRef)) {
            NodeRef versionedNodeRef = this.v1GetVersionedNodeRef(oldVHNodeRef);
            this.migrateVersionHistory(oldVHNodeRef, versionedNodeRef);
        } else {
            logger.warn((Object)("Have found a versioned working copy node " + oldVHNodeRef + ", skipping"));
        }
        if (deleteImmediately) {
            this.v1DeleteVersionHistory(oldVHNodeRef);
        } else {
            this.v1MarkVersionHistory(oldVHNodeRef);
        }
    }

    public boolean isMigrationComplete() {
        if (this.migrationComplete == null) {
            NodeRef oldRootNodeRef = this.dbNodeService.getRootNode(VERSION_STORE_REF_OLD);
            List<ChildAssociationRef> childAssocRefs = this.getVersionHistories(oldRootNodeRef);
            this.migrationComplete = childAssocRefs.size() == 0;
        }
        return this.migrationComplete;
    }

    private void refreshLock(String lockToken) {
        if (lockToken == null || this.jobLockService == null) {
            return;
        }
        this.jobLockService.refreshLock(lockToken, MigrateVersionStorePatch.LOCK, 30000L);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Refreshed lock: " + lockToken + " with TTL of " + 30000L + " ms [" + AlfrescoTransactionSupport.getTransactionId() + "][" + Thread.currentThread().getId() + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean migrateVersions(int batchSize, int threadCount, int limit, final boolean deleteImmediately, final String lockToken, boolean isRunningAsJob) {
        NodeRef oldRootNodeRef = this.dbNodeService.getRootNode(VERSION_STORE_REF_OLD);
        NodeRef newRootNodeRef = this.dbNodeService.getRootNode(VERSION_STORE_REF_NEW);
        this.refreshLock(lockToken);
        long startTime = System.currentTimeMillis();
        List<ChildAssociationRef> childAssocRefs = this.getVersionHistories(oldRootNodeRef);
        int toDo = childAssocRefs.size();
        if (toDo == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)I18NUtil.getMessage((String)MSG_PATCH_NOOP));
            }
            this.migrationComplete = true;
            return null;
        }
        this.migrationComplete = false;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Found " + childAssocRefs.size() + " version histories in old version store (in " + (System.currentTimeMillis() - startTime) / 1000L + " secs)"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("batchSize=" + batchSize + ", batchWorkerThreadCount=" + threadCount + ", deleteImmediately=" + deleteImmediately));
        }
        long splitTime = System.currentTimeMillis();
        boolean firstMigration = false;
        if (!isRunningAsJob) {
            List<ChildAssociationRef> newChildAssocRefs = this.getVersionHistories(newRootNodeRef);
            boolean bl = firstMigration = newChildAssocRefs.size() == 0;
            if (logger.isInfoEnabled() && !firstMigration) {
                logger.warn((Object)("This is not the first migration attempt. Found " + newChildAssocRefs.size() + " version histories in new version store (in " + (System.currentTimeMillis() - splitTime) / 1000L + " secs)"));
            }
        }
        int alreadyMigratedCount = 0;
        int batchErrorCount = 0;
        int batchCount = 0;
        boolean wasMLAware = MLPropertyInterceptor.setMLAware(true);
        try {
            splitTime = System.currentTimeMillis();
            int toMigrateCount = 0;
            int totalCount = 0;
            ArrayList batchProcessorWork = new ArrayList(2);
            ArrayList<NodeRef> tmpBatch = new ArrayList<NodeRef>(batchSize);
            int maxToDo = childAssocRefs.size();
            if (limit > -1) {
                maxToDo = limit;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Limit this job cycle to max of " + limit + " version histories"));
                }
            }
            for (ChildAssociationRef childAssocRef : childAssocRefs) {
                if (!firstMigration && this.isMigrated(childAssocRef)) {
                    ++alreadyMigratedCount;
                    continue;
                }
                ++toMigrateCount;
                if (tmpBatch.size() < batchSize) {
                    tmpBatch.add(childAssocRef.getChildRef());
                }
                if ((tmpBatch.size() == batchSize || toMigrateCount >= maxToDo || totalCount == childAssocRefs.size()) && tmpBatch.size() > 0) {
                    batchProcessorWork.add(new ArrayList(tmpBatch));
                    tmpBatch.clear();
                }
                if (toMigrateCount < maxToDo) continue;
                break;
            }
            if ((batchCount = batchProcessorWork.size()) > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Split " + toMigrateCount + " into " + batchCount + " batches in " + (System.currentTimeMillis() - splitTime) + " ms"));
                }
                final String runAsUser = AuthenticationUtil.getRunAsUser();
                BatchProcessor.BatchProcessWorkerAdaptor<List<NodeRef>> batchProcessorWorker = new BatchProcessor.BatchProcessWorkerAdaptor<List<NodeRef>>(){

                    @Override
                    public void beforeProcess() throws Throwable {
                        VersionMigrator.this.ruleService.disableRules();
                        AuthenticationUtil.setRunAsUser((String)runAsUser);
                    }

                    @Override
                    public void afterProcess() throws Throwable {
                        VersionMigrator.this.ruleService.enableRules();
                        AuthenticationUtil.clearCurrentSecurityContext();
                    }

                    @Override
                    public void process(List<NodeRef> vhBatch) throws Throwable {
                        long startTime = System.currentTimeMillis();
                        VersionMigrator.this.refreshLock(lockToken);
                        for (NodeRef oldVHNodeRef : vhBatch) {
                            VersionMigrator.this.migrateVersion(oldVHNodeRef, deleteImmediately);
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Migrated batch of " + vhBatch.size() + " version histories in " + (System.currentTimeMillis() - startTime) + " ms [" + AlfrescoTransactionSupport.getTransactionId() + "][" + Thread.currentThread().getId() + "]"));
                        }
                    }
                };
                boolean splitTxns = true;
                if (threadCount > 1) {
                    ArrayList batchProcessorWorkFirst = new ArrayList(2);
                    batchProcessorWorkFirst.add(new ArrayList((Collection)batchProcessorWork.get(0)));
                    BatchProcessor batchProcessorFirst = new BatchProcessor("MigrateVersionStore", this.transactionService.getRetryingTransactionHelper(), batchProcessorWorkFirst, threadCount, 1, this.applicationEventPublisher, logger, this.loggingInterval);
                    batchProcessorFirst.process(batchProcessorWorker, splitTxns);
                    batchErrorCount = batchProcessorFirst.getTotalErrors();
                    batchProcessorWork.remove(0);
                }
                if (batchProcessorWork.size() > 0) {
                    BatchProcessor batchProcessor = new BatchProcessor("MigrateVersionStore", this.transactionService.getRetryingTransactionHelper(), batchProcessorWork, threadCount, 1, this.applicationEventPublisher, logger, this.loggingInterval);
                    batchProcessor.process(batchProcessorWorker, splitTxns);
                    batchErrorCount += batchProcessor.getTotalErrors();
                }
            }
            if (alreadyMigratedCount > 0) {
                logger.warn((Object)I18NUtil.getMessage((String)MSG_PATCH_SKIP2, (Object[])new Object[]{alreadyMigratedCount}));
            }
            if (batchCount > 0) {
                if (batchErrorCount > 0) {
                    logger.warn((Object)I18NUtil.getMessage((String)MSG_PATCH_SKIP1, (Object[])new Object[]{batchErrorCount, batchCount, (System.currentTimeMillis() - startTime) / 1000L}));
                } else if (limit == -1 || toMigrateCount + alreadyMigratedCount == toDo) {
                    logger.info((Object)I18NUtil.getMessage((String)MSG_PATCH_COMPLETE, (Object[])new Object[]{toMigrateCount, toDo, (System.currentTimeMillis() - startTime) / 1000L, deleteImmediately}));
                    this.migrationComplete = true;
                } else {
                    logger.info((Object)I18NUtil.getMessage((String)MSG_PATCH_IN_PROGRESS, (Object[])new Object[]{toMigrateCount, toDo, (System.currentTimeMillis() - startTime) / 1000L, deleteImmediately}));
                }
            }
            Object var31_29 = null;
        }
        catch (Throwable throwable) {
            Object var31_30 = null;
            MLPropertyInterceptor.setMLAware(wasMLAware);
            throw throwable;
        }
        MLPropertyInterceptor.setMLAware(wasMLAware);
        return this.migrationComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCleanup(final int batchSize, final int threadCount) {
        if (!busy) {
            try {
                busy = true;
                RetryingTransactionHelper txHelper = this.transactionService.getRetryingTransactionHelper();
                txHelper.setMaxRetries(1);
                txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object execute() throws Throwable {
                        NodeRef oldRootNodeRef;
                        List<ChildAssociationRef> childAssocRefs;
                        int toDo;
                        long startTime = System.currentTimeMillis();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("batchSize=" + batchSize + ", batchWorkerThreadCount=" + threadCount));
                        }
                        if ((toDo = (childAssocRefs = VersionMigrator.this.getVersionHistories(oldRootNodeRef = VersionMigrator.this.dbNodeService.getRootNode(VERSION_STORE_REF_OLD))).size()) == 0) {
                            VersionMigrator.this.migrationComplete = true;
                        } else {
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)("Found " + toDo + " version histories to delete from old version store (in " + (System.currentTimeMillis() - startTime) / 1000L + " secs)"));
                            }
                            int notMigratedCount = 0;
                            int batchErrorCount = 0;
                            int batchCount = 0;
                            boolean wasMLAware = MLPropertyInterceptor.setMLAware(true);
                            try {
                                long splitTime = System.currentTimeMillis();
                                int totalCount = 0;
                                ArrayList batchProcessorWork = new ArrayList(2);
                                ArrayList<NodeRef> tmpBatch = new ArrayList<NodeRef>(batchSize);
                                for (ChildAssociationRef childAssocRef : childAssocRefs) {
                                    ++totalCount;
                                    if (!VersionMigrator.this.isMigrated(childAssocRef)) {
                                        ++notMigratedCount;
                                        continue;
                                    }
                                    if (tmpBatch.size() < batchSize) {
                                        tmpBatch.add(childAssocRef.getChildRef());
                                    }
                                    if (tmpBatch.size() != batchSize && totalCount != childAssocRefs.size()) continue;
                                    batchProcessorWork.add(new ArrayList(tmpBatch));
                                    tmpBatch.clear();
                                }
                                batchCount = batchProcessorWork.size();
                                if (batchCount > 0) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Split into " + batchCount + " batches in " + (System.currentTimeMillis() - splitTime) + " ms"));
                                    }
                                    BatchProcessor.BatchProcessWorkerAdaptor<List<NodeRef>> batchProcessorWorker = new BatchProcessor.BatchProcessWorkerAdaptor<List<NodeRef>>(){

                                        @Override
                                        public void process(List<NodeRef> vhBatch) throws Throwable {
                                            long startTime = System.currentTimeMillis();
                                            for (NodeRef oldVHNodeRef : vhBatch) {
                                                VersionMigrator.this.v1DeleteVersionHistory(oldVHNodeRef);
                                            }
                                            if (logger.isTraceEnabled()) {
                                                logger.trace((Object)("Deleted batch of " + vhBatch.size() + " migrated version histories in " + (System.currentTimeMillis() - startTime) + " ms [" + AlfrescoTransactionSupport.getTransactionId() + "][" + Thread.currentThread().getId() + "]"));
                                            }
                                        }
                                    };
                                    BatchProcessor batchProcessor = new BatchProcessor("CleanOldVersionStore", VersionMigrator.this.transactionService.getRetryingTransactionHelper(), batchProcessorWork, threadCount, 1, VersionMigrator.this.applicationEventPublisher, logger, VersionMigrator.this.loggingInterval);
                                    boolean splitTxns = true;
                                    batchProcessor.process(batchProcessorWorker, splitTxns);
                                    batchErrorCount = batchProcessor.getTotalErrors();
                                }
                                Object var19_16 = null;
                            }
                            catch (Throwable throwable) {
                                Object var19_17 = null;
                                MLPropertyInterceptor.setMLAware(wasMLAware);
                                throw throwable;
                            }
                            MLPropertyInterceptor.setMLAware(wasMLAware);
                            if (notMigratedCount > 0) {
                                logger.warn((Object)I18NUtil.getMessage((String)VersionMigrator.MSG_DELETE_SKIP2, (Object[])new Object[]{notMigratedCount}));
                            }
                            if (batchCount > 0) {
                                if (batchErrorCount > 0) {
                                    logger.warn((Object)I18NUtil.getMessage((String)VersionMigrator.MSG_DELETE_SKIP1, (Object[])new Object[]{batchErrorCount, (System.currentTimeMillis() - startTime) / 1000L}));
                                } else {
                                    logger.info((Object)I18NUtil.getMessage((String)VersionMigrator.MSG_DELETE_COMPLETE, (Object[])new Object[]{toDo - notMigratedCount, toDo, (System.currentTimeMillis() - startTime) / 1000L}));
                                    if (notMigratedCount == 0) {
                                        VersionMigrator.this.migrationComplete = null;
                                        VersionMigrator.this.isMigrationComplete();
                                    }
                                }
                            }
                        }
                        return null;
                    }
                }, true, true);
                Object var5_4 = null;
                busy = false;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                busy = false;
                throw throwable;
            }
        }
    }

    protected boolean isMigrated(ChildAssociationRef vhChildAssocRef) {
        return ((String)((Object)this.dbNodeService.getProperty(vhChildAssocRef.getChildRef(), ContentModel.PROP_NAME))).startsWith(PREFIX_MIGRATED);
    }
}

