/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.TaskComponent;
import org.alfresco.repo.workflow.WorkflowComponent;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.springframework.beans.factory.InitializingBean;

public class BPMEngine
implements InitializingBean {
    private BPMEngineRegistry registry;
    private String engineId;

    public void setBPMEngineRegistry(BPMEngineRegistry registry) {
        this.registry = registry;
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.engineId == null || this.engineId.length() == 0) {
            throw new WorkflowException("Engine Id not specified");
        }
        if (this instanceof WorkflowComponent) {
            this.registry.registerWorkflowComponent(this.engineId, (WorkflowComponent)((Object)this));
        }
        if (this instanceof TaskComponent) {
            this.registry.registerTaskComponent(this.engineId, (TaskComponent)((Object)this));
        }
    }

    protected String createGlobalId(String localId) {
        return BPMEngineRegistry.createGlobalId(this.engineId, localId);
    }

    protected String createLocalId(String globalId) {
        return BPMEngineRegistry.getLocalId(globalId);
    }
}

