/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.util.List;
import junit.framework.Assert;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.util.BaseSpringTest;
import org.jbpm.JbpmContext;
import org.jbpm.db.GraphSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.springmodules.workflow.jbpm31.JbpmCallback;
import org.springmodules.workflow.jbpm31.JbpmTemplate;

public class JBPMSpringTest
extends BaseSpringTest {
    JbpmTemplate jbpmTemplate;
    DescriptorService descriptorService;

    protected void onSetUpInTransaction() throws Exception {
        this.jbpmTemplate = (JbpmTemplate)this.applicationContext.getBean("jbpm_template");
        this.descriptorService = (DescriptorService)this.applicationContext.getBean("DescriptorService");
    }

    public void testDummy() {
    }

    public void testHelloWorld() throws Exception {
        this.deployProcessDefinition();
        this.processInstanceIsCreatedWhenUserSubmitsWebappForm();
        this.theProcessInstanceContinuesWhenAnAsyncMessageIsReceived();
    }

    public void testStep0() throws Exception {
        this.deployProcessDefinition();
        this.setComplete();
    }

    public void testStep1() throws Exception {
        this.processInstanceIsCreatedWhenUserSubmitsWebappForm();
        this.setComplete();
    }

    public void testStep2() throws Exception {
        this.theProcessInstanceContinuesWhenAnAsyncMessageIsReceived();
        this.undeployProcessDefinition();
        this.setComplete();
    }

    private void deployProcessDefinition() {
        final ProcessDefinition processDefinition = ProcessDefinition.parseXmlString((String)"<process-definition name='hello world'>  <start-state name='start'>    <transition to='s' />  </start-state>  <node name='s'>    <action class='org.alfresco.repo.workflow.jbpm.JBPMTestSpringActionHandler' config-type='bean'>       <value>a test value</value>    </action>    <transition to='end' />  </node>  <end-state name='end' /></process-definition>");
        this.jbpmTemplate.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                context.deployProcessDefinition(processDefinition);
                return null;
            }
        });
    }

    private void undeployProcessDefinition() {
        this.jbpmTemplate.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                GraphSession graphSession = context.getGraphSession();
                ProcessDefinition processDefinition = graphSession.findLatestProcessDefinition("hello world");
                graphSession.deleteProcessDefinition(processDefinition.getId());
                return null;
            }
        });
    }

    private void processInstanceIsCreatedWhenUserSubmitsWebappForm() {
        this.jbpmTemplate.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                GraphSession graphSession = context.getGraphSession();
                ProcessDefinition processDefinition = graphSession.findLatestProcessDefinition("hello world");
                ProcessInstance processInstance = new ProcessInstance(processDefinition);
                Token token = processInstance.getRootToken();
                Assert.assertEquals((String)"start", (String)token.getNode().getName());
                token.signal();
                Assert.assertEquals((String)"s", (String)token.getNode().getName());
                String result = "Repo: " + JBPMSpringTest.this.descriptorService.getServerDescriptor().getVersion() + ", Value: a test value, Node: s, Token: /";
                Assert.assertEquals((Object)result, (Object)processInstance.getContextInstance().getVariable("jbpm.test.action.result"));
                context.save(processInstance);
                return null;
            }
        });
    }

    private void theProcessInstanceContinuesWhenAnAsyncMessageIsReceived() {
        this.jbpmTemplate.execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                GraphSession graphSession = context.getGraphSession();
                ProcessDefinition processDefinition = graphSession.findLatestProcessDefinition("hello world");
                List processInstances = graphSession.findProcessInstances(processDefinition.getId());
                ProcessInstance processInstance = (ProcessInstance)processInstances.get(0);
                processInstance.signal();
                Assert.assertTrue((boolean)processInstance.hasEnded());
                context.save(processInstance);
                return null;
            }
        });
    }
}

