/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.asset;

import java.util.Date;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.util.WCMUtil;

public class AssetInfoImpl
implements AssetInfo {
    private AVMNodeDescriptor node;
    private String lockOwner = null;
    private int sandboxVersion = -1;
    private int diffCode = -1;

    AssetInfoImpl(int sandboxVersion, AVMNodeDescriptor node, String lockOwner) {
        this.sandboxVersion = sandboxVersion;
        this.node = node;
        this.lockOwner = lockOwner;
    }

    public String getName() {
        return this.node.getName();
    }

    public String getSandboxId() {
        return WCMUtil.getSandboxStoreId(this.node.getPath());
    }

    public String getPath() {
        return WCMUtil.getStoreRelativePath(this.node.getPath());
    }

    public boolean isFile() {
        return this.node.isFile() || this.node.isDeletedFile();
    }

    public boolean isFolder() {
        return this.node.isDirectory() || this.node.isDeletedDirectory();
    }

    public boolean isDeleted() {
        return this.node.isDeleted();
    }

    public String getCreator() {
        return this.node.getCreator();
    }

    public Date getCreatedDate() {
        return new Date(this.node.getCreateDate());
    }

    public String getModifier() {
        return this.node.getLastModifier();
    }

    public Date getModifiedDate() {
        return new Date(this.node.getModDate());
    }

    public int getSandboxVersion() {
        return this.sandboxVersion;
    }

    public boolean isLocked() {
        return this.lockOwner != null;
    }

    public long getFileSize() {
        return this.node.getLength();
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public AVMNodeDescriptor getAVMNodeDescriptor() {
        return this.node;
    }

    public String getAvmPath() {
        return this.node.getPath();
    }

    public int getDiffCode() {
        return this.diffCode;
    }

    public void setDiffCode(int diffCode) {
        this.diffCode = diffCode;
    }
}

