/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ZipController;
import de.schlichtherle.io.ZipDetector;
import de.schlichtherle.io.ZipEntry;
import de.schlichtherle.io.ZipFileSystemException;
import de.schlichtherle.io.ZipReadOnlyException;
import de.schlichtherle.util.zip.ZipFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class ZipFileSystem {
    static final String ROOT = "/";
    private static final Comparator REVERSE_ENTRIES_COMPARATOR;
    private static final int INITIAL_CAPACITY = 64;
    private static final List filteredList;
    private final ZipController controller;
    private final ZipDetector zipDetector;
    private final String cPathname;
    private final String encoding;
    private final boolean readOnly;
    private Map master;
    private final ZipEntry root;
    private long modCount;
    private final String[] split = new String[2];
    static final /* synthetic */ boolean $assertionsDisabled;

    static String[] splitEntryName(String string, String[] stringArray) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && stringArray == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && stringArray.length < 2) {
            throw new AssertionError();
        }
        int n = string.length();
        if (--n >= 0 && string.charAt(n) == '/') {
            --n;
        }
        int n2 = string.lastIndexOf(47, n);
        ++n;
        if (n2 != -1) {
            stringArray[0] = string.substring(0, ++n2);
            stringArray[1] = string.substring(n2, n);
        } else {
            stringArray[0] = n > 0 ? ROOT : null;
            stringArray[1] = string.substring(0, n);
        }
        return stringArray;
    }

    ZipFileSystem(ZipController zipController) throws IOException {
        this.controller = zipController;
        this.zipDetector = zipController.getZipDetector();
        this.cPathname = zipController.target.getPath();
        this.encoding = this.zipDetector.getEncoding(this.cPathname);
        this.master = new CompoundMap(REVERSE_ENTRIES_COMPARATOR, 64);
        this.root = this.createZipEntry(ROOT);
        this.root.setFileSystem(this);
        this.root.touch();
        this.master.put(ROOT, this.root);
        this.readOnly = false;
        if (!$assertionsDisabled && !this.isTouched()) {
            throw new AssertionError();
        }
    }

    ZipFileSystem(ZipController zipController, ZipFile zipFile, long l, boolean bl) {
        this.controller = zipController;
        this.zipDetector = zipController.getZipDetector();
        this.cPathname = zipController.target.getPath();
        this.encoding = this.zipDetector.getEncoding(this.cPathname);
        int n = (int)((double)zipFile.size() / 0.75);
        this.master = new CompoundMap(REVERSE_ENTRIES_COMPARATOR, n);
        this.root = this.createZipEntry(ROOT);
        this.root.setTime(l);
        this.root.setFileSystem(this);
        this.master.put(ROOT, this.root);
        Enumeration enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
            String string = zipEntry.getName();
            if (ROOT.equals(string)) continue;
            zipEntry.setFileSystem(this);
            this.master.put(string, zipEntry);
        }
        enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            this.fixParents((ZipEntry)enumeration.nextElement());
        }
        this.readOnly = bl;
        if (bl) {
            this.master = Collections.unmodifiableMap(this.master);
        }
        if (!$assertionsDisabled && this.isTouched()) {
            throw new AssertionError();
        }
    }

    private void fixParents(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        if (string.length() <= 0 || string.charAt(0) == '/') {
            return;
        }
        String[] stringArray = ZipFileSystem.splitEntryName(string, this.split);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        ZipEntry zipEntry2 = (ZipEntry)this.master.get(string2);
        if (zipEntry2 == null) {
            zipEntry2 = this.createZipEntry(string2);
            zipEntry2.setFileSystem(this);
            this.master.put(string2, zipEntry2);
        }
        this.fixParents(zipEntry2);
        zipEntry2.children.put(string3, zipEntry);
    }

    final boolean isReadOnly() {
        return this.readOnly;
    }

    final ZipEntry createZipEntry(String string) {
        return this.zipDetector.createZipEntry(this.cPathname, false, string);
    }

    final void touch() throws IOException {
        if (this.readOnly) {
            throw new ZipReadOnlyException();
        }
        if (this.modCount == 0L) {
            this.controller.getOutputStream(null);
            this.controller.schedule(true);
        }
        ++this.modCount;
    }

    final boolean isTouched() {
        return this.modCount != 0L;
    }

    private final void resetTouched() {
        this.modCount = 0L;
    }

    final Enumeration getReversedEntries() {
        return Collections.enumeration(this.master.values());
    }

    final ZipEntry getRoot() {
        return this.root;
    }

    final ZipEntry get(String string) {
        return (ZipEntry)this.master.get(string);
    }

    ZipEntry create(String string, boolean bl) throws IOException {
        if (!$assertionsDisabled && string.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string.charAt(0) == '/') {
            throw new AssertionError();
        }
        try {
            ZipEntry zipEntry;
            String[] stringArray = ZipFileSystem.splitEntryName(string, this.split);
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (!string3.equals(new String(string3.getBytes(this.encoding), this.encoding))) {
                throw new IOException(string + ": Illegal characters in entry name!");
            }
            ZipEntry zipEntry2 = (ZipEntry)this.master.get(string2);
            if (zipEntry2 != null) {
                zipEntry = (ZipEntry)this.master.get(string);
                this.checkMayReplace(string, zipEntry);
                if (zipEntry == null && zipEntry2.getTime() >= 0L) {
                    zipEntry2.touch();
                }
            } else if (bl) {
                zipEntry2 = this.create(string2, bl);
            } else {
                throw new ZipFileSystemException(string + ": Missing parent directory!");
            }
            zipEntry = this.createZipEntry(string);
            zipEntry.setFileSystem(this);
            zipEntry.touch();
            zipEntry2.children.put(string3, zipEntry);
            this.master.put(string, zipEntry);
            return zipEntry;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ZipReadOnlyException();
        }
    }

    private final void checkMayReplace(String string, ZipEntry zipEntry) throws IOException {
        int n = string.length() - 1;
        if (string.charAt(n) == '/') {
            if (zipEntry != null) {
                throw new ZipFileSystemException(string + ": Directories cannot be replaced!");
            }
            if (this.master.get(string.substring(0, n)) != null) {
                throw new ZipFileSystemException(string + ": Directories cannot replace files!");
            }
        } else if (this.master.get(string + ROOT) != null) {
            throw new ZipFileSystemException(string + ": Files cannot replace directories!");
        }
    }

    void delete(String string) throws IOException {
        if (!$assertionsDisabled && string.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string.charAt(0) == '/') {
            throw new AssertionError();
        }
        try {
            ZipEntry zipEntry = (ZipEntry)this.master.remove(string);
            if (zipEntry == null) {
                throw new ZipFileSystemException();
            }
            if (zipEntry == this.root || zipEntry.isDirectory() && zipEntry.children.size() != 0) {
                this.master.put(string, zipEntry);
                throw new ZipFileSystemException();
            }
            String[] stringArray = ZipFileSystem.splitEntryName(string, this.split);
            String string2 = stringArray[0];
            ZipEntry zipEntry2 = (ZipEntry)this.master.get(string2);
            if (!$assertionsDisabled && zipEntry2 == null) {
                throw new AssertionError((Object)("The parent directory of \"" + string + "\" is missing - ZIP file system is corrupted!"));
            }
            zipEntry2.children.remove(stringArray[1]);
            zipEntry2.touch();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ZipReadOnlyException();
        }
    }

    static {
        $assertionsDisabled = !ZipFileSystem.class.desiredAssertionStatus();
        REVERSE_ENTRIES_COMPARATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object2).compareTo(object);
            }
        };
        filteredList = new ArrayList(64);
    }

    private static class CompoundMap
    extends HashMap {
        static final LinkedList events = new LinkedList();
        static final Updater mapper = new Updater();
        static boolean done;
        final TreeMap tree;

        CompoundMap(Comparator comparator, int n) {
            super(n);
            this.tree = new TreeMap(comparator);
            int n2 = Thread.currentThread().getPriority();
            if (mapper.getPriority() < n2) {
                mapper.setPriority(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object object) {
            LinkedList linkedList = events;
            synchronized (linkedList) {
                events.addLast(new Event(object));
                done = false;
                events.notifyAll();
            }
            return super.remove(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object object, Object object2) {
            LinkedList linkedList = events;
            synchronized (linkedList) {
                events.addLast(new Event(object, object2));
                done = false;
                events.notifyAll();
            }
            return super.put(object, object2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection values() {
            LinkedList linkedList = events;
            synchronized (linkedList) {
                while (!done) {
                    try {
                        events.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.tree.values();
            }
        }

        static {
            mapper.start();
        }

        static class Updater
        extends Thread {
            Updater() {
                super("TrueZIP CompoundMap Updater");
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Event event;
                    LinkedList linkedList = events;
                    synchronized (linkedList) {
                        done = events.isEmpty();
                        if (done) {
                            events.notifyAll();
                            try {
                                events.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                        event = (Event)events.removeFirst();
                    }
                    if (event.put) {
                        event.map().put(event.key, event.value);
                        continue;
                    }
                    event.map().remove(event.key);
                }
            }
        }

        class Event {
            final boolean put;
            final Object key;
            Object value;

            Event(Object object, Object object2) {
                this.put = true;
                this.key = object;
                this.value = object2;
            }

            Event(Object object) {
                this.put = false;
                this.key = object;
            }

            final Map map() {
                return CompoundMap.this.tree;
            }
        }
    }
}

