/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;

public abstract class OctetCharset
extends Charset {
    protected static final char REPLACEMENT = '\ufffd';
    private final char[] byte2char;
    private final char[][] char2byte;

    protected OctetCharset(String string, String[] stringArray, char[] cArray) {
        super(string, stringArray);
        char[][] cArrayArray = new char[256][];
        for (int n = 0; n < 256; n = (int)((char)(n + 1))) {
            char c = cArray[n];
            if (c == '\ufffd') continue;
            int n2 = c >> 8;
            char[] cArray2 = cArrayArray[n2];
            if (cArray2 == null) {
                cArray2 = new char[256];
                Arrays.fill(cArray2, '\ufffd');
                cArrayArray[n2] = cArray2;
            }
            cArray2[c & 0xFF] = n;
        }
        this.byte2char = cArray;
        this.char2byte = cArrayArray;
    }

    public boolean contains(Charset charset) {
        return this.getClass().isInstance(charset);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder();
    }

    public CharsetDecoder newDecoder() {
        return new Decoder();
    }

    protected class Decoder
    extends CharsetDecoder {
        protected Decoder() {
            super(OctetCharset.this, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            char[] cArray = OctetCharset.this.byte2char;
            while (byteBuffer.hasRemaining()) {
                if (!charBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char c = cArray[byteBuffer.get() & 0xFF];
                if (c == '\ufffd') {
                    byteBuffer.position(byteBuffer.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                charBuffer.put(c);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    protected class Encoder
    extends CharsetEncoder {
        protected Encoder() {
            super(OctetCharset.this, 1.0f, 1.0f);
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[][] cArray = OctetCharset.this.char2byte;
            while (charBuffer.hasRemaining()) {
                char c;
                if (!byteBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char c2 = charBuffer.get();
                char[] cArray2 = cArray[c2 >> 8];
                if (cArray2 == null || (c = cArray2[c2 & 0xFF]) == '\ufffd') {
                    charBuffer.position(charBuffer.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                byteBuffer.put((byte)(c & 0xFF));
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

