/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import de.schlichtherle.io.rof.BufferedReadOnlyFile;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.SimpleReadOnlyFile;
import de.schlichtherle.util.zip.ZipConstants;
import de.schlichtherle.util.zip.ZipEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class ZipFile
implements ZipConstants {
    private static long LONG_MSB;
    private static final int LFH_FILE_NAME_LENGTH_OFFSET = 26;
    private static final int EOCD_NUM_ENTRIES_OFFSET = 10;
    private static final int EOCD_CD_SIZE_OFFSET = 12;
    private static final int EOCD_CD_LOCATION_OFFSET = 16;
    private static final int EOCD_COMMENT_OFFSET = 20;
    private final String encoding;
    private String comment;
    private final Map entries = new HashMap();
    private volatile ReadOnlyFile archive;
    private volatile int openStreams;
    private long preamble;
    private long postamble;
    private OffsetMapper mapper;
    private static final Set allocatedInflaters;
    private static final List releasedInflaters;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ZipFile(String string) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this(null, new File(string), "UTF-8", true, false);
    }

    public ZipFile(String string, String string2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this(null, new File(string), string2, true, false);
    }

    public ZipFile(String string, String string2, boolean bl, boolean bl2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this(null, new File(string), string2, bl, bl2);
    }

    public ZipFile(File file) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this(null, file, "UTF-8", true, false);
    }

    public ZipFile(File file, String string) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this(null, file, string, true, false);
    }

    public ZipFile(File file, String string, boolean bl, boolean bl2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this(null, file, string, bl, bl2);
    }

    public ZipFile(ReadOnlyFile readOnlyFile) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this(readOnlyFile, null, "UTF-8", true, false);
    }

    public ZipFile(ReadOnlyFile readOnlyFile, String string) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this(readOnlyFile, null, string, true, false);
    }

    public ZipFile(ReadOnlyFile readOnlyFile, String string, boolean bl, boolean bl2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this(readOnlyFile, null, string, bl, bl2);
    }

    private ZipFile(ReadOnlyFile readOnlyFile, File file, String string, boolean bl, boolean bl2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        if (string == null) {
            throw new NullPointerException("encoding");
        }
        new String(new byte[0], string);
        this.encoding = string;
        if (readOnlyFile == null) {
            if (file == null) {
                throw new NullPointerException();
            }
            readOnlyFile = this.createReadOnlyFile(file);
        } else if (!$assertionsDisabled && file != null) {
            throw new AssertionError();
        }
        this.archive = readOnlyFile;
        try {
            BufferedReadOnlyFile bufferedReadOnlyFile = this.archive instanceof BufferedReadOnlyFile ? (BufferedReadOnlyFile)this.archive : new BufferedReadOnlyFile(this.archive);
            try {
                this.populateFromCentralDirectory(bufferedReadOnlyFile, bl, bl2);
            }
            catch (IOException iOException) {
                if (file != null) {
                    bufferedReadOnlyFile.close();
                }
                throw iOException;
            }
        }
        catch (IOException iOException) {
            ZipException zipException;
            if (!(iOException instanceof ZipException)) {
                ZipException zipException2 = new ZipException("Not a ZIP compatible file or corrupted data!");
                zipException2.initCause(iOException);
                zipException = zipException2;
            }
            throw zipException;
        }
        if (!$assertionsDisabled && this.mapper == null) {
            throw new AssertionError();
        }
    }

    protected ReadOnlyFile createReadOnlyFile(File file) throws IOException {
        return new SimpleReadOnlyFile(file);
    }

    private void populateFromCentralDirectory(ReadOnlyFile readOnlyFile, boolean bl, boolean bl2) throws ZipException, IOException {
        int n = this.positionAtCentralDirectory(readOnlyFile, bl, bl2);
        if (!$assertionsDisabled && this.mapper == null) {
            throw new AssertionError();
        }
        this.preamble = Long.MAX_VALUE;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[46 - byArray.length];
        while (true) {
            readOnlyFile.readFully(byArray);
            if (ZipFile.readUInt(byArray) != 33639248L) break;
            readOnlyFile.readFully(byArray2);
            int n2 = ZipFile.readUShort(byArray2, 24);
            byte[] byArray3 = new byte[n2];
            readOnlyFile.readFully(byArray3);
            ZipEntry zipEntry = this.createZipEntry(new String(byArray3, this.encoding));
            try {
                byte[] byArray4;
                int n3 = 0;
                int n4 = ZipFile.readUShort(byArray2, n3);
                n3 += 2;
                zipEntry.setPlatform((short)(n4 >> 8 & 0xFF));
                zipEntry.setMethod((short)ZipFile.readUShort(byArray2, n3 += 4));
                zipEntry.setDosTime(ZipFile.readUInt(byArray2, n3 += 2));
                zipEntry.setCrc(ZipFile.readUInt(byArray2, n3 += 4));
                zipEntry.setCompressedSize(ZipFile.readUInt(byArray2, n3 += 4));
                zipEntry.setSize(ZipFile.readUInt(byArray2, n3 += 4));
                n3 += 4;
                int n5 = ZipFile.readUShort(byArray2, n3 += 2);
                int n6 = ZipFile.readUShort(byArray2, n3 += 2);
                n3 += 2;
                n3 += 2;
                n3 += 2;
                long l = this.mapper.location(ZipFile.readUInt(byArray2, n3 += 4));
                zipEntry.offset = l | LONG_MSB;
                if (l < this.preamble) {
                    this.preamble = l;
                }
                this.entries.put(zipEntry.getName(), zipEntry);
                if (n5 > 0) {
                    byArray4 = new byte[n5];
                    readOnlyFile.readFully(byArray4);
                    zipEntry.setExtra(byArray4);
                }
                if (n6 > 0) {
                    byArray4 = new byte[n6];
                    readOnlyFile.readFully(byArray4);
                    zipEntry.setComment(new String(byArray4, this.encoding));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ZipException zipException = new ZipException(zipEntry.getName());
                zipException.initCause(illegalArgumentException);
                throw zipException;
            }
            --n;
        }
        if (n != 0) {
            throw new ZipException("Not a ZIP compatible file: Expected " + n + (n > 0 ? " more" : " less") + " entries in the Central Directory!");
        }
    }

    private int positionAtCentralDirectory(ReadOnlyFile readOnlyFile, boolean bl, boolean bl2) throws ZipException, IOException {
        long l;
        byte[] byArray = new byte[4];
        if (!bl) {
            readOnlyFile.seek(0L);
            readOnlyFile.readFully(byArray);
            l = ZipFile.readUInt(byArray);
            boolean bl3 = bl = l == 67324752L || l == 101010256L;
        }
        if (bl) {
            l = readOnlyFile.length();
            long l2 = l - 22L;
            long l3 = !bl2 && l2 >= 65535L ? l2 - 65535L : 0L;
            for (long i = l2; i >= l3; --i) {
                readOnlyFile.seek(i);
                readOnlyFile.readFully(byArray);
                if (ZipFile.readUInt(byArray) != 101010256L) continue;
                byte[] byArray2 = new byte[22 - byArray.length];
                readOnlyFile.readFully(byArray2);
                int n = ZipFile.readUShort(byArray2, 10 - byArray.length);
                long l4 = ZipFile.readUInt(byArray2, 12 - byArray.length);
                long l5 = ZipFile.readUInt(byArray2, 16 - byArray.length);
                int n2 = ZipFile.readUShort(byArray2, 20 - byArray.length);
                if (n2 > 0) {
                    byte[] byArray3 = new byte[n2];
                    readOnlyFile.readFully(byArray3);
                    this.setComment(new String(byArray3, this.encoding));
                }
                this.postamble = l - readOnlyFile.getFilePointer();
                long l6 = i - l4;
                readOnlyFile.seek(l6);
                this.mapper = (l6 -= l5) != 0L ? new IrregularZipOffsetMapper(l6) : new RegularZipOffsetMapper();
                return n;
            }
        }
        throw new ZipException("Not a ZIP compatible file: End Of Central Directory signature is missing!");
    }

    protected ZipEntry createZipEntry(String string) {
        return new ZipEntry(string);
    }

    public String getComment() {
        return this.comment;
    }

    private void setComment(String string) {
        this.comment = string;
    }

    public boolean busy() {
        return this.openStreams > 0;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Enumeration entries() {
        return Collections.enumeration(this.entries.values());
    }

    public ZipEntry getEntry(String string) {
        return (ZipEntry)this.entries.get(string);
    }

    public int size() {
        return this.entries.size();
    }

    public long length() throws IOException {
        return this.archive.length();
    }

    public long getPreambleLength() {
        return this.preamble;
    }

    public InputStream getPreambleInputStream() throws IOException {
        return new BoundedInputStream(0L, this.preamble);
    }

    public long getPostambleLength() {
        return this.postamble;
    }

    public InputStream getPostambleInputStream() throws IOException {
        return new BoundedInputStream(this.archive.length() - this.postamble, this.postamble);
    }

    public boolean offsetsConsiderPreamble() {
        if (!$assertionsDisabled && this.mapper == null) {
            throw new AssertionError();
        }
        return this.mapper.location(0L) == 0L;
    }

    public final InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.getInputStream(zipEntry.getName(), true);
    }

    public final InputStream getInputStream(ZipEntry zipEntry, boolean bl) throws IOException {
        return this.getInputStream(zipEntry.getName(), bl);
    }

    public final InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(String string, boolean bl) throws IOException {
        Object object;
        long l;
        if (string == null) {
            throw new NullPointerException();
        }
        ZipEntry zipEntry = (ZipEntry)this.entries.get(string);
        if (zipEntry == null) {
            return null;
        }
        Object object2 = zipEntry;
        synchronized (object2) {
            l = zipEntry.offset;
            if (l == -1L) {
                return null;
            }
            if (l < 0L) {
                this.archive.seek(l &= LONG_MSB ^ 0xFFFFFFFFFFFFFFFFL);
                object = new byte[30];
                this.archive.readFully((byte[])object);
                if (ZipFile.readUInt(object) != 67324752L) {
                    throw new ZipException(string + ": Local File Header signature expected!");
                }
                zipEntry.offset = l += (long)(30 + ZipFile.readUShort(object, 26) + ZipFile.readUShort(object, 28));
            }
        }
        object2 = new BoundedInputStream(l, zipEntry.getCompressedSize());
        switch (zipEntry.getMethod()) {
            case 8: {
                if (bl) {
                    ((BoundedInputStream)object2).addDummy();
                    long l2 = zipEntry.getSize();
                    if (l2 > 65536L) {
                        l2 = 65536L;
                    } else if (l2 < 8192L) {
                        l2 = 8192L;
                    }
                    object = new InflaterInputStream((InputStream)object2, ZipFile.allocateInflater(), (int)l2){
                        private boolean closed;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void close() throws IOException {
                            if (!this.closed) {
                                this.closed = true;
                                try {
                                    super.close();
                                }
                                finally {
                                    ZipFile.releaseInflater(this.inf);
                                }
                            }
                        }
                    };
                    break;
                }
            }
            case 0: {
                object = object2;
                break;
            }
            default: {
                throw new ZipException(string + ": " + zipEntry.getMethod() + ": Unsupported compression method!");
            }
        }
        return new FilterInputStream((InputStream)object){
            private boolean closed;
            {
                ZipFile zipFile2 = ZipFile.this;
                synchronized (zipFile2) {
                    ZipFile.this.openStreams++;
                }
            }

            public int read(byte[] byArray) throws IOException {
                return this.in.read(byArray, 0, byArray.length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                ZipFile zipFile = ZipFile.this;
                synchronized (zipFile) {
                    if (!this.closed) {
                        this.closed = true;
                        ZipFile.this.openStreams--;
                        super.close();
                    }
                }
            }

            public void finalize() throws IOException {
                this.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Inflater allocateInflater() {
        Inflater inflater = null;
        List list = releasedInflaters;
        synchronized (list) {
            Iterator iterator = releasedInflaters.iterator();
            while (iterator.hasNext()) {
                inflater = (Inflater)((Reference)iterator.next()).get();
                iterator.remove();
                if (inflater == null) continue;
                inflater.reset();
                break;
            }
            if (inflater == null) {
                inflater = new Inflater(true);
            }
            allocatedInflaters.add(inflater);
        }
        return inflater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseInflater(Inflater inflater) {
        List list = releasedInflaters;
        synchronized (list) {
            releasedInflaters.add(new SoftReference<Inflater>(inflater));
            allocatedInflaters.remove(inflater);
        }
    }

    public synchronized void close() throws IOException {
        if (this.archive != null) {
            ReadOnlyFile readOnlyFile = this.archive;
            this.archive = null;
            readOnlyFile.close();
        }
    }

    static final int readUShort(byte[] byArray) {
        return ZipFile.readUShort(byArray, 0);
    }

    static final int readUShort(byte[] byArray, int n) {
        return (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    static final long readUInt(byte[] byArray) {
        return ZipFile.readUInt(byArray, 0);
    }

    static final long readUInt(byte[] byArray, int n) {
        n += 3;
        long l = (long)byArray[n--] & 0xFFL;
        l <<= 8;
        l |= (long)byArray[n--] & 0xFFL;
        l <<= 8;
        l |= (long)byArray[n--] & 0xFFL;
        l <<= 8;
        return l |= (long)byArray[n] & 0xFFL;
    }

    static {
        $assertionsDisabled = !ZipFile.class.desiredAssertionStatus();
        LONG_MSB = Long.MIN_VALUE;
        allocatedInflaters = new HashSet();
        releasedInflaters = new LinkedList();
    }

    private static class IrregularZipOffsetMapper
    implements OffsetMapper {
        final long start;

        public IrregularZipOffsetMapper(long l) {
            this.start = l;
        }

        public long location(long l) {
            return this.start + l;
        }
    }

    private static class RegularZipOffsetMapper
    implements OffsetMapper {
        private RegularZipOffsetMapper() {
        }

        public long location(long l) {
            return l;
        }
    }

    private static interface OffsetMapper {
        public long location(long var1);
    }

    private class BoundedInputStream
    extends InputStream {
        private long remaining;
        private long fp;
        private boolean addDummyByte;
        static final /* synthetic */ boolean $assertionsDisabled;

        BoundedInputStream(long l, long l2) {
            if (!$assertionsDisabled && l < 0L) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && l2 < 0L) {
                throw new AssertionError();
            }
            this.remaining = l2;
            this.fp = l;
        }

        private final void ensureOpen() throws ZipException {
            if (ZipFile.this.archive == null) {
                throw new ZipException("ZipFile has been closed!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            int n;
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                this.ensureOpen();
                ZipFile.this.archive.seek(this.fp);
                n = ZipFile.this.archive.read();
            }
            if (n >= 0) {
                ++this.fp;
                --this.remaining;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (n2 <= 0) {
                return 0;
            }
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    byArray[n] = 0;
                    return 1;
                }
                return -1;
            }
            if ((long)n2 > this.remaining) {
                n2 = (int)this.remaining;
            }
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                this.ensureOpen();
                ZipFile.this.archive.seek(this.fp);
                n3 = ZipFile.this.archive.read(byArray, n, n2);
            }
            if (n3 > 0) {
                this.fp += (long)n3;
                this.remaining -= (long)n3;
            }
            return n3;
        }

        void addDummy() {
            this.addDummyByte = true;
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$util$zip$ZipFile == null ? (class$de$schlichtherle$util$zip$ZipFile = ZipFile.class$("de.schlichtherle.util.zip.ZipFile")) : class$de$schlichtherle$util$zip$ZipFile).desiredAssertionStatus();
        }
    }
}

