/*
 * Decompiled with CFR 0.152.
 */
import de.schlichtherle.io.DefaultRaesZipDetector;
import de.schlichtherle.io.ZipDetector;
import de.schlichtherle.io.swing.tree.FileTreeModel;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;

public class nzip {
    private static final NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance();
    private static final FieldPosition fpos = new FieldPosition(0);
    private static final Thread progressMonitor = new Thread(){
        {
            this.setPriority(10);
            this.setDaemon(true);
        }

        public void run() {
            long l = 333L;
            while (true) {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                nzip.showProgress();
                l = 333L;
            }
        }
    };
    private static boolean showProgress;
    private static final Long[] args;

    private static void usage() {
        System.err.println("Usage: nzip COMMAND ...\n\nwhere COMMAND is one of (case is ignored):\n\n\tls [PATH] ...\t\t\t\tSimilar to GNU \"ls\"\n\tll [PATH] ...\t\t\t\tSimilar to GNU \"ls -l\"\n\tllR [PATH] ...\t\t\t\tSimilar to GNU \"ls -lR\"\n\tcat FILE ...\t\t\t\tLike GNU \"cat\"\n\tcp [-unzip|-cp437in|-utf8in|-cp437out|-utf8out] SRC ... DST\tSimilar to GNU \"cp -a\"\n\tmv SRC ... DST\t\t\t\tLike GNU \"mv\"\n\ttouch PATH ...\t\t\t\tLike GNU \"touch\"\n\tmkdir PATH ...\t\t\t\tLike GNU \"mkdir\"\n\tmkdirs PATH ...\t\t\t\tSimilar to GNU \"mkdir -p\"\n\trm PATH ...\t\t\t\tLike GNU \"rm\"\n\trmR PATH ...\t\t\t\tLike GNU \"rm -r\"\n\tisFile PATH\t\t\t\tTests if PATH is a file\n\tisDirectory PATH\t\t\tTests if PATH is a directory\n\texists PATH\t\t\t\tTests if PATH exists\n\nFor more information please refer to the respective man pages (on Linux).\n\nOptions (case is ignored):\n\n\t-unzip\t\tTreat any ZIP like pathnames in DST as plain\n\t\t\tdirectories.\n\t-cp437(in|out)\tForce any ZIP entry names in SRC/DST to be encoded in CP437.\n\t-utf8(in|out)\tForce any ZIP entry names in SRC/DST to be encoded in UTF-8.\n");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        boolean bl;
        block55: {
            if (stringArray.length < 1) {
                nzip.usage();
            }
            de.schlichtherle.io.File.setDefaultZipDetector(ZipDetector.ALL);
            String string = stringArray[0].toLowerCase();
            bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            try {
                if ("ls".equals(string) || (bl2 = "ll".equals(string)) || (bl3 = "llr".equals(string))) {
                    bl2 |= bl3;
                    for (int i = 1; i < stringArray.length || i == 1; ++i) {
                        de.schlichtherle.io.File file = new de.schlichtherle.io.File(i < stringArray.length ? stringArray[i] : ".");
                        if (stringArray.length > 2) {
                            System.out.println(file.getPath() + ":");
                        }
                        if (file.isDirectory()) {
                            File[] fileArray = file.listFiles();
                            if (fileArray != null) {
                                Arrays.sort(fileArray, FileTreeModel.FILE_NAME_COMPARATOR);
                                for (int j = 0; j < fileArray.length; ++j) {
                                    nzip.list(fileArray[j], bl2, bl3);
                                }
                                continue;
                            }
                            System.err.println(file.getPath() + ": Cannot list directory!");
                            bl = false;
                            continue;
                        }
                        if (file.exists()) {
                            nzip.list(file, bl2, bl3);
                            continue;
                        }
                        System.err.println(file.getPath() + ": " + "No such file or directory!");
                        bl = false;
                    }
                    break block55;
                }
                if ("cat".equals(string)) {
                    if (stringArray.length < 2) {
                        nzip.usage();
                    }
                    boolean bl4 = true;
                    for (int i = 1; i < stringArray.length; ++i) {
                        de.schlichtherle.io.File file = new de.schlichtherle.io.File(stringArray[i]);
                        boolean bl5 = file.catTo(System.out);
                        if (bl5) continue;
                        System.err.println(file.getPath() + ": Cannot read file!");
                        bl = false;
                    }
                } else if ("cp".equals(string) || (bl2 = "mv".equals(string))) {
                    int n;
                    if (stringArray.length < 3) {
                        nzip.usage();
                    }
                    boolean bl6 = false;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    int n2 = 0;
                    int n3 = 0;
                    for (n = 1; n < stringArray.length && stringArray[n].charAt(0) == '-'; ++n) {
                        if (bl2) {
                            nzip.usage();
                        }
                        if ("-unzip".equals(stringArray[n].toLowerCase())) {
                            bl6 = true;
                            ++n3;
                            continue;
                        }
                        if ("-cp437out".equals(stringArray[n].toLowerCase())) {
                            bl7 = true;
                            ++n3;
                            continue;
                        }
                        if ("-utf8out".equals(stringArray[n].toLowerCase())) {
                            bl8 = true;
                            ++n3;
                            continue;
                        }
                        if ("-cp437in".equals(stringArray[n].toLowerCase())) {
                            bl9 = true;
                            ++n2;
                            continue;
                        }
                        if ("-utf8in".equals(stringArray[n].toLowerCase())) {
                            bl10 = true;
                            ++n2;
                            continue;
                        }
                        nzip.usage();
                    }
                    if (n2 > 1 || n3 > 1) {
                        nzip.usage();
                    }
                    boolean bl11 = bl6;
                    final boolean bl12 = bl7;
                    final boolean bl13 = bl8;
                    final boolean bl14 = bl9;
                    final boolean bl15 = bl10;
                    DefaultRaesZipDetector defaultRaesZipDetector = new DefaultRaesZipDetector("zip|ear|jar|war|tzp|zip.rae|exe"){

                        public String getEncoding(String string) {
                            if (bl14) {
                                return "CP437";
                            }
                            if (bl15) {
                                return "UTF-8";
                            }
                            return super.getEncoding(string);
                        }
                    };
                    ZipDetector zipDetector = bl11 ? ZipDetector.NULL : new DefaultRaesZipDetector("zip|ear|jar|war|tzp|zip.rae|exe"){

                        public String getEncoding(String string) {
                            if (bl12) {
                                return "CP437";
                            }
                            if (bl13) {
                                return "UTF-8";
                            }
                            return super.getEncoding(string);
                        }
                    };
                    int n4 = stringArray.length - 1;
                    de.schlichtherle.io.File file = new de.schlichtherle.io.File(stringArray[n4], zipDetector);
                    if (n4 - n < 1 || n4 - n > 1 && !file.isZipFile() && !file.isDirectory()) {
                        nzip.usage();
                    }
                    if (file.getInnerZipFile() != null) {
                        nzip.startProgressMonitor();
                    }
                    for (int i = n; i < n4; ++i) {
                        boolean bl16;
                        de.schlichtherle.io.File file2 = new de.schlichtherle.io.File(stringArray[i], (ZipDetector)defaultRaesZipDetector);
                        de.schlichtherle.io.File file3 = n4 - n > 1 || file.isDirectory() ? new de.schlichtherle.io.File((File)file, file2.getName(), zipDetector) : file;
                        if (bl2) {
                            boolean bl17 = bl16 = !file2.contains(file3) && (!file3.isFile() || file3.delete()) && file2.renameTo(file3);
                            if (!bl16) {
                                System.err.println(file2 + ": Cannot move to " + file3 + "!");
                            }
                        } else {
                            bl16 = file2.archiveCopyAllTo(file3, defaultRaesZipDetector, zipDetector);
                            if (!bl16) {
                                System.err.println(file2 + ": Cannot copy to " + file3 + "!");
                            }
                        }
                        bl &= bl16;
                    }
                } else if ("touch".equals(string)) {
                    if (stringArray.length < 2) {
                        nzip.usage();
                    }
                    for (int i = 1; i < stringArray.length; ++i) {
                        de.schlichtherle.io.File file = new de.schlichtherle.io.File(stringArray[i]);
                        boolean bl18 = !file.exists() ? file.createNewFile() : file.setLastModified(System.currentTimeMillis());
                        if (bl18) continue;
                        String string2 = !file.exists() ? "Cannot create file!" : (file.isDirectory() ? "Cannot update directory last modification time!" : (file.isFile() ? "Cannot update file last modification time!" : "Cannot update special file or directory last modification time!"));
                        System.err.println(file.getPath() + ": " + string2);
                        bl = false;
                    }
                } else if ("mkdir".equals(string) || (bl2 = "mkdirs".equals(string))) {
                    if (stringArray.length < 2) {
                        nzip.usage();
                    }
                    for (int i = 1; i < stringArray.length; ++i) {
                        boolean bl19;
                        de.schlichtherle.io.File file = new de.schlichtherle.io.File(stringArray[i]);
                        boolean bl20 = bl19 = bl2 ? file.mkdirs() : file.mkdir();
                        if (bl19) continue;
                        String string3 = !file.exists() ? "Cannot create directory!" : (file.isDirectory() ? "Directory exists already!" : (file.isFile() ? "File exists already!" : "Special file or directory exists already!"));
                        System.err.println(file.getPath() + ": " + string3);
                        bl = false;
                    }
                } else if ("rm".equals(string) || (bl2 = "rmr".equals(string))) {
                    if (stringArray.length < 2) {
                        nzip.usage();
                    }
                    for (int i = 1; i < stringArray.length; ++i) {
                        boolean bl21;
                        de.schlichtherle.io.File file = new de.schlichtherle.io.File(stringArray[i]);
                        boolean bl22 = bl21 = bl2 ? file.deleteAll() : file.delete();
                        if (bl21) continue;
                        String string4 = !file.exists() ? "No such file or directory!" : (file.isDirectory() ? (file.list().length > 0 ? "Directory not empty!" : "Cannot remove directory!") : (file.isFile() ? "Cannot remove file!" : "Cannot remove special file or directory!"));
                        System.err.println(file.getPath() + ": " + string4);
                        bl = false;
                    }
                } else if ("isfile".equals(string)) {
                    if (stringArray.length < 2) {
                        nzip.usage();
                    }
                    bl = new de.schlichtherle.io.File(stringArray[1]).isFile();
                    System.out.println(bl);
                } else if ("isdirectory".equals(string)) {
                    if (stringArray.length < 2) {
                        nzip.usage();
                    }
                    bl = new de.schlichtherle.io.File(stringArray[1]).isDirectory();
                    System.out.println(bl);
                } else if ("exists".equals(string)) {
                    if (stringArray.length < 2) {
                        nzip.usage();
                    }
                    bl = new de.schlichtherle.io.File(stringArray[1]).exists();
                    System.out.println(bl);
                } else {
                    nzip.usage();
                    bl = false;
                }
            }
            finally {
                de.schlichtherle.io.File.update();
                nzip.showProgress();
            }
        }
        if (!bl) {
            System.exit(1);
        }
    }

    public static void list(File file, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            nzip.align(stringBuffer, file.length(), 11);
            stringBuffer.append(' ');
            stringBuffer.append(dateFormat.format(new Date(file.lastModified())));
            stringBuffer.append(' ');
        }
        stringBuffer.append(file.getName());
        if (bl) {
            stringBuffer.append(file.isDirectory() ? de.schlichtherle.io.File.separator : (file.isFile() ? "" : "?"));
        }
        System.out.println(stringBuffer.toString());
        if (bl2 && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                Arrays.sort(fileArray, FileTreeModel.FILE_NAME_COMPARATOR);
                for (int i = 0; i < fileArray.length; ++i) {
                    nzip.list(fileArray[i], bl, bl2);
                }
            } else {
                System.err.println(file.getPath() + ": Cannot list directory!");
            }
        }
    }

    private static void align(StringBuffer stringBuffer, long l, int n) {
        int n2 = stringBuffer.length();
        numberFormat.format(l, stringBuffer, fpos);
        int n3 = n - fpos.getEndIndex();
        while (--n3 >= 0) {
            stringBuffer.insert(n2, ' ');
        }
    }

    public static void startProgressMonitor() {
        showProgress = true;
        if (!progressMonitor.isAlive()) {
            progressMonitor.start();
        }
    }

    public static void showProgress() {
        if (!showProgress) {
            return;
        }
        nzip.args[0] = new Long((de.schlichtherle.io.File.getZipSyncTotalByteCountRead() + 1023L) / 1024L);
        nzip.args[1] = new Long((de.schlichtherle.io.File.getZipSyncTotalByteCountWritten() + 1023L) / 1024L);
        System.out.print(MessageFormat.format("Top level ZIP update: In {0} / Out {1} KB \r", args));
    }

    static {
        args = new Long[2];
    }
}

